// Path Drawing Configuration File


// Datatypes
// ------------------------------------------------------------------
//
// Boolean
// Booleans have two possible values true or false.
//     Example:
//         value: true
// Number
// Numbers can be represented as whole numbers or decimals.
//     Example:
//         x: -20
//         alpha: 0.4
//
// String
// String are described with quotes surrounding zero or more characters.
//     Example:
//         filename: "image1.png"
//
// Object 
// Objects are described with curly brackets surrounding 'name: value' pairs delimited by commas.
//     Example:
//         {
//             name1: value1,
//             name2: value2
//         }
//
// Array
// Arrays are described with square brackets surrounding values delimited by commas.
//     Example:
//         [
//             value1,
//             value2
//         ]

// Framework Properties
// ------------------------------------------------------------------
//
// View Properties
//     type (String)
//     filename (String): The url of image of the view is defined by the resourcePath and the filename.
//     x (Number): Location of view relative to the left of the viewport.
//     y (Number): Location of view relative to the top of the viewport.
//     offsetX (Number): Distance in pixels the image is shifted right.
//     offsetY (Number): Distance in pixels the image is shifted down.
//     numFrames (Number): Number of frames of animation. If this property is set and greater than one, the view will be a sprite.
//     frameRate (Number): Delay between frames of animation (in 1 / 60 second increments).
//         Example:
//              frameRate: 60 // The delay between frames is one second
//              frameRate: 10 // The delay between frames is on 10 / 60 or 0.6 seconds
//     hotspots (Array):  Array of bounding rectangles that will act as the hotspot for the view if specified.
//         Example:
//              hotspots: [
//					{x: 38, y: 0, width: 161, height: 45},
//					{x: 9, y: 45, width: 201, height: 51}
//              ]
//     hotspotsVisible (Boolean): If true the hotspot rectangles of the view will be outlined. This is used for debug purposes only. 
//     states (Array): Array of views that describe specific states of the view.
//         Example:
//             states: [
//					{
//						type: "ON",
//						filename: "light-switch-on.png"
//					},{
//						type: "OFF",
//						filename: "light-switch-off.png"
//					}
//				]
//
// Audio Properties
//     states (Array): Array of audio sprites.
//         State Properties:
//             name (String): Type of audio state. 
//             startTime (Number): Start time of the state in seconds.
//             duration (Number): The duration of the state in seconds.
//             loop (Boolean): If true the state will loop.
//         Example:
//             states: [
//                 {
//                     type: "intro", 
//                     startTime: 0,
//                     duration: 3
//                 },
//  
// Game Properties
//     element (HTML Element): The HTML element in which the game will be populated. Usually a div element.
//         Example:
//              element: window.document.getElementById("game"),
//     device (String): What device the game is launched in (e.g. "IPHONE", "IPAD").
//     resourcePath (String): The url where all resources are relative to. Note the "/" is required.
//         Example:
//             resourcePath: "resources/"
//.    deviceOffset (Object):
//         Example:
//             deviceOffset: {
//.                iPhone: {x: -32, y: -64}
//.            }
//     rounds (Array): An array of objects containing each round's properties.
//	   startImageFilename (String): The url of image title card show at the beginning of the game.
//     audioEnabled (Boolean): If false audio will not be loaded or played.
//     audioFilename (String): The url of the audio file.

// Path Drawing Specific Properties
// ------------------------------------------------------------------
//
// Game Properties
//
//     audio
//         Available States:
//             INTRO: Played at the beginning of each round.
//             PAYOFF: Played after the hero reaches the goal.
//             MUSIC: Loops in the background.
//			   OBSTACLE_HIT: Plays when the path enters the hotspot of an obstacle.
//      hint
//         Properties:
//             color: The color (in hex e.g. #ff0000 for red) of the hint line.
//		       speed: The speed (in pixels per second) at which the line is drawn.
//		       width: The diameter of the line.
//		       dashWidth: The length of the dash.
//		       dashGap: The length of the gap between dashes.
//     bumpers
//         Properties:
//             top: Y location of the bumper on the top 
//             bottom: Y location of the bumper on the bottom in relation to the bottom of the screen
//             left: X location of the bumper on the left
//             right: X location of the bumper on the right in relation to the right side of the screen
//             hudWidth: Width of the rectangle in the top right hand corner of the screen.
//             hudHeight: Height of the rectangle in the top right hand corner of the screen.
//         
// Round Properties
//
//     pathColor: The color (in hex e.g. #ff0000 for red) of the path drawn.
//     background
//         Properties:
//            filename: Filename of the background image.
//     hero
//         Properties:
//             startX: Start x position of the hero.
//             startY: Start y position of the hero.
//             speed: Number of pixels the hero moves each frame when moving along the path.
//         Available States:
//             DEFAULT: Only currently supported state.
//     goal
//         Available States:
//             DEFAULT: Initial state of the goal.
//             GOAL: Displayed when the hero reaches the goal.
//     groups (Array): An array of obstacle groups. One set of obstacles will be randomly chosen each round.
//         obstacles
//             Available States:
//                 DEFAULT: Only currently supported state.

WM.config = {
	resourcePath: "resources/",
	deviceOffset: { //chopping of the BG image to iPhone size specs. Image BG must be 1024x768
		iPhone: {
			x: -32,
			y: -128
		}
	},
	gameIcon: "icon-pathDrawing-duckie.png",
	loadingImageWhiteFilename: "loading-white.png",
	loadingImageColorFilename: "loading-color.png",
	landscapeOnlyFilename: "landscape-only.png",
	exitButtonFilename: "exit-button.png",
	startImageFilename: "startImage-pathDrawing-duckie.jpg",
	audioEnabled: true,
	audioFilename: "audio-pathDrawing-duckie.mp3", //all audio including intro, payoff, and music is in this one file
	audio: {
		states: [
			{
				name: "payoff",
				startTime: 4,
				duration: 1.1
			},
			{
				name: "music", 
				startTime: 16,
				duration: 25.6,
				loop: true
			}
		]
	},
	bumpers: {
		top: 20,
		bottom: -20,
		left: 20,
		right: -20,
		hudWidth: 100,
		hudHeight: 90
	},
	hint: {
		color: "#ffea00",
		speed: 5,
		width: 30, //width of the line itself. Makes the dots get bigger
		dashWidth: 1, //width of the dash in pixels. Cannot go higher than 10px
		dashGap: 50 //number of pixels between each dash. Cannot go lower than 10px
	},
	rounds: [
		{ //Round 1
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 0,
						duration: 3
					}
				]
			},
			pathColor: "#aedde9",
			background: {
				filename: "background-bathtub.png"
			},
			hero: { //the object being moved down the path
				type: "Hero",
				startX: 105,
				startY: 270,
				speed: 10,
				states: [
					{
						type: "Default",
						filename: "rubber-duck.png",
						offsetX: -73, //starting position of the object
						offsetY: -140,
						hotspots: [
							{ x: -93, y: -160, width: 183, height: 198 } //hotspot position and size
						]
					}
				]
			},
			goal: {
				type: "Goal",
				startX: 423,
				startY: 368,
				states: [
					{
						type: "Default",
						filename: "ernie-duckie-1.png",
						hotspots: [
							{ x: 310, y: 37, width: 260, height: 204 },
							{ x: 245, y: 220, width: 350, height: 180 }
						]
					},{
						type: "Goal",
						filename: "ernie-duckie-1-goal.png",
						frameRate: 15,
						numFrames: 12
					}
				]
			},
			groups: [{}]
		},{ //Round 2
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 6,
						duration: 6
					}
				]
			},
			pathColor: "#aedde9",
			background: {
				filename: "background-bathtub.png"
			},
			hero: {
				type: "Hero",
				startX: 105,
				startY: 270,
				speed: 10,
				states: [
					{
						type: "Default",
						filename: "rubber-duck.png",
						offsetX: -73,
						offsetY: -140,
						hotspots: [
							{ x: -93, y: -160, width: 183, height: 198 }
						]
						
					}
				]
			},
			goal: {
				type: "Goal",
				startX: 423,
				startY: 368,
				states: [
					{
						type: "Default",
						filename: "ernie-duckie-1.png",
						hotspots: [
							{ x: 310, y: 37, width: 260, height: 204 },
							{ x: 245, y: 220, width: 350, height: 180 }
						]
					},{
						type: "Goal",
						filename: "ernie-duckie-2-goal.png",
						frameRate: 15,
						numFrames: 12
					}
				]
			},
			groups: [{
				obstacles: [ //randomly chooses from 1 of the 3 obstacles below
					{
						type: "Obstacle",
						startX: 200, //these x,y positions can be obtained from the original AI or PSD file using the top left corner as point of reference
						startY: 200,
						states: [
							{
								type: "Default",
								filename: "toy-boat.png",									
								hotspots: [
									{ x: 27, y: 50, width: 160, height: 118 }, //position of the rectangular hotspot around the obstacle. There can be as many rectangles as there needs to be to cover the entire area of the obstacle
									{ x: 70, y: 0, width: 50, height: 50 } //second rectangle hotspot
								]
							}
						]
					}
				]
			}, {
				obstacles: [
					{
						type: "Obstacle",
						startX: 380,
						startY: 280,
						states: [
							{
								type: "Default",
								filename: "toy-boat.png",											
								hotspots: [
									{ x: 27, y: 50, width: 160, height: 118 },
									{ x: 70, y: 0, width: 50, height: 50 }
								]
							}
						]
					}
				]
			}, {
				obstacles: [
					{
						type: "Obstacle",
						startX: 450,
						startY: 280,
						states: [
							{
								type: "Default",
								filename: "back-brush.png",									
								hotspots: [
									{ x: 120, y: 0, width: 70, height: 108 },
									{ x: 50, y: 106, width: 90, height: 77 },
									{ x: 0, y: 179, width: 67, height: 49 }
								]
							}
						]
					}
				]
			}]
		},{ //Round 3
			pathColor: "#aedde9",
			background: {
				filename: "background-bathtub.png"
			},
			hero: {
				type: "Hero",
				startX: 105,
				startY: 270,
				speed: 10,
				states: [
					{
						type: "Default",
						filename: "rubber-duck.png",
						offsetX: -73,
						offsetY: -140,
						hotspots: [
							{ x: -93, y: -160, width: 183, height: 198 }
						]
						
					}
				]
			},
			goal: {
				type: "Goal",
				startX: 423,
				startY: 368,
				states: [
					{
						type: "Default",
						filename: "ernie-duckie-1.png",
						hotspots: [
							{ x: 310, y: 37, width: 260, height: 204 },
							{ x: 245, y: 220, width: 350, height: 180 }
						]
					},{
						type: "Goal",
						filename: "ernie-duckie-3-goal.png",
						frameRate: 15,
						numFrames: 16
					}
				]
			},
			groups: [{
				obstacles: [
					{
						type: "Obstacle",
						startX: 200,
						startY: 300,
						states: [
							{
								type: "Default",
								filename: "sail-boat.png",								
								hotspots: [
									{ x: 80, y: 20, width: 53, height: 40 },
									{ x: 40, y: 60, width: 110, height: 60 },
									{ x: 20, y: 120, width: 140, height: 105 }
								]
							}
						]
					},
					{
						type: "Obstacle",
						startX: 550,
						startY: 130,
						states: [
							{
								type: "Default",
								filename: "submarine.png",								
								hotspots: [
									{ x: 95, y: 0, width: 40, height: 75 },
									{ x: 30, y: 75, width: 160, height: 90 }
								]
							}
						]
					}
				]
			}, {
				obstacles: [
					{
						type: "Obstacle",
						startX: 200,
						startY: 460,
						states: [
							{
								type: "Default",
								filename: "whale.png",									
								hotspots: [
									{ x: 40, y: 49, width: 180, height: 110 }
								]
							}
						]
					},
					{
						type: "Obstacle",
						startX: 350,
						startY: 200,
						states: [
							{
								type: "Default",
								filename: "submarine.png",								
								hotspots: [
									{ x: 95, y: 0, width: 40, height: 75 },
									{ x: 30, y: 75, width: 160, height: 90 }
								]
							}
						]
					}
				]
			}, {
				obstacles: [
					{
						type: "Obstacle",
						startX: 240,
						startY: 140,
						states: [
							{
								type: "Default",
								filename: "whale.png",									
								hotspots: [
									{ x: 40, y: 49, width: 180, height: 110 }
								]
							}
						]
					}, {
						type: "Obstacle",
						startX: 500,
						startY: 300,
						states: [
							{
								type: "Default",
								filename: "shampoo.png",									
								hotspots: [
									{ x: 40, y: 20, width: 60, height: 160 }
								]								
							}
						]
					}
				]
			}]
		},{ //Round 4
			pathColor: "#aedde9",
			background: {
				filename: "background-bathtub.png"
			},
			hero: {
				type: "Hero",
				startX: 105,
				startY: 270,
				speed: 10,
				states: [
					{
						type: "Default",
						filename: "rubber-duck.png",
						offsetX: -73,
						offsetY: -140,
						hotspots: [
							{ x: -93, y: -160, width: 183, height: 198 }
						]
						
					}
				]
			},
			goal: {
				type: "Goal",
				startX: 423,
				startY: 368,
				states: [
					{
						type: "Default",
						filename: "ernie-duckie-1.png",
						hotspots: [
							{ x: 310, y: 37, width: 260, height: 204 },
							{ x: 245, y: 220, width: 350, height: 180 }
						]
					},{
						type: "Goal",
						filename: "ernie-duckie-4-goal.png",
						frameRate: 15,
						numFrames: 12
					}
				]
			},
			groups: [{
				obstacles: [
					{
						type: "Obstacle",
						startX: 550,
						startY: 250,
						states: [
							{
								type: "Default",
								filename: "toy-boat-2.png",								
								hotspots: [
									{ x: 40, y: 20, width: 35, height: 50 },
									{ x: 30, y: 70, width: 120, height: 80 }
								]
							}
						]
					},{
						type: "Obstacle",
						startX: 300,
						startY: 140,
						states: [
							{
								type: "Default",
								filename: "sponge.png",									
								hotspots: [
									{ x: 70, y: 10, width: 120, height: 60 },
									{ x: 50, y: 43, width: 100, height: 60 }
								]
							}
						]
					},{
						type: "Obstacle",
						startX: 80,
						startY: 350,
						states: [
							{
								type: "Default",
								filename: "octopus.png",
								hotspots: [
									{ x: 50, y: 30, width: 20, height: 90 },
									{ x: 170, y: 25, width: 30, height: 100 },
									{ x: 30, y: 100, width: 250, height: 70 },
									{ x: 180, y: 160, width: 40, height: 80 }
								]
							}
						]
					}
				]
			}, {
				obstacles: [
					{
						type: "Obstacle",
						startX: 80,
						startY: 470,
						states: [
							{
								type: "Default",
								filename: "toy-boat-2.png",								
								hotspots: [
									{ x: 40, y: 20, width: 35, height: 50 },
									{ x: 30, y: 70, width: 120, height: 80 }
								]
							}
						]
					}, {
						type: "Obstacle",
						startX: 240,
						startY: 200,
						states: [
							{
								type: "Default",
								filename: "soap.png",
								hotspots: [
									{ x: 60, y: 20, width: 110, height: 60 }
								]										
							}
						]
					}, {
						type: "Obstacle",
						startX: 500,
						startY: 200,
						states: [
							{
								type: "Default",
								filename: "sail-boat-2.png",
								hotspots: [
									{ x: 80, y: 50, width: 60, height: 50 },
									{ x: 40, y: 97, width: 110, height: 110 }
								]
							}
						]
					}
				]		
			}, {
				obstacles: [
					{
						type: "Obstacle",
						startX: 80,
						startY: 540,
						states: [
							{
								type: "Default",
								filename: "sponge.png",									
								hotspots: [
									{ x: 70, y: 10, width: 120, height: 60 },
									{ x: 50, y: 43, width: 100, height: 60 }
								]
							}
						]
					},{
						type: "Obstacle",
						startX: 550,
						startY: 140,
						states: [
							{
								type: "Default",
								filename: "octopus.png",
								hotspots: [
									{ x: 50, y: 30, width: 20, height: 90 },
									{ x: 170, y: 25, width: 30, height: 100 },
									{ x: 30, y: 100, width: 250, height: 70 },
									{ x: 180, y: 160, width: 40, height: 80 }
								]
							}
						]
					},{
						type: "Obstacle",
						startX: 220,
						startY: 270,
						states: [
							{
								type: "Default",
								filename: "soap.png",
								hotspots: [
									{ x: 60, y: 20, width: 110, height: 60 }
								]										
							}
						]
					}
				]			
			}]
		},{ //Round 5
			pathColor: "#aedde9",
			background: {
				filename: "background-bathtub.png"
			},
			hero: {
				type: "Hero",
				startX: 105,
				startY: 270,
				speed: 10,
				states: [
					{
						type: "Default",
						filename: "rubber-duck.png",
						offsetX: -73,
						offsetY: -140,
						hotspots: [
							{ x: -93, y: -160, width: 183, height: 198 }
						]
						
					}
				]
			},
			goal: {
				type: "Goal",
				startX: 423,
				startY: 368,
				states: [
					{
						type: "Default",
						filename: "ernie-duckie-1.png",
						hotspots: [
							{ x: 310, y: 37, width: 260, height: 204 },
							{ x: 245, y: 220, width: 350, height: 180 }
						]
					},{
						type: "Goal",
						filename: "ernie-duckie-5-goal.png",
						frameRate: 15,
						numFrames: 20
					}
				]
			},
			groups: [{
				obstacles: [
					{
						type: "Obstacle",
						startX: 500,
						startY: 370,
						states: [
							{
								type: "Default",
								filename: "sponge-2.png",							
								hotspots: [
									{ x: 90, y: 5, width: 100, height: 50 },
									{ x: 45, y: 40, width: 110, height: 45 }
								]
							}
						]
					}, {
						type: "Obstacle",
						startX: 300,
						startY: 140,
						states: [
							{
								type: "Default",
								filename: "back-brush-2.png",
								hotspots: [
									{ x: 160, y: 20, width: 50, height: 75 },
									{ x: 80, y: 90, width: 90, height: 40 },
									{ x: 10, y: 130, width: 80, height: 40 }
								]
							}
						]
					}, {
						type: "Obstacle",
						startX: 60,
						startY: 424,
						states: [
							{
								type: "Default",
								filename: "submarine.png",							
								hotspots: [
									{ x: 95, y: 0, width: 40, height: 75 },
									{ x: 30, y: 75, width: 160, height: 90 }
								]
							}
						]
					}, {
						type: "Obstacle",
						startX: 700,
						startY: 140,
						states: [
							{
								type: "Default",
								filename: "whale.png",							
								hotspots: [
									{ x: 40, y: 49, width: 180, height: 110 }
								]
							}
						]
					}
				]
			}, {
				obstacles: [
					{
						type: "Obstacle",
						startX: 313,
						startY: 216,
						states: [
							{
								type: "Default",
								filename: "sponge-2.png",							
								hotspots: [
									{ x: 90, y: 5, width: 100, height: 50 },
									{ x: 45, y: 40, width: 110, height: 45 }
								]
							}
						]
					},{
						type: "Obstacle",
						startX: 780,
						startY: 140,
						states: [
							{
								type: "Default",
								filename: "shampoo-2.png",							
								hotspots: [
									{ x: 20, y: 20, width: 90, height: 70 },
									{ x: 88, y: 60, width: 80, height: 70 }
								]
							}
						]
					},{
						type: "Obstacle",
						startX: 412,
						startY: 424,
						states: [
							{
								type: "Default",
								filename: "submarine.png",							
								hotspots: [
									{ x: 95, y: 0, width: 40, height: 75 },
									{ x: 30, y: 75, width: 160, height: 90 }
								]
							}
						]
					},{
						type: "Obstacle",
						startX: 20,
						startY: 480,
						states: [
							{
								type: "Default",
								filename: "whale.png",								
								hotspots: [
									{ x: 40, y: 49, width: 180, height: 110 }
								]
							}
						]
					}
				]
			}, {
				obstacles: [
					{
						type: "Obstacle",
						startX: 600,
						startY: 140,
						states: [
							{
								type: "Default",
								filename: "sponge-2.png",								
								hotspots: [
									{ x: 90, y: 5, width: 100, height: 50 },
									{ x: 45, y: 40, width: 110, height: 45 }
								]
							}
						]
					},{
						type: "Obstacle",
						startX: 412,
						startY: 424,
						states: [
							{
								type: "Default",
								filename: "shampoo-2.png",							
								hotspots: [
									{ x: 20, y: 20, width: 90, height: 70 },
									{ x: 88, y: 60, width: 80, height: 70 }
								]
							}
						]
					},{
						type: "Obstacle",
						startX: 80,
						startY: 580,
						states: [
							{
								type: "Default",
								filename: "soap-2.png",							
								hotspots: [
									{ x: 80, y: 20, width: 120, height: 65 }
								]
							}
						]
					},{
						type: "Obstacle",
						startX: 240,
						startY: 140,
						states: [
							{
								type: "Default",
								filename: "submarine.png",							
								hotspots: [
									{ x: 95, y: 0, width: 40, height: 75 },
									{ x: 30, y: 75, width: 160, height: 90 }
								]
							}
						]
					}
				]
			}]
		}
	]
};