App.controller('home', function (page) {
	var someresult = false;
	store.forEach(function(key, value) {
		if(key.indexOf('lista_')!=-1) {
			someresult = true;
			$(page).find('.lists-list').append('<li rel="'+key+'">'+value.name+'</li>');
		}
	});
	if(someresult) {
		$(page).find('.lists-list li').on('click', function() {
			var lista = $(this).attr('rel');
			App.load('verlista', { lista: lista } );
		});
	} else {
		$(page).find('.lists-list').html('<center>Você ainda não possui nenhum centro de estoque.</center>');
	}
});

App.controller('verlista', function(page, lista) {
	window.modifiedlista = false;
	var lista = lista.lista;
	var lista_data = store.get(lista);
	$(page).find('.app-title').text(lista_data.name);
	$(page).find('.list-name').val(lista_data.name);

	lista_data.products.forEach(function(item) {
		$(page).find('.produtoslista').append('<li><span class="list-quant">'+item.quant+'</span> <span class="list-itemname">'+item.name+'</span></li>');
	});
	
	$(page).find('.left').on('click', function() {
		if(window.modifiedlista) {
			App.dialog({
			  title        : 'Salvar estoque',
			  text         : 'Deseja salvar as alterações?',
			  okButton     : 'Salvar',
			  cancelButton : 'Cancelar'
			}, function (save) {
			  if (save) {
				
				var nomedalista = $(page).find('.list-name').val();
				if(!nomedalista) {
					var nomedalista = prompt("Insira um nome para este centro de estoque.", "");
				}
				
				store.remove(lista);
			  
				var produtos = new Array();
				
				$(page).find('.produtoslista li').each(function() {
					var produtonome = $(this).find('.list-itemname').text();
					var quantidade = parseInt($(this).find('.list-quant').text());
					produtos.push({ name: produtonome, quant: quantidade });
				});
				
				store.set(lista, { name: nomedalista, products: produtos } );
			  } else {
				$(page).find('.produtoslista li').remove();
			  }
			  App.load('home');
			});
		} else {
			App.back();
		}
	});
	
	$(page).find('.delthis').on('click', function() {
		App.dialog({
			title:			'Excluir lista?',
			text:			'Tem certeza que deseja excluir essa lista?',
			okButton:		'Excluir',
			cancelButton:	'Manter'
		}, function(del) {
			if(del) {
				store.remove(lista);
				App.load('home');
			}
		});
	});
	
	$(page).find('.additem').on('click', function() {
		var produtonome = $(page).find('.novoitem').val();
		var quantidade = parseInt($(page).find('.quantidade').val());
		if(produtonome && !isNaN(quantidade)) {
			$(page).find('.produtoslista').append('<li><span class="list-quant">'+quantidade+'</span> <span class="list-itemname">'+produtonome+'</span></li>');
			$(page).find('.novoitem').val('');
			$(page).find('.quantidade').val('');
			window.modifiedlista = true;
		}
	});
	
	$(page).on('click', '.produtoslista li', function() { // permanent selector
		var produtonome = $(this).find('.list-itemname').text();
		var quantidade = parseInt($(this).find('.list-quant').text());
		$(page).find('.novoitem').val(produtonome);
		$(page).find('.quantidade').val(quantidade);
		$(this).remove();
		window.modifiedlista = true;
	});

	$(page).find('.sendmail').on('click', function() {
		var estoque_nome,estoque_body,agora;

		if(window.modifiedlista) {
			alert("Antes de enviar, salve a lista clicando no botão de \"Voltar\".");
		} else {
			moment.locale('pt-br');
			estoque_nome = $(page).find('.list-name').val();
			agora = moment().format("D [de] MMMM [de] YYYY, HH:mm:ss");
			estoque_body  = "Situação do estoque "+estoque_nome+"\n";
			estoque_body += "Gerado em: "+agora+"\n";

			$(page).find('.produtoslista li').each(function() {
					var produtonome = $(this).find('.list-itemname').text();
					var quantidade = parseInt($(this).find('.list-quant').text());
					estoque_body += " - ";
					estoque_body += ""+produtonome+": ";
					estoque_body +=	String(quantidade);
					estoque_body +=	"\n";
			});
			estoque_body += "\n\nGerado utilizando app Estoque.";
		
			//window.plugins.socialsharing.shareViaWhatsApp('Message via WhatsApp', null /* img */, null /* url */, function() {
			window.plugins.socialsharing.share(estoque_body, null /* img */, null /* url */, function() {
				// nothing
			}, function(errormsg){
				
			});

		}
	});

	$(page).find('.sendmail2').on('click', function() {
		var estoque_nome,estoque_body,agora;

		if(window.modifiedlista) {
			alert("Antes de enviar, salve a lista clicando no botão de \"Voltar\".");
		} else {
			moment.locale('pt-br');
			estoque_nome = $(page).find('.list-name').val();
			agora = moment().format("D [de] MMMM [de] YYYY, HH:mm:ss");
			estoque_body  = "<h2>Situação do estoque "+estoque_nome+"</h2>\n";
			estoque_body += "<p>Gerado em: "+agora+"</p>";

			$(page).find('.produtoslista li').each(function() {
					var produtonome = $(this).find('.list-itemname').text();
					var quantidade = parseInt($(this).find('.list-quant').text());
					estoque_body += " &middot; ";
					estoque_body += "<b>"+produtonome+"</b>&nbsp;";
					estoque_body +=	String(quantidade);
					estoque_body +=	"<br/>";
			});
			estoque_body += "</ul>\n<p>Gerado utilizando app <a href=\"http://jefrey.ml/estoque\">Estoque</a>.</p>";
			
			cordova.plugins.email.open({
				subject: "Situação do estoque "+estoque_nome,
				body: estoque_body,
				isHTML: true
			});
		}
	});
});

App.controller('novalista', function (page) {
	window.modifiedlista = false;
	
	$(page).find('.left').on('click', function() {
		if(window.modifiedlista) {
			App.dialog({
			  title        : 'Salvar',
			  text         : 'Deseja salvar este centro de estoque?',
			  okButton     : 'Salvar',
			  cancelButton : 'Cancelar'
			}, function (save) {
			  if (save) {
				var nomedalista = $(page).find('.list-name').val();
				if(!nomedalista) {
					var nomedalista = prompt("Insira um nome para este centro de estoque.", "");
				}
				
				var produtos = new Array();
				
				$(page).find('.produtoslista li').each(function() {
					var produtonome = $(this).find('.list-itemname').text();
					var quantidade = parseInt($(this).find('.list-quant').text());
					produtos.push({ name: produtonome, quant: quantidade });
				});
				
				var listakey = uniqid();
				store.set('lista_'+listakey, { name: nomedalista, products: produtos } );
			  } else {
				$(page).find('.produtoslista li').remove();
			  }
			  App.load('home');
			});
		} else {
			App.back();
		}
	});
	
	$(page).find('.additem').on('click', function() {
		var produtonome = $(page).find('.novoitem').val();
		var quantidade = parseInt($(page).find('.quantidade').val());
		if(produtonome && quantidade) {
			$(page).find('.produtoslista').append('<li><span class="list-quant">'+quantidade+'</span> <span class="list-itemname">'+produtonome+'</span></li>');
			$(page).find('.novoitem').val('');
			$(page).find('.quantidade').val('');
			window.modifiedlista = true;
		}
	});
	
	$(page).on('click', '.produtoslista li', function() {
		var produtonome = $(this).find('.list-itemname').text();
		var quantidade = parseInt($(this).find('.list-quant').text());
		$(page).find('.novoitem').val(produtonome);
		$(page).find('.quantidade').val(quantidade);
		$(this).remove();
		window.modifiedlista = true;
	});
});

try {
	App.restore();
} catch (err) {
	App.load('home');
}