
function roundSelected()
{
	var elm=document.getElementById("s_roundSelect");
	var val=elm.value;
	
	window.location='/round.html?round='+val;
}


function createAllTeamsTable()
{
	var teams=getAllTeams();
	
	var tableStr="<table>\n";
	for ( var i = 0; i < teams.length/2; i++)
	{
		tableStr+="<tr>\n";
		
		for ( var j = 0; j < 2; j++)
		{
			var index=i*2+j;
			tableStr+="<td width=\"50%\">\n";
			tableStr+="<div width=\"100%\" id=\""+teams[index].id+"\" onclick=\"window.location='/team.html?id='+this.id;\">\n";
			tableStr+="<center>\n";
			
			tableStr+="<div style=\"margin: 0px\"><img src=\"./images/teams/"+teams[index].id+".png\" style=\"margin: 0px\"></img></div>\n";
			tableStr+="<div style=\"margin-bottom: 20px\">"+teams[index].name+"</div>\n";
			
			tableStr+="</center>\n";
			tableStr+="</div>\n";
			tableStr+="</td>\n";
		}
		
		tableStr+="</tr>\n";
	}
	tableStr+="</table>\n";
	
	document.getElementById('teamsTable').innerHTML = tableStr;
}

function getAllTeams()
{
	var teams=[
		        {id:6383,name:"Greece"},
		        {id:8496,name:"Czech Republic"},
		        {id:8568,name:"Poland"},
		        {id:8713,name:"Russia"},
		        {id:8570,name:"Germany"},
		        {id:8361,name:"Portugal"},
		        {id:8238,name:"Denmark"},
		       	{id:6708,name:"Netherlands"},
		       	{id:10155,name:"Croatia"},
		       	{id:8204,name:"Italy"},
		       	{id:6720,name:"Spain"},
		      	{id:5791,name:"Ireland"},
		       	{id:8520,name:"Sweden"},
		       	{id:8491,name:"England"},
		       	{id:6723,name:"France"},
		        {id:6718,name:"Ukraine"}
		        ];
		
	return teams;
}

function getAllGames()
{
	//select
	//'{' || 'fixtureid:' || fixtureid || ',date:"' || date || '",round:"' || round || '",home:' || home_team || ',away:' || away_team || ',score:"' || score || '"},'
	//from fixtures
	
	var games=[
{fixtureid:1139465,date:"2012-06-08T16:00:00",round:"Group A",home:8568,away:6383,score:"1 - 1"},
{fixtureid:1139466,date:"2012-06-08T18:45:00",round:"Group A",home:8713,away:8496,score:"4 - 1"},
{fixtureid:1139467,date:"2012-06-12T16:00:00",round:"Group A",home:6383,away:8496,score:"1 - 2"},
{fixtureid:1139468,date:"2012-06-12T18:45:00",round:"Group A",home:8568,away:8713,score:"1 - 1"},
{fixtureid:1139469,date:"2012-06-16T18:45:00",round:"Group A",home:8496,away:8568,score:"1 - 0"},
{fixtureid:1139470,date:"2012-06-16T18:45:00",round:"Group A",home:6383,away:8713,score:"1 - 0"},
{fixtureid:1139471,date:"2012-06-09T16:00:00",round:"Group B",home:6708,away:8238,score:"0 - 1"},
{fixtureid:1139472,date:"2012-06-09T18:45:00",round:"Group B",home:8570,away:8361,score:"1 - 0"},
{fixtureid:1139473,date:"2012-06-13T16:00:00",round:"Group B",home:8238,away:8361,score:"2 - 3"},
{fixtureid:1139475,date:"2012-06-13T18:45:00",round:"Group B",home:6708,away:8570,score:"1 - 2"},
{fixtureid:1139477,date:"2012-06-17T18:45:00",round:"Group B",home:8361,away:6708,score:"2 - 1"},
{fixtureid:1139478,date:"2012-06-17T18:45:00",round:"Group B",home:8238,away:8570,score:"1 - 2"},
{fixtureid:1139474,date:"2012-06-10T16:00:00",round:"Group C",home:6720,away:8204,score:"1 - 1"},
{fixtureid:1139476,date:"2012-06-10T18:45:00",round:"Group C",home:5791,away:10155,score:"1 - 3"},
{fixtureid:1139480,date:"2012-06-14T16:00:00",round:"Group C",home:8204,away:10155,score:"1 - 1"},
{fixtureid:1139479,date:"2012-06-14T18:45:00",round:"Group C",home:6720,away:5791,score:"4 - 0"},
{fixtureid:1139482,date:"2012-06-18T18:45:00",round:"Group C",home:10155,away:6720,score:"0 - 1"},
{fixtureid:1139485,date:"2012-06-18T18:45:00",round:"Group C",home:8204,away:5791,score:"2 - 0"},
{fixtureid:1139481,date:"2012-06-11T16:00:00",round:"Group D",home:6723,away:8491,score:"1 - 1"},
{fixtureid:1139483,date:"2012-06-11T18:45:00",round:"Group D",home:6718,away:8520,score:"2- 1"},
{fixtureid:1139486,date:"2012-06-15T16:00:00",round:"Group D",home:6718,away:6723,score:"0 - 2"},
{fixtureid:1139484,date:"2012-06-15T19:00:00",round:"Group D",home:8520,away:8491,score:"2 - 3"},
{fixtureid:1139487,date:"2012-06-19T18:45:00",round:"Group D",home:8491,away:6718,score:"1 - 0"},
{fixtureid:1139488,date:"2012-06-19T18:45:00",round:"Group D",home:8520,away:6723,score:"2 - 0"},
{fixtureid:1139309,date:"2012-06-21T18:45:00",round:"Quarter finals",home:8496,away:8361,score:"0 - 1"},
{fixtureid:1139310,date:"2012-06-22T18:45:00",round:"Quarter finals",home:8570,away:6383,score:"4 - 2"},
{fixtureid:1139311,date:"2012-06-23T18:45:00",round:"Quarter finals",home:6720,away:6723,score:"2 - 0"},
{fixtureid:1139312,date:"2012-06-24T18:45:00",round:"Quarter finals",home:8491,away:8204,score:"0 - 0"},
{fixtureid:1139313,date:"2012-06-27T18:45:00",round:"Semi finals",home:8361,away:6720,score:"0 - 0"},
{fixtureid:1139314,date:"2012-06-28T18:45:00",round:"Semi finals",home:8570,away:8204,score:"1 - 2"},
{fixtureid:1139317,date:"2012-07-01T18:45:00",round:"Final",home:6720,away:8204,score:"4 - 0"},
	           ];
	
	return games;
}

function gup(name)
{
	name = name.replace(/[\[]/,"\\\[").replace(/[\]]/,"\\\]");  
	var regexS = "[\\?&]"+name+"=([^&#]*)";  
	var regex = new RegExp( regexS );  
	var results = regex.exec( window.location.href ); 
	 if( results == null )    return "";  
	else    return results[1];
}

function setTeamTitle()
{
	var teamid=gup("id");
	document.write(getTeamFromID(teamid));
}

function setRoundTitle()
{
	var round=gup("round").replace("%20"," ");
	document.write(round);
}

function setMatchTitle()
{
	var matchid=gup("id");
	var match=getMatchFromID(matchid);
	if (match!=null)
	{
		var title=getTeamFromID(match.home)+" - "+getTeamFromID(match.away);
		document.write(title);
	}
	else
	{
		document.write(matchid);
	}
		
}

function getTeamFromID(id)
{
	var teams=getAllTeams();
	for ( var i = 0; i < teams.length; i++)
	{
		if (teams[i].id==id)
			return teams[i].name;
	}
	return "-";
}

function getGamesFromTeam(id)
{
	var games=getAllGames();
	var g=[];
	for ( var i = 0; i < games.length; i++)
	{
		if (games[i].home==id || games[i].away==id)
		{
			g.push(games[i]);
		}
	}
	return g;
}

function getGamesFromRound(round)
{
	var games=getAllGames();
	var g=[];
	for ( var i = 0; i < games.length; i++)
	{
		if (games[i].round==round)
		{
			g.push(games[i]);
		}
	}
	return g;
}

function getMatchFromID(id)
{
	try
	{
		var games=getAllGames();
		for ( var i = 0; i < games.length; i++)
		{
			if (games[i].fixtureid==id)
				return games[i];
		}
	}
	catch (e)
	{
		alert(e.toString());
	}
	return null;
}

function createGamesOfTeamTable(onegame) //pare to id apo ti selida
{
	try {
		
	
	var teamid=gup("id");
	var isRound=false;
	var games=null;
	if (teamid)
	{
		games=getGamesFromTeam(teamid);
	}
	else
	{
		isRound=true;
		teamid=gup("round").replace("%20"," ");
		games=getGamesFromRound(teamid);
	}
	
	if (onegame!=null)
	{
		games=onegame;
	}
	
	
	var tableStr="<center><table style=\"margin:0px; padding:0px;\" width=\"100%\">\n";
	for ( var i = 0; i < games.length; i++)
	{
		tableStr+="<tr style=\"margin:0px;  padding:0px;\" width=\"100%\" >\n";
		
		tableStr+="<td width=\"100%\">\n";
		tableStr+="<div width=\"100%\" id=\""+games[i].fixtureid+"\" onclick=\"window.location='/match.html?id='+this.id;\" style=\"background: #ad00fe;\">\n";
		tableStr+="<center>\n";
		
		
		
		tableStr+="<table width=\"100%\">\n";
		
		tableStr+="<tr width=\"100%\">\n";
		tableStr+="<td>\n";
		tableStr+="<img src=\"./images/teams/"+games[i].home+".png\" style=\"margin: 0px\" ></img>\n";
		tableStr+="</td>\n";
		tableStr+="<td>\n";
		tableStr+=getTeamFromID(games[i].home);
		tableStr+="</td>\n";
		tableStr+="<td width=\"99%\">\n";
		tableStr+="</td>\n";
		tableStr+="<td>\n";
		tableStr+=getTeamFromID(games[i].away);
		tableStr+="</td>\n";
		tableStr+="<td>\n";
		tableStr+="<img src=\"./images/teams/"+games[i].away+".png\" style=\"margin: 0px\"></img>\n";
		tableStr+="</td>\n";
		tableStr+="</tr>\n";
		
		tableStr+="<tr width=\"100%\">\n";
		tableStr+="<td colspan=\"5\">\n";
		tableStr+="<center>\n";
		tableStr+=games[i].score;
		tableStr+="</center>\n";
		tableStr+="</td>\n";
		tableStr+="</tr>\n";
		
		tableStr+="<tr width=\"100%\">\n";
		tableStr+="<td colspan=\"2\">\n";
		tableStr+=games[i].round;
		tableStr+="</td>\n";
		tableStr+="<td width=\"99%\">\n";
		tableStr+="</td>\n";
		tableStr+="<td colspan=\"2\">\n";
		tableStr+=games[i].date.replace("T"," ").replace("00:00","00").replace("45:00","00");
		tableStr+="</td>\n";
		tableStr+="</tr>\n";
		
		tableStr+="</table>\n";
		
		
		
		tableStr+="</center>\n";
		tableStr+="</div>\n";
		tableStr+="</td>\n";
		tableStr+="</tr>\n";
	}
	tableStr+="</table></center>\n";
	} catch (e) {
		alert(e.message);
	}

	document.getElementById('gamesTable').innerHTML = tableStr;
}


function createGameDiv()
{
	var matchid=gup("id");
	var match=getMatchFromID(matchid);
	var games=[match];
	createGamesOfTeamTable(games);
}



function getAllIncidents()
{
	var incidents=[
	               
{id:176,eventid:1139471,aa:14,type:"in",home:"Dirk Kuyt 85'",away:""},
{id:175,eventid:1139471,aa:13,type:"out",home:"Gregory van der Wiel 85'",away:""},
{id:171,eventid:1139471,aa:12,type:"in",home:"",away:"84' Tobias P. Mikkelsen"},
{id:170,eventid:1139471,aa:11,type:"out",home:"",away:"84' Dennis Rommedahl"},
{id:169,eventid:1139471,aa:10,type:"y",home:"",away:"81' William Kvist"},
{id:168,eventid:1139471,aa:9,type:"y",home:"",away:"78' Simon Poulsen"},
{id:167,eventid:1139471,aa:8,type:"in",home:"",away:"74' Lasse Schøne"},
{id:165,eventid:1139471,aa:6,type:"in",home:"Klaas Jan Huntelaar 71'",away:""},
{id:166,eventid:1139471,aa:7,type:"out",home:"",away:"74' Christian Eriksen"},
{id:162,eventid:1139471,aa:3,type:"out",home:"Nigel de Jong 71'",away:""},
{id:163,eventid:1139471,aa:4,type:"in",home:"Rafael van der Vaart 71'",away:""},
{id:164,eventid:1139471,aa:5,type:"out",home:"Ibrahim Afellay 71'",away:""},
{id:160,eventid:1139471,aa:1,type:"n",home:"",away:"24' Michael Krohn-Dehli"},
{id:161,eventid:1139471,aa:2,type:"y",home:"Mark van Bommel 67'",away:""},
{id:71,eventid:1139472,aa:15,type:"in",home:"Lars Bender 90'",away:""},
{id:70,eventid:1139472,aa:14,type:"out",home:"Thomas Müller 90'",away:""},
{id:68,eventid:1139472,aa:12,type:"out",home:"Mesut Özil 87'",away:""},
{id:69,eventid:1139472,aa:13,type:"in",home:"Toni Kroos 87'",away:""},
{id:67,eventid:1139472,aa:11,type:"in",home:"",away:"80' Silvestre Varela"},
{id:66,eventid:1139472,aa:10,type:"out",home:"",away:"80' Raul Meireles"},
{id:65,eventid:1139472,aa:9,type:"in",home:"Miroslav Klose 80'",away:""},
{id:63,eventid:1139472,aa:7,type:"n",home:"Mario Gomez 72'",away:""},
{id:64,eventid:1139472,aa:8,type:"out",home:"Mario Gomez 80'",away:""},
{id:62,eventid:1139472,aa:6,type:"in",home:"",away:"70' Nélson Oliveira"},
{id:61,eventid:1139472,aa:5,type:"out",home:"",away:"70' Hélder Postiga"},
{id:60,eventid:1139472,aa:4,type:"y",home:"Jérome Boateng 69'",away:""},
{id:59,eventid:1139472,aa:3,type:"y",home:"",away:"61' Fabio Coentrao"},
{id:58,eventid:1139472,aa:2,type:"y",home:"Holger Badstuber 43'",away:""},
{id:57,eventid:1139472,aa:1,type:"y",home:"",away:"13' Hélder Postiga"},
{id:92,eventid:1139465,aa:1,type:"n",home:"Robert Lewandowski 17'",away:""},
{id:93,eventid:1139465,aa:2,type:"assist",home:"Jakub Blaszczykowski 17'",away:""},
{id:94,eventid:1139465,aa:3,type:"y",home:"",away:"35' Sokratis Papastathopoulos"},
{id:95,eventid:1139465,aa:4,type:"out",home:"",away:"36' Avraam Papadopoulos"},
{id:96,eventid:1139465,aa:5,type:"in",home:"",away:"36' Kyriakos Papadopoulos"},
{id:97,eventid:1139465,aa:6,type:"y2",home:"",away:"44' Sokratis Papastathopoulos"},
{id:98,eventid:1139465,aa:7,type:"y",home:"",away:"45' José Holebas"},
{id:99,eventid:1139465,aa:8,type:"out",home:"",away:"46' Sotirios Ninis"},
{id:100,eventid:1139465,aa:9,type:"in",home:"",away:"46' Dimitrios Salpingidis"},
{id:101,eventid:1139465,aa:10,type:"n",home:"",away:"51' Dimitrios Salpingidis"},
{id:102,eventid:1139465,aa:11,type:"assist",home:"",away:"51' Georgios Karagounis"},
{id:103,eventid:1139465,aa:12,type:"y",home:"",away:"54' Georgios Karagounis"},
{id:104,eventid:1139465,aa:13,type:"out",home:"",away:"68' Theofanis Gekas"},
{id:105,eventid:1139465,aa:14,type:"in",home:"",away:"68' Konstantinos Fortounis"},
{id:106,eventid:1139465,aa:15,type:"r",home:"Wojciech Szczesny 69'",away:""},
{id:107,eventid:1139465,aa:16,type:"out",home:"Maciej Rybus 70'",away:""},
{id:108,eventid:1139465,aa:17,type:"in",home:"Przemyslaw Tyton 70'",away:""},
{id:109,eventid:1139465,aa:18,type:"npm",home:"",away:"71' Georgios Karagounis"},
{id:110,eventid:1139466,aa:1,type:"n",home:"Alan Dzagoev 15'",away:""},
{id:111,eventid:1139466,aa:2,type:"assist",home:"Alexandr Kerzhakov 15'",away:""},
{id:112,eventid:1139466,aa:3,type:"n",home:"Roman Shirokov 24'",away:""},
{id:113,eventid:1139466,aa:4,type:"assist",home:"Andrey Arshavin 24'",away:""},
{id:114,eventid:1139466,aa:5,type:"out",home:"",away:"46' Jan Rezek"},
{id:115,eventid:1139466,aa:6,type:"in",home:"",away:"46' Tomas Hübschman"},
{id:116,eventid:1139466,aa:7,type:"n",home:"",away:"52' Vaclav Pilar"},
{id:117,eventid:1139466,aa:8,type:"assist",home:"",away:"52' Jaroslav Plasil"},
{id:118,eventid:1139466,aa:9,type:"out",home:"Alexandr Kerzhakov 73'",away:""},
{id:119,eventid:1139466,aa:10,type:"in",home:"Roman Pavlyuchenko 73'",away:""},
{id:120,eventid:1139466,aa:11,type:"out",home:"",away:"75' Petr Jiracek"},
{id:121,eventid:1139466,aa:12,type:"in",home:"",away:"75' Milan Petrzela"},
{id:122,eventid:1139466,aa:13,type:"n",home:"Alan Dzagoev 79'",away:""},
{id:123,eventid:1139466,aa:14,type:"assist",home:"Roman Pavlyuchenko 79'",away:""},
{id:124,eventid:1139466,aa:15,type:"n",home:"Roman Pavlyuchenko 82'",away:""},
{id:125,eventid:1139466,aa:16,type:"out",home:"Alan Dzagoev 85'",away:""},
{id:126,eventid:1139466,aa:17,type:"in",home:"Alexander Kokorin 85'",away:""},
{id:127,eventid:1139466,aa:18,type:"out",home:"",away:"86' Milan Baros"},
{id:128,eventid:1139466,aa:19,type:"in",home:"",away:"86' David Lafata"},
{id:177,eventid:1139474,aa:1,type:"y",home:"",away:"37' Mario Balotelli"},
{id:178,eventid:1139474,aa:2,type:"out",home:"",away:"56' Mario Balotelli"},
{id:179,eventid:1139474,aa:3,type:"in",home:"",away:"56' Antonio Di Natale"},
{id:180,eventid:1139474,aa:4,type:"n",home:"",away:"61' Antonio Di Natale"},
{id:181,eventid:1139474,aa:5,type:"assist",home:"",away:"61' Andrea Pirlo"},
{id:182,eventid:1139474,aa:6,type:"n",home:"Cesc Fabregas 64'",away:""},
{id:183,eventid:1139474,aa:7,type:"assist",home:"David Silva 64'",away:""},
{id:184,eventid:1139474,aa:8,type:"out",home:"David Silva 65'",away:""},
{id:185,eventid:1139474,aa:9,type:"in",home:"Jesus Navas 65'",away:""},
{id:186,eventid:1139474,aa:10,type:"out",home:"",away:"65' Antonio Cassano"},
{id:187,eventid:1139474,aa:11,type:"in",home:"",away:"65' Sebastian Giovinco"},
{id:188,eventid:1139474,aa:12,type:"y",home:"",away:"66' Leonardo Bonucci"},
{id:189,eventid:1139474,aa:13,type:"y",home:"Jordi Alba 66'",away:""},
{id:190,eventid:1139474,aa:14,type:"out",home:"Cesc Fabregas 74'",away:""},
{id:191,eventid:1139474,aa:15,type:"in",home:"Fernando Torres 74'",away:""},
{id:192,eventid:1139474,aa:16,type:"y",home:"",away:"79' Giorgio Chiellini"},
{id:193,eventid:1139474,aa:17,type:"y",home:"Alvaro Arbeloa 84'",away:""},
{id:194,eventid:1139474,aa:18,type:"y",home:"Fernando Torres 84'",away:""},
{id:195,eventid:1139474,aa:19,type:"y",home:"",away:"89' Christian Maggio"},
{id:196,eventid:1139474,aa:20,type:"out",home:"",away:"90' Thiago Motta"},
{id:197,eventid:1139474,aa:21,type:"in",home:"",away:"90' Antonio Nocerino"},
{id:198,eventid:1139476,aa:1,type:"n",home:"",away:"3' Mario Mandzukic"},
{id:199,eventid:1139476,aa:2,type:"assist",home:"",away:"3' Darijo Srna"},
{id:200,eventid:1139476,aa:3,type:"n",home:"Sean St. Ledger 19'",away:""},
{id:201,eventid:1139476,aa:4,type:"assist",home:"Aiden McGeady 19'",away:""},
{id:202,eventid:1139476,aa:5,type:"n",home:"",away:"43' Nikica Jelavic"},
{id:203,eventid:1139476,aa:6,type:"y",home:"Keith Andrews 45'",away:""},
{id:204,eventid:1139476,aa:7,type:"n",home:"",away:"48' Mario Mandzukic"},
{id:205,eventid:1139476,aa:8,type:"assist",home:"",away:"48' Ivan Perisic"},
{id:206,eventid:1139476,aa:9,type:"y",home:"",away:"53' Luka Modric"},
{id:207,eventid:1139476,aa:10,type:"out",home:"Kevin Doyle 53'",away:""},
{id:208,eventid:1139476,aa:11,type:"in",home:"Jonathan Walters 53'",away:""},
{id:209,eventid:1139476,aa:12,type:"out",home:"Aiden McGeady 54'",away:""},
{id:210,eventid:1139476,aa:13,type:"in",home:"Simon Cox 54'",away:""},
{id:211,eventid:1139476,aa:14,type:"out",home:"",away:"72' Nikica Jelavic"},
{id:212,eventid:1139476,aa:15,type:"in",home:"",away:"72' Niko Kranjcar"},
{id:213,eventid:1139476,aa:16,type:"out",home:"Robbie Keane 75'",away:""},
{id:214,eventid:1139476,aa:17,type:"in",home:"Shane Long 75'",away:""},
{id:215,eventid:1139476,aa:18,type:"y",home:"",away:"84' Niko Kranjcar"},
{id:216,eventid:1139476,aa:19,type:"out",home:"",away:"89' Ivan Perisic"},
{id:217,eventid:1139476,aa:20,type:"in",home:"",away:"89'  Eduardo"},
{id:218,eventid:1139476,aa:21,type:"out",home:"",away:"90' Ivan Rakitic"},
{id:219,eventid:1139476,aa:22,type:"in",home:"",away:"90' Tomislav Dujmovic"},
{id:220,eventid:1139481,aa:1,type:"n",home:"",away:"30' Joleon Lescott"},
{id:221,eventid:1139481,aa:2,type:"assist",home:"",away:"30' Steven Gerrard"},
{id:222,eventid:1139481,aa:3,type:"y",home:"",away:"34' Alex Oxlade-Chamberlain"},
{id:223,eventid:1139481,aa:4,type:"n",home:"Samir Nasri 39'",away:""},
{id:224,eventid:1139481,aa:5,type:"assist",home:"Franck Ribéry 39'",away:""},
{id:225,eventid:1139481,aa:6,type:"y",home:"",away:"71' Ashley Young"},
{id:226,eventid:1139481,aa:7,type:"out",home:"",away:"77' Alex Oxlade-Chamberlain"},
{id:227,eventid:1139481,aa:8,type:"in",home:"",away:"77' Jermain Defoe"},
{id:228,eventid:1139481,aa:9,type:"out",home:"",away:"78' Scott Parker"},
{id:229,eventid:1139481,aa:10,type:"in",home:"",away:"78' Jordan Henderson"},
{id:230,eventid:1139481,aa:11,type:"out",home:"Yohan Cabaye 84'",away:""},
{id:231,eventid:1139481,aa:12,type:"in",home:"Hatem Ben Arfa 84'",away:""},
{id:232,eventid:1139481,aa:13,type:"out",home:"Florent Malouda 85'",away:""},
{id:233,eventid:1139481,aa:14,type:"in",home:"Marvin Martin 85'",away:""},
{id:234,eventid:1139481,aa:15,type:"out",home:"",away:"90' Danny Welbeck"},
{id:235,eventid:1139481,aa:16,type:"in",home:"",away:"90' Theo Walcott"},
{id:236,eventid:1139483,aa:1,type:"y",home:"",away:"11' Kim Källström"},
{id:237,eventid:1139467,aa:1,type:"n",home:"",away:"3' Petr Jiracek"},
{id:238,eventid:1139467,aa:2,type:"assist",home:"",away:"3' Tomas Hübschman"},
{id:239,eventid:1139467,aa:3,type:"n",home:"",away:"6' Vaclav Pilar"},
{id:240,eventid:1139467,aa:4,type:"assist",home:"",away:"6' Theodor Gebre Selassie"},
{id:241,eventid:1139467,aa:5,type:"out",home:"Konstantinos Chalkias 23'",away:""},
{id:242,eventid:1139467,aa:6,type:"in",home:"Michalis Sifakis 23'",away:""},
{id:243,eventid:1139467,aa:7,type:"y",home:"",away:"27' Tomas Rosicky"},
{id:244,eventid:1139467,aa:8,type:"y",home:"Vasilios Torosidis 34'",away:""},
{id:245,eventid:1139467,aa:9,type:"y",home:"",away:"36' Petr Jiracek"},
{id:246,eventid:1139467,aa:10,type:"out",home:"",away:"46' Tomas Rosicky"},
{id:247,eventid:1139467,aa:11,type:"in",home:"",away:"46' Daniel Kolar"},
{id:248,eventid:1139467,aa:12,type:"out",home:"Georgios Fotakis 46'",away:""},
{id:249,eventid:1139467,aa:13,type:"in",home:"Theofanis Gekas 46'",away:""},
{id:250,eventid:1139467,aa:14,type:"n",home:"Theofanis Gekas 53'",away:""},
{id:251,eventid:1139467,aa:15,type:"y",home:"Kyriakos Papadopoulos 56'",away:""},
{id:252,eventid:1139467,aa:16,type:"y",home:"Dimitrios Salpingidis 57'",away:""},
{id:253,eventid:1139467,aa:17,type:"out",home:"",away:"64' Milan Baros"},
{id:254,eventid:1139467,aa:18,type:"in",home:"",away:"64' Tomas Pekhart"},
{id:255,eventid:1139467,aa:19,type:"y",home:"",away:"66' Daniel Kolar"},
{id:256,eventid:1139467,aa:20,type:"out",home:"Konstantinos Fortounis 71'",away:""},
{id:257,eventid:1139467,aa:21,type:"in",home:"Konstantinos Mitroglou 71'",away:""},
{id:258,eventid:1139467,aa:22,type:"out",home:"",away:"90' Daniel Kolar"},
{id:259,eventid:1139467,aa:23,type:"in",home:"",away:"90' Frantisek Rajtoral"},
{id:260,eventid:1139468,aa:1,type:"n",home:"",away:"37' Alan Dzagoev"},
{id:261,eventid:1139468,aa:2,type:"assist",home:"",away:"37' Andrey Arshavin"},
{id:262,eventid:1139468,aa:3,type:"n",home:"Jakub Blaszczykowski 57'",away:""},
{id:263,eventid:1139468,aa:4,type:"assist",home:"Ludovic Obraniak 57'",away:""},
{id:264,eventid:1139468,aa:5,type:"y",home:"Robert Lewandowski 60'",away:""},
{id:265,eventid:1139468,aa:6,type:"y",home:"",away:"60' Igor Denisov"},
{id:266,eventid:1139468,aa:7,type:"out",home:"",away:"70' Alexandr Kerzhakov"},
{id:267,eventid:1139468,aa:8,type:"in",home:"",away:"70' Roman Pavlyuchenko"},
{id:268,eventid:1139468,aa:9,type:"out",home:"Dariusz Dudka 73'",away:""},
{id:269,eventid:1139468,aa:10,type:"in",home:"Adrian Mierzejewski 73'",away:""},
{id:270,eventid:1139468,aa:11,type:"y",home:"",away:"75' Alan Dzagoev"},
{id:271,eventid:1139468,aa:12,type:"out",home:"",away:"79' Alan Dzagoev"},
{id:272,eventid:1139468,aa:13,type:"in",home:"",away:"79' Marat Izmailov"},
{id:273,eventid:1139468,aa:14,type:"y",home:"Eugen Polanski 79'",away:""},
{id:274,eventid:1139468,aa:15,type:"out",home:"Eugen Polanski 85'",away:""},
{id:275,eventid:1139468,aa:16,type:"in",home:"Adam Matuschyk 85'",away:""},
{id:276,eventid:1139468,aa:17,type:"out",home:"Ludovic Obraniak 90'",away:""},
{id:277,eventid:1139468,aa:18,type:"in",home:"Pawel Brozek 90'",away:""},
{id:278,eventid:1139473,aa:1,type:"out",home:"Niki Zimling 17'",away:""},
{id:279,eventid:1139473,aa:2,type:"in",home:"Jakob Poulsen 17'",away:""},
{id:280,eventid:1139473,aa:3,type:"n",home:"",away:"24'  Pepe"},
{id:281,eventid:1139473,aa:4,type:"assist",home:"",away:"24' Joao Moutinho"},
{id:282,eventid:1139473,aa:5,type:"y",home:"",away:"29' Raul Meireles"},
{id:283,eventid:1139473,aa:6,type:"n",home:"",away:"36' Hélder Postiga"},
{id:284,eventid:1139473,aa:7,type:"assist",home:"",away:"36'  Nani"},
{id:285,eventid:1139473,aa:8,type:"n",home:"Nicklas Bendtner 41'",away:""},
{id:286,eventid:1139483,aa:3,type:"n",home:" Andriy Shevchenko 55'",away:""},
{id:287,eventid:1139483,aa:2,type:"n",home:"",away:"52' Zlatan Ibrahimovic"},
{id:288,eventid:1139483,aa:4,type:"n",home:"Andriy Shevchenko 61'",away:""},
{id:289,eventid:1139483,aa:5,type:"out",home:"",away:"62' Ola Toivonen"},
{id:290,eventid:1139483,aa:6,type:"in",home:"",away:"62' Anders Svensson"},
{id:291,eventid:1139483,aa:7,type:"out",home:"",away:"68' Sebastian Larsson"},
{id:292,eventid:1139483,aa:8,type:"in",home:"",away:"68' Christian Wilhelmsson"},
{id:293,eventid:1139483,aa:9,type:"out",home:"",away:" 71' Markus Rosenberg"},
{id:294,eventid:1139483,aa:10,type:"in",home:"",away:"71' Johan Elmander"},
{id:295,eventid:1139483,aa:11,type:"out",home:"Andriy Shevchenko 81'",away:""},
{id:296,eventid:1139483,aa:12,type:"in",home:"Artem Milevsky 81'",away:""},
{id:297,eventid:1139483,aa:13,type:"y",home:"",away:"83' Rasmus Elm"},
{id:298,eventid:1139483,aa:14,type:"out",home:"Andrey Voronin 84'",away:""},
{id:299,eventid:1139483,aa:15,type:"in",home:"Ruslan Rotan 84'",away:""},
{id:300,eventid:1139483,aa:16,type:"out",home:"Yevheniy Konoplyanka 90'",away:""},
{id:301,eventid:1139483,aa:17,type:"in",home:"Marko Devic 90'",away:""},
{id:302,eventid:1139473,aa:9,type:"assist",home:"Michael Krohn-Dehli 41'",away:""},
{id:303,eventid:1139473,aa:10,type:"y",home:"Jakob Poulsen 56'",away:""},
{id:304,eventid:1139473,aa:11,type:"out",home:"Dennis Rommedahl 60'",away:""},
{id:305,eventid:1139473,aa:12,type:"in",home:"Tobias P. Mikkelsen 60'",away:""},
{id:306,eventid:1139473,aa:13,type:"out",home:"",away:"64' Hélder Postiga"},
{id:307,eventid:1139473,aa:14,type:"in",home:"",away:"64' Nélson Oliveira"},
{id:308,eventid:1139473,aa:15,type:"n",home:"Nicklas Bendtner 80'",away:""},
{id:309,eventid:1139473,aa:16,type:"assist",home:"Lars Jacobsen 80'",away:""},
{id:310,eventid:1139473,aa:17,type:"y",home:"Lars Jacobsen 81'",away:""},
{id:311,eventid:1139473,aa:18,type:"out",home:"",away:"84' Raul Meireles"},
{id:312,eventid:1139473,aa:19,type:"in",home:"",away:"84' Silvestre Varela"},
{id:313,eventid:1139473,aa:20,type:"n",home:"",away:"87' Silvestre Varela"},
{id:314,eventid:1139473,aa:21,type:"assist",home:"",away:"87' Fabio Coentrao"},
{id:315,eventid:1139473,aa:22,type:"out",home:"",away:"89'  Nani"},
{id:316,eventid:1139473,aa:23,type:"in",home:"",away:"89'  Rolando"},
{id:317,eventid:1139473,aa:24,type:"out",home:"Michael Krohn-Dehli 90'",away:""},
{id:318,eventid:1139473,aa:25,type:"in",home:"Lasse Schøne 90'",away:""},
{id:319,eventid:1139473,aa:26,type:"y",home:"",away:"90' Cristiano Ronaldo"},
{id:320,eventid:1139475,aa:1,type:"n",home:"",away:"24' Mario Gomez"},
{id:321,eventid:1139475,aa:2,type:"assist",home:"",away:"24' Bastian Schweinsteiger"},
{id:322,eventid:1139475,aa:3,type:"n",home:"",away:"38' Mario Gomez"},
{id:323,eventid:1139475,aa:4,type:"assist",home:"",away:"38' Bastian Schweinsteiger"},
{id:324,eventid:1139475,aa:5,type:"out",home:"Mark van Bommel 46'",away:""},
{id:325,eventid:1139475,aa:6,type:"in",home:"Rafael van der Vaart 46'",away:""},
{id:326,eventid:1139475,aa:7,type:"out",home:"Ibrahim Afellay 47'",away:""},
{id:327,eventid:1139475,aa:8,type:"in",home:"Klaas Jan Huntelaar 47'",away:""},
{id:328,eventid:1139475,aa:9,type:"out",home:"",away:"72' Mario Gomez"},
{id:329,eventid:1139475,aa:10,type:"in",home:"",away:"72' Miroslav Klose"},
{id:330,eventid:1139475,aa:11,type:"n",home:"Robin van Persie 73'",away:""},
{id:331,eventid:1139475,aa:12,type:"assist",home:"Arjen Robben 73'",away:""},
{id:332,eventid:1139475,aa:13,type:"y",home:"Nigel de Jong 81'",away:""},
{id:333,eventid:1139475,aa:14,type:"out",home:"",away:"81' Mesut Özil"},
{id:334,eventid:1139475,aa:15,type:"in",home:"",away:"81' Toni Kroos"},
{id:335,eventid:1139475,aa:16,type:"out",home:"Arjen Robben 83'",away:""},
{id:336,eventid:1139475,aa:17,type:"in",home:"Dirk Kuyt 83'",away:""},
{id:337,eventid:1139475,aa:18,type:"y",home:"",away:"87' Jérome Boateng"},
{id:338,eventid:1139475,aa:19,type:"y",home:"Jetro Willems 90'",away:""},
{id:339,eventid:1139475,aa:20,type:"out",home:"",away:"90' Thomas Müller"},
{id:340,eventid:1139475,aa:21,type:"in",home:"",away:"90' Lars Bender"},
{id:341,eventid:1139480,aa:1,type:"n",home:"Andrea Pirlo 39'",away:""},
{id:342,eventid:1139480,aa:2,type:"y",home:"Thiago Motta 57'",away:""},
{id:343,eventid:1139480,aa:3,type:"out",home:"Thiago Motta 62'",away:""},
{id:344,eventid:1139480,aa:4,type:"in",home:"Riccardo Montolivo 62'",away:""},
{id:345,eventid:1139480,aa:5,type:"out",home:"",away:"68' Ivan Perisic"},
{id:346,eventid:1139480,aa:6,type:"in",home:"",away:"68' Danijel Pranjic"},
{id:347,eventid:1139480,aa:7,type:"out",home:"Mario Balotelli 69'",away:""},
{id:348,eventid:1139480,aa:8,type:"in",home:"Antonio Di Natale 69'",away:""},
{id:349,eventid:1139480,aa:9,type:"n",home:"",away:"72' Mario Mandzukic"},
{id:350,eventid:1139480,aa:10,type:"assist",home:"",away:"72' Ivan Strinic"},
{id:351,eventid:1139480,aa:11,type:"y",home:"Riccardo Montolivo 80'",away:""},
{id:352,eventid:1139480,aa:12,type:"out",home:"",away:"83' Nikica Jelavic"},
{id:353,eventid:1139480,aa:13,type:"in",home:"",away:"83'  Eduardo"},
{id:354,eventid:1139480,aa:14,type:"out",home:"Antonio Cassano 83'",away:""},
{id:355,eventid:1139480,aa:15,type:"in",home:"Sebastian Giovinco 83'",away:""},
{id:356,eventid:1139480,aa:16,type:"y",home:"",away:"86' Gordon Schildenfeld"},
{id:357,eventid:1139480,aa:17,type:"out",home:"",away:"90' Mario Mandzukic"},
{id:358,eventid:1139480,aa:18,type:"in",home:"",away:"90' Niko Kranjcar"},
{id:359,eventid:1139479,aa:1,type:"n",home:"Fernando Torres 4'",away:""},
{id:360,eventid:1139479,aa:2,type:"y",home:"",away:"36' Robbie Keane"},
{id:361,eventid:1139479,aa:3,type:"y",home:"",away:"45' Glenn Whelan"},
{id:362,eventid:1139479,aa:4,type:"out",home:"",away:"46' Simon Cox"},
{id:363,eventid:1139479,aa:5,type:"in",home:"",away:"46' Jonathan Walters"},
{id:364,eventid:1139479,aa:6,type:"n",home:"David Silva 49'",away:""},
{id:365,eventid:1139479,aa:7,type:"y",home:"Xabi Alonso 54'",away:""},
{id:366,eventid:1139479,aa:8,type:"out",home:"Xabi Alonso 65'",away:""},
{id:367,eventid:1139479,aa:9,type:"in",home:"Javier Martinez 65'",away:""},
{id:368,eventid:1139479,aa:10,type:"n",home:"Fernando Torres 70'",away:""},
{id:369,eventid:1139479,aa:11,type:"assist",home:"David Silva 70'",away:""},
{id:370,eventid:1139479,aa:12,type:"out",home:"Fernando Torres 74'",away:""},
{id:371,eventid:1139479,aa:13,type:"in",home:"Cesc Fabregas 74'",away:""},
{id:372,eventid:1139479,aa:14,type:"y",home:"Javier Martinez 76'",away:""},
{id:373,eventid:1139479,aa:15,type:"out",home:"",away:"76' Damien Duff"},
{id:374,eventid:1139479,aa:16,type:"in",home:"",away:"76' James McClean"},
{id:375,eventid:1139479,aa:17,type:"out",home:"Andrés Iniesta 79'",away:""},
{id:376,eventid:1139479,aa:18,type:"in",home:"Santiago Cazorla 79'",away:""},
{id:377,eventid:1139479,aa:19,type:"out",home:"",away:"80' Glenn Whelan"},
{id:378,eventid:1139479,aa:20,type:"in",home:"",away:"80' Paul Green"},
{id:379,eventid:1139479,aa:21,type:"n",home:"Cesc Fabregas 83'",away:""},
{id:380,eventid:1139479,aa:22,type:"assist",home:"David Silva 83'",away:""},
{id:381,eventid:1139479,aa:23,type:"y",home:"",away:"84' Sean St. Ledger"},
{id:382,eventid:1139486,aa:1,type:"y",home:"",away:"40' Jérémy Menez"},
{id:383,eventid:1139486,aa:2,type:"out",home:"Andrey Voronin 46'",away:""},
{id:384,eventid:1139486,aa:3,type:"in",home:"Marko Devic 46'",away:""},
{id:385,eventid:1139486,aa:4,type:"n",home:"",away:"53' Jérémy Menez"},
{id:386,eventid:1139486,aa:5,type:"assist",home:"",away:"53' Karim Benzema"},
{id:387,eventid:1139486,aa:6,type:"y",home:"Yevhen Selin 55'",away:""},
{id:388,eventid:1139486,aa:7,type:"n",home:"",away:"56' Yohan Cabaye"},
{id:389,eventid:1139486,aa:8,type:"assist",home:"",away:"56' Karim Benzema"},
{id:390,eventid:1139486,aa:9,type:"out",home:"Sergei Nazarenko 60'",away:""},
{id:391,eventid:1139486,aa:10,type:"in",home:"Artem Milevsky 60'",away:""},
{id:392,eventid:1139486,aa:11,type:"out",home:"",away:"68' Yohan Cabaye"},
{id:393,eventid:1139486,aa:12,type:"in",home:"",away:"68' Yann M´Vila"},
{id:394,eventid:1139486,aa:13,type:"out",home:"Andriy Yarmolenko 68'",away:""},
{id:395,eventid:1139486,aa:14,type:"in",home:"Oleksandr Aliyev 68'",away:""},
{id:396,eventid:1139486,aa:15,type:"out",home:"",away:"73' Jérémy Menez"},
{id:397,eventid:1139486,aa:16,type:"in",home:"",away:"73' Marvin Martin"},
{id:398,eventid:1139486,aa:17,type:"out",home:"",away:"75' Karim Benzema"},
{id:399,eventid:1139486,aa:18,type:"in",home:"",away:"75' Olivier Giroud"},
{id:400,eventid:1139486,aa:19,type:"y",home:"",away:"79' Mathieu Debuchy"},
{id:401,eventid:1139486,aa:20,type:"y",home:"",away:"81' Phillippe Mexes"},
{id:402,eventid:1139486,aa:21,type:"y",home:"Anatoli Tymoschuk 86'",away:""},
{id:403,eventid:1139484,aa:1,type:"n",home:"",away:"23' Andrew Carroll"},
{id:404,eventid:1139484,aa:2,type:"assist",home:"",away:"23' Steven Gerrard"},
{id:405,eventid:1139484,aa:3,type:"o",home:"Glen Johnson 49'",away:""},
{id:406,eventid:1139484,aa:4,type:"y",home:"",away:"58' James Milner"},
{id:407,eventid:1139484,aa:5,type:"n",home:"Olof Mellberg 59'",away:""},
{id:408,eventid:1139484,aa:6,type:"assist",home:"Sebastian Larsson 59'",away:""},
{id:409,eventid:1139484,aa:7,type:"out",home:"",away:"61' James Milner"},
{id:410,eventid:1139484,aa:8,type:"in",home:"",away:"61' Theo Walcott"},
{id:411,eventid:1139484,aa:9,type:"y",home:"Olof Mellberg 63'",away:""},
{id:412,eventid:1139484,aa:10,type:"n",home:"",away:"64' Theo Walcott"},
{id:413,eventid:1139484,aa:11,type:"out",home:"Andreas Granqvist 66'",away:""},
{id:414,eventid:1139484,aa:12,type:"in",home:"Mikael Lustig 66'",away:""},
{id:415,eventid:1139484,aa:13,type:"y",home:"Jonas Olsson 72'",away:""},
{id:416,eventid:1139484,aa:14,type:"n",home:"",away:"78' Danny Welbeck"},
{id:417,eventid:1139484,aa:15,type:"assist",home:"",away:"78' Theo Walcott"},
{id:418,eventid:1139484,aa:16,type:"out",home:"Johan Elmander 79'",away:""},
{id:419,eventid:1139484,aa:17,type:"in",home:"Markus Rosenberg 79'",away:""},
{id:420,eventid:1139484,aa:18,type:"out",home:"Rasmus Elm 81'",away:""},
{id:421,eventid:1139484,aa:19,type:"in",home:"Christian Wilhelmsson 81'",away:""},
{id:422,eventid:1139484,aa:20,type:"out",home:"",away:"89' Danny Welbeck"},
{id:423,eventid:1139484,aa:21,type:"in",home:"",away:"89' Alex Oxlade-Chamberlain"},
{id:424,eventid:1139484,aa:22,type:"y",home:"Anders Svensson 90'",away:""},
{id:425,eventid:1139469,aa:1,type:"y",home:"David Limbersky 12'",away:""},
{id:426,eventid:1139469,aa:2,type:"y",home:"",away:"23' Rafal Murawski"},
{id:427,eventid:1139470,aa:1,type:"n",home:"Georgios Karagounis 45'",away:""},
{id:428,eventid:1139470,aa:2,type:"out",home:"",away:"46' Alexandr Kerzhakov"},
{id:429,eventid:1139470,aa:3,type:"in",home:"",away:"46' Roman Pavlyuchenko"},
{id:430,eventid:1139469,aa:3,type:"y",home:"",away:"48' Eugen Polanski"},
{id:431,eventid:1139469,aa:4,type:"out",home:"",away:"56' Eugen Polanski"},
{id:432,eventid:1139469,aa:5,type:"in",home:"",away:"56' Kamil Grosicki"},
{id:433,eventid:1139469,aa:6,type:"y",home:"",away:"61' Marcin Wasilewski"},
{id:434,eventid:1139470,aa:4,type:"y",home:"Georgios Karagounis 61'",away:""},
{id:435,eventid:1139470,aa:5,type:"out",home:"Theofanis Gekas 64'",away:""},
{id:436,eventid:1139470,aa:6,type:"in",home:"José Holebas 64'",away:""},
{id:437,eventid:1139470,aa:7,type:"y",home:"",away:"65' Alexander Anyukov"},
{id:438,eventid:1139470,aa:8,type:"out",home:"Georgios Karagounis 67'",away:""},
{id:439,eventid:1139470,aa:9,type:"in",home:"Grigorios Makos 67'",away:""},
{id:440,eventid:1139470,aa:10,type:"y",home:"",away:"69' Yuri Zhirkov"},
{id:441,eventid:1139470,aa:11,type:"y",home:"",away:"70' Alan Dzagoev"},
{id:442,eventid:1139469,aa:7,type:"n",home:"Petr Jiracek 72'",away:""},
{id:443,eventid:1139469,aa:8,type:"assist",home:"Milan Baros 72'",away:""},
{id:444,eventid:1139469,aa:9,type:"out",home:"",away:"73' Ludovic Obraniak"},
{id:445,eventid:1139469,aa:10,type:"in",home:"",away:"73' Pawel Brozek"},
{id:446,eventid:1139470,aa:12,type:"out",home:"",away:"72' Denis Glushakov"},
{id:447,eventid:1139470,aa:13,type:"in",home:"",away:"72' Pavel Pogrebnyak"},
{id:448,eventid:1139469,aa:11,type:"out",home:"",away:"73' Rafal Murawski"},
{id:449,eventid:1139469,aa:12,type:"in",home:"",away:"73' Adrian Mierzejewski"},
{id:450,eventid:1139470,aa:14,type:"out",home:"",away:"81' Alexander Anyukov"},
{id:451,eventid:1139470,aa:15,type:"in",home:"",away:"81' Marat Izmailov"},
{id:452,eventid:1139469,aa:13,type:"out",home:"Petr Jiracek 84'",away:""},
{id:453,eventid:1139469,aa:14,type:"in",home:"Frantisek Rajtoral 84'",away:""},
{id:454,eventid:1139470,aa:16,type:"out",home:"Dimitrios Salpingidis 83'",away:""},
{id:455,eventid:1139470,aa:17,type:"in",home:"Sotirios Ninis 83'",away:""},
{id:456,eventid:1139469,aa:15,type:"out",home:"Vaclav Pilar 87'",away:""},
{id:457,eventid:1139469,aa:16,type:"in",home:"Jan Rezek 87'",away:""},
{id:458,eventid:1139469,aa:17,type:"y",home:"",away:"88' Jakub Blaszczykowski"},
{id:459,eventid:1139469,aa:18,type:"y",home:"Jaroslav Plasil 88'",away:""},
{id:460,eventid:1139469,aa:19,type:"y",home:"",away:"90' Damien Perquis"},
{id:461,eventid:1139469,aa:20,type:"out",home:"Milan Baros 90'",away:""},
{id:462,eventid:1139469,aa:21,type:"in",home:"Tomas Pekhart 90'",away:""},
{id:463,eventid:1139469,aa:22,type:"y",home:"Tomas Pekhart 90'",away:""},
{id:464,eventid:1139470,aa:18,type:"y",home:"",away:"90' Pavel Pogrebnyak"},
{id:465,eventid:1139470,aa:19,type:"y",home:"José Holebas 90'",away:""},
{id:466,eventid:1139477,aa:1,type:"n",home:"",away:"11' Rafael van der Vaart"},
{id:467,eventid:1139477,aa:2,type:"assist",home:"",away:"11' Arjen Robben"},
{id:468,eventid:1139478,aa:1,type:"n",home:"",away:"19' Lukas Podolski"},
{id:469,eventid:1139478,aa:2,type:"assist",home:"",away:"19' Mario Gomez"},
{id:470,eventid:1139478,aa:3,type:"n",home:"Michael Krohn-Dehli 24'",away:""},
{id:471,eventid:1139478,aa:4,type:"assist",home:"Nicklas Bendtner 24'",away:""},
{id:472,eventid:1139477,aa:3,type:"n",home:"Cristiano Ronaldo 28'",away:""},
{id:473,eventid:1139477,aa:4,type:"assist",home:"Joao Pereira 28'",away:""},
{id:474,eventid:1139477,aa:5,type:"y",home:"",away:"51' Jetro Willems"},
{id:475,eventid:1139477,aa:6,type:"out",home:"Hélder Postiga 64'",away:""},
{id:476,eventid:1139477,aa:7,type:"in",home:"Nélson Oliveira 64'",away:""},
{id:477,eventid:1139478,aa:5,type:"out",home:"",away:"64' Lukas Podolski"},
{id:478,eventid:1139478,aa:6,type:"in",home:"",away:"64' Andre Schürrle"},
{id:479,eventid:1139477,aa:8,type:"out",home:"",away:"68' Jetro Willems"},
{id:480,eventid:1139477,aa:9,type:"in",home:"",away:"68' Ibrahim Afellay"},
{id:481,eventid:1139477,aa:10,type:"y",home:"",away:"70' Robin van Persie"},
{id:482,eventid:1139477,aa:11,type:"out",home:"Raul Meireles 72'",away:""},
{id:483,eventid:1139477,aa:12,type:"in",home:"Custodio 72'",away:""},
{id:484,eventid:1139477,aa:13,type:"n",home:"Cristiano Ronaldo 74'",away:""},
{id:485,eventid:1139477,aa:14,type:"assist",home:"Nani 74'",away:""},
{id:486,eventid:1139478,aa:7,type:"out",home:"",away:"74' Mario Gomez"},
{id:487,eventid:1139478,aa:8,type:"in",home:"",away:"74' Miroslav Klose"},
{id:488,eventid:1139478,aa:9,type:"out",home:"Niki Zimling 78'",away:""},
{id:489,eventid:1139478,aa:10,type:"in",home:"Christian Poulsen 78'",away:""},
{id:490,eventid:1139478,aa:11,type:"n",home:"",away:"80' Lars Bender"},
{id:491,eventid:1139478,aa:12,type:"assist",home:"",away:"80' Mesut Özil"},
{id:492,eventid:1139478,aa:13,type:"out",home:"Jakob Poulsen 82'",away:""},
{id:493,eventid:1139478,aa:14,type:"in",home:"Tobias P. Mikkelsen 82'",away:""},
{id:494,eventid:1139478,aa:15,type:"out",home:"",away:"84' Thomas Müller"},
{id:495,eventid:1139478,aa:16,type:"in",home:"",away:"84' Toni Kroos"},
{id:496,eventid:1139477,aa:15,type:"out",home:"Nani 87'",away:""},
{id:497,eventid:1139477,aa:16,type:"in",home:"Rolando 87'",away:""},
{id:498,eventid:1139477,aa:17,type:"y",home:"Joao Pereira 90'",away:""},
{id:499,eventid:1139482,aa:1,type:"y",home:"Vedran Corluka 27'",away:""},
{id:500,eventid:1139485,aa:1,type:"y",home:"Federico Balzaretti 28'",away:""},
{id:501,eventid:1139485,aa:2,type:"n",home:"Antonio Cassano 35'",away:""},
{id:502,eventid:1139485,aa:3,type:"assist",home:"Andrea Pirlo 35'",away:""},
{id:503,eventid:1139485,aa:4,type:"y",home:"",away:"37' Keith Andrews"},
{id:504,eventid:1139485,aa:5,type:"y",home:"",away:"39' John O´Shea"},
{id:505,eventid:1139482,aa:2,type:"y",home:"Darijo Srna 44'",away:""},
{id:506,eventid:1139482,aa:3,type:"y",home:"Ivan Strinic 54'",away:""},
{id:507,eventid:1139485,aa:6,type:"out",home:"Giorgio Chiellini 57'",away:""},
{id:508,eventid:1139485,aa:7,type:"in",home:"Leonardo Bonucci 57'",away:""},
{id:509,eventid:1139482,aa:4,type:"out",home:"",away:"61' Fernando Torres"},
{id:510,eventid:1139482,aa:5,type:"in",home:"",away:"61' Jesus Navas"},
{id:511,eventid:1139485,aa:8,type:"out",home:"Antonio Cassano 62'",away:""},
{id:512,eventid:1139485,aa:9,type:"in",home:"Alessandro Diamanti 62'",away:""},
{id:513,eventid:1139485,aa:10,type:"out",home:"",away:"65' Aiden McGeady"},
{id:514,eventid:1139485,aa:11,type:"in",home:"",away:"65' Shane Long"},
{id:515,eventid:1139482,aa:6,type:"out",home:"Domagoj Vida 66'",away:""},
{id:516,eventid:1139482,aa:7,type:"in",home:"Nikica Jelavic 66'",away:""},
{id:517,eventid:1139482,aa:8,type:"out",home:"Danijel Pranjic 66'",away:""},
{id:518,eventid:1139482,aa:9,type:"in",home:"Ivan Perisic 66'",away:""},
{id:519,eventid:1139485,aa:12,type:"y",home:"Daniele De Rossi 71'",away:""},
{id:520,eventid:1139482,aa:10,type:"out",home:"",away:"73' David Silva"},
{id:521,eventid:1139482,aa:11,type:"in",home:"",away:"73' Cesc Fabregas"},
{id:522,eventid:1139485,aa:13,type:"y",home:"Gianluigi Buffon 73'",away:""},
{id:523,eventid:1139485,aa:14,type:"out",home:"Antonio Di Natale 74'",away:""},
{id:524,eventid:1139485,aa:15,type:"in",home:"Mario Balotelli 74'",away:""},
{id:525,eventid:1139485,aa:16,type:"out",home:"",away:"76' Kevin Doyle"},
{id:526,eventid:1139485,aa:17,type:"in",home:"",away:"76' Jonathan Walters"},
{id:527,eventid:1139482,aa:12,type:"out",home:"Ognjen Vukojevic 81'",away:""},
{id:528,eventid:1139482,aa:13,type:"in",home:"Eduardo 81'",away:""},
{id:529,eventid:1139485,aa:18,type:"y",home:"",away:"84' Sean St. Ledger"},
{id:530,eventid:1139485,aa:19,type:"out",home:"",away:"86' Robbie Keane"},
{id:531,eventid:1139485,aa:20,type:"in",home:"",away:"86' Simon Cox"},
{id:532,eventid:1139482,aa:14,type:"n",home:"",away:"88' Jesus Navas"},
{id:533,eventid:1139482,aa:15,type:"assist",home:"",away:"88' Andrés Iniesta"},
{id:534,eventid:1139482,aa:16,type:"out",home:"",away:"89' Xavi Hernandez"},
{id:535,eventid:1139482,aa:17,type:"in",home:"",away:"89' Alvaro Negredo"},
{id:536,eventid:1139485,aa:21,type:"y2",home:"",away:"89' Keith Andrews"},
{id:537,eventid:1139485,aa:22,type:"n",home:"Mario Balotelli 90'",away:""},
{id:538,eventid:1139485,aa:23,type:"assist",home:"Alessandro Diamanti 90'",away:""},
{id:539,eventid:1139482,aa:18,type:"y",home:"Nikica Jelavic 90'",away:""},
{id:540,eventid:1139482,aa:19,type:"y",home:"Mario Mandzukic 90'",away:""},
{id:541,eventid:1139482,aa:20,type:"y",home:"Ivan Rakitic 90'",away:""},
{id:542,eventid:1139488,aa:1,type:"out",home:"Emir Bajrami 46'",away:""},
{id:543,eventid:1139488,aa:2,type:"in",home:"Christian Wilhelmsson 46'",away:""},
{id:544,eventid:1139487,aa:1,type:"n",home:"Wayne Rooney 48'",away:""},
{id:545,eventid:1139487,aa:2,type:"assist",home:"Steven Gerrard 48'",away:""},
{id:546,eventid:1139488,aa:3,type:"n",home:"Zlatan Ibrahimovic 54'",away:""},
{id:547,eventid:1139488,aa:4,type:"assist",home:"Sebastian Larsson 54'",away:""},
{id:548,eventid:1139488,aa:5,type:"out",home:"",away:"59' Hatem Ben Arfa"},
{id:549,eventid:1139488,aa:6,type:"in",home:"",away:"59' Florent Malouda"},
{id:550,eventid:1139487,aa:3,type:"y",home:"",away:"63' Anatoli Tymoschuk"},
{id:551,eventid:1139488,aa:7,type:"y",home:"",away:"68' Phillippe Mexes"},
{id:552,eventid:1139487,aa:4,type:"out",home:"James Milner 69'",away:""},
{id:553,eventid:1139487,aa:5,type:"in",home:"Theo Walcott 69'",away:""},
{id:554,eventid:1139487,aa:6,type:"out",home:"",away:"70' Marko Devic"},
{id:555,eventid:1139487,aa:7,type:"in",home:"",away:"70' Andriy Shevchenko"},
{id:556,eventid:1139488,aa:8,type:"y",home:"Anders Svensson 70'",away:""},
{id:557,eventid:1139487,aa:8,type:"y",home:"Steven Gerrard 73'",away:""},
{id:558,eventid:1139487,aa:9,type:"y",home:"",away:"74' Yaroslav Rakitskiy"},
{id:559,eventid:1139487,aa:10,type:"out",home:"",away:"77' Artem Milevsky"},
{id:560,eventid:1139488,aa:9,type:"out",home:"",away:"77' Samir Nasri"},
{id:561,eventid:1139488,aa:10,type:"in",home:"",away:"77' Jérémy Menez"},
{id:562,eventid:1139488,aa:11,type:"out",home:"Ola Toivonen 78'",away:""},
{id:563,eventid:1139488,aa:12,type:"in",home:"Pontus Wernbloom 78'",away:""},
{id:564,eventid:1139487,aa:11,type:"in",home:"",away:"77' Bohdan Butko"},
{id:565,eventid:1139487,aa:12,type:"out",home:"",away:"78' Denis Garmash"},
{id:566,eventid:1139487,aa:13,type:"in",home:"",away:"78' Sergei Nazarenko"},
{id:567,eventid:1139487,aa:14,type:"y",home:"Ashley Cole 78'",away:""},
{id:568,eventid:1139488,aa:13,type:"out",home:"Anders Svensson 79'",away:""},
{id:569,eventid:1139488,aa:14,type:"in",home:"Samuel Holmén 79'",away:""},
{id:570,eventid:1139488,aa:15,type:"y",home:"Samuel Holmén 81'",away:""},
{id:571,eventid:1139487,aa:15,type:"out",home:"Danny Welbeck 82'",away:""},
{id:572,eventid:1139487,aa:16,type:"in",home:"Andrew Carroll 82'",away:""},
{id:573,eventid:1139488,aa:16,type:"out",home:"",away:"83' Yann M´Vila"},
{id:574,eventid:1139488,aa:17,type:"in",home:"",away:"83' Olivier Giroud"},
{id:575,eventid:1139487,aa:17,type:"y",home:"",away:"86' Andriy Shevchenko"},
{id:576,eventid:1139487,aa:18,type:"out",home:"Wayne Rooney 87'",away:""},
{id:577,eventid:1139487,aa:19,type:"in",home:"Alex Oxlade-Chamberlain 87'",away:""},
{id:578,eventid:1139488,aa:18,type:"n",home:"Sebastian Larsson 90'",away:""},
{id:579,eventid:1139309,aa:1,type:"y",home:"",away:"26'  Nani"},
{id:580,eventid:1139309,aa:2,type:"y",home:"",away:"27' Miguel Veloso"},
{id:581,eventid:1139309,aa:3,type:"out",home:"",away:"40' Hélder Postiga"},
{id:582,eventid:1139309,aa:4,type:"in",home:"",away:"40' Hugo Almeida"},
{id:583,eventid:1139309,aa:5,type:"out",home:"Vladimir Darida 61'",away:""},
{id:584,eventid:1139309,aa:6,type:"in",home:"Jan Rezek 61'",away:""},
{id:585,eventid:1139309,aa:7,type:"n",home:"",away:"79' Cristiano Ronaldo"},
{id:586,eventid:1139309,aa:8,type:"assist",home:"",away:"79' Joao Moutinho"},
{id:587,eventid:1139309,aa:9,type:"out",home:"",away:"84'  Nani"},
{id:588,eventid:1139309,aa:10,type:"in",home:"",away:"84'  Custodio"},
{id:589,eventid:1139309,aa:11,type:"out",home:"Tomas Hübschman 86'",away:""},
{id:590,eventid:1139309,aa:12,type:"in",home:"Tomas Pekhart 86'",away:""},
{id:591,eventid:1139309,aa:13,type:"out",home:"",away:"88' Raul Meireles"},
{id:592,eventid:1139309,aa:14,type:"in",home:"",away:"88'  Rolando"},
{id:593,eventid:1139309,aa:15,type:"y",home:"David Limbersky 90'",away:""},
{id:594,eventid:1139310,aa:1,type:"y",home:"",away:"14' Georgios Samaras"},
{id:595,eventid:1139310,aa:2,type:"n",home:"Philipp Lahm 39'",away:""},
{id:596,eventid:1139310,aa:3,type:"assist",home:"Mesut Özil 39'",away:""},
{id:597,eventid:1139310,aa:4,type:"out",home:"",away:"46' Giorgos Tzavellas"},
{id:598,eventid:1139310,aa:5,type:"in",home:"",away:"46' Georgios Fotakis"},
{id:599,eventid:1139310,aa:6,type:"out",home:"",away:"46' Sotirios Ninis"},
{id:600,eventid:1139310,aa:7,type:"in",home:"",away:"46' Theofanis Gekas"},
{id:601,eventid:1139310,aa:8,type:"n",home:"",away:"55' Georgios Samaras"},
{id:602,eventid:1139310,aa:9,type:"assist",home:"",away:"55' Dimitrios Salpingidis"},
{id:603,eventid:1139310,aa:10,type:"n",home:"Sami Khedira 61'",away:""},
{id:604,eventid:1139310,aa:11,type:"assist",home:"Jérome Boateng 61'",away:""},
{id:605,eventid:1139310,aa:12,type:"out",home:"Andre Schürrle 67'",away:""},
{id:606,eventid:1139310,aa:13,type:"in",home:"Thomas Müller 67'",away:""},
{id:607,eventid:1139310,aa:14,type:"n",home:"Miroslav Klose 68'",away:""},
{id:608,eventid:1139310,aa:15,type:"assist",home:"Mesut Özil 68'",away:""},
{id:609,eventid:1139310,aa:16,type:"out",home:"",away:"72' Grigorios Makos"},
{id:610,eventid:1139310,aa:17,type:"in",home:"",away:"72' Nikos Liberopoulos"},
{id:611,eventid:1139310,aa:18,type:"n",home:"Marco Reus 74'",away:""},
{id:612,eventid:1139310,aa:19,type:"y",home:"",away:"75' Sokratis Papastathopoulos"},
{id:613,eventid:1139310,aa:20,type:"out",home:"Miroslav Klose 80'",away:""},
{id:614,eventid:1139310,aa:21,type:"in",home:"Mario Gomez 80'",away:""},
{id:615,eventid:1139310,aa:22,type:"out",home:"Marco Reus 80'",away:""},
{id:616,eventid:1139310,aa:23,type:"in",home:"Mario Götze 80'",away:""},
{id:617,eventid:1139310,aa:24,type:"p",home:"",away:"89' Dimitrios Salpingidis"},
{id:618,eventid:1139311,aa:1,type:"n",home:"Xabi Alonso 19'",away:""},
{id:619,eventid:1139311,aa:2,type:"assist",home:"Jordi Alba 19'",away:""},
{id:620,eventid:1139311,aa:3,type:"y",home:"Sergio Ramos 31'",away:""},
{id:621,eventid:1139311,aa:4,type:"y",home:"",away:"42' Yohan Cabaye"},
{id:622,eventid:1139311,aa:5,type:"out",home:"",away:"64' Mathieu Debuchy"},
{id:623,eventid:1139311,aa:6,type:"in",home:"",away:"64' Jérémy Menez"},
{id:624,eventid:1139311,aa:7,type:"out",home:"",away:"65' Florent Malouda"},
{id:625,eventid:1139311,aa:8,type:"in",home:"",away:"65' Samir Nasri"},
{id:626,eventid:1139311,aa:9,type:"out",home:"David Silva 65'",away:""},
{id:627,eventid:1139311,aa:10,type:"in",home:"Pedro Rodriguez 65'",away:""},
{id:628,eventid:1139311,aa:11,type:"out",home:"Cesc Fabregas 67'",away:""},
{id:629,eventid:1139311,aa:12,type:"in",home:"Fernando Torres 67'",away:""},
{id:630,eventid:1139311,aa:13,type:"y",home:"",away:"76' Jérémy Menez"},
{id:631,eventid:1139311,aa:14,type:"out",home:"",away:"79' Yann M´Vila"},
{id:632,eventid:1139311,aa:15,type:"in",home:"",away:"79' Olivier Giroud"},
{id:633,eventid:1139311,aa:16,type:"out",home:"Andrés Iniesta 84'",away:""},
{id:634,eventid:1139311,aa:17,type:"in",home:"Santiago Cazorla 84'",away:""},
{id:635,eventid:1139311,aa:18,type:"p",home:"Xabi Alonso 90'",away:""},
{id:636,eventid:1139312,aa:1,type:"out",home:"Danny Welbeck 60'",away:""},
{id:637,eventid:1139312,aa:2,type:"in",home:"Andrew Carroll 60'",away:""},
{id:638,eventid:1139312,aa:3,type:"out",home:"James Milner 61'",away:""},
{id:639,eventid:1139312,aa:4,type:"in",home:"Theo Walcott 61'",away:""},
{id:640,eventid:1139312,aa:5,type:"out",home:"",away:"78' Antonio Cassano"},
{id:641,eventid:1139312,aa:6,type:"in",home:"",away:"78' Alessandro Diamanti"},
{id:642,eventid:1139312,aa:7,type:"out",home:"",away:"80' Daniele De Rossi"},
{id:643,eventid:1139312,aa:8,type:"in",home:"",away:"80' Antonio Nocerino"},
{id:644,eventid:1139312,aa:9,type:"y",home:"",away:"82' Andrea Barzagli"},
{id:645,eventid:1139312,aa:10,type:"out",home:"",away:"90' Ignazio Abate"},
{id:646,eventid:1139312,aa:11,type:"in",home:"",away:"90' Christian Maggio"},
{id:647,eventid:1139312,aa:12,type:"y",home:"",away:"94' Christian Maggio"},
{id:648,eventid:1139312,aa:13,type:"out",home:"Scott Parker 94'",away:""},
{id:649,eventid:1139312,aa:14,type:"in",home:"Jordan Henderson 94'",away:""},
{id:650,eventid:1139312,aa:15,type:"p",home:"",away:"121' Mario Balotelli"},
{id:651,eventid:1139312,aa:16,type:"p",home:"Steven Gerrard 121'",away:""},
{id:652,eventid:1139312,aa:17,type:"npm",home:"",away:"121' Riccardo Montolivo"},
{id:653,eventid:1139312,aa:18,type:"p",home:"Wayne Rooney 121'",away:""},
{id:654,eventid:1139312,aa:19,type:"p",home:"",away:"121' Andrea Pirlo"},
{id:655,eventid:1139312,aa:20,type:"npm",home:"Ashley Young 121'",away:""},
{id:656,eventid:1139312,aa:21,type:"p",home:"",away:"121' Antonio Nocerino"},
{id:657,eventid:1139312,aa:22,type:"npm",home:"Ashley Cole 121'",away:""},
{id:658,eventid:1139312,aa:23,type:"p",home:"",away:"121' Alessandro Diamanti"},
{id:659,eventid:1139313,aa:1,type:"y",home:"",away:"40' Sergio Ramos"},
{id:660,eventid:1139313,aa:2,type:"y",home:"Fabio Coentrao 45'",away:""},
{id:661,eventid:1139313,aa:3,type:"out",home:"",away:"54' Alvaro Negredo"},
{id:662,eventid:1139313,aa:4,type:"in",home:"",away:"54' Cesc Fabregas"},
{id:663,eventid:1139313,aa:5,type:"y",home:"",away:"60' Sergio Busquets"},
{id:664,eventid:1139313,aa:6,type:"out",home:"",away:"60' David Silva"},
{id:665,eventid:1139313,aa:7,type:"in",home:"",away:"60' Jesus Navas"},
{id:666,eventid:1139313,aa:8,type:"y",home:"Pepe 61'",away:""},
{id:667,eventid:1139313,aa:9,type:"y",home:"Joao Pereira 64'",away:""},
{id:668,eventid:1139313,aa:10,type:"out",home:"Hugo Almeida 81'",away:""},
{id:669,eventid:1139313,aa:11,type:"in",home:"Nélson Oliveira 81'",away:""},
{id:670,eventid:1139313,aa:12,type:"y",home:"",away:"84' Alvaro Arbeloa"},
{id:671,eventid:1139313,aa:13,type:"y",home:"Bruno Alves 86'",away:""},
{id:672,eventid:1139313,aa:14,type:"out",home:"",away:"87' Xavi Hernandez"},
{id:673,eventid:1139313,aa:15,type:"in",home:"",away:"87' Pedro Rodriguez"},
{id:674,eventid:1139313,aa:16,type:"y",home:"Miguel Veloso 90'",away:""},
{id:675,eventid:1139313,aa:17,type:"out",home:"Miguel Veloso 105'",away:""},
{id:676,eventid:1139313,aa:18,type:"in",home:"Custodio 105'",away:""},
{id:677,eventid:1139313,aa:19,type:"out",home:"Raul Meireles 112'",away:""},
{id:678,eventid:1139313,aa:20,type:"in",home:"Silvestre Varela 112'",away:""},
{id:679,eventid:1139313,aa:21,type:"y",home:"",away:"113' Xabi Alonso"},
{id:680,eventid:1139313,aa:22,type:"npm",home:"",away:"121' Xabi Alonso"},
{id:681,eventid:1139313,aa:23,type:"npm",home:"Joao Moutinho 121'",away:""},
{id:682,eventid:1139313,aa:24,type:"p",home:"",away:"121' Andrés Iniesta"},
{id:683,eventid:1139313,aa:25,type:"p",home:"Pepe 121'",away:""},
{id:684,eventid:1139313,aa:26,type:"p",home:"",away:"121' Gerard Piqué"},
{id:685,eventid:1139313,aa:27,type:"p",home:"Nani 121'",away:""},
{id:686,eventid:1139313,aa:28,type:"p",home:"",away:"121' Sergio Ramos"},
{id:687,eventid:1139313,aa:29,type:"npm",home:"Bruno Alves 121'",away:""},
{id:688,eventid:1139313,aa:30,type:"p",home:"",away:"121' Cesc Fabregas"},
{id:689,eventid:1139314,aa:1,type:"n",home:"",away:"20' Mario Balotelli"},
{id:690,eventid:1139314,aa:2,type:"assist",home:"",away:"20' Antonio Cassano"},
{id:691,eventid:1139314,aa:3,type:"n",home:"",away:"36' Mario Balotelli"},
{id:692,eventid:1139314,aa:4,type:"assist",home:"",away:"36' Riccardo Montolivo"},
{id:693,eventid:1139314,aa:5,type:"y",home:"",away:"37' Mario Balotelli"},
{id:694,eventid:1139314,aa:6,type:"out",home:"Mario Gomez 46'",away:""},
{id:695,eventid:1139314,aa:7,type:"in",home:"Miroslav Klose 46'",away:""},
{id:696,eventid:1139314,aa:8,type:"out",home:"Lukas Podolski 46'",away:""},
{id:697,eventid:1139314,aa:9,type:"in",home:"Marco Reus 46'",away:""},
{id:698,eventid:1139314,aa:10,type:"out",home:"",away:"58' Antonio Cassano"},
{id:699,eventid:1139314,aa:11,type:"in",home:"",away:"58' Alessandro Diamanti"},
{id:700,eventid:1139314,aa:12,type:"y",home:"",away:"61' Leonardo Bonucci"},
{id:701,eventid:1139314,aa:13,type:"out",home:"",away:"63' Riccardo Montolivo"},
{id:702,eventid:1139314,aa:14,type:"in",home:"",away:"63' Thiago Motta"},
{id:703,eventid:1139314,aa:15,type:"out",home:"",away:"70' Mario Balotelli"},
{id:704,eventid:1139314,aa:16,type:"in",home:"",away:"70' Antonio Di Natale"},
{id:705,eventid:1139314,aa:17,type:"out",home:"Jérome Boateng 71'",away:""},
{id:706,eventid:1139314,aa:18,type:"in",home:"Thomas Müller 71'",away:""},
{id:707,eventid:1139314,aa:19,type:"y",home:"",away:"84' Daniele De Rossi"},
{id:708,eventid:1139314,aa:20,type:"y",home:"",away:"89' Thiago Motta"},
{id:709,eventid:1139314,aa:21,type:"p",home:"Mesut Özil 90'",away:""},
{id:710,eventid:1139314,aa:22,type:"y",home:"Mats Hummels 90'",away:""},
{id:711,eventid:1139317,aa:1,type:"n",home:"David Silva 14'",away:""},
{id:712,eventid:1139317,aa:2,type:"assist",home:"Cesc Fabregas 14'",away:""},
{id:713,eventid:1139317,aa:3,type:"out",home:"",away:"21' Giorgio Chiellini"},
{id:714,eventid:1139317,aa:4,type:"in",home:"",away:"21' Federico Balzaretti"},
{id:715,eventid:1139317,aa:5,type:"y",home:"Gerard Piqué 25'",away:""},
{id:716,eventid:1139317,aa:6,type:"n",home:"Jordi Alba 41'",away:""},
{id:717,eventid:1139317,aa:7,type:"assist",home:"Xavi Hernandez 41'",away:""},
{id:718,eventid:1139317,aa:8,type:"y",home:"",away:"45' Andrea Barzagli"},
{id:719,eventid:1139317,aa:9,type:"out",home:"",away:"46' Antonio Cassano"},
{id:720,eventid:1139317,aa:10,type:"in",home:"",away:"46' Antonio Di Natale"},
{id:721,eventid:1139317,aa:11,type:"out",home:"",away:"56' Riccardo Montolivo"},
{id:722,eventid:1139317,aa:12,type:"in",home:"",away:"56' Thiago Motta"},
{id:723,eventid:1139317,aa:13,type:"out",home:"David Silva 59'",away:""},
{id:724,eventid:1139317,aa:14,type:"in",home:"Pedro Rodriguez 59'",away:""},
{id:725,eventid:1139317,aa:15,type:"out",home:"Cesc Fabregas 75'",away:""},
{id:726,eventid:1139317,aa:16,type:"in",home:"Fernando Torres 75'",away:""},
{id:727,eventid:1139317,aa:17,type:"n",home:"Fernando Torres 84'",away:""},
{id:728,eventid:1139317,aa:18,type:"assist",home:"Xavi Hernandez 84'",away:""},
{id:729,eventid:1139317,aa:19,type:"out",home:"Andrés Iniesta 87'",away:""},
{id:730,eventid:1139317,aa:20,type:"in",home:"Juan Mata 87'",away:""},
{id:731,eventid:1139317,aa:21,type:"n",home:"Juan Mata 88'",away:""},
{id:732,eventid:1139317,aa:22,type:"assist",home:"Fernando Torres 88'",away:""}
	];

	return incidents;
}



function createIncidentsTable()
{
	try {
		
	
		var matchid=gup("id");
		var match=getMatchFromID(matchid);
		
		var incidents=getIncidentsFromGame(match.fixtureid);

		//document.write("incidents.length="+incidents.length);

		var tableStr="<center><table style=\"margin:0px; padding:0px;\" width=\"100%\">\n";
		for ( var i = 0; i < incidents.length; i++)
		{
			if (incidents[i].type=="assist")
			{
				continue;
			}
			
			tableStr+="<tr style=\"margin:0px;  padding:0px;\" width=\"100%\" >\n";
			
			tableStr+="<td width=\"100%\">\n";
			tableStr+="<div width=\"100%\" >\n";
			//tableStr+="<center>\n";
			
			
			
			tableStr+="<table width=\"100%\">\n";
			tableStr+="<tr width=\"100%\" >\n";
			
			var home=incidents[i].home;
			if (incidents[i].home)
			{
				var minute=home.substring(home.lastIndexOf(" ")+1,home.length);
				var player=home.substring(0,home.lastIndexOf(" "));
				
				tableStr+="<td style=\"color: #ad00fe;\">\n";
				tableStr+=minute;
				tableStr+="</td>\n";
				tableStr+="<td>\n";
				tableStr+="<img src=\"./images/incs/"+incidents[i].type+".png\" style=\"margin: 2px\" width=\"22\" height=\"22\"></img>\n";
				tableStr+="</td>\n";
				tableStr+="<td nowrap=\"nowrap\">\n";
				tableStr+=player;
				tableStr+="</td>\n";
				tableStr+="<td width=\"99%\">\n";
				tableStr+="</td>\n";
			}
			else
			{
				var home=incidents[i].away;
				
				var minute=home.substring(0,home.indexOf(" "));
				var player=home.substring(home.indexOf(" ")+1,home.legth);
				
				tableStr+="<td width=\"99%\">\n";
				tableStr+="</td>\n";
				tableStr+="<td nowrap=\"nowrap\">\n";
				tableStr+=player;
				tableStr+="</td>\n";
				tableStr+="<td>\n";
				tableStr+="<img src=\"./images/incs/"+incidents[i].type+".png\" style=\"margin: 2px\" width=\"22\" height=\"22\"></img>\n";
				tableStr+="</td>\n";
				tableStr+="<td style=\"color: #ad00fe;\">\n";
				tableStr+=minute;
				tableStr+="</td>\n";
			}
			
			tableStr+="</tr>\n";
			tableStr+="</table>\n";
			
			
			
			//tableStr+="</center>\n";
			tableStr+="</div>\n";
			tableStr+="</td>\n";
			tableStr+="</tr>\n";
	}
	tableStr+="</table></center>\n";
	} catch (e) {
		alert(e.message);
	}

	//alert(matchid+"\n"+tableStr);
	document.getElementById('gamesTable1').innerHTML = tableStr;
}

function getIncidentsFromGame(id)
{
	var games=getAllIncidents();
	var g=[];
	for ( var i = 0; i < games.length; i++)
	{
		if (games[i].eventid==id)
		{
			g.push(games[i]);
		}
	}
	
	var allages=1;
	while (allages>0)
	{
		allages=0;
		for (var i=1;i<g.length;i++)
		{
			if (g[i].aa<g[i-1].aa)
			{
				allages=allages+1;
				var temp=g[i];
				g[i]=g[i-1];
				g[i-1]=temp;
			}
		}
	}
	
	return g;
}