
//Initialize the Global converter
converter = Converter(CONFIG);


// For localization
window.addEventListener('localized', function() {
  document.documentElement.lang = document.webL10n.getLanguage();
  document.documentElement.dir = document.webL10n.getDirection();
  console.log("i10n initialized");
  console.log("lang: " + document.webL10n.getLanguage());
  console.log("direction: " + document.webL10n.getDirection());
}, false);

//the converter launches it after a successful rate update
window.addEventListener('exchangeUpdated', function (e) { 
  console.log("Event:exchangeUpdated: " + e.detail);
  updateExchangeUI(converter);
}, false);


//updates the footer exchange info
function updateExchangeUI(converter) {
  //exchange
  document.getElementById("exchange_to_2").innerHTML= converter.exchangeRateTo2String(3); 
  document.getElementById("exchange_to_1").innerHTML= converter.exchangeRateTo1String(3); 
  //format date
  date = converter.exchangeUpdatedAt();
  dateString = converter.exchangeUpdatedAt();
  if (dateString) {
    dateString = dateString.substring(0,dateString.indexOf("GMT"));
  }
  document.getElementById("exchange_updated_at").innerHTML= dateString;
  console.log("updateExchangeUI::datestring: " + dateString)
  console.log("updateExchangeUI::exchange: " + converter.exchangeTo2(1));
}


function updateAmountUI() {
  //update conversion
  //when modifying the
  console.log("amount changed on " + this.id +  ".New value: " + this.value);
  switch (this.id) {
  case "currency1_amount":
    newValue = converter.exchangeTo2(this.value).toFixed(2).toLocaleString();
    document.getElementById('currency2_amount').value=newValue
    break;    
  case "currency2_amount":
    newValue = converter.exchangeTo1(this.value).toFixed(2).toLocaleString();
    document.getElementById('currency1_amount').value=newValue
    break;
        
  default:
    console.log("updateAmountUI: humm... what input field are you changing?")
  }        
}

function amountFocused(element, notFocusedValue="0.00") {
  switch(element.id) {
  case "currency1_amount":
    notFocusedAmount = document.getElementById('currency2_amount')
    break;
  case "currency2_amount":
    notFocusedAmount = document.getElementById('currency1_amount')
    break;
  default:
    return;
  }
  notFocusedAmount.value= notFocusedValue;
  notFocusedAmount.type="text"; //avoid red border when number is not a number
  
  element.value = "";
  element.type="number"; 
  element.focus();
}

//MAIN 
window.addEventListener("load", function() {

 console.log("¡Ola que ase!");
  console.log("Yo conversiones de divisa ¿y tú?");
  
  // asyncStorage.setItem('key', 'value');
   
  //shortcut for i18n, Ex: _("title")
  //var _ = document.webL10n.get;
  
  //print some config.js in console
  console.log("Config Currency1: " + CONFIG.currency1.symbol);
  console.log("Config Currency2: " + CONFIG.currency2.symbol);
  console.log("Config default exchange: " + CONFIG.exchange);
  console.log("Converter.exchangeTo2: " + converter.exchangeTo2(1));
  
  
  updateExchangeUI(converter);
  
  function isFloat(n) {
      return n === +n && n !== (n|0);
  }
  
  //update data from server if current data does not exist or is too old
  var lastUpdate = Date.parse(converter.exchangeUpdatedAt());
  console.log("lastUpdate Before: " + lastUpdate);
  if (! isFloat(lastUpdate)) { lastUpdate = 0.0; }
  
  console.log(lastUpdate);
  console.log("last exchange update: " + converter.exchangeUpdatedAt() + " parsed:" + lastUpdate);
  var diff = (  (new Date).getTime() - lastUpdate )/1000; //secs 
  console.log("                diff: " + diff);
  if (diff > 43200) { //> 12 h => update
    console.log("trying to get new exchange rates from network...");
    converter.updateExchange();
  } else {
    console.log("update not needed");
  }
  
  
  //Update symbols on UI
  document.getElementById("currency1_symbol").innerHTML= converter.currency1GraphicSymbol();
  document.getElementById("currency2_symbol").innerHTML= converter.currency2GraphicSymbol();
  
   //update exchange
  var c1Amount = document.getElementById("currency1_amount");
  c1Amount.addEventListener("input", updateAmountUI);
  c1Amount.addEventListener("focus", function(){
    amountFocused(this,"0.00");
  });
  
  var c2Amount = document.getElementById("currency2_amount");
  c2Amount.addEventListener("input", updateAmountUI);
  c2Amount.addEventListener("focus", function(){
    amountFocused(this,"0.00");
  });
  
  //this is a hack, adding i10n module does something which prevents focus() to work
  //it should be: c1Amount.focus();  
  setTimeout(function () {
    document.getElementById("currency1_amount").focus(); 
    //0.00 is set by default on non focused amount. 
    //After load we want nothing to apear
    amountFocused(document.getElementById("currency1_amount"),"")
  }, 300);
  
  
});
