/**
* Converter class
* 
* Receives a config object (see config.js) to set the currencies and the exchange
* 
* By calling updateExchange, it can update the exchange.
* Supported data sources: ECB
* 
* requires async_storage.js
*/
var Converter = function (config) {
  
  //graphic symbols
  var _graphicSymbol = {
    'EUR': '€',
    'USD': '$',
    'JPN': '¥',
    'GBP': '£',
    'HRK': 'Kn'
    //TODO add more :)
  }

  var _dataSources = { 
    'ecb': {
      'url':  "http://www.ecb.europa.eu/stats/eurofxref/eurofxref-daily.xml" 
    }
  }

  //var _id = +(new Date());
  //var privateMethod = function() { alert(_id); };

  console.log(config);
  var _config = config;
  var _currency1 = _config.currency1;
  var _currency2 = _config.currency2;
  var _lang= 'en-US';
   
  //load data from localStorage 
  //exchange is always from currency 1 to currency 2

  
  
  var _exchange = localStorage.getItem('exchange') == null ? _config.exchange : parseFloat(localStorage.getItem('exchange'));
  
  console.log( window.localStorage.getItem('exchange'));
  console.log( window.localStorage.getItem('exchange_updated_at'));
    // All methods and members defined here are public  
  return {
      
    lang: function() {
      return _lang;
    },
      
    setLang: function(lang) {
      _lang = lang;
    },
    
    currency1: function() {
      return _currency1;
    },
      
    currency2: function() {
      return _currency2; 
    },
    
    currency1GraphicSymbol: function() {
      return _graphicSymbol[_currency1.symbol];
    },
      
    currency2GraphicSymbol: function() {
      return _graphicSymbol[_currency2.symbol];
    },
      
    //returns the amount in currency2
    exchangeTo2: function(amount) {
      return _exchange * amount;
    },
        
    //returns the amount in currency2
    exchangeTo1: function(amount) {
      return  amount / _exchange;
    },
        
    exchangeUpdatedAt: function() {
      return localStorage.getItem('exchange_updated_at');
    },
       
    //from c1 to c2 ex: €1 = $1.25 
    exchangeRateTo2String: function(decimals = 2) {
      left = _graphicSymbol[_currency1.symbol] + "1"
      right = _graphicSymbol[_currency2.symbol] + this.exchangeTo2(1).toFixed(decimals);
      return  left + " = " + right;
    },
      
    //from c1 to c2 ex: $1 = €0.800
    exchangeRateTo1String: function(decimals = 2) {
      //Note .toLocaleString does not work fine in FFOS
      left = _graphicSymbol[_currency2.symbol] + "1"
       
      right = _graphicSymbol[_currency1.symbol] + this.exchangeTo1(1).toFixed(decimals).toLocaleString(_lang);
      return  left + " = " + right;
    },
      
    // returns the amount coverted to currency 1. Ex: "€ 1,124.44"
    prettyTo1: function(amount, decimals=2) {
      return this.exchangeTo1(amount).toFixed(decimals).toLocaleString(_lang, { style: 'currency', currency: _config.currency1.symbol});
    },
      
      
    prettyTo2: function(amount, decimals = 2) {
      return this.exchangeTo2(amount).toFixed(decimals).toLocaleString(_lang, { style: 'currency', currency: _config.currency2.symbol});
    },
          
    updateExchange: function() {
      //TODO add a switch for different data sources
      //ECB stuff
      //get data from ecb server 
      var xhr = new XMLHttpRequest({mozSystem : true}); //Allow Cross site without CORS
      xhr.onreadystatechange = function() {
        if (xhr.readyState == 4) {
          /* example of ecb expected resp
          <?xml version="1.0" encoding="UTF-8"?>
          <gesmes:Envelope xmlns:gesmes="http://www.gesmes.org/xml/2002-08-01" xmlns="http://www.ecb.int/vocabulary/2002-08-01/eurofxref">
          <gesmes:subject>Reference rates</gesmes:subject>
          <gesmes:Sender>
          <gesmes:name>European Central Bank</gesmes:name>
          </gesmes:Sender>
          <Cube>
          <Cube time='2014-11-14'>
          <Cube currency='USD' rate='1.2436'/>
          ...
          <Cube currency='ZAR' rate='13.9236'/>
          </Cube>
          </Cube>
          </gesmes:Envelope>" 
          */
          //console.log(xhr.responseText);
          xmlDoc=xhr.responseXML;
          cubes = xmlDoc.getElementsByTagName("Cube");
          //console.log(x);
              
          currency1Rate = 1.00; 
          currency2Rate = 1.00; 
          currenciesFound = 0;
          for (i=0;i<cubes.length;i++) {
            node = cubes[i];
            //console.log(node.getAttribute("currency"));
            //if Cube node has time attr => then is the last time it was updated on svr
            if (node.hasAttribute("time")) { 
              console.log(node.getAttribute("time"));
            }
            //if Cube Node has currency attr => exchange is stored in rate attr
            if (node.hasAttribute("currency")) {  
              if (node.getAttribute("currency")  == _currency1.symbol) { 
                currency1Rate = node.getAttribute("rate");
                currenciesFound++;
                console.log("currency1 " + _currency1.symbol + " found exchange");
              }
              if (node.getAttribute("currency") == _currency2.symbol) { 
                currency2Rate = node.getAttribute("rate");
                currenciesFound++;
                console.log("currency2 found");
              }
            }
          }
          //Set exchange locally.
          // exchange is currency 1 to currency 2
          newExchange = currency2Rate / currency1Rate;
          if (currenciesFound > 0) {
            _exchange = newExchange;
            console.log("Converter: updating exchange to " + _exchange);
            localStorage.setItem('exchange', _exchange)
            localStorage.setItem('exchange_updated_at', new Date());
            //create the event
            window.dispatchEvent(new CustomEvent('exchangeUpdated', { 'detail': _exchange}));
          }     
        }
      }
      xhr.open('GET',  _dataSources[_config.source].url, true);
      xhr.send(null);
        
         
    }
  };
};
