// Constantes
var API_NOTICIAS = 'http://www.androidapps.cl/app_everton/api/get_noticias.php';
var API_VIDEOS = 'http://www.androidapps.cl/app_everton/api/get_video.php';
var API_TABLA = 'http://www.androidapps.cl/app_everton/api/get_tabla.php';


// Llamados de Funciones -------------------------------------------------------
getNoticias();
clickNoticias('#tab_noticias');
clickVideos('#tab_video');
clickHistoria('#tab_historia');
clickTwitter('#tab_twitter');
clickRadio('#tab_radio');
clickTabla('#tab_tabla');

clickBuscarVideo('#video_buscar');

// Funciones -------------------------------------------------------------------

function clickNoticias(id) {
    $(id).click(function () {
        setSelected(id);
        getNoticias();
    });

}

function clickVideos(id) {
    $(id).click(function () {
        setSelected(id);
        getVideos('none');
    });

}


function clickBuscarVideo(id) {
    $(id).click(function () {
        var video_txt = $('#video_txt').val();

        if (video_txt == '') {
            alert('Debe ingresar un criterio de búsqueda');
        } else {
            getVideos(video_txt);
        }

    });

}


function clickHistoria(id) {

    $(id).click(function () {
        setSelected(id);
        setCargando();
        $('#contenido-app').load('html/historia.html');
    });
}

function clickTwitter(id) {

    $(id).click(function () {
        setSelected(id);
        setCargando();
        $('#contenido-app').load('html/tw.html');
    });
}


function clickRadio(id) {

    $(id).click(function () {
        setSelected(id);
        setCargando();
        $('#contenido-app').load('html/streaming.html');
    });
}



function clickTabla(id) {

    $(id).click(function () {

        setSelected(id);
        setCargando();
        $.ajax({
            dataType: 'jsonp',
            url: API_TABLA,
            success: function (datos) {

                var tabla = datos['cuerpo'];
                var salida = '';

                salida = '<div class="row">';
                salida = salida + '<div>' + tabla + '</div>';
                salida = salida + '</div>';

                $('#contenido-app').html(salida);
                $('#contenido-app').css("display", "none");

                var tablaP = $('.textwidget:eq(2)').html();
                $('#contenido-app').html('<div class="row"><div class="col-md-12 col-sm-12 col-xs-12"><div class="thumbnail"><div class="caption"><h3>Tabla de Posiciones</h3>' + tablaP + '</div></div></div></div>');

                // Reemplazo de URL Imagen
                $("#contenido-app img").each(function (index, text) {

                    var urlInsignia = "http://www.everton.cl" + $(this).attr('src');
                    $(this).attr('src', urlInsignia);
                });

                // Mostrar Contenido
                $("#tablepress-1").addClass("table _table-striped");
                $('#contenido-app').css("display", "inline");

            },
            error: function () {
                alert("Error en la lectura de datos ");
            }
        });

    });

}


function setSelected(id) {

    $(".panel-tab").removeClass("selected");
    $(id).addClass("selected");
}


function getNoticias() {

    setCargando();
    $.ajax({
        dataType: 'jsonp',
        url: API_NOTICIAS,
        success: function (datos) {
            cont = 0;
            largo = datos.titular.length;
            var salida = '';
            salida = '<div class="row">';
            while (cont < largo) {
                salida = salida + '<div class="col-md-4 col-sm-6 col-xs-12">';
                salida = salida + '<div class="thumbnail">';
                salida = salida + '<div class="caption">';
                salida = salida + '<h3>' + datos.titular[cont] + '</h3>';
                salida = salida + '<p class="strong">' + datos.fecha[cont] + '</p>';
                salida = salida + '<div class="cuerpo-noticia">' + datos.cuerpo[cont] + '</div>';

                //salida = salida + '<div class="cuerpo-noticia separa">';
                //salida = salida + '<div class="fb-comments" data-href="'+datos.link[cont]+'" data-width="300" data-numposts="5" data-colorscheme="light"></div>';
                //salida = salida + '</div>';

                salida = salida + '</div>';
                salida = salida + '</div>';
                salida = salida + '</div>';


                cont++;
            }
            salida = salida + '</div>';
            $('#contenido-app').html(salida);
        },
        error: function () {
            alert("Error en la lectura de datos ");
        }
    });

}

function getVideos(criterio) {

    var url_video = '';

    if (criterio != 'none') {
        url_video = API_VIDEOS + '?url=' + criterio;
    } else {
        url_video = API_VIDEOS;
    }

    setCargando();
    $.ajax({
        dataType: 'jsonp',
        url: url_video,
        success: function (datos) {
            //cont = 0; // Corrige error de Youtube, video 0 no corresponde
            cont = 1; 
            largo = datos.titular.length;
            var salida = '';
            salida = '<div class="row">';

            salida = salida + '<div class="col-md-12 col-sm-12 col-xs-12" style="margin-bottom:10px">';
            salida = salida + "<input style='float:left; width:80%' type='text' class='form-control' id='video_txt' placeholder='Buscar Video'>";
            salida = salida + "<button id='video_buscar' style='width:20%;' type='submit' class='btn btn-primary'>Buscar</button>";
            salida = salida + '</div>';

            while (cont < largo) {
                salida = salida + '<div class="col-md-4 col-sm-6 col-xs-12">';
                salida = salida + '<div class="thumbnail">';
                salida = salida + '<div class="caption">';
                salida = salida + '<h3>' + datos.titular[cont] + '</h3>';
                salida = salida + '<p class="strong"></p>';
                salida = salida + '<div class="cuerpo-noticia">' + datos.cuerpo[cont] + '</div>';
                salida = salida + '</div>';
                salida = salida + '</div>';
                salida = salida + '</div>';
                cont++;
            }
            salida = salida + '</div>';
            $('#contenido-app').html(salida);

            $("#contenido-app a").attr("target", "_blank");
            $("#contenido-app div").css("border", "none");

            if (criterio != 'none') {
                $('#video_txt').val(criterio);
            }

            //Listener
            clickBuscarVideo('#video_buscar');

        },
        error: function () {
            alert("Error en la lectura de datos ");
        }
    });


}


function setCargando() {
    var content = "<div id='cargando' style='text-align:center'><h3>Cargando...</h3><br><img src='img/loader.gif'></div>";
    $('#contenido-app').html(content);
}
