var keyboardShowed = false;

$(document).bind("mobileinit", function () {
    $(document).on('focus', 'input, textarea, select', function (e) {
        if (keyboardShowed) {
            clearTimeout(keyboardShowed);
            keyboardShowed = false;
        }
        else {
            $("[data-position=fixed]").css('position', 'absolute');
        }
    }).on('blur', 'input, textarea, select', function (e) {
        keyboardShowed = setTimeout(function () {
            $("[data-position=fixed]").css('position', 'fixed');
            window.scrollTo(document.body.scrollLeft, document.body.scrollTop);
            keyboardShowed = false;
        }, 1);
    });
});