
    // controllers
App.controller('about', function (page) {
	document.webL10n.reload();
});


App.controller('home', function (page) {
	document.webL10n.reload();
	if(storejs.get('notfirstrun')!='true') {
		storejs.set('notfirstrun', 'true');

		// add default ones
		storejs.set('cur_'+uniqid(), { coin1: 'BTC', coin2: 'USD', coinlen: 1, notify: true });
	}

	storejs.forEach(function(key, val) {
		if(key.substr(0, 4)=='cur_') {
			currency(val.coin1, val.coin2, val.coinlen, function(v) {
				$(page).find('.cur_list').append('<div class="mdl-card mdl-shadow--2dp div_'+key+'">\
			          <div class="mdl-card__title mdl-card--expand">\
			            <h2 class="mdl-card__title-text">'+v+'</h2>\
			          </div>\
			          <div class="mdl-card__supporting-text">\
			            '+val.coinlen+' &times; '+(val.coin1.toUpperCase())+' &#10093; '+(val.coin2.toUpperCase())+'\
			          </div>\
			          <div class="mdl-card__actions mdl-card--border">\
			            <a class="mdl-button mdl-button--colored mdl-js-button mdl-js-ripple-effect stopfollowing" rel="'+key+'" data-l10n-id="stopfollowing"></a>\
			          </div>\
			        </div>');

				document.webL10n.reload();
			});
		}
	});

	$(page).find('.cur_list').on('click', '.stopfollowing', function() {
		var id = $(this).attr('rel');
		$(page).find('.div_'+id).toggle('slide', { direction: 'left' });
		storejs.remove(id);
	});
});

App.controller('about', function (page) {
	document.webL10n.reload();
});

App.controller('newexchange', function(page) {
	document.webL10n.reload();
	componentHandler.upgradeElements(page); // MDL & App.js

	$(page).find('.app-back-button').on('click', function() {
		var coin1 = $(page).find('.cur1 :selected').text().substr(-3, 3);
		var coin2 = $(page).find('.cur2 :selected').text().substr(-3, 3);
		var coinlen = parseFloat($(page).find('.curlen').val().replace(",", "."));
		var notify = false; // not supported in FxOS yet
		
		if(coin1==_("selectcurrency").substr(-3, 3) || coin2==_("selectcurrency").substr(-3, 3) || !coinlen) {
			App.load('home');
		} else {
			storejs.set('cur_'+uniqid(), { coin1: coin1, coin2: coin2, coinlen: coinlen, notify: notify });
			App.load('home');
		}
	});
});

try {
	App.restorejs();
} catch (err) {
	App.load('home');
}