//Setting up constants
var circlesCount = 100; // Circles count used by the wormhole
var offsetX = 70; // Wormhole center offset (X)
var offsetY = 40; // Wormhole center offset (Y)
var maxDepth = 1.5; // Maximal distance for a circle
var circleDiameter = 10.0; // Circle diameter
var depthSpeed = 0.001; // Circle speed
var angleSpeed = 0.05; // Circle angular rotation speed

//Getting elements



var canvas = document.getElementById("backgroundCanvas");
var context = canvas.getContext("2d");
var stats = document.getElementById("stats");

//How to display a circle?





function Circle(initialDepth, initialAngle, intensity) {
    var angle = initialAngle;
    this.depth = initialDepth;
    var color = intensity;
}



var x = offsetX * Math.cos(angle);
var y = offsetY * Math.sin(angle);



function perspective(fov, aspectRatio, x, y) {
    var yScale = Math.pow(Math.tan(fov / 2.0), -1);
    var xScale = yScale / aspectRatio;

    var M11 = xScale;
    var M22 = yScale;

    var outx = x * M11 + canvas.width / 2.0;
    var outy = y * M22 + canvas.height / 2.0;

    return {
        x: outx,
        y: outy
    };
}



var x = offsetX * Math.cos(angle);
var y = offsetY * Math.sin(angle);
var project = perspective(0.9, canvas.width / canvas.height, x, y);
var diameter = circleDiameter / this.depth;
var ploX = project.x - diameter / 2.0;
var ploY = project.y - diameter / 2.0;



context.beginPath();
context.arc(ploX, ploY, diameter, 0, 2 * Math.PI, false);
context.closePath();
var opacity = 1.0 - this.depth / maxDepth;
context.strokeStyle = "rgba(" + color + "," + color + "," + color + "," + opacity + ")";
context.lineWidth = 4;
context.stroke();