"use strict";

var domInputShutterSpeed, domInputAperture, domInputISO; // Input elements
var domOutputShutterSpeed, domOutputAperture, domOutputISO; // Output elements
var domInputExposure, domOutputExposure, domExposureDifference; // Data elements
var selectedType; // Char
var inputExposure, outputExposure; // Exposure
var exposureDifference; // Double
var selectedOutputShutterSpeedIndex, selectedOutputApertureIndex, selectedOutputISOIndex; // Int

window.onload = function () {
   InitializeVariables();
   SetSelectElementsBehavior();
   SetButtonElementsBehavior();
   SetExposureValues();
   SetInputExposure();
   SetOutputExposure();
   CalculateExposureDifference();
   DisplayData();
};

function InitializeVariables() {
   domInputShutterSpeed = document.getElementById("inputShutterSpeed");
   domInputAperture = document.getElementById("inputAperture");
   domInputISO = document.getElementById("inputISO");

   domOutputShutterSpeed = document.getElementById("outputShutterSpeed");
   domOutputAperture = document.getElementById("outputAperture");
   domOutputISO = document.getElementById("outputISO");

   domInputExposure = document.getElementById("inputExposure");
   domOutputExposure = document.getElementById("outputExposure");
   domExposureDifference = document.getElementById("exposureDifference");

   exposureDifference = 0;
   selectedType = localStorage.getItem('selectedType');

   if (selectedType == null) {
      selectedType = 'i';
      localStorage.setItem('selectedType', selectedType);
   }

   switch (selectedType) {
      case 's':
         domOutputShutterSpeed.disabled = true;
         break;

      case 'a':
         domOutputAperture.disabled = true;
         break;

      case 'i':
         domOutputISO.disabled = true;
         break;
   }
}

function SetSelectElementsBehavior() {
   // INPUT
   var InputSelectElementValueChanged = function() {
      SetInputExposure();
      CalculateExposureDifference();
      CorrectExposureDifference();
   };

   domInputShutterSpeed.onchange = function() {
      InputSelectElementValueChanged();
      localStorage.setItem('inputShutterSpeed', this.value);
   };

   domInputAperture.onchange = function() {
      InputSelectElementValueChanged();
      localStorage.setItem('inputAperture', this.value);
   };

   domInputISO.onchange = function() {
      InputSelectElementValueChanged();
      localStorage.setItem('inputISO', this.value);
   };

   // OUTPUT
   var OutputSelectElementValueChanged = function() {
      SetOutputExposure();
      CalculateExposureDifference();
      CorrectExposureDifference();
   };

   domOutputShutterSpeed.onchange = function() {
      OutputSelectElementValueChanged();
      localStorage.setItem('outputShutterSpeed', this.value);
   };

   domOutputAperture.onchange = function() {
      OutputSelectElementValueChanged();
      localStorage.setItem('outputAperture', this.value);
   };

   domOutputISO.onchange = function() {
      OutputSelectElementValueChanged();
      localStorage.setItem('outputISO', this.value);
   };
}

function SetButtonElementsBehavior() {
   document.getElementById('selectShutterSpeed').onclick = function () {
      domOutputShutterSpeed.disabled = true;
      domOutputAperture.disabled = false;
      domOutputISO.disabled = false;
      selectedType = 's';
      localStorage.setItem('selectedType', selectedType);
      CorrectExposureDifference();
   };

   document.getElementById('selectAperture').onclick = function () {
      domOutputShutterSpeed.disabled = false;
      domOutputAperture.disabled = true;
      domOutputISO.disabled = false;
      selectedType = 'a';
      localStorage.setItem('selectedType', selectedType);
      CorrectExposureDifference();
   };

   document.getElementById('selectISO').onclick = function () {
      domOutputShutterSpeed.disabled = false;
      domOutputAperture.disabled = false;
      domOutputISO.disabled = true;
      selectedType = 'i';
      localStorage.setItem('selectedType', selectedType);
      CorrectExposureDifference();
   };
}

function SetExposureValues() {
   SetInputExposureValuesToSelectElement(domInputShutterSpeed, shutterSpeedValues, 's');
   SetInputExposureValuesToSelectElement(domInputAperture, apertureValues, 'a');
   SetInputExposureValuesToSelectElement(domInputISO, isoValues, 'i');

   SetOutputExposureValuesToSelectElement(domOutputShutterSpeed, shutterSpeedValues, 's');
   SetOutputExposureValuesToSelectElement(domOutputAperture, apertureValues, 'a');
   SetOutputExposureValuesToSelectElement(domOutputISO, isoValues, 'i');
}

function SetInputExposureValuesToSelectElement(selectElement, valueArray, type) {
   var tmpShutterSpeed = localStorage.getItem('inputShutterSpeed');
   var tmpAperture = localStorage.getItem('inputAperture');
   var tmpISO = localStorage.getItem('inputISO');

   for (var i = 0; i < valueArray.length; i++) {
      var sel = false;
      var opt = document.createElement('option');
      var val = valueArray[i];
      opt.value = val;

      switch (type) {
         case 's':
            sel = ((tmpShutterSpeed != null && IsEqual(val, tmpShutterSpeed)) || (tmpShutterSpeed == null && IsEqual(val, 1/60)));
            val = FormatShutterSpeed(val);
            break;

         case 'a':

            sel = ((tmpAperture != null && IsEqual(val, tmpAperture)) || (tmpAperture == null && IsEqual(val, 4)));
            val = FormatAperture(val);
            break;

         case 'i':

            sel = ((tmpISO != null && IsEqual(val, tmpISO)) || (tmpISO == null && IsEqual(val, 200)));
            val = FormatISO(val);
            break;

         default:
            return;
      }

      if (sel) {
         opt.setAttribute('selected', 'selected');
      }

      opt.appendChild(document.createTextNode(val));
      selectElement.appendChild(opt);
   }
}

function SetOutputExposureValuesToSelectElement(selectElement, valueArray, type) {
   var tmpShutterSpeed = localStorage.getItem('outputShutterSpeed');
   var tmpAperture = localStorage.getItem('outputAperture');
   var tmpISO = localStorage.getItem('outputISO');

   for (var i = 0; i < valueArray.length; i++) {
      var sel = false;
      var opt = document.createElement('option');
      var val = valueArray[i];
      opt.value = val;

      switch (type) {
         case 's':
             if ((tmpShutterSpeed != null && IsEqual(val, tmpShutterSpeed)) || (tmpShutterSpeed == null && IsEqual(val, 1/60))) {
                sel = true;
                selectedOutputShutterSpeedIndex = i;
             }

            val = FormatShutterSpeed(val);
            break;

         case 'a':
            if ((tmpAperture != null && IsEqual(val, tmpAperture)) || (tmpAperture == null && IsEqual(val, 4))) {
               sel = true;
               selectedOutputApertureIndex = i;
            }

            val = FormatAperture(val);
            break;

         case 'i':
            if ((tmpISO != null && IsEqual(val, tmpISO)) || (tmpISO == null && IsEqual(val, 200))) {
               sel = true;
               selectedOutputISOIndex = i;
            }

            val = FormatISO(val);
            break;

         default:
            return;
      }

      if (sel) {
         opt.setAttribute('selected', 'selected');
      }

      opt.appendChild(document.createTextNode(val));
      selectElement.appendChild(opt);
   }
}

function SetInputExposure() {
   inputExposure = new Exposure(domInputShutterSpeed.value, domInputAperture.value, domInputISO.value);
}

function SetOutputExposure() {
   outputExposure = new Exposure(domOutputShutterSpeed.value, domOutputAperture.value, domOutputISO.value);
}

function CalculateExposureDifference() {
   exposureDifference = inputExposure.CalculateExposureDifference(outputExposure);
}

function CorrectExposureDifference() {
   var correctedIndex = outputExposure.CorrectExposureDifferenceByType(exposureDifference, selectedType);
   CalculateExposureDifference();
   DisplayData();

   if (correctedIndex == -1) {
      return;
   }

   switch (selectedType) {
      case 's':
         domOutputShutterSpeed.children[selectedOutputShutterSpeedIndex].removeAttribute('selected');
         domOutputShutterSpeed.children[correctedIndex].setAttribute('selected', 'selected');
         localStorage.setItem('outputShutterSpeed', shutterSpeedValues[correctedIndex]);
         selectedOutputShutterSpeedIndex = correctedIndex;
         break;

      case 'a':
         domOutputAperture.children[selectedOutputApertureIndex].removeAttribute('selected');
         domOutputAperture.children[correctedIndex].setAttribute('selected', 'selected');
         localStorage.setItem('outputAperture', apertureValues[correctedIndex]);
         selectedOutputApertureIndex = correctedIndex;
         break;

      case 'i':
         domOutputISO.children[selectedOutputISOIndex].removeAttribute('selected');
         domOutputISO.children[correctedIndex].setAttribute('selected', 'selected');
         localStorage.setItem('outputISO', isoValues[correctedIndex]);
         selectedOutputISOIndex = correctedIndex;
         break;
   }
}

function IsEqual(num1, num2) {
   return (Math.abs(num1 - num2) < 0.00001);
}

function DisplayData() {
   var exposureDifferenceThirds = GetRealExposureDifferenceAsThirds(exposureDifference);
   var exposureDifferenceString = 'The exposure difference is ';

   if (exposureDifferenceThirds[1] == 0) {
      exposureDifferenceString += exposureDifferenceThirds[0];
   }
   else {
      exposureDifferenceString += exposureDifferenceThirds[0] + ' ' + Math.abs(exposureDifferenceThirds[1]) + '/3';
   }

   exposureDifferenceString += ' EV';
   domExposureDifference.innerHTML = exposureDifferenceString;
}
