function ClassGrid()
{
    this.width = 0;
    this.height = 0;

    this.old_random = 0;

    this.mass = [];
    for(var i=0;i<8; i++)
    {
        this.mass.push([]);
        for(var j=0;j<8; j++)
            this.mass[i].push(new ClassEl());
    }
    this.glow_m = 0;
    this.glow = [[0,0,0,0,0,0,0,0],
                 [0,0,0,0,0,0,0,0],
                 [0,0,0,0,0,0,0,0],
                 [0,0,0,0,0,0,0,0],
                 [0,0,0,0,0,0,0,0],
                 [0,0,0,0,0,0,0,0],
                 [0,0,0,0,0,0,0,0],
                 [0,0,0,0,0,0,0,0]];

    this.destroy = [[0,0,0,0,0,0,0,0],
                    [0,0,0,0,0,0,0,0],
                    [0,0,0,0,0,0,0,0],
                    [0,0,0,0,0,0,0,0],
                    [0,0,0,0,0,0,0,0],
                    [0,0,0,0,0,0,0,0],
                    [0,0,0,0,0,0,0,0],
                    [0,0,0,0,0,0,0,0]];

    this.getImg = new createjs.Container();

    this.bg = new ClassBg();
    this.getImg.addChild(this.bg.getImg);

    this.gr = new ClassGr();
    this.getImg.addChild(this.gr.getImg);

    this.s = new createjs.Shape();
    this.s.x = -19*devise_size;
    this.s.y = -19*devise_size;
    this.s.alpha = 0.5;
    this.getImg.addChild(this.s);
}

ClassGrid.prototype.rand = function()
{
    var a = (Math.random()*config.lvls[game.level_num].pets)<<0;
    while(this.old_random == a)
        a = (Math.random()*config.lvls[game.level_num].pets)<<0;
    this.old_random = a;
    return a;
};

ClassGrid.prototype.Re = function()
{
    global_glow = true;

    this.height = levels[game.level_num].length;
    this.width = levels[game.level_num][0].length;

    game.grid.getImg.x = (20+(8-this.width)*20)*devise_size;
    game.grid.getImg.y = (96+(8-this.height)*18)*devise_size;

    for(var i=0;i<8; i++)
        for(var j=0;j<8; j++)
        {
            if(j>=this.width || i>=this.height || levels[game.level_num][i][j] == 0)
                this.mass[i][j].set(-1, 0);
            else
                this.mass[i][j].set(0, this.rand());
        }

    this.FindLine();

    while(this.isDestroy())
    {
        for(i=0;i<this.height; i++)
            for(j=0;j<this.width; j++)
                if(this.destroy[i][j] == 1)
                {
                    this.mass[i][j].set(0, this.rand());
                    this.destroy[i][j] = 0;
                }
        this.FindLine();
    }

    for(i = 0; i < config.lvls[game.level_num].bonus.length; i++)
        this.AddBonus(config.lvls[game.level_num].bonus[i]);


    this.bg.Re();
    stage_glow.removeAllChildren();
    this.gr.Re();
};

ClassGrid.prototype.Drw = function()
{
    this.gr.Drw();
};

//-------------------------------find-------------------------------\\
ClassGrid.prototype.FindLine = function()
{
    var i, j;

    this.glow_m = 0;
    for(i=0; i<this.height; i++)
        for(j=0; j<this.width; j++)
            this.glow[i][j] = 0;

    for(i=0; i<this.height; i++) {
        j=0;
        while(j < this.width-1) j += this.getMatchW(i, j);
    }
    for(j=0; j<this.width; j++) {
        i=0;
        while(i < this.height-1) i += this.getMatchH(i, j);
    }

    for(i=0; i<this.height; i++)
        for(j=0; j<this.width; j++)
            if(this.glow[i][j] == 1 && this.destroy[i][j] == 0)
            {
                this.destroy[i][j] = 1;
                this.glow_m++;
            }
};

ClassGrid.prototype.getMatchW = function(i, j)
{
    var a = 1, s=j;
    if(this.mass[i][j].ID == 1) { a++; s = j+1; }
    for(var k=s; k<this.width-1; k++)
        if(isDes(this.mass[i][s], this.mass[i][k+1]))
            a++;
        else
        {
            if(a>=config.NUMBER_PETS)
                this.addDestroyW(i, j, a);
            else
                if(this.mass[i][k].ID == 1) a--;
            return a;
        }
    if(a>=config.NUMBER_PETS)
        this.addDestroyW(i, j, a);
    else
        if(this.mass[i][k].ID == 1) a--;
    return a;
};

ClassGrid.prototype.getMatchH = function(i, j)
{
    var a = 1, s=i;
    if(this.mass[i][j].ID == 1) { a++; s = i+1; }
    for(var k=s; k<this.height-1; k++)
        if(isDes(this.mass[s][j], this.mass[k+1][j]))
            a++;
        else
        {
            if(a>=config.NUMBER_PETS)
                this.addDestroyH(i, j, a);
            else
                if(this.mass[k][j].ID == 1) a--;
            return a;
        }
    if(a>=config.NUMBER_PETS)
        this.addDestroyH(i, j, a);
    else
        if(this.mass[k][j].ID == 1) a--;
    return a;
};
//-------------------------------find-------------------------------\\


//-------------------------------destroy-------------------------------\\
ClassGrid.prototype.addDestroyW = function(i, j, a)
{
    stage_glow.addChild(ClassBorder(this.getImg.x+j*(40*devise_size)-20*devise_size, this.getImg.y+i*(40*devise_size)-20*devise_size, a*(40*devise_size)+0*devise_size, (40*devise_size)));
    for(var k=j; k<j+a; k++){
        if(this.mass[i][k].bonusID == 1)
        {
            this.mass[i][k].bonusID = 0;
            this.addDestroyHG(0,k,this.height);
        }
        this.destroy[i][k] = 1;
    }
};

ClassGrid.prototype.addDestroyH = function(i, j, a)
{
    stage_glow.addChild(ClassBorder(this.getImg.x+j*(40*devise_size)-20*devise_size, this.getImg.y+i*(40*devise_size)-20*devise_size, (40*devise_size), a*(40*devise_size)+0*devise_size));
    for(var k=i; k<i+a; k++) {
        if(this.mass[k][j].bonusID == 1)
            if(this.mass[k][j].bonusID == 1)
            {
                this.mass[k][j].bonusID = 0;
                this.addDestroyWG(k,0,this.width);
            }
        this.destroy[k][j] = 1;
    }
};

ClassGrid.prototype.addDestroyWG = function(i, j, a)
{
    global_glow = true;

    var s = "";
    var strt = -1, end = 0;
    for(var t=0; t<this.width; t++)
    {
        s += this.mass[i][t].ID+" ";
        if(this.mass[i][t].ID != -1)
        {
            if(strt == -1) strt = t;
            end = t;
        }
    }

    stage_glow.addChild(ClassBorder(this.getImg.x+strt*(40*devise_size)-20*devise_size, this.getImg.y+i*(40*devise_size)-20*devise_size, (end+1-strt)*(40*devise_size)+0*devise_size, (40*devise_size)));

    for(var k=j; k<j+a; k++){
        if(this.mass[i][k].bonusID == 1)
        {
            this.mass[i][k].bonusID = 0;
            this.addDestroyHG(strt,k,end);
        }
        if(this.mass[i][k].ID != -1 && this.mass[i][k].bonusID != 2) this.glow[i][k] = 1;
    }
};

ClassGrid.prototype.addDestroyHG = function(i, j, a)
{
    global_glow = true;

    var s = "";
    var strt = -1, end = 0;
    for(var t=0; t<this.height; t++)
    {
        s += this.mass[i][t].ID+" ";
        if(this.mass[t][j].ID != -1)
        {
            if(strt == -1) strt = t;
            end = t;
        }
    }

    stage_glow.addChild(ClassBorder(this.getImg.x+j*(40*devise_size)-20*devise_size, this.getImg.y+strt*(40*devise_size)-20*devise_size, (40*devise_size), (end+1-strt)*(40*devise_size)+0*devise_size));

    for(var k=i; k<i+a; k++) {
        if(this.mass[k][j].bonusID == 1)
        {
            this.mass[k][j].bonusID = 0;
            this.addDestroyWG(k,strt,end);
        }
        if(this.mass[k][j].ID != -1 && this.mass[k][j].bonusID != 2) this.glow[k][j] = 1;
    }
};
//-------------------------------destroy-------------------------------\\

//-------------------------------restroy-------------------------------\\
//-------------------------------restroy-------------------------------\\

ClassGrid.prototype.addMulti = function()
{
    for(var i=0; i<this.height; i++)
        for(var j=0; j<this.width; j++)
            if(this.destroy[i][j] == 0 && this.mass[i][j].ID == 0 && this.mass[i][j].bonusID == 0 &&
            (
                (i-1>=0 && j-1>=0 && this.destroy[i-1][j-1] != 0) ||
                (i-1>=0 && this.destroy[i-1][j] != 0) ||
                (i-1>=0 && j+1<this.width && this.destroy[i-1][j+1] != 0) ||
                (j-1>=0 && this.destroy[i][j-1] != 0) ||
                (j+1<this.width && this.destroy[i][j+1] != 0) ||
                (i+1<this.height && j-1>=0 && this.destroy[i+1][j-1] != 0) ||
                (i+1<this.height && this.destroy[i+1][j] != 0) ||
                (i+1<this.height && j+1<this.width && this.destroy[i+1][j+1] != 0)))
                this.mass[i][j].addMulti();
};

var global_glow = true;

ClassGrid.prototype.AddBonus = function(a)
{
    var x = (Math.random()*this.width)<<0, y = (Math.random()*this.height)<<0;
    while(!(this.mass[y][x].ID == 0 && this.mass[y][x].bonusID == 0))
    {
        x = (Math.random()*this.width)<<0;
        y = (Math.random()*this.height)<<0;
    }

    switch(a)
    {
        case "glow":
            if(global_glow)
            {
                this.mass[y][x].bonusID = 1;
                global_glow = false;
            }
            break;
        case "key":
            this.mass[y][x].bonusID = 2;
            break;
        case "gift":
            this.mass[y][x].bonusID = 3;
            break;
        case "heart":
            this.mass[y][x].ID = 1;
            break;
        case "water":
            this.mass[y][x].ID = 2;
            this.mass[y][x].val = 12;
            break;
        case "pumpkin":
            this.mass[y][x].ID = 3;
            this.mass[y][x].val = 1;
            break;
        case "watermelons":
            this.mass[y][x].ID = 4;
            this.mass[y][x].val = 1;
            break;
    }
};

var save_combo = 0;
ClassGrid.prototype.SetCombo1 = function()
{
    var a = 0;
    for(var i=0; i<this.height; i++)
        for(var j=0; j<this.width; j++)
            if(this.destroy[i][j] == 1)
                a++;
    save_combo = a - this.glow_m;
};

ClassGrid.prototype.SetCombo2 = function()
{
    game.combo.Set(save_combo);
};

ClassGrid.prototype.fGift = function()
{
    for(var i=0; i<this.height; i++)
        for(var j=0; j<this.width; j++)
            if(this.destroy[i][j] == 1 && this.mass[i][j].bonusID == 3)
                window_controller.Show("gift");
};

ClassGrid.prototype.newRand = function(i, j)
{
    if(game.all_job.job.isWater() && Math.random() < config.water_pr)
    {
        this.mass[i][j].ID = 2;
        this.mass[i][j].value = 12;
        this.mass[i][j].bonusID = 0;
        this.mass[i][j].multi = 1;
    }
    else
    {
        this.mass[i][j].set(0, this.rand());
    }
};

ClassGrid.prototype.Restroy = function()
{
    stage_glow.removeAllChildren();

    this.addMulti();
    this.SetCombo1();
    this.fGift();

    save_swap[0] = -1;
    var a, b = 1;
    for(var j=0; j<this.width; j++)
    {
        b = 1;
        for(var i=this.height-1; i>-1; i--)
            if(this.destroy[i][j] == 1)
            {
                a = this.getUp(i, j);
                if(a < 0)
                {
                    b++;
                    this.destroy[i][j] = 0;
                    this.newRand(i, j);
                    this.gr.ToCor(i, j, -b, j);
                }
                else
                {
                    this.destroy[i][j] = 0;
                    this.destroy[a][j] = 1;
                    swapE(i, j, a, j);
                    this.gr.ToImg(i, j, a, j);
                }
            }
    }
    this.SetCombo2();

    this.gr.Upd();
};

ClassGrid.prototype.getUp = function(i_, j_)
{
    var i = i_-1;
    while(i > -1 && (this.destroy[i][j_] == 1 || this.mass[i][j_].ID == -1))
        i--;
    return i;
};

var save_swap = [];

ClassGrid.prototype.MouseSwap = function(i1, j1, i2, j2)
{
    if(this.mass[i1][j1].bonusID != 2 && this.mass[i1][j1].ID != 3 && this.mass[i1][j1].ID != 4 && this.mass[i2][j2].bonusID != 2 && this.mass[i2][j2].ID != 3 && this.mass[i2][j2].ID != 4
       && this.mass[i1][j1].ID != -1 && this.mass[i2][j2].ID != -1)
    {
        stage_glow.addChild(ClassBorder(game.grid.getImg.x+j1*(40*devise_size)-20*devise_size, game.grid.getImg.y+i1*(40*devise_size)-20*devise_size, 40*devise_size, 40*devise_size));
        stage_glow.addChild(ClassBorder(game.grid.getImg.x+j2*(40*devise_size)-20*devise_size, game.grid.getImg.y+i2*(40*devise_size)-20*devise_size, 40*devise_size, 40*devise_size));
        save_swap = [i1, j1, i2, j2];
        swapE(i1, j1, i2, j2);
        this.gr.ToCor(i1, j1, i2, j2);
        this.gr.ToCor(i2, j2, i1, j1);
        this.gr.Upd();
    }
};

ClassGrid.prototype.isDestroy = function()
{
    var a = 0;
    for(var i=0; i<this.height; i++)
        for(var j=0; j<this.width; j++)
            a += this.destroy[i][j];
    game.score.Add(a);
    return (a != 0);
};

ClassGrid.prototype.backSwap = function()
{
    if(save_swap[0] != -1)
    {
        this.MouseSwap(save_swap[0], save_swap[1], save_swap[2], save_swap[3]);
        game.all_job.moves.Add(-1);
    }
    save_swap[0] = -1;
};

ClassGrid.prototype.Bonus1 = function(i1, j1)          //water
{
    if(this.mass[i1][j1].ID == 3 || this.mass[i1][j1].ID == 4)
    {
        if(this.mass[i1][j1].val == 2)
            this.destroy[i1][j1] = 1;
        else
            this.mass[i1][j1].val++;

        this.gr.setAnimBonus6();
        return true;
    }
    return false;
};

ClassGrid.prototype.Bonus2 = function(i1, j1)          //one
{
    if(this.mass[i1][j1].ID != -1 && this.mass[i1][j1].bonusID != 2)
    {
        this.destroy[i1][j1] = 1;
        this.gr.setAnimBonus2();
        return true;
    }
    return false;
};

ClassGrid.prototype.Bonus3 = function(i1, j1)          //bomb
{
    if(this.mass[i1][j1].ID != -1 && this.mass[i1][j1].bonusID != 2)
    {
        if(j1+1<this.width && this.mass[i1][j1+1].ID != -1 && this.mass[i1][j1+1].bonusID != 2) this.destroy[i1][j1+1] = 1;
        this.destroy[i1][j1] = 1;
        if(j1-1>=0 && this.mass[i1][j1-1].ID != -1 && this.mass[i1][j1-1].bonusID != 2) this.destroy[i1][j1-1] = 1;

        if(j1+1<this.width && i1+1<this.height && this.mass[i1+1][j1+1].ID != -1 && this.mass[i1+1][j1+1].bonusID != 2) this.destroy[i1+1][j1+1] = 1;
        if(i1+1<this.height && this.mass[i1+1][j1].ID != -1 && this.mass[i1+1][j1].bonusID != 2) this.destroy[i1+1][j1] = 1;
        if(j1-1>=0 && i1+1<this.height && this.mass[i1+1][j1-1].ID != -1 && this.mass[i1+1][j1-1].bonusID != 2) this.destroy[i1+1][j1-1] = 1;

        if(j1+1<this.width && i1-1>=0 && this.mass[i1-1][j1+1].ID != -1 && this.mass[i1-1][j1+1].bonusID != 2) this.destroy[i1-1][j1+1] = 1;
        if(i1-1>=0 && this.mass[i1-1][j1].ID != -1 && this.mass[i1-1][j1].bonusID != 2) this.destroy[i1-1][j1] = 1;
        if(j1-1>=0 && i1-1>=0 && this.mass[i1-1][j1-1].ID != -1 && this.mass[i1-1][j1-1].bonusID != 2) this.destroy[i1-1][j1-1] = 1;

        this.gr.setAnimBonus3();
        return true;
    }
    return false;
};

ClassGrid.prototype.Bonus4 = function(i1, j1)          //line
{
    for(var j=0; j<this.width; j++)
        if(this.mass[i1][j].ID != -1 && this.mass[i1][j].bonusID != 2)
            this.destroy[i1][j] = 1;

    this.gr.setAnimBonus4();
    return true;
};

ClassGrid.prototype.Bonus5 = function(i1, j1)          //color
{
    if(this.mass[i1][j1].ID == 0)
    {
        for(var i=0; i<this.height; i++)
            for(var j=0; j<this.width; j++)
                if(this.mass[i][j].ID == 0 && this.mass[i][j].val == this.mass[i1][j1].val && this.mass[i][j].bonusID != 2)
                    this.destroy[i][j] = 1;

        this.gr.setAnimBonus5();
        return true;
    }
    return false;
};

ClassGrid.prototype.Bonus6 = function(i1, j1)          //loc
{
    if(this.mass[i1][j1].ID != -1 && this.mass[i1][j1].bonusID == 2)
    {
        this.mass[i1][j1].setB(0);

        this.gr.setAnimBonus6();
        return true;
    }
    return false;
};

ClassGrid.prototype.Mix = function()
{
    for(var i=0;i<this.height; i++)
        for(var j=0;j<this.width; j++)
            if(this.mass[i][j].ID == 0)
                this.mass[i][j].set(0, this.rand());

    this.FindLine();
    while(this.isDestroy())
    {
        for(i=0;i<this.height; i++)
            for(j=0;j<this.width; j++)
                if(this.destroy[i][j] == 1)
                {
                    this.mass[i][j].set(0, this.rand());
                    this.destroy[i][j] = 0;
                }
        this.FindLine();
    }

    this.gr.Upd();
};


var bot = [0, 0, 0, 0, 0];
var f_bot = 0;

ClassGrid.prototype.FindAll = function()   //поиск
{
    bot = [0, 0, 0, 0, 0];
    f_bot = 0;

    for(var i=0; i<this.height; i++)
        for(var j=0; j<this.width; j++)
            this.Find(i, j);

    var a = true;
    if(game.bot == false) {
        for (i = 0; i < this.height; i++)
            for (j = 0; j < this.width; j++)
                if(this.mass[i][j].ID == 2) a = false;
    }

    if(bot[4] == 0 && a)
    {
        this.Mix();
        this.FindAll();
    }
};

ClassGrid.prototype.Find = function(i, j)
{
    if(i+1<this.height && isSwp(i, j) && isSwp(i+1, j))
        this.OneFind(i, j, i+1, j);
    if(i-1>=0 && isSwp(i, j) && isSwp(i-1, j))
        this.OneFind(i, j, i-1, j);
    if(j+1<this.width && isSwp(i, j) && isSwp(i, j+1))
        this.OneFind(i, j, i, j+1);
    if(j-1>=0 && isSwp(i, j) && isSwp(i, j-1))
        this.OneFind(i, j, i, j-1);
};

ClassGrid.prototype.Write = function()
{
    var a = "";
    for(var i=0; i<this.height; i++)
    {
        a += "[";
        for(var j=0; j<this.width; j++)
        {
            a += this.mass[i][j].bonusID + ", "
        }
        a += "]";
    }
    a += "\n";
    console.log(a);
};

ClassGrid.prototype.OneFind = function(i1, j1, i2, j2)
{
    f_bot = 0;
    swapE(i1, j1, i2, j2);

    var i, j;
    for(i=0; i<this.height; i++) {
        j=0;
        while(j < this.width-1) j += this.OneMatchW(i, j);
    }
    for(j=0; j<this.width; j++) {
        i=0;
        while(i < this.height-1) i += this.OneMatchH(i, j);
    }

    if(f_bot > bot[4])
    {
        bot[0] = i1;
        bot[1] = j1;
        bot[2] = i2;
        bot[3] = j2;
        bot[4] = f_bot;
    }
    swapE(i1, j1, i2, j2);
};

ClassGrid.prototype.OneMatchW = function(i, j)
{
    /*
    var a = 1;
    for(var k=j; k<this.width-1; k++)
        if(isDes(this.mass[i][k], this.mass[i][k+1]))
            a++;
        else
        {
            if(a>=config.NUMBER_PETS) f_bot += a;
            return a;
        }
    if(a>=config.NUMBER_PETS) f_bot += a;
    return a;
    */


    var a = 1, s=j;
    if(this.mass[i][j].ID == 1) { a++; s = j+1; }
    for(var k=s; k<this.width-1; k++)
        if(isDes(this.mass[i][s], this.mass[i][k+1]))
            a++;
        else
        {
            if(a>=config.NUMBER_PETS)
                f_bot += a;
            else
                if(this.mass[i][k].ID == 1) a--;
            return a;
        }
    if(a>=config.NUMBER_PETS)
        f_bot += a;
    else
        if(this.mass[i][k].ID == 1) a--;
    return a;
};

ClassGrid.prototype.OneMatchH = function(i, j)
{
    /*
    var a = 1;
    for(var k=i; k<this.height-1; k++)
        if(isDes(this.mass[k][j], this.mass[k+1][j]))
            a++;
        else
        {
            if(a>=config.NUMBER_PETS) f_bot += a;
            return a;
        }
    if(a>=config.NUMBER_PETS) f_bot += a;
    return a;
     */

    var a = 1, s=i;
    if(this.mass[i][j].ID == 1) { a++; s = i+1; }
    for(var k=s; k<this.height-1; k++)
        if(isDes(this.mass[s][j], this.mass[k+1][j]))
            a++;
        else
        {
            if(a>=config.NUMBER_PETS)
                f_bot += a;
            else
                if(this.mass[k][j].ID == 1) a--;
            return a;
        }
    if(a>=config.NUMBER_PETS)
        f_bot += a;
    else
        if(this.mass[k][j].ID == 1) a--;
    return a;
};