function ClassLoad()
{
    this.queue = new createjs.LoadQueue(true);
    this.queue.loadManifest(
        [
            {id:"load", src:"assets/load"+devise_size+".jpg"},
            {id:"load_progress", src:"assets/load_progress"+devise_size+".png"}
        ]
    );
    this.queue.addEventListener("complete", function(){
        load.Start();
    }, false);
}

ClassLoad.prototype.Start = function()
{
    this.img_load = new createjs.Bitmap(this.queue.getResult("load"));
    stage.addChild(this.img_load);
    this.img_load_progress = new createjs.Bitmap(this.queue.getResult("load_progress"));
    this.img_load_progress.x = 66*devise_size;
    this.img_load_progress.y = 336*devise_size;
    this.img_load_progress.regX = 15*devise_size;
    this.img_load_progress.regY = 15*devise_size;
    stage.addChild(this.img_load_progress);

    this.queue.removeAllEventListeners("complete");
    this.queue.addEventListener("complete", function(){ load.EndLoad(); }, false);
    this.queue.addEventListener("progress", function(){ load.Drw(); }, false);
    this.queue.loadManifest(
        [
            {id:"pack1", src:"assets/pack1"+devise_size+".png"},
            {id:"pack2", src:"assets/pack2"+devise_size+".png"},
            {id:"bg_main", src:"assets/bg_main"+devise_size+".jpg"},
            {id:"bg_menu", src:"assets/bg_menu"+devise_size+".jpg"},
            {id:"scr", src:"assets/scr"+devise_size+".jpg"},

            //fonts
            {id:"font0", src:"assets/fnt/font0"+devise_size+".png"},
            {id:"font1", src:"assets/fnt/font1"+devise_size+".png"},
            {id:"font2", src:"assets/fnt/font2"+devise_size+".png"},
            {id:"font3", src:"assets/fnt/font3"+devise_size+".png"},
            {id:"font4", src:"assets/fnt/font4"+devise_size+".png"},

            //config and data
            {id:"config", src:"config.js", type: createjs.LoadQueue.JAVASCRIPT},
            {id:"levels", src:"levels.js", type: createjs.LoadQueue.JAVASCRIPT},
            {id:"data", src:"data"+devise_size+".js", type: createjs.LoadQueue.JAVASCRIPT},
            {id:"fonts", src:"fonts"+devise_size+".js", type: createjs.LoadQueue.JAVASCRIPT},


            //________________________4_GRUNT_____________________________________________________

            // {id:"minigame", src:"game.min.js", type: createjs.LoadQueue.JAVASCRIPT},
            //_____________________________________________________________________________

            // need to comment:
            {id:"class_font", src:"class_font.js", type: createjs.LoadQueue.JAVASCRIPT},
            //class
            {id:"class_border", src:"class_border.js", type: createjs.LoadQueue.JAVASCRIPT},
            {id:"class_game", src:"class_game.js", type: createjs.LoadQueue.JAVASCRIPT},
            {id:"class_init", src:"class_init.js", type: createjs.LoadQueue.JAVASCRIPT},

            {id:"class_el", src:"class_el.js", type: createjs.LoadQueue.JAVASCRIPT},
            {id:"class_grid", src:"class_grid.js", type: createjs.LoadQueue.JAVASCRIPT},
            {id:"class_bg", src:"class_bg.js", type: createjs.LoadQueue.JAVASCRIPT},
            {id:"class_gr", src:"class_gr.js", type: createjs.LoadQueue.JAVASCRIPT},

            {id:"class_bonus", src:"class_bonus.js", type: createjs.LoadQueue.JAVASCRIPT},
            {id:"class_moves", src:"class_moves.js", type: createjs.LoadQueue.JAVASCRIPT},
            {id:"class_save", src:"class_save.js", type: createjs.LoadQueue.JAVASCRIPT},
            {id:"class_job", src:"class_job.js", type: createjs.LoadQueue.JAVASCRIPT},
            {id:"class_combo", src:"class_combo.js", type: createjs.LoadQueue.JAVASCRIPT},
            {id:"class_progress_bar", src:"class_progress_bar.js", type: createjs.LoadQueue.JAVASCRIPT},
            {id:"class_bot", src:"class_bot.js", type: createjs.LoadQueue.JAVASCRIPT},
            {id:"class_flypets", src:"class_flypets.js", type: createjs.LoadQueue.JAVASCRIPT},
            {id:"class_add_bonus", src:"class_add_bonus.js", type: createjs.LoadQueue.JAVASCRIPT},
            {id:"class_score", src:"class_score.js", type: createjs.LoadQueue.JAVASCRIPT},
            {id:"class_time_bar", src:"class_time_bar.js", type: createjs.LoadQueue.JAVASCRIPT},
            {id:"class_all_j", src:"class_all_j.js", type: createjs.LoadQueue.JAVASCRIPT},
            {id:"class_bonus_bar", src:"class_bonus_bar.js", type: createjs.LoadQueue.JAVASCRIPT},
            {id:"class_flywater", src:"class_flywater.js", type: createjs.LoadQueue.JAVASCRIPT},
            //window
            {id:"class_window", src:"windows/class_window.js", type: createjs.LoadQueue.JAVASCRIPT},
            {id:"class_window_controller", src:"windows/class_window_controller.js", type: createjs.LoadQueue.JAVASCRIPT},
            {id:"window_ss", src:"windows/window_ss.js", type: createjs.LoadQueue.JAVASCRIPT},
            {id:"window_main_menu", src:"windows/window_main_menu.js", type: createjs.LoadQueue.JAVASCRIPT},
            {id:"window_pause", src:"windows/window_pause.js", type: createjs.LoadQueue.JAVASCRIPT},
            {id:"window_job", src:"windows/window_job.js", type: createjs.LoadQueue.JAVASCRIPT},
            {id:"window_map", src:"windows/window_map.js", type: createjs.LoadQueue.JAVASCRIPT},
            {id:"window_main_menu", src:"windows/window_setting.js", type: createjs.LoadQueue.JAVASCRIPT},
            {id:"window_location", src:"windows/window_location.js", type: createjs.LoadQueue.JAVASCRIPT},
            {id:"window_level_clear", src:"windows/window_level_clear.js", type: createjs.LoadQueue.JAVASCRIPT},
            {id:"window_game_complete", src:"windows/window_game_complete.js", type: createjs.LoadQueue.JAVASCRIPT},
            {id:"window_bonus_lvl", src:"windows/window_bonus_lvl.js", type: createjs.LoadQueue.JAVASCRIPT},
            {id:"window_about", src:"windows/window_about.js", type: createjs.LoadQueue.JAVASCRIPT},
            {id:"window_tut", src:"windows/window_tut.js", type: createjs.LoadQueue.JAVASCRIPT},
            {id:"windows_gift", src:"windows/windows_gift.js", type: createjs.LoadQueue.JAVASCRIPT},
            {id:"window_level_failed", src:"windows/window_level_failed.js", type: createjs.LoadQueue.JAVASCRIPT},
            {id:"window_bonus_level_complete", src:"windows/window_bonus_level_complete.js", type: createjs.LoadQueue.JAVASCRIPT},
            {id:"window_level_complete", src:"windows/window_level_complete.js", type: createjs.LoadQueue.JAVASCRIPT},
            {id:"window_target", src:"windows/window_target.js", type: createjs.LoadQueue.JAVASCRIPT}

            //--------------END-COMMENT-4-GRUNT---------------------------------------------------------------
        ]
    );
    //this.load_interval = setInterval(function(){ load.Drw(); }, 1000/30);
};

ClassLoad.prototype.Drw = function()
{
    this.img_load_progress.x = (66 + (176 * this.queue.progress)<<0)*devise_size;
    stage.update();
};

ClassLoad.prototype.EndLoad = function()
{
    //clearInterval(this.load_interval);
    //document.body.appendChild(load.queue.getResult("config"));

    stage.removeAllChildren();

    CreateFonts();

    StartGame();
};

ClassLoad.prototype.LoadAudio = function()
{
    if(lock_audio)
    {
        lock_audio = false;
        createjs.Sound.registerPlugins([createjs.WebAudioPlugin]);
        audio_supported = createjs.WebAudioPlugin.isSupported();
        if(audio_supported)
        {
            createjs.Sound.alternateExtensions = ["ogg"];
            this.queue.installPlugin(createjs.Sound);
            this.queue.removeAllEventListeners();
            this.queue.addEventListener("complete", MusicPlay, false);
            this.queue.loadManifest([
                {id:"game_over", src:"assets/sound/game_over.mp3", type: createjs.LoadQueue.SOUND},
                {id:"get_reward", src:"assets/sound/get_reward.mp3", type: createjs.LoadQueue.SOUND},
                {id:"level_completed", src:"assets/sound/level_completed.mp3", type: createjs.LoadQueue.SOUND},
                {id:"pop_pets", src:"assets/sound/pop_pets.mp3", type: createjs.LoadQueue.SOUND},
                {id:"use_of_bonus_award", src:"assets/sound/use_of_bonus_award.mp3", type: createjs.LoadQueue.SOUND},
                {id:"music", src:"assets/sound/music.mp3", type: createjs.LoadQueue.SOUND}
            ]);
        }
    }
};

function MusicPlay()
{
    window_controller.windows[window_controller.getIDbyName("pause")].btn_mc.on("mousedown", function()
    {
        music.setMute(!music.getMute());
        if(music.getMute())
            window_controller.windows[window_controller.getIDbyName("pause")].btn_music_up.alpha = 0.5;
        else
            window_controller.windows[window_controller.getIDbyName("pause")].btn_music_up.alpha = 1;
    });

    window_controller.windows[window_controller.getIDbyName("pause")].btn_s.on("mousedown", function()
    {
        s_game_over.setMute(!s_use_of_bonus_award.getMute());
        s_get_reward.setMute(!s_use_of_bonus_award.getMute());
        s_level_completed .setMute(!s_use_of_bonus_award.getMute());
        s_pop_pets.setMute(!s_use_of_bonus_award.getMute());
        s_use_of_bonus_award.setMute(!s_use_of_bonus_award.getMute());
        if(s_use_of_bonus_award.getMute())
            window_controller.windows[window_controller.getIDbyName("pause")].btn_sound_up.alpha = 0.5;
        else
            window_controller.windows[window_controller.getIDbyName("pause")].btn_sound_up.alpha = 1;
    });

    window_controller.windows[window_controller.getIDbyName("setting")].btn_sound.on("mousedown", function()
    {
        s_game_over.setMute(!s_use_of_bonus_award.getMute());
        s_get_reward.setMute(!s_use_of_bonus_award.getMute());
        s_level_completed .setMute(!s_use_of_bonus_award.getMute());
        s_pop_pets.setMute(!s_use_of_bonus_award.getMute());
        s_use_of_bonus_award.setMute(!s_use_of_bonus_award.getMute());
        if(s_use_of_bonus_award.getMute())
            window_controller.windows[window_controller.getIDbyName("setting")].btn_sound_up.alpha = 0.5;
        else
            window_controller.windows[window_controller.getIDbyName("setting")].btn_sound_up.alpha = 1;
    });

    window_controller.windows[window_controller.getIDbyName("setting")].btn_music.on("mousedown", function()
    {
        music.setMute(!music.getMute());
        if(music.getMute())
            window_controller.windows[window_controller.getIDbyName("setting")].btn_music_up.alpha = 0.5;
        else
            window_controller.windows[window_controller.getIDbyName("setting")].btn_music_up.alpha = 1;
    });

    s_game_over = createjs.Sound.createInstance("game_over");
    s_get_reward = createjs.Sound.createInstance("get_reward");
    s_level_completed = createjs.Sound.createInstance("level_completed");
    s_pop_pets = createjs.Sound.createInstance("pop_pets");
    s_use_of_bonus_award = createjs.Sound.createInstance("use_of_bonus_award");
    music = createjs.Sound.createInstance("music");
    music.play({loop : -1});
}

var s_game_over, s_get_reward, s_level_completed, s_pop_pets, s_use_of_bonus_award, music;
var lock_audio = true, audio_supported;