function ClassSave()
{
    this.bonus = [0,0,0,0,0,0];
    this.map = [];
    this.tut = true;
}

ClassSave.prototype.setMap = function(stars)
{
    this.map[game.level_num] = Math.max(this.map[game.level_num], stars);
    if(game.level_num < config.lvls.length)
        this.map[game.level_num+1] = Math.max(this.map[game.level_num+1], 0);
    window.localStorage.setItem("fpets_map", '['+this.map.toString()+']');
};

ClassSave.prototype.SaveMap = function()
{
    window.localStorage.setItem("fpets_map", '['+this.map.toString()+']');
};

ClassSave.prototype.LoadMap = function()
{
    if(window.localStorage.getItem("fpets_map") === null)
    {
        for(var i=0; i<config.lvls.length; i++)
            this.map.push(-1);    //-------
        this.map[0] = 0;
        this.SaveMap();
    }
    else
    {
        this.map = JSON.parse(window.localStorage.getItem("fpets_map"));
    }
};

ClassSave.prototype.SaveBonus = function()
{
    window.localStorage.setItem("fpets_bonus", '['+this.bonus.toString()+']');
};

ClassSave.prototype.LoadBonus = function()
{
    if(window.localStorage.getItem("fpets_bonus") === null)
    {
        this.SaveBonus();
    }
    else
    {
        this.bonus = JSON.parse(window.localStorage.getItem("fpets_bonus"));
    }
};

ClassSave.prototype.SaveTut = function()
{
    window.localStorage.setItem("fpets_tut", tut.toString());
};

ClassSave.prototype.LoadTut = function()
{
    if(window.localStorage.getItem("fpets_tut") === null)
    {
        this.tut = true;
        this.SaveTut();
    }
    else
    {
        this.tut = (window.localStorage.getItem("fpets_tut") == "true");
    }
};