function ClassWindowController()
{
    this.windows = [];
    this.windows.push(new WindowMainMenu());
    this.windows.push(new WindowMap());
    this.windows.push(new WindowLocation());
    this.windows.push(new WindowSetting());
    this.windows.push(new WindowLevelComplete());
    this.windows.push(new WindowPause());
    this.windows.push(new WindowJob());
    this.windows.push(new WindowLevelClear());
    this.windows.push(new WindowGameComplete());
    this.windows.push(new WindowBonusLevel());
    this.windows.push(new WindowAbout());
    this.windows.push(new WindowTut());
    this.windows.push(new WindowGift());
    this.windows.push(new WindowLevelFailed());
    this.windows.push(new WindowBonusLevelComplete());
    this.windows.push(new WindowSScr());
    this.windows.push(new WindowTarget());

    this.modal_bg = new createjs.Shape();
    this.modal_bg.graphics.beginFill("#000").drawRect(0, 0, 640, 960);
    this.modal_bg.alpha = 0.6;
    this.modal_bg.visible = false;

    this.active_ID = 0;
    this.path = [];
    for(var j=0; j<2; j++)
    {
        if(j == 1)
            stage.addChild(this.modal_bg);
        for(var i=0; i<this.windows.length; i++)
            if(this.windows[i].layer == j)
                stage.addChild(this.windows[i].getImg);
    }
}

ClassWindowController.prototype.Show = function(name)
{
    this.windows[this.active_ID].AHide();
    this.next = name;

    var a = this.getIDbyName(name);
    if(this.windows[a].animation_time_in != 0)
        this.windows[a]._Show();
    if(this.windows[this.active_ID].animation_time_out == 0)
        this.ShowPost();
};
ClassWindowController.prototype.ShowPost = function()
{
    this.active_ID = this.getIDbyName(this.next);
    this.windows[this.active_ID].AShow();

    if(this.windows[this.active_ID].animation_time_in == 0)
        this.AUpd();
};
ClassWindowController.prototype.AUpd = function()
{
    var i = this.path.length-1;
    while(i>=0 && this.path[i] != this.active_ID) i--;
    if(i>=0)
        this.path.splice(i+1, this.path.length-i-1);
    else
        this.path.push(this.active_ID);
    this.Upd();
};

ClassWindowController.prototype.Upd = function()
{
   /* var s = "";
    for(var j=0; j<this.path.length; j++)
        s += this.windows[this.path[j]].name+", ";
    console.log(s); */

    this.modal_bg.visible = false;
    for(var j=0; j<this.windows.length; j++)
        this.windows[j]._Hide();

    var a = true;
    for(j=1; j>=0; j--)
    {
        var i = this.path.length-1;
        while(i>=0 && this.windows[this.path[i]].layer != j) i--;
        if(i>=0)
        {
            if(a)
            {
                this.windows[this.path[i]].getImg.mouseEnabled = true;
                a = false;
            }
            else
            {
                this.windows[this.path[i]].getImg.mouseEnabled = false;
            }
            this.windows[this.path[i]]._Show();
            if(j == 1)
                this.modal_bg.visible = true;
        }
    }
};

ClassWindowController.prototype.getIDbyName = function(name)
{
    var i = 0;
    while(this.windows[i].name != name) i++;
    return i;
};

ClassWindowController.prototype.Drw = function()
{
    this.windows[this.active_ID]._Drw();
};