// loads the listeners for the charNotesMenu
var charNotesMenuListeners = function() {
	for (var i=0; i<6; i++) {
		(function(x){
			document.getElementsByClassName("charNotesOption")[i].addEventListener('click', function(){handleNotesSetMode(x)})
		})(i);
	}	
}
var clearMatchUpContainers = function() {
	generalInfoSpecContainer.innerHTML = "";
	combosSpecContainer.innerHTML = "";
	punishesSpecContainer.innerHTML = "";
	frameTrapsSpecContainer.innerHTML = "";
	optionSelectsSpecContainer.innerHTML = "";
	setUpsSpecContainer.innerHTML = "";
};


// These 3 functions handle the add button and the overylay that comes with it
var addModeButtonListener = function() {
	document.getElementById("addButton").addEventListener('click', addMode);	
}
var closeAddModeListener = function() {
	document.getElementById("closeAddButton").addEventListener('click', closeOverlay);
}
var addMode = function() {
	showOverlay();
	showElement("submitNewEntryButton");
	showElement("buttonsForNotes");
	showElement("directionsForNotes");
	showElement("inputsForNotes");
	showElement("addNewEntry");
	showElement("addNewEntryHeader");
	if (currentMode == "matchups") {
		showElement("sectionDropDown");
	};
	if (currentMode == "matchups" && formatLegendState != false) {
		showElement("formattingLegend");
	};
}

// Creates the listener for the "Submit button"
var submitButtonListener = function() {
	document.getElementById("submitNewEntryButton").addEventListener('click', appendToNotesDataBase);
}

//puts input images in the textbox

var insertButtonImage = function(buttonToAdd) {
	if (addNewEntry.classList[0] == "shown") {
		var appendedTextbox = document.getElementById("newEntryTextBox");
	} else {
		var appendedTextbox = document.getElementById("editEntryTextBox");
	}
	console.log("appending " + buttonToAdd);
	appendedTextbox.value += '{' + buttonToAdd + '}';
	
}


// Adds new data to the localStorage database
var appendToNotesDataBase = function() {
	// retrieves the database and temporarily assigns it to a var
	var tempNotesDatabase = JSON.parse(window.localStorage.getItem("charNotesData"));
	// get the text from the box
	var text = document.getElementById("newEntryTextBox").value;
	if (text == "") {
		// catches empty entry
		alert("You have to actually put something in the box!");
	} else if (text.indexOf("<script") > -1 || text.indexOf("<div") > -1 || text.indexOf("<span") > -1 || text.indexOf("<html") > -1 || text.indexOf("<body") > -1 || text.indexOf("<head") > -1 || text.indexOf("<!-") > -1 || text.indexOf("<h1") > -1 || text.indexOf("<h2") > -1 || text.indexOf("<h4") > -1 || text.indexOf("<h5") > -1 || text.indexOf("<h6") > -1 || text.indexOf("<p") > -1 || text.indexOf("<table") > -1 || text.indexOf("<tbody") > -1 || text.indexOf("<select") > -1 || text.indexOf("<input") > -1 || text.indexOf("<a") > -1){
		alert("Now now! I appreciate your ingenuity, but no silly tags allowed!")
	} else {
		console.log("appending:" + text);
		// puts the new text in the temp-database
		if (currentMode != "matchups") {
			tempNotesDatabase[player1][currentMode].push(text);
		} else {
			var sectionNumber = document.getElementById("sectionDropDown").selectedIndex;
			var selectedSection = document.getElementById("sectionDropDown")[sectionNumber].getAttribute("id");
			tempNotesDatabase[player1][currentMode][player2][selectedSection].push(text);
		}
		console.log("Saving to database");
		//saves the temp database over the old one
		window.localStorage.setItem("charNotesData", JSON.stringify(tempNotesDatabase));
		// reloads the answerSpace with the new data included
		loadCurrentData();
		// clears the textbox
		document.getElementById("newEntryTextBox").value = ""
		// closes the overlay box
		hideElement("submitNewEntryButton");
		hideElement("addNewEntry");
		closeOverlay();
	}
}

var appendToAnswerListCharNotes = function(toBeAppended, elementNumber, containerName, sectionNumber, sectionName) {
	
	if (currentMode != "matchups") {
		var d = document.getElementById("answerSpace");
		var newP = document.createElement("p");
		newP.innerHTML = toBeAppended;
		d.appendChild(newP);
	
		d.children[elementNumber].setAttribute("onclick", "editMode(" + elementNumber + ")");
		
		d.children[elementNumber].setAttribute("class", "highlightable char_note_data_entity");
		
	} else {
		var d = document.getElementById("matchUpSpace");
		var section = d.children[containerName]
		var newP = document.createElement("p");
		newP.innerHTML = toBeAppended;
		section.appendChild(newP);
		
		section.children[sectionNumber].setAttribute("onclick", "editMode(" + sectionNumber + ", " + elementNumber + ", " + sectionName + ")");
		
		section.children[sectionNumber].setAttribute("class", "highlightable char_note_data_entity");
	}
	
}

// Loads the data already inputted for the current mode
var loadCurrentData = function() {
	console.log("loading");
	var tempNotesDatabase = JSON.parse(window.localStorage.getItem("charNotesData"));

	if (currentMode != "matchups") {
		answerSpace.innerHTML = "";
		var currentDataSet = tempNotesDatabase[player1][currentMode];
		for (i=0;i<currentDataSet.length;i++) {
			var toBeAppended = currentDataSet[i];
			var toBeAppNewLined = toBeAppended.replace(/\n/g, '<br>')
			
			var toBeAppTagOpen = toBeAppNewLined.replace(/{/g, '<img class="mlInput" src="images/input_images/')
			var toBeAppReady = toBeAppTagOpen.replace(/}/g, '.png">')
			
			
			appendToAnswerListCharNotes(toBeAppReady, i);
		}
	} else {
		
		clearMatchUpContainers();
		var currentDataSet = tempNotesDatabase[player1][currentMode][player2];
		var k = 0;
		for (var sectionName in currentDataSet) {
			var section = currentDataSet[sectionName];
			
			var containerName = sectionName + "Container";
			for (var i=0;i<section.length;i++) {
				var toBeAppended = section[i];
				var toBeAppNewLined = toBeAppended.replace(/\n/g, '<br>')
				
				var toBeAppTagOpen = toBeAppNewLined.replace(/{/g, '<img class="mlInput" src="images/input_images/')
				var toBeAppReady = toBeAppTagOpen.replace(/}/g, '.png">')
				
				
				appendToAnswerListCharNotes(toBeAppReady, k, containerName, i, sectionName);
				k++;
			}
		}
	}
}

var editMode = function(reference, reference2, reference3) {
	var tempNotesDatabase = JSON.parse(window.localStorage.getItem("charNotesData"));
	var currentDataSet = tempNotesDatabase[player1][currentMode];
	
	if (currentMode != "matchups") {
		document.getElementById("editEntryTextBox").value = currentDataSet[reference];
		currentEditingElement = reference;
		currentEditingSection = reference;
	} else {
		
		document.getElementById("editEntryTextBox").value = currentDataSet[player2][reference3.id][reference]
		currentEditingSection = reference3;
		currentEditingElement = reference;
		
	}
	
	
	
	showOverlay();
	showElement("editEntry");
	showElement("editEntryHeader");
	showElement("editCurrentEntryButton");
	showElement("buttonsForNotes");
	showElement("directionsForNotes");
	showElement("inputsForNotes");
	showElement("deleteCurrentEntryButton");
	if (currentMode == "matchups" && formatLegendState) {
		showElement("formattingLegend");
	};
}
// Creates the listener for the "Edit button"
var editButtonListener = function() {
	document.getElementById("editCurrentEntryButton").addEventListener('click', editEntryDataBase);
}
// Creates the listener for the "Delete button"
var deleteButtonListener = function() {
	document.getElementById("deleteCurrentEntryButton").addEventListener('click', deleteEntryDataBase);
}
// Adds edited data to the localStorage database
var editEntryDataBase = function() {
	// retrieves the database and temporarily assigns it to a var
	var tempNotesDatabase = JSON.parse(window.localStorage.getItem("charNotesData"));
	// get the text from the box
	var text = document.getElementById("editEntryTextBox").value;
	if (text == "") {
		// catches empty entry
		alert("You have to actually put something in the box!");
	} else if (text.indexOf("<script") > -1 || text.indexOf("<div") > -1 || text.indexOf("<span") > -1 || text.indexOf("<html") > -1 || text.indexOf("<body") > -1 || text.indexOf("<head") > -1 || text.indexOf("<!-") > -1 || text.indexOf("<h1") > -1 || text.indexOf("<h2") > -1 || text.indexOf("<h4") > -1 || text.indexOf("<h5") > -1 || text.indexOf("<h6") > -1 || text.indexOf("<p") > -1 || text.indexOf("<table") > -1 || text.indexOf("<tbody") > -1 || text.indexOf("<select") > -1 || text.indexOf("<input") > -1 || text.indexOf("<a") > -1){
		alert("Now now! I appreciate your ingenuity, but no silly tags allowed!")
	} else {
		console.log("appending:" + text);
		// puts the new text in the temp-database
		if (currentMode != "matchups") {
			tempNotesDatabase[player1][currentMode].splice(currentEditingElement, 1, text);
		} else {
			tempNotesDatabase[player1][currentMode][player2][currentEditingSection.getAttribute("id")].splice(currentEditingElement, 1, text);
		}
		
		console.log("Saving to database");
		//saves the temp database over the old one
		window.localStorage.setItem("charNotesData", JSON.stringify(tempNotesDatabase));
		// reloads the answerSpace with the new data included
		loadCurrentData();
		// clears the textbox
		document.getElementById("newEntryTextBox").value = ""
		// closes the overlay box
		closeOverlay();
	};
}
// Deletes data from the localStorage database
var deleteEntryDataBase = function() {
	if (confirm("Are you sure you want to permanently delete this entry from your notes?")) {
		// retrieves the database and temporarily assigns it to a var
		var tempNotesDatabase = JSON.parse(window.localStorage.getItem("charNotesData"));
		// removes the element in the temp-database
		if (currentMode != "matchups") {
			tempNotesDatabase[player1][currentMode].splice(currentEditingElement, 1);
		} else {
			tempNotesDatabase[player1][currentMode][player2][currentEditingSection.getAttribute("id")].splice(currentEditingElement, 1);
		}
		
		
		console.log("Saving to database");
		//saves the temp database over the old one
		window.localStorage.setItem("charNotesData", JSON.stringify(tempNotesDatabase));
		// reloads the answerSpace with the new data included
		loadCurrentData();
		// clears the textbox
		document.getElementById("newEntryTextBox").value = ""
		// closes the overlay box
		closeOverlay();
	}
}


// Sets Mode specifically for the Notes Mode
handleNotesSetMode = function(mode) {
	hideElement("charNotesMenu");
	switch (mode) {
		case 0:
			currentMode = "combosU";
			hideElement("charNotesHeader");
			showElement("combosUHeader");
			showNotesMode();
			break;
		case 1:
			currentMode = "punishesU";
			hideElement("charNotesHeader");
			showElement("punishesUHeader");
			showNotesMode();
			break;
		case 2:
			currentMode = "frameTrapsU";
			hideElement("charNotesHeader");
			showElement("frameTrapsUHeader");
			showNotesMode();
			break;
		case 3:
			currentMode = "optionSelectsU";
			hideElement("charNotesHeader");
			showElement("optionSelectsUHeader");
			showNotesMode();
			break;
		case 4:
			currentMode = "setUpsU";
			hideElement("charNotesHeader");
			showElement("setUpsUHeader");
			showNotesMode();
			break;
		case 5:
			currentMode = "matchUpSet";
			playerNum = 2;
			for (var i=0; i<44; i++) {
				var chars = document.getElementsByClassName("char_index");
				chars[i].classList.remove("character_one");
				chars[i].classList.add("character_two");
			}
			showElement("charMenu");
			hideElement("charNotesHeader");
			showElement("player2Header");
			break;
		default:
			console.log("Something has gone terribly wrong!");
			break;
	};
};

// begins selected mode
var showNotesMode = function() {
	console.log("BEGINNING MODE: " + currentMode);
	console.log(player1);
	hideElement("helpButton");
	showElement("addButton");
	
	switch(currentMode) {
		case "combosU":
		case "punishesU":
		case "frameTrapsU":
		case "optionSelectsU":
		case "setUpsU":
			showElement("answerSpace");
			showElement("playerOneBanner");
			loadCurrentData();
			break;
		case "matchups":
			window.scrollTo(0,0);
			loadCurrentData();
			break;
		default:
			console.log("Something has gone terribly wrong!");
			break;
		
	};
};

//returns to the charNotes Menu

var returnToCharNotesMenu = function() {
	var currentShownElements = document.getElementsByClassName("shown");
	var numOfElements = currentShownElements.length;
	
	for (var i=0; i<numOfElements; i++){
		hideElement(currentShownElements[0].id);
	}
	
	showElement("charNotesMenu");
	showElement("charNotesHeader");
	showElement("screenBackButton");
	showElement("helpButton");
	currentMode = "charNotesMenu";
}