// Initiliing Variables
var characterContainer;
var dropDownOne;
var dropDownTwo;
var textField;
var answerSpace;
var counterhit;
var counterhitSet;
var counterhitButton;
var currentMode;
var overlayShown = false;
var frameGap;
var sectionSelected;

var normalsFiltered; //if true then they ARE filtered
var specialsFiltered;
var commandGrabsFiltered;
var supersFiltered;
var ultrasFiltered;
var comboGrabsFiltered;
var throwsFiltered;
var focusAttackFiltered;
var tauntsFiltered;
var movementSpecialsFiltered;

var player1;
var player2;
var playerNum = 1;


var settingsScreen;
var confirmOnQuitState;
var characterBannersSizeState;
var char_pic_hidden;
var lastDisplayResult;
var lastDonatorDisplayed;

var deviceOS, deviceVersion;

// loads the listeners for the main menu
var mainMenuListeners = function() {
	for (var i=0; i<7; i++) {
		(function(x){
			document.getElementsByClassName("fatMenuOption")[i].addEventListener('click', function(){playerSelect(x)})
		})(i);
	}
};

// Selects the mode to display on screen
var playerSelect = function(mode) {
	window.scrollTo(0,0);
	var currentShownElements = document.getElementsByClassName("shown");
	var numOfElements = currentShownElements.length;
	
	for (var i=0; i<numOfElements; i++){
		hideElement(currentShownElements[0].id);
	}	
	favCharactersContainer.innerHTML = "";
	
	if (playerNum == 1) {
		showElement("player1Header");
	} else {
		showElement("player2Header");
	}
	showElement("screenBackButton");
	showElement("charMenu");
	createFavourites();
	favouritesListeners();
	
	switch (mode) {
		case 0:
			currentMode = "ftSpec";
			break;
		case 1:
			currentMode = "ftLister";
			break;
		case 2:
			currentMode = "mpLister";
			break;
		case 3:
			currentMode = "mlLister";
			break;
		case 4:
			currentMode = "moveProp";
			break;
		case 5:
			currentMode = "charNotesMenu";
			break;
		case 6:
			currentMode = "movesList";
			break;
		default:
			console.log("Something has gone terribly wrong!");
			break;
	};
};

// loads the Main Menu Button listener
var screenBackButtonListener = function() {
	document.getElementById("screenBackButton").addEventListener('click', goBack);	
}
// acts on the 2 back buttons depending on the context
var goBack = function() {
	window.scrollTo(0,0);
	if (overlayShown == true) {
		closeOverlay();
	} else if (currentMode == "credits" || currentMode == "versionLog" || currentMode == "favChar") {
		goToSettingsMenu();
	}
	else if (currentMode == "combosU" ||
	currentMode == "punishesU" ||
	currentMode == "frameTrapsU" ||
	currentMode == "optionSelectsU" ||
	currentMode == "setUpsU") {
		document.getElementById("answerSpace").innerHTML = "";
		returnToCharNotesMenu();
	} else if (currentMode == "matchUpSet") {
		clearMatchUpContainers();
		returnToCharNotesMenu();
	} else if (playerNum == 3 && currentMode == "matchups") {
		clearMatchUpContainers();
		currentMode = "matchUpSet";
		playerNum = 2;
		playerSelect();
	} else if (playerNum == 3 && currentMode == "mpLister") {
		clearMatchUpContainers();
		dataElementClearing();
		playerNum = 2;
		playerSelect();
	} else if (playerNum == 2) {
		console.log(currentMode);
		playerOneSelectReset();
		dataElementClearing();
		playerNum = 1;
		playerSelect();
	} else if (typeof currentMode != "undefined") {
		console.log(currentMode);
		returnToMainMenu();
	} else {
		if (confirmOnQuitState == true) {
			exitCheck = confirm("Are you sure you want to quit? (This confirmation can be switched off via the settings menu)")
			if (exitCheck == true) {
				navigator.app.exitApp();
			}
		} else {
			navigator.app.exitApp();
		}
	}
}



// destorys and recreates elements in order to remove the Event Listeners
var dataElementClearing = function() {
	dropDownOne.innerHTML = "";
	dropDownTwo.innerHTML = "";
	answerSpace.innerHTML = "";
	
	
	var movePropSpace = document.getElementById("movePropSpace").children[0];
	movePropSpace.innerHTML = "";
	
	counterhit = false;
	var ch = document.getElementById("counterhitButton");
	ch.classList.remove("button_inactive");
	ch.classList.remove("button_active");
	ch.classList.add("button_inactive");

	var cloneDD1 = dropDownOne.cloneNode();
	document.getElementById("inputEntity").removeChild(dropDownOne);
	document.getElementById("inputEntity").insertBefore(cloneDD1, dropDownTwo);
	dropDownOne = document.getElementById("dropDownOne");
	
	var cloneDD2 = dropDownTwo.cloneNode();
	document.getElementById("inputEntity").removeChild(dropDownTwo);
	document.getElementById("inputEntity").insertBefore(cloneDD2, dropDownOne.nextSibling);
	dropDownTwo = document.getElementById("dropDownTwo");
	
	var cloneTF = textField.cloneNode();
	document.getElementById("inputEntity").removeChild(textField);
	document.getElementById("inputEntity").insertBefore(cloneTF, dropDownTwo.nextSibling);
	textField = document.getElementById("textField");
	
	var cloneCHButton = counterhitButton.cloneNode(true);
	document.getElementById("inputEntity").removeChild(counterhitButton);
	document.getElementById("inputEntity").insertBefore(cloneCHButton, dropDownOne);
	counterhitButton = document.getElementById("counterhitButton");
}

var playerOneSelectReset = function() {
	var chars = document.getElementsByClassName("char_index");
	if (chars[0].classList[1] == "character_two") {
		for (var i=0; i<44; i++) {
			chars[i].classList.remove("character_two");
			chars[i].classList.remove("character_one");
			chars[i].classList.add("character_one");
		}
	}
}

var returnToMainMenu = function() {
	
	var currentShownElements = document.getElementsByClassName("shown");
	var numOfElements = currentShownElements.length;
	
	for (var i=0; i<numOfElements; i++){
		hideElement(currentShownElements[0].id);
	}
	
	showElement("mainMenu");
	donatorBoxCheck();
	showElement("settingsButton");
	showElement("twitterButton");
	showElement("FATool");
	player1 = undefined;
	player2 = undefined;
	favCharactersContainer.innerHTML = "";
	playerNum = 1;
	
	dataElementClearing();
	playerOneSelectReset();
	currentMode = undefined;
	
	playerOneBanner.innerHTML = "";
	playerTwoBanner.innerHTML = "";
	playerStatsBanner.innerHTML = "";
	
}

var donatorBoxCheck = function() {
	var donatorBoxEntries = ["<p><a onclick=\"window.open('http://www.hitboxarcade.com', '_system')\">Hit Box arcade</a> controller for fighting games, with video tutorials and a community full of knowledge.</p>", "<p>Steve Hope-Ross donated at Ultra requesting active frames and for the app to remain free always.</p>", "<p>Sairus - Irish FGC's number one bandanna sportin', Skullgirls playin' hero. Requested less ugly dark mode.</p>", "<p>My sensei in this app has been javascript guru, Gearoid Moroney; famous for projects like <a onclick=\"window.open('http://gearoid.me/pokemon', '_system')\">\"Who's That Pokemon\"</a> and <a onclick=\"window.open('https://play.google.com/store/apps/details?id=com.syncostyle.c25k', '_system')\">\"c25k\"</a>.</p>", "<p>Would you like your message here? Donate at AE 2012 Level or above!</p>", "<p>The UK's VSFighting Tournament Series returns this August 23-24th in Birmingham showcasing some of Europe's finest competitors.<br><a onclick=\"window.open('http://www.vsfighting.com', '_system')\">Details here</a>. <a onclick=\"window.open('https://www.facebook.com/electronicdojo', '_system')\">Facebook</a> and <a onclick=\"window.open('https://twitter.com/electronicdojo', '_system')\">Twitter</a> too!</p>", "<p>I've known <a onclick=\"window.open('https://twitter.com/Rob2D', '_system')\">Rob2D</a> since I was 5 years old. He donated to push the Move List way up the dev list. Partially to annoy me. Thanks Rob!</p>", "<p>Supafreak187 says: NYC FGC check out MashFest @ <a onclick=\"window.open('https://facebook.com/mashfestnyc', '_system')\">Facebook.com/MashFestNYC</a></p>", "<p>Dhami says shoutouts to all you Vampire Saviour players out there! You're all far braver than me!</p>", "<p>KeyServ2 says - \"I post acoustic guitar jams at <a onclick=\"window.open('http://www.youtube.com/keyserv2', '_system')\">youtube.com/keyserv2</a> They're all pretty ok.  This USF4 app is awesome.  Donate.\"</p>", "<p>Azizlksa donated ultra out of the kindness of his heart! Awwww! Add him on xbox live! gamertag: AZIZLKSA</p>", "<p>Slim Arkane requested move input icons being used in notes mode. Good idea!</p>"]
	
	if (Math.floor(Math.random()*(10)+1) <= 5 && !lastDisplayResult) {
		showElement("donatorSpace");
		if (typeof toBeDisplayed == "undefined") {
			toBeDisplayed = Math.floor(Math.random()*(donatorBoxEntries.length));
		}
		else if (toBeDisplayed === (donatorBoxEntries.length - 1)) {
			toBeDisplayed = 0;
		} else {
			toBeDisplayed++;
		}
		donatorSpace.innerHTML = donatorBoxEntries[toBeDisplayed]
		lastDisplayResult = true;
		lastDonatorDisplayed = toBeDisplayed;
	} else {
		hideElement("donatorSpace");
		lastDisplayResult = false;
	}
	
}

// loads the Setting Button listener
var settingsButtonListener = function() {
	document.getElementById("settingsButton").addEventListener('click', goToSettingsMenu);	
}
// loads the Settings Menu
var goToSettingsMenu = function() {
	
	var currentShownElements = document.getElementsByClassName("shown");
	var numOfElements = currentShownElements.length;
	currentMode = "settings";
	
	for (var i=0; i<numOfElements; i++){
		hideElement(currentShownElements[0].id);
	}
	window.scrollTo(0,0);
	hideElement("settingsButton");
	showElement("settingsHeader");
	showElement("screenBackButton");
	showElement("settingsMenu");
	showElement("creditsButton");
}

// loads the Credits Button listener
var creditsButtonListener = function() {
	document.getElementById("creditsButton").addEventListener('click', goToCreditsScreen);	
}
// loads the Credits Screen
var goToCreditsScreen = function() {
	
	var currentShownElements = document.getElementsByClassName("shown");
	var numOfElements = currentShownElements.length;
	currentMode = "credits";
	
	for (var i=0; i<numOfElements; i++){
		hideElement(currentShownElements[0].id);
	}
	window.scrollTo(0,0);
	hideElement("creditsButton");
	showElement("creditsHeader");
	showElement("screenBackButton");
	showElement("credits");
}

// loads the Credits Button listener
var favCharListener = function() {
	document.getElementById("favCharButton").addEventListener('click', goToFavCharScreen);	
}
// loads the Credits Screen
var goToFavCharScreen = function() {
	
	var currentShownElements = document.getElementsByClassName("shown");
	var numOfElements = currentShownElements.length;
	currentMode = "favChar";
	
	for (var i=0; i<numOfElements; i++){
		hideElement(currentShownElements[0].id);
	}
	window.scrollTo(0,0);
	
	var storedNames = window.localStorage.getItem("currentFavChars");
	var currentFavChars = JSON.parse(storedNames);
	
	var allBoxes = document.getElementsByClassName("check_box");
	for (var i=0; i<allBoxes.length; i++) {
		if (currentFavChars.indexOf(allBoxes[i].name) > -1) {
			allBoxes[i].checked = true;
		}
	}
	
	hideElement("creditsButton");
	showElement("favCharHeader");
	showElement("screenBackButton");
	showElement("favChar");
}
//creates the listeners for the boxes
var checkboxListeners = function() {
	var allBoxes = document.getElementsByClassName("check_box");
	for (var i=0; i<allBoxes.length; i++) {
		(function() {
			var characterName = allBoxes[i].name;
			allBoxes[i].addEventListener('change', function() {handleCheckboxTick(characterName)})
		})(i);
	}
}
//checks how many boxes are ticked and returns a number
var checkNumFavs = function() {
	var allBoxes = document.getElementsByClassName("check_box");
	var numChecked = 0;
	for (var i=0; i<allBoxes.length; i++) {
		if (allBoxes[i].checked) {
			numChecked++
		}
	}
	return numChecked;
}
// handles the ticking of favourite character boxes
var handleCheckboxTick = function(characterName) {
	allBoxes = document.getElementsByClassName("check_box");
	for (var i=0; i<allBoxes.length; i++) {
		if (allBoxes[i].name == characterName) {
			var checkedCharacter = allBoxes[i]
		}
	}
	
	if (checkNumFavs() == 4) {
		alert("You've already selected 3 characters!");
		checkedCharacter.checked = false;
		return false;
	}
	var storedNames = window.localStorage.getItem("currentFavChars");
	var currentFavChars = JSON.parse(storedNames);
	
	if (checkedCharacter.checked == true) {
		currentFavChars.push(characterName);
		console.log(currentFavChars);
		window.localStorage.setItem("currentFavChars", JSON.stringify(currentFavChars));
	} else {
		currentFavChars.splice(currentFavChars.indexOf(characterName), 1);
		console.log(currentFavChars);
		window.localStorage.setItem("currentFavChars", JSON.stringify(currentFavChars));
	}
	
}
var createFavourites = function() {
	var favCharactersContainer = document.getElementById("favCharactersContainer");
	var storedNames = window.localStorage.getItem("currentFavChars");
	var currentFavChars = JSON.parse(storedNames);
	
	for (var i=0; i<currentFavChars.length; i++) {
		var newA = document.createElement("a");
		newA.href = "";
		newA.classList.add("fav_char_index");
		newA.classList.add("favourite_character");
		
		var newIMG = document.createElement("img");
		newIMG.classList.add("char_pic");
		imgSrc = "images/character_pics/" + currentFavChars[i] + ".jpg"
		newIMG.src = imgSrc;
		
		var characterTitle;
		switch(currentFavChars[i]){
			case("ChunLi"): characterTitle = "Chun-Li"; break;
			case("CViper"): characterTitle = "C.Viper"; break;
			case("EHonda"): characterTitle = "E.Honda"; break;
			case("FeiLong"): characterTitle = "Fei Long"; break;
			case("ElFuerte"): characterTitle = "El Fuerte"; break;
			case("EvilRyu"): characterTitle = "Evil Ryu"; break;
			case("MBison"): characterTitle = "M.Bison"; break;
			case("THawk"): characterTitle = "T.Hawk"; break;
			default: characterTitle = currentFavChars[i]; break;
		}
				
			
		var newText = document.createTextNode(characterTitle);
		newA.appendChild(newIMG);
		newA.appendChild(newText);
		favCharactersContainer.appendChild(newA);
		
		var newElement = favCharactersContainer.children[i];
		newElement.setAttribute("onclick", "return false");

		newElement.children[0].setAttribute("data-char", currentFavChars[i]);
	}
}
var favouritesListeners = function() {
	var portraits = document.getElementsByClassName("fav_char_index");
	for (var j=0; j<portraits.length; j++) {
		(function(){
			var charName = portraits[j].children[0].getAttribute("data-char");
			portraits[j].addEventListener('click', function(){handleCharacterSet(charName)})
		})(j);
	}
}


var donationScreenListener = function() {
	var donateButton = document.getElementById("donateButton");
	donateButton.addEventListener('click', goToDonateScreen);
}
var goToDonateScreen = function() {
	var currentShownElements = document.getElementsByClassName("shown");
	var numOfElements = currentShownElements.length;
	currentMode = "donate";
	
	for (var i=0; i<numOfElements; i++){
		hideElement(currentShownElements[0].id);
	}
	showElement("donateHeader");
	showElement("screenBackButton");
	hideElement("creditsButton");
	showElement("donateMenu");
}

var versionLogListener = function() {
	var versionLogButton = document.getElementById("versionLogButton");
	versionLogButton.addEventListener('click', goToVersionLogScreen);
}
var goToVersionLogScreen = function() {
	var currentShownElements = document.getElementsByClassName("shown");
	var numOfElements = currentShownElements.length;
	currentMode = "versionLog";
	
	for (var i=0; i<numOfElements; i++){
		hideElement(currentShownElements[0].id);
	}
	window.scrollTo(0,0);
	showElement("versionLogHeader");
	showElement("screenBackButton");
	hideElement("creditsButton");
	showElement("versionLog");
}

var confirmOnQuitListener = function() {
	var confirmOnQuitButton = document.getElementById("confirmOnQuit");
	confirmOnQuitButton.addEventListener('click', confirmOnQuitHandler);
}
var confirmOnQuitLoad = function() {
	var d = document.getElementById("confirmOnQuit");
	confirmOnQuitState = window.localStorage.getItem("confirmOnQuitState");
	if (confirmOnQuitState == true) {
		d.classList.add("button_active");
		d.innerHTML = "On";
	} else {
		d.classList.add("button_inactive");
		d.innerHTML = "Off"
	}
}
var confirmOnQuitHandler = function() {
	var d = document.getElementById("confirmOnQuit");
	if (confirmOnQuitState == true) {
		d.classList.remove("button_active");
		d.classList.add("button_inactive");
		d.innerHTML = "Off"
		confirmOnQuitState = false;
		window.localStorage.setItem("confirmOnQuitState", 0);
	} else {
		d.classList.remove("button_inactive");
		d.classList.add("button_active");
		d.innerHTML = "On";
		confirmOnQuitState = true;
		window.localStorage.setItem("confirmOnQuitState", 1);
	}
}

var characterBannersSizeListener = function() {
	var characterBannersSizeButton = document.getElementById("characterBannersSize");
	characterBannersSizeButton.addEventListener('click', characterBannersSizeHandler);
}
var characterBannersSizeLoad = function() {
	var d = document.getElementById("characterBannersSize");
	characterBannersSizeState = window.localStorage.getItem("characterBannersSizeState");
	if (characterBannersSizeState == "s") {
		d.innerHTML = "Small";
		char_pic_hidden = "char_pic_hidden";
	}
}
var characterBannersSizeHandler = function() {
	var d = document.getElementById("characterBannersSize");
	if (characterBannersSizeState === "l") {
		d.innerHTML = "Small";
		char_pic_hidden = "char_pic_hidden";
		characterBannersSizeState = "s";
		window.localStorage.setItem("characterBannersSizeState", "s");
	} else {
		d.innerHTML = "Large";
		char_pic_hidden = "";
		characterBannersSizeState = "l";
		window.localStorage.setItem("characterBannersSizeState", "l");
	}
}

var formatLegendListener = function() {
	var formatLegendButton = document.getElementById("formatLegendButton");
	formatLegendButton.addEventListener('click', formatLegendHandler);
}
var formatLegendLoad = function() {
	var d = document.getElementById("formatLegendButton");
	formatLegendState = window.localStorage.getItem("formatLegendState");
	if (formatLegendState == false) {
		d.classList.add("button_inactive");
		d.innerHTML = "Off"
	} else {	
		d.classList.add("button_active");
		d.innerHTML = "On";
	}
}
var formatLegendHandler = function() {
	var d = document.getElementById("formatLegendButton");
	if (formatLegendState || typeof formatLegendState != "boolean") {
		d.classList.remove("button_active");
		d.classList.add("button_inactive");
		d.innerHTML = "Off"
		formatLegendState = false;
		window.localStorage.setItem("formatLegendState", 0);
	} else {
		d.classList.remove("button_inactive");
		d.classList.add("button_active");
		d.innerHTML = "On";
		formatLegendState = true;
		window.localStorage.setItem("formatLegendState", 1);
	}
}

var themeSetListener = function() {
	var themeButton = document.getElementById("themeButton");
	themeButton.addEventListener('click', themeSetHandler);
}
var themeSetLoad = function() {
	var d = document.getElementById("themeCSS");
	var b = document.getElementById("themeButton");
	var currentThemeState = window.localStorage.getItem("currentThemeState");
	if (currentThemeState == "Dark") {
		d.href = "css/dark.css";
		b.innerHTML = "Dark";
	}
}
var themeSetHandler = function() {
	var d = document.getElementById("themeCSS")
	var b = document.getElementById("themeButton");
	var currentThemeState = window.localStorage.getItem("currentThemeState");
	if (currentThemeState === "Dark") {
		d.href = "css/light.css";
		b.innerHTML = "Light";
		window.localStorage.setItem("currentThemeState", "Light");
	} else {
		d.href = "css/dark.css";
		b.innerHTML = "Dark";
		window.localStorage.setItem("currentThemeState", "Dark");
	}
	hideElement("settingsMenu");
	showElement("settingsMenu");
}

var destroyDatabaseListener = function() {
	var destroyDatabaseButton = document.getElementById("destroyDatabase");
	destroyDatabaseButton.addEventListener('click', destroyDatabaseHandler);
}
var destroyDatabaseHandler = function() {
	if (confirm("Are you sure you want to clear everything from storage? You will lose all the data that you've entered into the app's 'Character Notes' section!") == true) {
		if (confirm("Last chance to back out! YOU CAN NOT RETRIEVE THIS DATA! Tap okay to get rid of everything! WARNING: Resetting requires the app to restart") == true) {
			localStorage.removeItem("charNotesData");
			location.reload()
			
		}
	}
}

var restoreDonationListener = function() {
	var restoreDonationButton = document.getElementById("restoreDonation");
	restoreDonationButton.addEventListener('click', restoreDonationHandler);
}
var restoreDonationHandler = function() {
	getOwned();
}

// loads the type_button listeners
var typeButtonListeners = function() {
	var typeButtons = document.getElementsByClassName("type_button");
	for (var i=0; i<10; i++) {
		(function() {
			var typeButtonName = typeButtons[i].id;
			typeButtons[i].addEventListener('click', function() {handleTypeSet(typeButtonName)})
		})(i);
	}
}
// filters out the unwanted moves
var handleTypeSet = function(typeButtonName) {
	var d = document.getElementById(typeButtonName);
	switch(typeButtonName) {
		case "normalsButton":
			if (normalsFiltered == "normal") {
				normalsFiltered = "";
				d.classList.remove("tb_inactive");
				d.classList.add("tb_active");
			} else {
				normalsFiltered = "normal";
				d.classList.remove("tb_active");
				d.classList.add("tb_inactive");
			}
			callCurrentMode();
			console.log("Filtering normals is set to: " + normalsFiltered);
			break;
		case "specialsButton":
			if (specialsFiltered == "special") {
				specialsFiltered = "";
				d.classList.remove("tb_inactive");
				d.classList.add("tb_active");
			} else {
				specialsFiltered = "special";
				d.classList.remove("tb_active");
				d.classList.add("tb_inactive");
			}
			callCurrentMode();
			console.log("Filtering specials is set to: " + specialsFiltered);
			break;
		case "commandGrabsButton":
			if (commandGrabsFiltered == "command-grab") {
				commandGrabsFiltered = "";
				d.classList.remove("tb_inactive");
				d.classList.add("tb_active");
			} else {
				commandGrabsFiltered = "command-grab";
				d.classList.remove("tb_active");
				d.classList.add("tb_inactive");
			}
			callCurrentMode();
			console.log("Filtering command-grab is set to: " + commandGrabsFiltered);
			break;
		case "supersButton":
			if (supersFiltered == "super") {
				supersFiltered = "";
				d.classList.remove("tb_inactive");
				d.classList.add("tb_active");
			} else {
				supersFiltered = "super";
				d.classList.remove("tb_active");
				d.classList.add("tb_inactive");
			}
			callCurrentMode();
			console.log("Filtering supers is set to: " + supersFiltered);
			break;
		case "ultrasButton":
			if (ultrasFiltered == "ultra") {
				ultrasFiltered = "";
				d.classList.remove("tb_inactive");
				d.classList.add("tb_active");
			} else {
				ultrasFiltered = "ultra";
				d.classList.remove("tb_active");
				d.classList.add("tb_inactive");
			}
			callCurrentMode();
			console.log("Filtering ultras is set to: " + ultrasFiltered);
			break;
		case "comboGrabsButton":
			if (comboGrabsFiltered == "combo grab") {
				comboGrabsFiltered = "";
				d.classList.remove("tb_inactive");
				d.classList.add("tb_active");
			} else {
				comboGrabsFiltered = "combo grab";
				d.classList.remove("tb_active");
				d.classList.add("tb_inactive");
			}
			callCurrentMode();
			console.log("Filtering combo grabs is set to: " + comboGrabsFiltered);
			break;
		case "throwsButton":
			if (throwsFiltered == "throw") {
				throwsFiltered = "";
				d.classList.remove("tb_inactive");
				d.classList.add("tb_active");
			} else {
				throwsFiltered = "throw";
				d.classList.remove("tb_active");
				d.classList.add("tb_inactive");
			}
			callCurrentMode();
			console.log("Filtering throws is set to: " + throwsFiltered);
			break;
		case "focusAttackButton":
			if (focusAttackFiltered == "focus") {
				focusAttackFiltered = "";
				d.classList.remove("tb_inactive");
				d.classList.add("tb_active");
			} else {
				focusAttackFiltered = "focus";
				d.classList.remove("tb_active");
				d.classList.add("tb_inactive");
			}
			callCurrentMode();
			console.log("Filtering focus attacks is set to: " + focusAttackFiltered);
			break;
		case "tauntsButton":
			if (tauntsFiltered == "taunt") {
				tauntsFiltered = "";
				d.classList.remove("tb_inactive");
				d.classList.add("tb_active");
			} else {
				tauntsFiltered = "taunt";
				d.classList.remove("tb_active");
				d.classList.add("tb_inactive");
			}
			callCurrentMode();
			console.log("Filtering taunts is set to: " + tauntsFiltered);
			break;
		case "movementSpecialsButton":
			if (movementSpecialsFiltered == "movement-special") {
				movementSpecialsFiltered = "";
				d.classList.remove("tb_inactive");
				d.classList.add("tb_active");
			} else {
				movementSpecialsFiltered = "movement-special";
				d.classList.remove("tb_active");
				d.classList.add("tb_inactive");
			}
			callCurrentMode();
			console.log("Filtering Movement Speicals is set to: " + movementSpecialsFiltered);
			break;
		default:
			console.log("Something has gone terribly wrong!");
			break;
		
	}
}

// loads the listeners for the characters
var characterSelectListeners = function() {
	var portraits = document.getElementsByClassName("char_index");
	for (var j=0; j<44; j++) {
		(function(){
			var charName = portraits[j].children[0].getAttribute("data-char");
			portraits[j].addEventListener('click', function(){handleCharacterSet(charName)})
		})(j);
	}
	
};
// sets the characters
var handleCharacterSet = function(charClicked) {
	if ((currentMode != "mpLister") && (currentMode != "matchUpSet") && (playerNum == 1)) {
		player1 = charClicked;
		var player1Stats = characterStats[player1];
		if (currentMode == "moveProp") {
			playerStatsBanner.innerHTML = "<table><tr><th colspan='2'>" + player1 + "</th></tr><tr><td>Health</td><td>" + player1Stats["health"] + "</td></tr><tr><td>Stun</td><td>" + player1Stats["stun"] + "</td></tr><tr><td>Forward Dash</td><td>" + player1Stats["fDash"] + " Frames</td></tr><tr><td>Back Dash</td><td>" + player1Stats["bDash"] + " Frames</td></tr><tr><td>LVL1 FADC Fwd</td><td>" + player1Stats["lvlOneF"] + "</td></tr><tr><td>LVL1 FADC Back</td><td>" + player1Stats["lvlOneB"] + "</td></tr><tr><td>LVL2 FADC Fwd</td><td>" + player1Stats["lvlTwoF"] + "</td></tr></td></tr><tr><td>LVL2 FADC Back</td><td>" + player1Stats["lvlTwoB"] + "</td></tr><tr><td>wUltra Scaling</td><td>" + player1Stats["wUltra"] + "</td></tr></table>"
		} else {
			playerOneBanner.innerHTML = "<h2>" + player1 + "</h2><img class='char_pic " + char_pic_hidden + "' src=\"images/character_pics/" + player1 + ".jpg\"><h3>Player 1</h3>";
		}
		hideElement("charMenu");
		window.scrollTo(0,0);
		return showMode();
	} else if ((playerNum == 1) && (currentMode = "mpLister")) {
		player1 = charClicked;
		playerOneBanner.innerHTML = "<h2>" + player1 + "</h2><img class='char_pic " + char_pic_hidden + "' src=\"images/character_pics/" + player1 + ".jpg\"><h3>Player 1</h3>";
		playerNum = 2;
		hideElement("player1Header");
		window.scrollTo(0,0);
		for (var i=0; i<44; i++) {
			var chars = document.getElementsByClassName("char_index");
			chars[i].classList.remove("character_one");
			chars[i].classList.add("character_two");
		}
		showElement("player2Header");
	} else {
		player2 = charClicked;
		playerTwoBanner.innerHTML = "<h2>" + player2 + "</h2><img class='char_pic " + char_pic_hidden + "' src=\"images/character_pics/" + player2 + ".jpg\"><h3>Player 2</h3>";
		playerNum = 3;
		hideElement("charMenu");
		window.scrollTo(0,0);
		return showMode();
	}
	
}

// begins selected mode
var showMode = function() {
	console.log("BEGINNING MODE: " + currentMode);
	console.log(player1);
	console.log(player2);
	showElement("inputEntity");
	showElement("helpButton");
	hideElement("player1Header");
	hideElement("player2Header");
	
	switch(currentMode) {
		case "ftSpec":
			showElement("ftSpec");
			showElement("dropDownOne");
			showElement("dropDownTwo");
			showElement("playerOneBanner");
			showElement("answerSpace");
			showElement("linkOrCancel");
			linkOrCancel.children[1].selectedIndex = 0;
			loadDropDownContent();
			playerNum = 2;
			break;
		case "ftLister":
			showElement("ftLister");
			showElement("textField");
			showElement("playerOneBanner");
			showElement("filterEntity");
			showElement("normalsButton");
			showElement("specialsButton");
			showElement("commandGrabsButton");
			showElement("supersButton");
			showElement("ultrasButton");
			showElement("comboGrabsButton");
			showElement("answerSpace");
			loadTextInput();
			loadDropDownContent();
			playerNum = 2;
			break;
		case "mpLister":
			showElement("mpLister");
			showElement("dropDownOne");
			showElement("playerOneBanner");
			showElement("playerTwoBanner");
			showElement("answerSpace");
			loadDropDownContent();
			break;
		case "mlLister":
			showElement("mlLister");
			showElement("dropDownOne");
			showElement("counterhitButton");
			showElement("playerOneBanner");
			showElement("filterEntity");
			showElement("normalsButton");
			showElement("specialsButton");
			showElement("supersButton");
			showElement("ultrasButton");
			showElement("comboGrabsButton");
			showElement("answerSpace");
			loadDropDownContent();
			counterhit = false;
			counterhitButton.addEventListener('click', counterhitSet);
			playerNum = 2;
			break;
		case "moveProp":
			showElement("moveProp");
			showElement("playerStatsBanner");
			showElement("dropDownOne");
			showElement("filterEntity");
			showElement("normalsButton");
			showElement("specialsButton");
			showElement("commandGrabsButton");
			showElement("supersButton");
			showElement("ultrasButton");
			showElement("comboGrabsButton");
			showElement("throwsButton");
			showElement("focusAttackButton");
			showElement("tauntsButton");
			showElement("movementSpecialsButton");
			showElement("movePropSpace");
			showElement("orientationMessage");
			playerNum = 2;
			loadDropDownContent();
			dropDownOne.selectedIndex = 1;
			moveProperties();
			break;
		case "movesList":
			showElement("movesListHeader");
			showElement("playerOneBanner");
			showElement("dropDownOne");
			showElement("filterEntity");
			showElement("normalsButton");
			showElement("specialsButton");
			showElement("commandGrabsButton");
			showElement("supersButton");
			showElement("ultrasButton");
			showElement("comboGrabsButton");
			showElement("throwsButton");
			showElement("focusAttackButton");
			showElement("tauntsButton");
			showElement("movementSpecialsButton");
			showElement("movePropSpace");
			playerNum = 2;
			loadDropDownContent();
			dropDownOne.selectedIndex = 1;
			movesList();
			break;
		case "charNotesMenu":
			showElement("charNotesMenu");
			showElement("charNotesHeader");
			playerNum = 2;
			break;
		case "matchUpSet":
			currentMode = "matchups";
			showElement("matchUpSpace");
			showElement("matchUpHeader");
			showElement("playerOneBanner");
			showElement("playerTwoBanner");
			showNotesMode();
			break;
		default:
			console.log("Something has gone terribly wrong!");
			break;
		
	};
};

// calls the current mode 
var callCurrentMode = function() {
	switch(currentMode) {
		case "ftSpec":
			frameTrapSpecific();
			break;
		case "ftLister":
			frameTrapLister();
			break;
		case "mpLister":
			movePunishLister();
			break;
		case "mlLister":
			moveLinkLister();
			break;
		case "moveProp":
			moveProperties();
			break;
		case "movesList":
			movesList();
			break;
		default:
			console.log("Something has gone terribly wrong!");
			break;
		
		
	};
};

// Checks the current mode and then loads the required move sets into their respective drop down menus. After the HTML is done being added, event listeners are tagged on to each of the drop downs, referencing the required function
var loadDropDownContent = function(param) {
	switch(currentMode) {
		case "ftSpec":
			if (linkOrCancel.children[1].options[linkOrCancel.children[1].selectedIndex].text == "Link") {
				dataElementClearing();
				console.log("Link Mode");
				dropDownOne.innerHTML = "<option>First Move</option>"
				dropDownTwo.innerHTML = "<option>Second Move</option>"
				hideElement("frameToCancel");
				for (var move in characters[player1]) {
					if (characters[player1][move]["moveType"] != "movement-special" && characters[player1][move]["moveType"] != "throw" && characters[player1][move]["moveType"] != "command-grab" && characters[player1][move]["airmove"] == false && !isNaN(characters[player1][move]["onBlock"]) && characters[player1][move]["nonHittingMove"] != true && characters[player1][move]["antiAirMove"] != true) {
						dropDownOne.innerHTML += "<option>" + move + "</option>";
					}
				}
				dropDownOne.addEventListener('change', frameTrapSpecific);
				
				for (var move in characters[player1]) {
					if (characters[player1][move]["moveType"] != "throw" && characters[player1][move]["airmove"] == false && characters[player1][move]["followUp"] == false && characters[player1][move]["startup"] != "empty" && characters[player1][move]["antiAirMove"] != true && characters[player1][move]["moveType"] != "combo grab" && characters[player1][move]["nonHittingMove"] != true) {
						dropDownTwo.innerHTML += "<option>" + move + "</option>";
					}
				}
				dropDownTwo.addEventListener('change', frameTrapSpecific);
				break;
			} else if (param == "modeChange") {
				dropDownOne.innerHTML = "<option>First Move</option>"
				answerSpace.innerHTML = "";
				console.log("Cancel Mode");
				for (var move in characters[player1]) {
					if (characters[player1][move]["moveType"] != "movement-special" && characters[player1][move]["moveType"] != "throw" && characters[player1][move]["moveType"] != "command-grab" && characters[player1][move]["airmove"] == false && !isNaN(characters[player1][move]["onBlock"]) && characters[player1][move]["nonHittingMove"] != true && characters[player1][move]["antiAirMove"] != true && characters[player1][move]["cancelAbility"] != "-" && !(isNaN(characters[player1][move]["recovery"])) ) {
						dropDownOne.innerHTML += "<option>" + move + "</option>";
					}
				}
				dropDownOne.addEventListener('change', function(){loadDropDownContent("loadSecondMove");});
				frameToCancel.children[1].innerHTML = "<option>1st move Active Frames</option>";
				showElement("frameToCancel");
				dropDownTwo.innerHTML = "<option>Select 'First Move'</option>";
				break;
			} else if (param == "loadSecondMove"){
				dropDownTwo.innerHTML = "<option>Second Move</option>"
				answerSpace.innerHTML = ""
				for (var move in characters[player1]) {
					if (characters[player1][move]["airmove"] != true && characters[player1][move]["followUp"] != true) {
						if (characters[player1][dropDownOne.options[dropDownOne.selectedIndex].text]["cancelAbility"].indexOf("su") > -1 && characters[player1][move]["moveType"] == "super") {
							console.log("superCancelOkay");
							dropDownTwo.innerHTML += "<option>" + move + "</option>";
						}
						if (characters[player1][dropDownOne.options[dropDownOne.selectedIndex].text]["cancelAbility"].indexOf("sp") > -1 && (characters[player1][move]["moveType"] == "special" || characters[player1][move]["moveType"] == "movement-special" )) {
							console.log("specialCancelOkay");
							dropDownTwo.innerHTML += "<option>" + move + "</option>";
						}
					}
					dropDownTwo.addEventListener('change', function(){loadDropDownContent("loadActiveFrames");})
					frameToCancel.children[1].addEventListener('change', frameTrapSpecific);
				}
				break;
			} else {
				frameToCancel.children[1].innerHTML = "";
				var numberOfFrames = parseInt(characters[player1][dropDownOne.options[dropDownOne.selectedIndex].text]["active"]);
				for (var i=1; i < (numberOfFrames + 1); i++) {
					frameToCancel.children[1].innerHTML += "<option>" + i + "</option>";
				}
				break;
			}
			
			
		case "mpLister":
			dropDownOne.innerHTML += "<option>Blocked Move</option>"
			for (var move in characters[player2]) {
				if (characters[player2][move]["moveType"] != "movement-special" && characters[player2][move]["moveType"] != "throw" && characters[player2][move]["moveType"] != "command-grab" && characters[player2][move]["airmove"] == false && !isNaN(characters[player2][move]["onBlock"])) {
					dropDownOne.innerHTML += "<option>" + move + "</option>";
				}
			}
			dropDownOne.addEventListener('change', movePunishLister);
			
			
			break;
		case "mlLister":
			dropDownOne.innerHTML += "<option>First Move</option>"
			for (var move in characters[player1]) {
				if (characters[player1][move]["moveType"] != "movement-special" && characters[player1][move]["moveType"] != "throw" && characters[player1][move]["moveType"] != "command-grab" && characters[player1][move]["airmove"] == false && characters[player1][move]["followUp"] == false && !isNaN(characters[player1][move]["onHit"]) && characters[player1][move]["antiAirMove"] != true) {
					dropDownOne.innerHTML += "<option>" + move + "</option>";
				}
			}
			dropDownOne.addEventListener('change', moveLinkLister);
			break;
			
		case "moveProp":
			dropDownOne.innerHTML += "<option>Select A Move</option>"
			dropDownOne.innerHTML += "<option>All Moves</option>"
			for (var move in characters[player1]) {
				dropDownOne.innerHTML += "<option>" + move + "</option>";
			}
			dropDownOne.addEventListener('change', moveProperties);
			break;
			
		case "movesList":
			dropDownOne.innerHTML += "<option>Select A Move</option>"
			dropDownOne.innerHTML += "<option>All Moves</option>"
			for (var move in characters[player1]) {
				if (!characters[player1][move]["hideForMoveList"]) {
					dropDownOne.innerHTML += "<option>" + move + "</option>";
				}
			}
			dropDownOne.addEventListener('change', movesList);
			break;
	}
}

// as above but for the text input field
var loadTextInput = function() {
	textField.addEventListener('input', frameTrapLister);
}

// loads the counterhit button
var counterhitSet = function() {
	var d = document.getElementById("counterhitButton");
	if (counterhit == false) {
		console.log("setting CH to True");
		counterhit = true;
		d.classList.remove("button_inactive");
		d.classList.add("button_active");
		callCurrentMode();
	} else {
		console.log("setting CH to False");
		counterhit = false;
		d.classList.remove("button_active");
		d.classList.add("button_inactive");
		callCurrentMode();
	}	
}

var appendToAnswerList = function(toBeAppended) {
	var d = document.getElementById("answerList");
	var newLI = document.createElement("li");
	newText = document.createTextNode(toBeAppended);
	newLI.appendChild(newText);
	d.appendChild(newLI);
}

// Checks a character's entire moveset for a sepcific frame gap. It does this by pulling one tuple at a time from the startup dictionary along with another tuple from the "on block" dictionary and subtracting them. Anything that matches the specified gap is printed.
var frameTrapSpecific = function() {
	
	if (linkOrCancel.children[1].options[linkOrCancel.children[1].selectedIndex].text == "Link") {
		
		if (typeof characters[player1][dropDownOne.options[dropDownOne.selectedIndex].text] == "undefined") {
		
			answerSpace.innerHTML = "";
			return console.log("Either 'Select A Move' selected or something has gone terribly wrong");
			
		} else if (typeof characters[player1][dropDownTwo.options[dropDownTwo.selectedIndex].text] == "undefined") {
		
			answerSpace.innerHTML = "";
			return console.log("Either 'Select A Move' selected or something has gone terribly wrong");
			
		} else {
			var moveOne = dropDownOne.options[dropDownOne.selectedIndex].text;
			var moveOneOnBlock = characters[player1][moveOne]["onBlock"];	
			
			var moveTwo = dropDownTwo.options[dropDownTwo.selectedIndex].text;
			var moveTwoOnStartup = characters[player1][moveTwo]["startup"];
			
			console.log("move1 on block is: " + moveOneOnBlock);
			console.log("move2 on startup is: " + moveTwoOnStartup);
			
			if (moveOneOnBlock > 0) {
				var plus = "+"
			} else {
				var plus = ""
			}
			
			
			var frameGap = moveTwoOnStartup - moveOneOnBlock;
			console.log("the gap in frames is: " + frameGap);
			
			if (frameGap <= 0) {
				answerSpace.innerHTML = "<p>First Move: " + moveOne + " is " + plus + moveOneOnBlock + " on block.</p><p>Second Move: " + moveTwo + " has " + moveTwoOnStartup + " frames of startup.</p><p>There is <b>no frame gap</b> between " + moveOne + " and " + moveTwo + ". It is a true blockstring.</p>";
			} else {
				answerSpace.innerHTML = "<p>First Move: " + moveOne + " is " + plus + moveOneOnBlock + " on block.</p><p>Second Move: " + moveTwo + " has " + moveTwoOnStartup + " frames of startup.</p><p>There is a gap of <b>" + frameGap + " frames</b> between " + moveOne + " and " + moveTwo + ".";
			}
		}
	} else {
		if (typeof characters[player1][dropDownOne.options[dropDownOne.selectedIndex].text] == "undefined" || typeof characters[player1][dropDownTwo.options[dropDownTwo.selectedIndex].text] == "undefined") {
		
			answerSpace.innerHTML = "";
			return console.log("Either 'Select A Move' selected or something has gone terribly wrong");

		} else {
		
			var moveOne = dropDownOne.options[dropDownOne.selectedIndex].text;
			var moveOneActive = characters[player1][moveOne]["active"];	
			var moveOneCancelled = parseInt(frameToCancel.children[1].options[frameToCancel.children[1].selectedIndex].text);
			var moveOneRecovery = characters[player1][moveOne]["recovery"];	
			var moveOneOnBlock = characters[player1][moveOne]["onBlock"];	
			
			var moveTwo = dropDownTwo.options[dropDownTwo.selectedIndex].text;
			
			if (characters[player1][moveTwo]["startup"] == "empty") {
				var moveTwoOnStartup = characters[player1][moveTwo]["recovery"];
			} else {
				var moveTwoOnStartup = characters[player1][moveTwo]["startup"];
			}
			
			var blockStun = parseInt(moveOneActive) + moveOneRecovery + moveOneOnBlock
			
			var frameGap = -1 * (blockStun + (moveOneCancelled - 3) - moveTwoOnStartup);
			console.log("the gap in frames is: " + frameGap);
			
			if (frameGap <= 0) {
				answerSpace.innerHTML = "<p>" + moveOne + " causes " + blockStun + " frames of block stun.</p><p>" + moveTwo + " starts in " + moveTwoOnStartup + " frames.</p><p>There is <b>no gap</b> in the string: " + moveOne + " xx " + moveTwo + " when " + moveOne + " connects on active frame " + moveOneCancelled + " and is cancelled immediately. It is a true blockstring.</p>"
			} else {
				answerSpace.innerHTML = "<p>" + moveOne + " causes " + blockStun + " frames of block stun.</p><p>" + moveTwo + " starts in " + moveTwoOnStartup + " frames.</p><p>There is a gap of <b>" + frameGap + " frames</b> in the string: " + moveOne + " xx " + moveTwo + " when " + moveOne + " connects on active frame " + moveOneCancelled + " and is cancelled immediately.";
			}
		}
	}
};

// presents a list of moves which will punish another character's moves
var frameTrapLister = function() {
	frameGap = textField.value;
	answerSpace.innerHTML = ("");
	
	x = 0
	
	if (frameGap == "") {
		answerSpace.innerHTML = ("");
		x += 1;
	} else if (frameGap <= 0) {
		answerSpace.innerHTML += ("That is not a valid choice!");
		x += 1;
	} else {
		answerSpace.innerHTML += ("<p>Using the above filters, the following strings have a gap of " + frameGap + ":</p><ul id='answerList'></ul>");
		for (var firstMove in characters[player1]) {
			for (var secondMove in characters[player1]) {
					if (
					characters[player1][secondMove]["startup"] - characters[player1][firstMove]["onBlock"] == frameGap && 
					characters[player1][firstMove]["moveType"] != "movement-special" && 
					characters[player1][firstMove]["moveType"] != "throw" && 
					characters[player1][firstMove]["moveType"] != "command-grab" &&	
					!isNaN(characters[player1][firstMove]["onBlock"]) && 
					characters[player1][firstMove]["airmove"] == false && 
					characters[player1][firstMove]["nonHittingMove"] != true && 
					characters[player1][firstMove]["antiAirMove"] != true && 
					characters[player1][secondMove]["moveType"] != "throw" && 
					characters[player1][secondMove]["startup"] != "empty" && 
					characters[player1][secondMove]["moveType"] != "combo grab" && 
					characters[player1][secondMove]["antiAirMove"] != true && 
					characters[player1][secondMove]["nonHittingMove"] != true &&
					characters[player1][secondMove]["airmove"] == false && 
					characters[player1][secondMove]["followUp"] == false &&
					characters[player1][firstMove]["moveType"] != normalsFiltered &&
					characters[player1][firstMove]["moveType"] != specialsFiltered &&
					characters[player1][firstMove]["moveType"] != supersFiltered &&
					characters[player1][firstMove]["moveType"] != ultrasFiltered &&
					characters[player1][firstMove]["moveType"] != comboGrabsFiltered &&
					characters[player1][secondMove]["moveType"] != normalsFiltered &&
					characters[player1][secondMove]["moveType"] != specialsFiltered &&
					characters[player1][secondMove]["moveType"] != commandGrabsFiltered &&
					characters[player1][secondMove]["moveType"] != supersFiltered &&
					characters[player1][secondMove]["moveType"] != ultrasFiltered &&
					characters[player1][secondMove]["moveType"] != comboGrabsFiltered &&
					!(firstMove.indexOf("s.") > -1 && secondMove.indexOf("cl.") > -1)
					
					) {
						x += 1;
						var result = (firstMove + ", " + secondMove);
						
						appendToAnswerList(result);
					}
			}
		}
	}
	
	if (x == 0 && typeof frameGap != "undefined") {
		answerSpace.innerHTML = ("");
		answerSpace.innerHTML += (player1 + " doesn't have any moves that can create a gap of " + frameGap + " frames, using the above filters! Sorry :(");
	} else if (x == 0) {
		answerSpace.innerHTML = ("");
		answerSpace.innerHTML += ("Please enter a number first!");
	}
};

// Checks a specified move's frames on block and lists another characters moves that have equal or higher startup.
var movePunishLister = function() {
	
	if (typeof characters[player2][dropDownOne.options[dropDownOne.selectedIndex].text] == "undefined") {
		answerSpace.innerHTML = "";
		return console.log("Either 'Select A Move' selected or something has gone terribly wrong");
	}
	
	if (characters[player2][dropDownOne.options[dropDownOne.selectedIndex].text]["onBlock"] > 0) {
		var plus = "+"
	} else {
		var plus = ""
	}
	
	var x = 0;
	
	var punishedAdvantage = characters[player2][dropDownOne.options[dropDownOne.selectedIndex].text]["onBlock"] * -1;
	
	answerSpace.innerHTML = "<p>" + player2 + "'s " + dropDownOne.options[dropDownOne.selectedIndex].text + " is " + plus + characters[player2][dropDownOne.options[dropDownOne.selectedIndex].text]["onBlock"] + " on block.</p>";
	
	answerSpace.innerHTML += "<p>After blocking " + player2 + "'s " + dropDownOne.options[dropDownOne.selectedIndex].text + ", " + player1 + " can punish using the following moves:</p><ul id='answerList'></ul>";
	
	for (move in characters[player1]) {
		if (characters[player1][move]["startup"] <= punishedAdvantage && characters[player1][move]["followUp"] != true && characters[player1][move]["airmove"] != true && characters[player1][move]["nonHittingMove"] != true && characters[player1][move]["antiAirMove"] != true){
			
			x += 1;
			
			var gap = (punishedAdvantage - characters[player1][move]["startup"]) + 1;
			
			
			var result = move + " is a " + gap + " frame punish.";
			
			appendToAnswerList(result);
			
		} 
		
	}
	
	if (x == 0) {
	
		answerSpace.innerHTML = player2 + "'s " + dropDownOne.options[dropDownOne.selectedIndex].text + " is " + plus + characters[player2][dropDownOne.options[dropDownOne.selectedIndex].text]["onBlock"] + " on block</br>";
		
		answerSpace.innerHTML += "</br>" + player1 + " has no moves that can punish " + player2 + "'s " + dropDownOne.options[dropDownOne.selectedIndex].text + ". Sorry!";
	}


	
	
};

// Shows a list of moves that link after a specific move
var moveLinkLister = function() {
	
	
	if (typeof characters[player1][dropDownOne.options[dropDownOne.selectedIndex].text] == "undefined") {
		answerSpace.innerHTML = "";
		return console.log("Either 'Select A Move' selected or something has gone terribly wrong");
	}
	
	var firstMove = dropDownOne.options[dropDownOne.selectedIndex].text;
	var i, j;
	if (counterhit == true) {
		if (firstMove.indexOf("lp") > -1 || firstMove.indexOf("lk") > -1) {
			i = 1
			j = 2
		} else if ((player1 == "Blanka" && firstMove == "cr.mk") || (player1 == "Dhalsim" && firstMove == "s.mk") || (player1 == "Dudley" && firstMove == "Victory Rose")) {
			i = 0;
			j = 1;
		} else {
			i = 3;
			j = 4;
		}
	} else {
		i = 0;
		j = 1;
	}
	
	
	
	var x = 0;
	
	
	var firstMoveOnHit = characters[player1][firstMove]["onHit"]
	console.log(firstMoveOnHit + i);
	
	if ((firstMoveOnHit + i) > 0) {
			var plus = "+"
		} else {
			var plus = ""
		}
	
	var secondMoveList = characters[player1];
	answerSpace.innerHTML = player1 + "'s " + firstMove + " is " + plus + (firstMoveOnHit + i) + " on hit.</p>";
	answerSpace.innerHTML += "<p>After " + firstMove + ", " + player1 + " can link the following moves:</p><ul id='answerList'></ul>";
	
	for (secondMove in secondMoveList) {
		if (secondMoveList[secondMove]["startup"] <= (firstMoveOnHit + i) && secondMoveList[secondMove]["moveType"] != "movement-special" && secondMoveList[secondMove]["moveType"] != "throw" && secondMoveList[secondMove]["moveType"] != "command-grab" && secondMoveList[secondMove]["airmove"] == false && secondMoveList[secondMove]["followUp"] == false  && secondMoveList[secondMove]["nonHittingMove"] != true && secondMoveList[secondMove]["moveType"] != "combo grab" && secondMoveList[secondMove]["moveType"] != normalsFiltered && secondMoveList[secondMove]["moveType"] != specialsFiltered && secondMoveList[secondMove]["moveType"] != supersFiltered && secondMoveList[secondMove]["moveType"] != ultrasFiltered && secondMoveList[secondMove]["moveType"] != comboGrabsFiltered && secondMoveList[secondMove]["antiAirMove"] != true && secondMoveList[secondMove]["throwMove"] != true) {
		
			x += 1;
			
			var gap = (firstMoveOnHit - secondMoveList[secondMove]["startup"]) + j;
			
			var result =  firstMove + ", " + secondMove + " is a " + gap + " frame link.";
			
			appendToAnswerList(result);
		}		
	}
	
	if (x == 0) {
		answerSpace.innerHTML = player1 + "'s " + firstMove + " is " + plus + (firstMoveOnHit + i) + " on hit.</p>";
		answerSpace.innerHTML += player1 + " has no moves that can link after " + firstMove + ". Sorry!";
	}
};
// lists all of a characters moves along with the data I have for them
var moveProperties = function() {
	var movePropSpace = document.getElementById("movePropSpace").children[0];
	movePropSpace.innerHTML = "<tr><th>Move</th><th class='portraitFrameData'>S</th><th class='portraitFrameData'>A</th><th class='portraitFrameData'>R</th><th class='portraitFrameData'>oH</th><th class='portraitFrameData'>oB</th><th class='landscapeFrameData'>Damage</th><th class='landscapeFrameData'>Stun</th><th class='landscapeFrameData'>Meter Gain</th><th class='landscapeFrameData'>Cancel Ability</th><th class='landscapeFrameData'>Startup</th><th class='landscapeFrameData'>Active</th><th class='landscapeFrameData'>Recovery</th><th class='landscapeFrameData'>On Hit</th><th class='landscapeFrameData'>On Block</th></tr>";
	if (dropDownOne.options[dropDownOne.selectedIndex].text == "All Moves") {
		console.log("ALL MOVES");
		for (move in characters[player1]) {
			if (characters[player1][move]["moveType"] != normalsFiltered &&
			characters[player1][move]["moveType"] != specialsFiltered &&
			characters[player1][move]["moveType"] != supersFiltered &&
			characters[player1][move]["moveType"] != ultrasFiltered &&
			characters[player1][move]["moveType"] != comboGrabsFiltered &&
			characters[player1][move]["moveType"] != throwsFiltered &&
			characters[player1][move]["moveType"] != commandGrabsFiltered &&
			characters[player1][move]["moveType"] != focusAttackFiltered &&
			characters[player1][move]["moveType"] != tauntsFiltered &&
			characters[player1][move]["moveType"] != movementSpecialsFiltered) {
			
				if (characters[player1][move]["startup"] == "empty") {
					var currentMoveStartup = "~"
				} else {
					var currentMoveStartup = characters[player1][move]["startup"]
				}	
				if (characters[player1][move]["active"] == "empty") {
					var currentMoveActive = "~"
				} else {
					var currentMoveActive = characters[player1][move]["active"]
				}				
				if (characters[player1][move]["recovery"] == "empty") {
					var currentMoveRecovery = "~"
				} else {
					var currentMoveRecovery = characters[player1][move]["recovery"]
				}		
				if (characters[player1][move]["onHit"] == "empty") {
					var currentMoveOnHit = "~"
				} else {
					var currentMoveOnHit = characters[player1][move]["onHit"]
				}
				if (characters[player1][move]["onBlock"] == "empty") {
					var currentMoveOnBlock = "~"
				} else {
					var currentMoveOnBlock = characters[player1][move]["onBlock"]
				}
				if (characters[player1][move]["damage"] == "empty") {
					var currentMoveDamage = "~"
				} else {
					var currentMoveDamage = characters[player1][move]["damage"]
				}
				if (characters[player1][move]["stun"] == "empty") {
					var currentMoveStun = "~"
				} else {
					var currentMoveStun = characters[player1][move]["stun"]
				}
				if (characters[player1][move]["meterGain"] == "empty") {
					var currentMoveMeterGain = "~"
				} else {
					var currentMoveMeterGain = characters[player1][move]["meterGain"]
				}
				if (characters[player1][move]["cancelAbility"] == "empty") {
					var currentMoveCancelAbility = "~"
				} else {
					var currentMoveCancelAbility = characters[player1][move]["cancelAbility"]
				}
				
				var newNameText = document.createTextNode(move);
				var newTDN = document.createElement("td");
				var newStartUpText = document.createTextNode(currentMoveStartup);
				var newTDS = document.createElement("td");
				var newOnBlockText = document.createTextNode(currentMoveOnBlock);
				var newTDOB = document.createElement("td");
				var newOnHitText = document.createTextNode(currentMoveOnHit);
				newTDOB.style.whiteSpace = "nowrap";
				var newTDOH = document.createElement("td");
				var newRecoveryText = document.createTextNode(currentMoveRecovery);
				newTDOH.style.whiteSpace = "nowrap";
				var newTDR = document.createElement("td");
				var newActiveText = document.createTextNode(currentMoveActive);
				var newTDA = document.createElement("td");
				var newDamageText = document.createTextNode(currentMoveDamage);
				var newTDDam = document.createElement("td");
				var newStunText = document.createTextNode(currentMoveStun);
				var newTDStun = document.createElement("td");
				var newMeterGainText = document.createTextNode(currentMoveMeterGain);
				var newTDMeterGain = document.createElement("td");
				var newCancelAbilityText = document.createTextNode(currentMoveCancelAbility);
				var newTDCancelAbility = document.createElement("td");
				var newTR = document.createElement("tr");
				
				newTDN.appendChild(newNameText);
				newTR.appendChild(newTDN);
				newTDDam.appendChild(newDamageText);
				newTDDam.classList.add("landscapeFrameData");
				newTR.appendChild(newTDDam);
				newTDStun.appendChild(newStunText);
				newTDStun.classList.add("landscapeFrameData");
				newTR.appendChild(newTDStun);	
				newTDMeterGain.appendChild(newMeterGainText);
				newTDMeterGain.classList.add("landscapeFrameData");
				newTR.appendChild(newTDMeterGain);
				newTDCancelAbility.appendChild(newCancelAbilityText);
				newTDCancelAbility.classList.add("landscapeFrameData");
				newTR.appendChild(newTDCancelAbility);				
				newTDS.appendChild(newStartUpText);
				newTR.appendChild(newTDS);				
				newTDA.appendChild(newActiveText);
				newTR.appendChild(newTDA);				
				newTDR.appendChild(newRecoveryText);
				newTR.appendChild(newTDR);				
				newTDOH.appendChild(newOnHitText);
				newTR.appendChild(newTDOH);				
				newTDOB.appendChild(newOnBlockText);
				newTR.appendChild(newTDOB);
				
				movePropSpace.appendChild(newTR);
			}
		}
		movePropSpace.innerHTML += "<tr><th>Move</th><th class='portraitFrameData'>S</th><th class='portraitFrameData'>A</th><th class='portraitFrameData'>R</th><th class='portraitFrameData'>oH</th><th class='portraitFrameData'>oB</th><th class='landscapeFrameData'>Damage</th><th class='landscapeFrameData'>Stun</th><th class='landscapeFrameData'>Meter Gain</th><th class='landscapeFrameData'>Cancel Ability</th><th class='landscapeFrameData'>Startup</th><th class='landscapeFrameData'>Active</th><th class='landscapeFrameData'>Recovery</th><th class='landscapeFrameData'>On Hit</th><th class='landscapeFrameData'>On Block</th></tr>"
		
	} else if (typeof characters[player1][dropDownOne.options[dropDownOne.selectedIndex].text] == "undefined") {
	
		return console.log("Either 'Select A Move' selected or something has gone terribly wrong");
		
	} else {
		var selectedMove = characters[player1][dropDownOne.options[dropDownOne.selectedIndex].text];
		console.log(selectedMove);
		console.log("ALL MOVES");
		
		if (selectedMove["moveType"] != normalsFiltered &&
		selectedMove["moveType"] != specialsFiltered &&
		selectedMove["moveType"] != supersFiltered &&
		selectedMove["moveType"] != ultrasFiltered &&
		selectedMove["moveType"] != comboGrabsFiltered &&
		selectedMove["moveType"] != throwsFiltered &&
		selectedMove["moveType"] != commandGrabsFiltered &&
		selectedMove["moveType"] != focusAttackFiltered &&
		selectedMove["moveType"] != tauntsFiltered &&
		selectedMove["moveType"] != movementSpecialsFiltered) {
		
			if (selectedMove["startup"] == "empty") {
				var currentMoveStartup = "~"
			} else {
				var currentMoveStartup = selectedMove["startup"]
			}	
			if (selectedMove["active"] == "empty") {
				var currentMoveActive = "~"
			} else {
				var currentMoveActive = selectedMove["active"]
			}				
			if (selectedMove["recovery"] == "empty") {
				var currentMoveRecovery = "~"
			} else {
				var currentMoveRecovery = selectedMove["recovery"]
			}		
			if (selectedMove["onHit"] == "empty") {
				var currentMoveOnHit = "~"
			} else {
				var currentMoveOnHit = selectedMove["onHit"]
			}
			if (selectedMove["onBlock"] == "empty") {
				var currentMoveOnBlock = "~"
			} else {
				var currentMoveOnBlock = selectedMove["onBlock"]
			}
			if (selectedMove["damage"] == "empty") {
				var currentMoveDamage = "~"
			} else {
				var currentMoveDamage = selectedMove["damage"]
			}
			if (selectedMove["stun"] == "empty") {
				var currentMoveStun = "~";
			} else {
				var currentMoveStun = selectedMove["stun"];
			}
			if (selectedMove["meterGain"] == "empty") {
				var currentMoveMeterGain = "~";
			} else {
				var currentMoveMeterGain = selectedMove["meterGain"];
			}
			if (selectedMove["cancelAbility"] == "empty") {
				var currentMoveCancelAbility = "~";
			} else {
				var currentMoveCancelAbility = selectedMove["cancelAbility"];
			}
			
			
			var newNameText = document.createTextNode(dropDownOne.options[dropDownOne.selectedIndex].text);
			var newTDN = document.createElement("td");
			var newStartUpText = document.createTextNode(currentMoveStartup);
			var newTDS = document.createElement("td");
			var newOnBlockText = document.createTextNode(currentMoveOnBlock);
			var newTDOB = document.createElement("td");
			var newOnHitText = document.createTextNode(currentMoveOnHit);
			newTDOB.style.whiteSpace = "nowrap";
			var newTDOH = document.createElement("td");
			var newRecoveryText = document.createTextNode(currentMoveRecovery);
			newTDOH.style.whiteSpace = "nowrap";
			var newTDR = document.createElement("td");
			var newActiveText = document.createTextNode(currentMoveActive);
			var newTDA = document.createElement("td");
			var newDamageText = document.createTextNode(currentMoveDamage);
			var newTDDam = document.createElement("td");
			var newStunText = document.createTextNode(currentMoveStun);
			var newTDStun = document.createElement("td");
			var newMeterGainText = document.createTextNode(currentMoveMeterGain);
			var newTDMeterGain = document.createElement("td");
			var newCancelAbilityText = document.createTextNode(currentMoveCancelAbility);
			var newTDCancelAbility = document.createElement("td");
			var newTR = document.createElement("tr");
			
			newTDN.appendChild(newNameText);
			newTR.appendChild(newTDN);
			newTDDam.appendChild(newDamageText);
			newTDDam.classList.add("landscapeFrameData");
			newTR.appendChild(newTDDam);				
			newTDStun.appendChild(newStunText);
			newTDStun.classList.add("landscapeFrameData");
			newTR.appendChild(newTDStun);	
			newTDMeterGain.appendChild(newMeterGainText);
			newTDMeterGain.classList.add("landscapeFrameData");
			newTR.appendChild(newTDMeterGain);
			newTDCancelAbility.appendChild(newCancelAbilityText);
			newTDCancelAbility.classList.add("landscapeFrameData");
			newTR.appendChild(newTDCancelAbility);				
			newTDS.appendChild(newStartUpText);
			newTR.appendChild(newTDS);				
			newTDA.appendChild(newActiveText);
			newTR.appendChild(newTDA);				
			newTDR.appendChild(newRecoveryText);
			newTR.appendChild(newTDR);				
			newTDOH.appendChild(newOnHitText);
			newTR.appendChild(newTDOH);				
			newTDOB.appendChild(newOnBlockText);
			newTR.appendChild(newTDOB);
			
			movePropSpace.appendChild(newTR);
		}
	}
}
var movesList = function() {
	var movePropSpace = document.getElementById("movePropSpace").children[0];
	movePropSpace.innerHTML = "<tr><th>Move Name</th><th>Input</th></tr>";
	if (dropDownOne.options[dropDownOne.selectedIndex].text == "All Moves") {
		console.log("ALL MOVES");
		for (move in characters[player1]) {
			if (characters[player1][move]["moveType"] != normalsFiltered &&
			characters[player1][move]["moveType"] != specialsFiltered &&
			characters[player1][move]["moveType"] != supersFiltered &&
			characters[player1][move]["moveType"] != ultrasFiltered &&
			characters[player1][move]["moveType"] != comboGrabsFiltered &&
			characters[player1][move]["moveType"] != throwsFiltered &&
			characters[player1][move]["moveType"] != commandGrabsFiltered &&
			characters[player1][move]["moveType"] != focusAttackFiltered &&
			characters[player1][move]["moveType"] != tauntsFiltered &&
			characters[player1][move]["moveType"] != movementSpecialsFiltered && 
			characters[player1][move]["hideForMoveList"] != true) {
			
				var currentMoveMotion = characters[player1][move].moveMotion;
				var currentMoveButton = characters[player1][move].moveButton;
				
				if (characters[player1][move].airmove === true && !(move.indexOf("air") > -1)) {
					var newNameText = document.createTextNode(move + " (air)");
				} else {
					var newNameText = document.createTextNode(move);
				}
				var newTDName = document.createElement("td");
				newTDName.appendChild(newNameText);
				

				var newTDInput = document.createElement("td");
				if (currentMoveMotion == "none" && currentMoveButton ==  "none") {
					newTDInput.innerHTML += "-";
				} else if (characters[player1][move].chargeDirection == "R") {
					newTDInput.innerHTML += "Hold & Release <img class='mlInput' src=images/input_images/" + currentMoveButton + ".png>";
				} else if (currentMoveMotion == "none") {
					newTDInput.innerHTML += "<img class='mlInput' src=images/input_images/" + currentMoveButton + ".png>";
				} else if (currentMoveMotion == "mash") {
					newTDInput.innerHTML += "Mash <img class='mlInput' src=images/input_images/" + currentMoveButton + ".png>";
				}  else if (characters[player1][move].chargeDirection) {
					newTDInput.innerHTML += "Charge <img class='mlInput' src=images/input_images/" + characters[player1][move].chargeDirection + ".png><img class='mlInput' src=images/input_images/" + currentMoveMotion + ".png>" + " + " + "<img class='mlInput' src=images/input_images/" + currentMoveButton + ".png>";
				} else if (currentMoveButton == "none") {
					newTDInput.innerHTML += "<img class='mlInput' src=images/input_images/" + currentMoveMotion + ".png>";
				} else {
					newTDInput.innerHTML += "<img class='mlInput' src=images/input_images/" + currentMoveMotion + ".png>" + " + " + "<img class='mlInput' src=images/input_images/" + currentMoveButton + ".png>";
				}
				
				
				
				var newTR = document.createElement("tr");
				newTR.appendChild(newTDName);
				newTR.appendChild(newTDInput);
				movePropSpace.appendChild(newTR);			
			}
		}
		
	} else if (typeof characters[player1][dropDownOne.options[dropDownOne.selectedIndex].text] == "undefined") {
	
		return console.log("Either 'Select A Move' selected or something has gone terribly wrong");
		
	} else {
		var selectedMove = dropDownOne.options[dropDownOne.selectedIndex].text;
		console.log(selectedMove);
		
		var currentMoveMotion = characters[player1][selectedMove].moveMotion;
		var currentMoveButton = characters[player1][selectedMove].moveButton;
		
		if (characters[player1][selectedMove].airmove === true && !(selectedMove.indexOf("air") > -1)) {
			var newNameText = document.createTextNode(selectedMove + " (air)");
		} else {
			var newNameText = document.createTextNode(selectedMove);
		}
		var newTDName = document.createElement("td");
		newTDName.appendChild(newNameText);
		

		var newTDInput = document.createElement("td");
		if (currentMoveMotion == "none" && currentMoveButton ==  "none") {
			newTDInput.innerHTML += "-";
		} else if (characters[player1][selectedMove].chargeDirection == "R") {
			newTDInput.innerHTML += "Hold & Release <img class='mlInput' src=images/input_images/" + currentMoveButton + ".png>";
		} else if (currentMoveMotion == "none") {
			newTDInput.innerHTML += "<img class='mlInput' src=images/input_images/" + currentMoveButton + ".png>";
		} else if (currentMoveMotion == "mash") {
			newTDInput.innerHTML += "Mash <img class='mlInput' src=images/input_images/" + currentMoveButton + ".png>";
		}  else if (characters[player1][selectedMove].chargeDirection) {
			newTDInput.innerHTML += "Charge <img class='mlInput' src=images/input_images/" + characters[player1][selectedMove].chargeDirection + ".png><img class='mlInput' src=images/input_images/" + currentMoveMotion + ".png>" + " + " + "<img class='mlInput' src=images/input_images/" + currentMoveButton + ".png>";
		} else if (currentMoveButton == "none") {
			newTDInput.innerHTML += "<img class='mlInput' src=images/input_images/" + currentMoveMotion + ".png>";
		} else {
			newTDInput.innerHTML += "<img class='mlInput' src=images/input_images/" + currentMoveMotion + ".png>" + " + " + "<img class='mlInput' src=images/input_images/" + currentMoveButton + ".png>";
		}
		
		
		
		var newTR = document.createElement("tr");
		newTR.appendChild(newTDName);
		newTR.appendChild(newTDInput);
		movePropSpace.appendChild(newTR);
		
	}
}


// shows and hides the overlay used in the help and add modes
var showOverlay = function() {
	overlayShown = true;
	showElement("overlay");
	showElement("overlayBox");
	switch(currentMode){
		case("ftSpec"):
			showElement("ftsHelpHeader");
			break;
		case("ftLister"):
			showElement("ftlHelpHeader");
			break;
		case("mpLister"):
			showElement("mPunHelpHeader");
			break;
		case("mlLister"):
			showElement("mlHelpHeader");
			break;
		case("moveProp"):
			showElement("mPropHelpHeader");
			break;
		case("movesList"):
			showElement("mListHelpHeader");
			break;
		case("charNotesMenu"):
			showElement("charNotesUHelpHeader");
			break;
		case("matchUpSet"):
			showElement("charNotesSHelpHeader");
			break;
	}
	showElement("closeOverlayButton");
}
var closeOverlay = function() {
	hideElement("overlay");
	hideElement("overlayBox");
	hideElement("ftlHelpHeader");
	hideElement("mPunHelpHeader");
	hideElement("mlHelpHeader");
	hideElement("mPropHelpHeader");
	hideElement("charNotesUHelpHeader");
	hideElement("charNotesSHelpHeader");
	hideElement("closeOverlayButton");
	hideElement("editEntry");
	hideElement("editEntryHeader");
	hideElement("editCurrentEntryButton");
	hideElement("addNewEntry");
	hideElement("addNewEntryHeader");
	hideElement("submitNewEntryButton");
	hideElement("deleteCurrentEntryButton");
	hideElement("sectionDropDown");
	hideElement("charNotesHelp");
	hideElement("matchUpNotesHelp");
	overlayShown = false;
}


// loads the Help Button listener
var helpButtonListener = function() {
	document.getElementById("helpButton").addEventListener('click', helpMode);	
}
var closeOverlayButtonListener = function() {
	document.getElementById("closeOverlayButton").addEventListener('click', closeOverlay);
}
var helpMode = function() {
	showOverlay();
	switch(currentMode) {
		case("ftSpec"):
			showElement("ftsHelp");
			break;
		case("ftLister"):
			showElement("ftlHelp");
			break;
		case("mpLister"):
			showElement("mPunHelp");
			break;
		case("mlLister"):
			showElement("mlHelp");
			break;
		case("moveProp"):
			showElement("mPropHelp");
			break;
		case("charNotesMenu"):
			showElement("charNotesHelp");
			break;
		case("movesList"):
			showElement("movesListHelp");
			break;
		case("matchUpSet"):
			showElement("matchUpNotesHelp");
			break;
		default:
			console.log("Something has gone horribly wrong");
			break;
	}
}

// Checks to see if the charNotesData has ever been created. If not, it's loaded into local storage from the charNotesDataSetUp.js file. If it already exists, nothing further happens.
var charNotesDataCreate = function() {
	if (window.localStorage.getItem("charNotesData") == null) {
		console.log("creating notes database");
		window.localStorage.setItem("charNotesData", JSON.stringify(charNotesDataSetUp));	
	}
}



// shows Elements
var showElement = function(element) {
	var d = document.getElementById(element);
	d.classList.remove("hidden");
	d.classList.add("shown");
}
// hides Elements
var hideElement = function(element) {
	var d = document.getElementById(element);
	d.classList.remove("shown");
	d.classList.add("hidden");
}
// greys Elements Out
var greyOutElement = function(element) {
	var s = document.getElementById(element).style;
	s.opacity = 0.4;
}

var unlockThemeChange = function() {
	themeSetListener();
	document.getElementById("themeSettingContainer").style.opacity = 1.0;
}
var greyOutDonated = function() {
	var vD = "vanillaDonationContainer";
	var vDB = document.getElementById("vanillaDonationButton");
	var sD = "superDonationContainer";
	var sDB = document.getElementById("superDonationButton");
	var aD = "ae2012DonationContainer";
	var aDB = document.getElementById("ae2012DonationButton");
	var uD = "ultraDonationContainer";
	var uDB = document.getElementById("ultraDonationButton");
	for (var item in localStorage) {
		switch(item) {
			case "ultra_donation":
				greyOutElement(uD);
				uDB.onclick = "return false";
			case "ae2012_donation":
				greyOutElement(aD);
				aDB.onclick = "return false";
			case "super_donation":
				greyOutElement(sD);
				sDB.onclick = "return false";
			case "vanilla_donation":
				greyOutElement(vD);
				vDB.onclick = "return false";
				unlockThemeChange();
				break;
			default:
				console.log(item + " is not a donation");
				break;
		}
			
	}
}

var onDeviceReady = function() {
	document.addEventListener("backbutton", goBack, false);
    deviceOS = device.platform.toLowerCase();
    deviceVersion = parseInt(device.version, 10);

    if(deviceOS === 'ios') {
        StatusBar.overlaysWebView(true);
        StatusBar.styleLightContent();
    }
	
	// Creates the listeners for the bulk of the program
	characterSelectListeners();
	screenBackButtonListener();
	charNotesMenuListeners();
	settingsButtonListener();
	helpButtonListener();
	addModeButtonListener();
	mainMenuListeners();
	typeButtonListeners();
	closeOverlayButtonListener();
	submitButtonListener();
	editButtonListener();
	deleteButtonListener();
	document.getElementById("linkOrCancel").children[1].addEventListener('change', function(){
   loadDropDownContent("modeChange");});
	
	
	// Creates listeners for the settings section and sets current settings;
	donationScreenListener();
	confirmOnQuitListener();
	confirmOnQuitLoad();
	formatLegendListener();
	formatLegendLoad();
	characterBannersSizeListener();
	characterBannersSizeLoad();
	themeSetLoad();
	versionLogListener();
	creditsButtonListener();
	favCharListener();
	checkboxListeners();
	destroyDatabaseListener();
	restoreDonationListener();
	
	
	// Ensures favourite characters is in the local storage
	if (window.localStorage.getItem("currentFavChars") == null) {
		window.localStorage.setItem("currentFavChars", "[]");
		storedNames = window.localStorage.getItem("currentFavChars");
	}
	
	// Assigns the various parts of the DOM to variables for later use now that they're loaded up.
	dropDownOne = document.getElementById("dropDownOne");
	dropDownTwo = document.getElementById("dropDownTwo");
	textField = document.getElementById("textField");
	counterhitButton = document.getElementById("counterhitButton");
	answerSpace = document.getElementById("answerSpace");
	
	
	
	//Initilises the billing plugin
    if(deviceOS === 'android') {
    	inappbilling.init();
    } else if(deviceOS === 'ios') {
        initIAP();
    }
	
	// Ensures charData is in local storage
	charNotesDataCreate();
	
	// Fixes an old instance of the notes DataBase
    if(deviceOS === 'android') {
    	fixNotes();
    }
	
	// Greys out donated options
	greyOutDonated();	
	
	// Shows the main menu
	hideElement("loadingIcon");
	showElement("mainMenu");
	donatorBoxCheck();
	showElement("twitterButton");
	showElement("settingsButton");		
	
	
}

// wait for device to be ready
window.onload = function() {
	document.addEventListener('deviceready', onDeviceReady, false);
}