'use strict';

/*

plantilla finaL para el desarrollo de videojuegos 2D con html5
En esta se cargaran todos los recursos de una vex, por ser para juegos pequeños
y por que las imagenes son pocas

Diyo Games, gilberto389@gmail.com

*/
var miJuego,canvas1,canvas2,mql;
var dataMision=[];
var traslate=[];
var app=true,ads=false;
var mFondo,mefectos,entorno;
    
if(window.cordova){
    document.addEventListener("deviceready",Init, false);
    //console.log("se fue por cordoba");
    app=true;
    }else{
        //console.log("no hay cordoba");
		window.addEventListener('load',Init, false);
    }

//AREA DE FUNCIONES COMPLEMENTARIAS AL JUEGO 	
function goAngRad(x1,y1,x2,y2){
    
	return Math.atan2(x1-x2,y1-y2);

}

function Vtouch(x,y){

    this.x=x||0;
    this.y=y||0;
}

function vector2D(fx,fy){
	this.x=fx||0;
    this.y=fy||0;
}

vector2D.prototype.getAngulo=function(sx,sy){
	//devuelve el angulo en grados
	return ~~((Math.atan2(sy-this.y,sx-this.x))*(180/3.1416));
}

vector2D.prototype.getAnguloRads=function(sx,sy){
	//devuelve el angulo en grados
	return Math.atan2(sy-this.y,sx-this.x);
}

vector2D.prototype.getDistancia=function(sx,sy){
	miJuego.dx=this.x-sx; 
	miJuego.dy=this.y-sy; 
	return ~~(Math.sqrt(miJuego.dx*miJuego.dx+miJuego.dy*miJuego.dy));
}

function cuadro2D(cx,cy,radiox,radioy){
    this.cx=cx;
    this.cy=cy;
    this.radiox=radiox;
    this.radioy=radioy;
    
    this.x=0;
    this.y=0;
    
    this.x2=0;
    this.y2=0;
    
    this.ancho=this.radiox*2;
    this.alto=this.radioy*2;
}

cuadro2D.prototype.existir=function(cx,cy){
    this.cx=cx;
    this.cy=cy;
    
    this.x=this.cx-this.radiox;
    this.y=this.cy-this.radioy;
    
    this.x2=this.cx+this.radiox;
    this.y2=this.cy+this.radioy;
    
}

cuadro2D.prototype.colisionar=function(){
    //mirar como colisionar con otros objetos
    
}

cuadro2D.prototype.pintar=function(){
    
    miJuego.ctx.strokeStyle="rgba(0,0,255,1.0)";
    miJuego.ctx.lineWidth=1;
    miJuego.ctx.beginPath();
    miJuego.ctx.strokeRect(this.x,this.y,this.ancho,this.alto);
    miJuego.ctx.closePath();
    miJuego.ctx.lineWidth=1;
}


function random(nMin, nMax){
	
	return ~~(Math.random()*(nMax-(nMin-1))) + nMin;
}

function random2( min, max ) {
	return Math.random() * ( max - min ) + min;
}

function toRads(grads){
    return (grads*3.1416)/180;
}

function handleVisibilityChange(){
       if(!miJuego.haySonido)return;
      if (document.hidden) {
           mFondo.mute();
          }else{
              mFondo.unmute();
            }
    } 

function Juego(totalEscenas){

	
	this.totalObjetos=0;
	this.objetosCargados=0;
    this.mobil=false;
	this.haySonido=true;
    this.nativo=false;//indicara si esta en un envoltorio o no
	this.ancho=800;
	this.alto=512;

	//para los for
	this.i=0;
	this.f=0;
	this.j=0;
	this.k=0;
    this.q=0;
    this.rt=0;
    this.rk=0;
    this.tg=0;
    this.kl=0;
    this.showInterstitial=5;//adder to each show a interstitial
    
	this.x=0;
	this.y=0;

	this.dx=0;//para las distancias
	this.dy=0;
	this.dt=0;
    
    this.restatorAds=0;//conrola los interstitials

	this.pixelRatio=0;
	this.nMax=0;
	this.nMin=0;
	this.aleat=0;

	this.tipoAudio="";
	this.sonExt="";
	this.c_imagenes="";

	this.totalEscenas=totalEscenas;//20 niveles de juego + menu + seleccion mas ayuda
	this.escenaActiva=0;
    this.nivel=0;//nivel actual en el que se esta ju
	this.scaleX=1;
	this.scaleY=1;

	this.audio=new Audio();

	this.escenas=[];
	this.touches=[];
    this.colores=[];
    
    //para los mezcladores de colores
    this.r3=0;
    this.g3=0;
    this.b3=0;
    this.a3=1.0;
}

Juego.prototype.setCanvas=function(){
    
    //capa de escenrio de fondo
	canvas2=document.getElementById("esce");
	this.ctx2=canvas2.getContext('2d',{antialias:false});
	canvas2.width=this.ancho;
	canvas2.height=this.alto;
	if(navigator.platform=="Win32"){canvas2.style.position='fixed';}else{canvas2.style.position='static';}
    canvas2.style.top='0';
	canvas2.style.left='0';
    
	canvas2.style.position='absolute';
	canvas2.style.backgroundColor='#000';
	
	//canvas2.style.width='100%';
	//canvas2.style.height='100%';
	canvas2.style.zIndex="-2";
    
	canvas1=document.getElementById("canvas");
	this.ctx=canvas1.getContext('2d',{antialias:false});
	canvas1.width=this.ancho;
	canvas1.height=this.alto;
	if(navigator.platform=="Win32"){canvas1.style.position='fixed';}else{canvas1.style.position='static';}
    canvas1.style.top='0';
	canvas1.style.left='0';
    
	canvas1.style.position='absolute';
	canvas1.style.backgroundColor='transparent';
	
	//canvas1.style.width='100%';
	//canvas1.style.height='100%';
	canvas1.style.zIndex="-1";
    
    if(app){
        //this.scaleX=(this.ancho/window.innerWidth);
        //this.scaleY=(this.alto/window.innerHeight);
        
        canvas1.style.width='100%';
        canvas1.style.height='100%';

        canvas2.style.width='100%';
        canvas2.style.height='100%';
        
    }
    
}

Juego.prototype.setAudio=function(){
	
	if(this.audio.canPlayType('audio/ogg').replace(/no/,'')){
		this.audio=null;
		this.sonExt="ogg";
        this.tipoAudio="audio/ogg";
	}else{
		this.audio=null;
		this.sonExt="mp3";
        this.tipoAudio="audio/mpeg";
	}
}//find e setaudio

Juego.prototype.setCarpetas=function(){
	
	this.pixelRatio=window.devicePixelRatio || 1;
	/*
	if(window.innerWidth*pixelRatio > 1599 ){
		
		c_imagenes=resoluciones[1];
		ancho=1920;
		alto=1080;
		
	}else if(window.innerWidth*pixelRatio < 1600 ){
		
		c_imagenes=resoluciones[2];
		ancho=960;
		alto=540;
		
	}
	*/
	
	//dev, controlar la resolucion manualmente
	if(50 > 51 ){
		
		this.c_imagenes="HD";
		this.ancho=this.ancho*2;
		this.alto=this.alto*2;
		
	}else{
		
		this.c_imagenes="SD";
		
		
	}
    /*
    if(app){
        this.scaleX=(this.ancho/window.innerWidth);
        this.scaleY=(this.alto/window.innerHeight);
        
        this.canvas1.style.width='100%';
        this.canvas1.style.height='100%';

        this.canvas2.style.width='100%';
        this.canvas2.style.height='100%';
        
        this.canvas2.style.position='absolute';
        this.canvas1.style.position='absolute';
    }
    */
    
    

    //console.log("escala x "+this.scaleX+" escala y "+this.scaleY);
    
	//console.log("ancho del juego "+this.ancho+" alto del juego "+this.alto);
    
    //todos los colores de las frutas
   
    this.colores[0]={rady:10,nombre:"ninguna",rad:10,r:255,g:255,b:255,a:1.0};////blanco
    this.colores[1]={rady:20,nombre:"manzana",rad:16,r:255,g:0,b:0,a:1.0};//manzana roja
    this.colores[2]={rady:20,nombre:"pina",rad:14,r:242,g:180,b:0,a:1.0};//pina
    this.colores[3]={rady:17,nombre:"naranja",rad:17,r:255,g:183,b:10,a:1.0};//naranja
    this.colores[4]={rady:14,nombre:"limon",rad:12,r:18,g:106,b:18,a:1.0};//limon
    this.colores[5]={rady:15,nombre:"fresa",rad:12,r:234,g:0,b:0,a:1.0};//fresa
    this.colores[6]={rady:10,nombre:"mora",rad:10,r:124,g:10,b:124,a:1.0};//mora
    this.colores[7]={rady:18,nombre:"patilla",rad:15,r:43,g:159,b:36,a:1.0};//patilla
    this.colores[8]={rady:14,nombre:"pera",rad:8,r:100,g:231,b:100,a:1.0};//pera
    this.colores[9]={rady:10,nombre:"kiwi",rad:8,r:148,g:102,b:19,a:1.0};//kiwi
    this.colores[10]={rady:10,nombre:"cereza",rad:8,r:220,g:7,b:7,a:1.0};//cereza
    this.colores[11]={rady:12,nombre:"banano",rad:9,r:255,g:241,b:112,a:1.0};//banano
    
    
}//fin de setCarpetas

Juego.prototype.setMemoria=function(){
	
	if(localStorage.getItem("sonido") == null){
		localStorage.setItem("sonido","1");
	}else if(localStorage.getItem("sonido") == "1"){
		this.haySonido=true;
	}else if(localStorage.getItem("sonido") == "0"){
		this.haySonido=false;
	}
    
	/*
	if(localStorage.getItem("escena") == null){
		localStorage.setItem("escena","0");
	}else if(localStorage.getItem("escena") != null){
		this.escenaActiva=localStorage.getItem("escena");
	}
    */
    //cargar el nivel actual
    if(localStorage.getItem("nivel") == null){
		localStorage.setItem("nivel","1");
	}
    
	//otras cosas de la memoria persistente
	//aqui faltan puntuaciones
    
    if(localStorage.getItem("misionActiva") == null){
        localStorage.setItem("misionActiva","1");
        for(this.i=1;this.i<=this.totalEscenas;this.i++){
            localStorage.setItem("mision"+this.i,"0");
        }
    }
}//fin de setMemoria

Juego.prototype.setEscenas=function(){

	this.escenas[0]=new Escena("Juego",0);
    this.escenas[0].constructor();
    
    this.escenas[1]=new Menu("menu",1);
    this.escenas[1].constructor();
    
    this.escenas[2]=new Nivel("mNiveles",2);
    this.escenas[2].constructor();
    
    
	//console.log("se creo la escena "+this.escenas[0].nombre);

}//fin de setEscenas

Juego.prototype.ir=function(anterior,siguiente){
	//cargar una escena
    //console.log("ir de "+anterior+" a "+siguiente);
    this.restatorAds=0;
    if(anterior != null){
        //this.escenas[anterior].destructor();
    }
    if(siguiente != null){
        
        this.escenaActiva=siguiente;
        //this.escenas[this.escenaActiva].constructor();
        this.escenas[this.escenaActiva].cargando=true;
        
    }
    
    //console.log("escena activa "+this.escenaActiva);
}//fin de ir

Juego.prototype.pantalla=function(){
    //console.log("e activa  "+this.escenaActiva);
    /*
    console.log("angulo de disp "+screen.orientation.angle);
    console.log("ancho de pantalla "+window.innerWidth);
    console.log("alto de pantalla "+window.innerHeight);
    */
    //console.log("--------------- ");
   
    mql = window.matchMedia("(orientation: portrait)");

    // If there are matches, we're in portrait
    
    if(app){
        
                
        if(mql.matches) { 
        // Portrait orientation
            
            this.scaleY=(512/window.innerWidth);
            this.scaleX=(800/window.innerHeight);
            this.escenas[this.escenaActiva].bloqueado=true;
            
            //console.log("port "+this.escenaActiva+" , "+this.escenas[this.escenaActiva].bloqueado);
            if(this.haySonido){
                mFondo.mute();
            }
            
        } else {  
        // Landscape orientation
            //console.log("lands");
            this.scaleX=(800/window.innerWidth);
            this.scaleY=(510/window.innerHeight);
            this.escenas[this.escenaActiva].bloqueado=false;
            
            if(this.haySonido){
                mFondo.unmute();
            }
        }
        
    }else{
        this.scaleX=1;
        this.scaleY=1;
    }
    
    miJuego.enableInputs();
}

Juego.prototype.enableInputs=function(){
    
    //document.addEventListener("visibilitychange", handleVisibilityChange, false);
    
    document.addEventListener('touchstart',function(evt){
        var t=evt.changedTouches;
            //miJuego.escenas[miJuego.escenaActiva].toque=true;
        
            miJuego.x=~~((t[0].pageX-canvas1.offsetLeft)*miJuego.scaleX);
            miJuego.y=~~((t[0].pageY-canvas1.offsetTop)*miJuego.scaleY);
            miJuego.touches[0]=new Vtouch(miJuego.x,miJuego.y);
           
			
        
    },false);
        
    document.addEventListener('touchmove',function(evt){
            evt.preventDefault();
            var t=evt.changedTouches;
           
                 if(miJuego.touches[0] != null){
                    miJuego.touches[0].x=~~((t[0].pageX-canvas1.offsetLeft)*miJuego.scaleX);
                    miJuego.touches[0].y=~~((t[0].pageY-canvas1.offsetTop)*miJuego.scaleY);
                 }
            
        },false);
    
    document.addEventListener('touchend',function(evt){
            
            miJuego.touches[0]=null;
          
        },false);
        
    document.addEventListener('touchcancel',function(evt){
            
            
            miJuego.touches[0]=null;
				 
            
        },false);
        
    document.addEventListener('mousedown',function(evt){
            evt.preventDefault();
            
            miJuego.x=~~((evt.pageX-canvas1.offsetLeft)*miJuego.scaleX);
            miJuego.y=~~((evt.pageY-canvas1.offsetTop)*miJuego.scaleY);
           	miJuego.touches[0]=new Vtouch(miJuego.x,miJuego.y);
            
			
        },false);
        
    document.addEventListener('mousemove',function(evt){
            if(miJuego.touches[0] != null){
                miJuego.touches[0].x=~~((evt.pageX-canvas1.offsetLeft)*miJuego.scaleX);
                miJuego.touches[0].y=~~((evt.pageY-canvas1.offsetTop)*miJuego.scaleY);
            }
        },false);
        
    document.addEventListener('mouseup',function(evt){
        miJuego.touches[0]=null;
        
        },false);
    
		   
    window.addEventListener("resize", function(){
       miJuego.pantalla();
    }, false);
    
    document.addEventListener("visibilitychange", handleVisibilityChange, false);
    
    
}//fin de  inicializar controles

Juego.prototype.getR=function(color){
    return this.colores[color].r+","+this.colores[color].g+","+this.colores[color].b;
}

Juego.prototype.getColor=function(color){
    return "rgba("+this.colores[color].r+","+this.colores[color].g+","+this.colores[color].b+","+this.colores[color].a+")";
}

Juego.prototype.getColorAlpaVar=function(color){
    return "rgba("+this.colores[color].r+","+this.colores[color].g+","+this.colores[color].b+","+(random(1,10)/100)+")";
}

Juego.prototype.mezclarRojos=function(rR,color2){
    
    this.r3=~~((rR+this.colores[color2].r)/2);
    return this.r3;
    
}

Juego.prototype.mezclarVerdes=function(rG,color2){
    
    
    this.g3=~~((rG+this.colores[color2].g)/2);
    return this.g3;
    
}

Juego.prototype.mezclarAzules=function(rB,color2){
    
    this.b3=~~((rB+this.colores[color2].b)/2);
    return this.b3;
    
}
//**************************************************

function Init(){
    
    miJuego=new Juego(40);
    
    entorno = detect.parse(navigator.userAgent);
    //console.log(entorno.os.family);
    switch(entorno.os.family){
        case "iOS":
                miJuego.mobil=true;
            break;
            case "Android":
                miJuego.mobil=true;
            break;
            case "Windows Phone 8":
                miJuego.mobil=true;
            break;
            default:
            miJuego.mobil=false;
            break;
            
    }
    
    mql = window.matchMedia("(orientation: landscape)");
    
	
    miJuego.setCanvas();
	//miJuego.enableInputs();

	miJuego.setAudio();
	miJuego.setCarpetas();
	miJuego.setMemoria();
	miJuego.setEscenas();
    miJuego.escenaActiva=1;//dejando las escena de menu por defecto
    //mFondo=new Sonido("fondoM",miJuego.sonExt+"/fondo1."+miJuego.sonExt,false,true,false,true,0.1,10,0);
    
    mFondo = new Howl({
      urls: ['sonidos/fondo1.mp3', 'sonidos/fondo1.ogg'],
      autoplay: true,
      loop: true,
      volume: 0.2,
      onload: function() {
        miJuego.escenas[1].totalSonidos+=1;
          this.unmute();
        }
    });
    
    mefectos = new Howl({
      urls: ['sonidos/efectos.mp3', 'sonidos/efectos.ogg'],
      sprite: {
        spaso: [0, 695],
        sperder: [696, 1636],
        sbien: [2333, 549],
        sestrella: [2882, 321],
        sfin: [3202, 1891],
        smal: [5093, 840],
        sDer1: [5933, 305],
        sIzq1: [6239, 305],
        sDer2: [6543, 305],
        sIzq2: [6848, 305],
        sDer3: [7154, 305],
        sIzq3: [7459, 305]
      },onload:function(){
          miJuego.escenas[1].totalSonidos+=1;
      }
    });
    
    
    miJuego.pantalla();  
    //ir a la escena del menu
    //id,src,mute,loop,autoplay,preload,vol,padre,pos
     
    
	miJuego.ir(null,1);
	run();
}

function run(){
	//console.log("dss "+miJuego.escenas[0].nombre);
	
        /*
        var now=Date.now();
        var deltaTime=now-time;
        if(deltaTime>1000)deltaTime=0;
        time=now;
        */
        //console.log("sd");
       	miJuego.escenas[miJuego.escenaActiva].actualizar();
        miJuego.escenas[miJuego.escenaActiva].pintar();
    requestAnimationFrame(run);
}

window.requestAnimationFrame=(function(){
	return window.requestAnimationFrame || 
	window.webkitRequestAnimationFrame || 
	window.mozRequestAnimationFrame || 
	window.oRequestAnimationFrame || 
	function(callback){window.setTimeout(callback,100);};
})();

