var indexTheme = 0;
var northHemisphere = true;

Date.prototype.getDayName = function() {
	var dayWeek = this.getUTCDay();
	var weekday = [ "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];
	return weekday[dayWeek]; 
}

Date.prototype.getMonthName = function() {
	var month = this.getMonth();
	var monthNames = [ "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December" ];
	return monthNames[month];
}

Date.prototype.getSeason = function(hemisphere) {	
	var month = this.getMonth()+1;
	var day = this.getUTCDate();
	var season = '';
	
	if ( (month == 1) || (month == 2))
		season = 'winter';
	else if ( (month == 4) || (month == 5))
		season = 'spring';
	else if ( (month == 7) || (month == 8))
		season = 'summer';
	else if ( (month == 10)|| (month == 11))
		season = 'autumn'; //fall season
	else if ( (month == 3) && (day <= 19 ))
		season = 'winter';
	else if ( (month == 3) && (day >= 20 ))
		season = 'spring';
	else if ( (month == 6) && (day <= 20 ))
		season = 'spring';
	else if ( (month == 6) && (day >= 21 ))
		season = 'summer';
	else if ( (month == 9) && (day <= 20 ))
		season = 'summer';
	else if ( (month == 9) && (day >= 21 ))
		season = 'autumn';
	else if ( (month == 12) && (day <= 21 ))
		season =  'autumn';
	else if ( (month == 12) && (day >= 22 ))
		season = 'winter';
	
	if (!hemisphere) {
	
		//get in suth hemisphere
		if (season == 'winter') season2 = 'summer';
		if (season == 'spring') season2 = 'autumn';
		if (season == 'summer') season2 = 'winter';
		if (season == 'autumn') season2 = 'spring';
		season = season2;
	}
	return season;
}

currentDateClass = function() {
	instance = this;
	timeInterval = null;
	
	function padZero(n, width, z) {
		z = z || '0';
		n = n + '';
		return n.length >= width ? n : new Array(width - n.length + 1).join(z) + n;
	}
	
	this.init = function() {
		this.refreshClock();
		timeInterval = setInterval(this.refreshClock,1000);
	}
	
	this.refreshClock = function() {
		var result = [];
		var currentDate = new Date();
	
		
		result.dayName = currentDate.getDayName();
		result.monthName = currentDate.getMonthName();
		result.day =  padZero(currentDate.getDate(),2);
		result.year = currentDate.getFullYear();
		result.season = currentDate.getSeason(northHemisphere);
		instance.onRefresh(result);
	}
	
	this.onRefresh = function(result) {
		//refresh every second
	}
	
}



$(document).ready(function() {
	//initiate app
	$('#viewPort').css({opacity: 0}); 
	var trans = new translateObj({
		'defaultLang':'en',
		'autoDetect': true,
		'onTranslateEnd': function() {
			$('#viewPort').transition({ scale: '1.2', opacity: 0}).transition({ scale: '1', opacity: 1});	
		}
	});
	trans.initTranslate();
	
	var currentDate = new currentDateClass();

	//refresh every second
	currentDate.onRefresh = function(result) {
		$('#dayName').html(trans.echo(result.dayName.toLowerCase()));
		$('#monthName').html(trans.echo(result.monthName.toLowerCase()));
		$('#day').html(result.day);
		$('#year').html(result.year);
		$('#imgSeason').attr('src','img/' + result.season + '_season.png');
	}
	
	//start clock
	currentDate.init();

	
	/*Main action buttons*/
	$(document).hammer().on('swipe', function(event) {
		indexTheme++;if (indexTheme > 2) indexTheme = 0;
		
		if(indexTheme == 0)	$('body').attr('class', '').addClass('light-theme');
		if(indexTheme == 1)	$('body').attr('class', '').addClass('dark-theme');
		if(indexTheme == 2)	$('body').attr('class', '').addClass('night-theme');
	});
	
	$('#imgSeason').on("click", function(){
		$(this).transition({ rotate: '360', duration: 1000}).transition({ rotate: '0',  duration: 600});
	});

	$('.simpleToast').css({
		position:'absolute',
		left: ($(window).width() - $('.simpleToast').width())/2
		//top: ($(window).height() - $('.simpleToast').outerHeight())/2
	});
	
	$('#imgSeason').hammer().on("hold", function(){
		$(this).transition({ scale: '0', opacity: 0}).delay(1000).transition({ scale: '1', opacity: 1});
		northHemisphere = !northHemisphere;
		if (northHemisphere) $('.simpleToast').html(trans.echo('north-hemisphere')); else $('.simpleToast').html(trans.echo('suth-hemisphere'));
		$('.simpleToast').fadeIn(400).delay(3000).fadeOut(400);
	});
	
});