//Default settings for Favourites, make an array!
if (window.localStorage.getArray("favourites") === null) {
	favouriteRoutes = new Array();
	window.localStorage.setArray("favourites", favouriteRoutes);
}

function favouritesList() {
	if(paidapp === true) {
		if (tablet === true) {$("#depart-content,#arrive-content,#schedule-content").empty();}
		/*Set the title */
		$('div#title').html('<h1>Favourites</h1>');
		$('#route-flip,#favourite-btn').hide();
		
		/*Load a new ad */
		loadAds();
		
		favouriteRoutes = window.localStorage.getArray("favourites");
		if (favouriteRoutes.length != 0) {
			favoriteText = "<ul class='list' id='depart-list'>";
		$.each(favouriteRoutes, function (index, value) {
			var departHash = Object.keys(value);
			var arriveHash = value[departHash];
					favoriteText += "<li class='list-item depart-list-item depart-list-forward'><a class='favouriteAction' data-favourite-key='" + departHash + "' data-favourite-value='" + arriveHash + "'><div class='remove-btn-text'>Remove</div></a><a class='favourite-list-anchor' data-favourite-key='" + departHash + "' data-favourite-value='" + arriveHash + "' dataval='#" + json[departHash].hash + "'><h2>" + json[departHash].title + " to " + json[arriveHash].title + "</h2><p>" + json[departHash].location + "</p><p class='hidden'>" + json[departHash].group + "</p></a></li>";
			});
			favoriteText += '</ul>';
		} else {
			favoriteText = '<div class="page"><div id="about-container"><p>No favourites added! Add some by selecting your favourite route and clicking the star located top right!</p></div></div>';
		}
		$("#depart-content").html(favoriteText);
		$(".favouriteAction").each(function() {
			var h = $(this).parent().height();
			$(this).css({
				"height": h,
				"line-height": h + "px"});
		});
		favouriteBtnLinks();
		favouriteLinks();
	} else {
		$('#depart-content').html('<div class="page"><h1>Favourites</h1><p>Sadly only owners of the paid Ferries+ app are eligible for our favourites section!</p><p>Please upgrade to Ferries+, support independent developers, AND get free stickers!</p><p>You also get all of the following benefits</p><ul class="upgrade-page"><li>All BC Ferry Routes</li><li>Tablet View</li><li>Free Stickers</li><li>No Advertising</li><li>Live Ferry Loads</li></ul><h2><a id="upgradenow" onclick="">Upgrade Now!</a></h2></div>');
		$("a#upgradenow").attr("onclick", "window.open('https://itunes.apple.com/us/app/ferries+/id602435586?ls=1&mt=8', '_system', 'location=yes');");
	}
}

function favouriteAdd(item) {
	favouriteRoutes = window.localStorage.getArray("favourites");
	favouriteRoutes.push(item);
	window.localStorage.setArray("favourites", favouriteRoutes);
}

function favouriteRemove(k,v) {
	favouriteRoutes = window.localStorage.getArray("favourites");
	favouriteRoutes.remove(k,v);
	window.localStorage.setArray("favourites", favouriteRoutes);
}

function favouriteBtnLinks() {
	$(".favouriteAction").unbind();
	$(".favouriteAction").on("click", "a", function () {
		$(this).children().css("opacity", "0").on("webkitTransitionEnd transitionend", function () { $(this).html("Confirm?").css("opacity", "1"); });
		$(this).css("background-color","#58d090").on('click', function() {;
			var k = $(this).attr('data-favourite-key');
			var v = $(this).attr('data-favourite-value');
			$(this).removeClass('favouriteActive').addClass('favouriteInactive');
			favouriteRemove(k,v);
			favouritesList();
		});
	})
}

function favouriteLinks() {
	$(".favourite-list-anchor").unbind();
	$(".favourite-list-anchor").on("click", "a", function () {
		depart = $(this).attr("data-favourite-key");
		arrive = $(this).attr("data-favourite-value");
		departTitle = json[depart].title;
		arriveTitle = json[arrive].title;
		$("#menu").removeClass('home').addClass('back');
		scheduleList();
	});
}

//Have fun trying to figure out this one Matt.
function favouriteClick() {
	var favourite = {};
	favourite[json[depart].hash] = json[arrive].hash;
	var currentSelection = window.localStorage.getArray("favourites").some(function(o){return o[json[depart].hash] === json[arrive].hash;});
	if(currentSelection === true) {
		$("#favourite-btn").removeClass().addClass("favourite-btn-inactive");
		favouriteRemove(json[depart].hash,json[arrive].hash);
	} else {
		$("#favourite-btn").removeClass().addClass("favourite-btn-active");
		favouriteAdd(favourite);
	}
}