function scheduleList() {
		/*Set the title */
		$('div#title').html('<h1>' + departTitle + ' to ' + arriveTitle + '</h1>');
		$('#route-flip').show();
		$('#favourite-btn').show();
		
		//Setup the Click bind for Favourite Button, doesn't work in favourites.js for some reason
		$("#favourite-btn").on("click", function() {
			favouriteClick();
		});
		
		//Global binding for the Route Flip button
		$("#route-flip").unbind().on("click", function () {
			    var el = $('#route-flip').addClass('rotate');
			    setTimeout(function() {
			        el.removeClass('rotate');
			    }, 500);
			flipRoutes();
		});
		
		/*Load a new ad*/
		loadAds();
		
		/*Setup the menu bar*/
		var menuText = '<ul id="menubar">';
		var menuItems = 0;
		
			/*Setup the Directions link*/
			if(mobileos != 'firefoxos') {
				if(typeof json[depart].address  !== 'undefined') { //Safety check
					//find this function in app.js because you want to find it. I know you do.
					mapsUrlChange();
					menuText += '<li class="btn"><div class="menu-icon" id="directions"></div><a href="' + mapsUrl + json[depart].address + '">Directions</a></li>';
					menuItems++;
				}
			}
			
			/*Setup the reserve button if it exists */
			if(typeof json[depart].routes[arrive].reserve  !== 'undefined') { //Safety check
				if (json[depart].routes[arrive].reserve === true) {
					menuText += '<li onclick=\'$(document).off("backbutton"); window.open("http://www.bcferries.com/res/widget/widget.html", "_blank", "location=no");\' target="_blank" class="btn"><div class="menu-icon" id="reserve"></div><a>Reserve</a></li>';
					menuItems++;
				}
			}
			/*Setup the route map if it exists */
			if(typeof json[depart].routes[arrive].routemap  !== 'undefined') { //Safety check
				routemapURL = json[depart].routes[arrive].routemap;
				menuText += '<li onclick=\'$(document).off("backbutton"); window.open("' + routemapURL + '", "_blank", "location=no");\' target="_blank" class="btn"><div class="menu-icon" id="routemap"></div><a>Route Map</a></li>';
				menuItems++;
			}
			
		/*Wrap up the menu bar */
		menuText += '</ul>';
		
		/* Setup our test for first div */
		first = false;
		/* Setup the select and lists */
		scheduleText = "";
		selectText = "<select id='dateselect'>";
		$.each(json[depart].routes[arrive].dates, function (i) {
			//Setup todays date
			d = new Date();
			month = d.getMonth() + 1;
			day = d.getDate();
			todaysDate = d.getFullYear() + (month < 10 ? '0' : '') + month + (day < 10 ? '0' : '') + day;
			
			if (todaysDate < i) {
				if (first === false) {
					currentClass = ' current';
				} else {
					currentClass = '';
				}
				
				scheduleText += '<ul id="' + i + '" class="list schedule-list' + currentClass + '">';
				$.each(this, function (i, item) {
					//Pretty time conversions
					departTime = item.depart;
					sailingLength = json[depart].routes[arrive].length;
					standardTime = convertTime(departTime);
					
					//Setup arrival time					
					if (sailingLength != null) {
						tripDepart = convertHours(departTime); //Now in minutes
						sailingLength = convertHours(sailingLength);
						tripLength = parseInt(tripDepart) + parseInt(sailingLength); //Add the integers for length 
						tripLength = convertMinutes(tripLength);
						arrivalTime = convertTime(tripLength);
					} else {
						arrivalTime = convertTime(item.arrive);
					}
					
					//Actually setup the LI
					scheduleText += '<li class="list-item schedule-list-item" data-time="' + departTime + '"><div class="result-text"><h2>Departing: ' + standardTime + '</h2><p class="schedule-list-arrive">Arriving: ' + arrivalTime + '</p><p class="schedule-list-when">Schedule: ' + item.when + '</p></li></div>';
				});
				scheduleText += '</ul>';
				
				
				/*Setup date of the schedule*/
				
				sdYear = i.slice(0,4);
				
				if (i.slice(4,6) - 1 > 10) {
					sdMonth = i.slice(4,6) - 1;
				} else {
					sdMonth = i.slice(5,6) - 1;
				}
				if (i.slice(6,8) > 10) {
					sdDate =  i.slice(6,8);
				} else {
					sdDate =  i.slice(7,8);
				}
				
				sd = new Date();
				sd.setFullYear(sdYear);
				sd.setMonth(sdMonth);
				sd.setDate(sdDate);
				scheduleDate = sd.toDateString();
				
				//Checks to see if the last date has been set before, and sets it if it hasn't
				if (typeof lastDate === 'undefined' ) {
					lastDate = new Date();
					lastDate = sd;
				}
				else {
					//Sets up the date for the next schedules after the first
					nextDate = new Date();
					nextDate.setTime(lastDate.getTime() + 86400000) ;
					nextDate = nextDate.toDateString();
					//Then sets it again for the next loop
					lastDate = new Date();
					lastDate = sd;
				}

				/*Show the first div */
				
				if (first === false) {
					firstDiv = "#" + i;
					first = true;
						if ( i == 99999999) {
							selectText += '<option>Year Round</option>';
						}
						else if ( i === "montothur" ) {
							selectText += '<option value="montothur">Monday to Thursday</option>';
						}
						else if ( i === "montofri" ) {
							selectText += '<option value="montofri">Monday to Friday</option>';
						}
					else {
						selectText += '<option value="' + i + '">Today until ' + scheduleDate + '</option>';
						}
					}
				else if ( i === "fritosun" ) {
						selectText += '<option value="fritosun">Friday to Sunday</option>';
					}
				else if ( i === "montofri" ) {
						selectText += '<option value="montofri">Monday to Friday</option>';
					}
				else if ( i === "sattosun" ) {
						selectText += '<option value="sattosun">Saturday to Sunday</option>';
					}
				else {
					selectText += '<option value="' + i + '">' + nextDate + ' to ' + scheduleDate + '</option>';
				}
			}
		});
		selectText += "</select>";
		$("#schedule-content").html(menuText + selectText + scheduleText);
		
		
		/* Resize schedule text based on how many itemse are in it */
		for (i=0;i<menuItems;i++) {
			$('#menubar .btn').css('width',((((100-(menuItems+1))/menuItems))+"%"));
		}
		
		/*Then show the first div */
		if (typeof firstDiv === 'undefined'){
			$("#schedule-content").html('<p>No schedules currently available.</p><p>Please check for an updated version of Ferries.</p><p>If no updated version available please contact us at <a href="mailto:hello@ferriesapp.ca">hello@ferriesapp.ca</a></p>');
		}
		else {
			$(firstDiv).show();
		}
		
		/*Then hijack the select tag */
		$('#dateselect').change(function(){
		
			$('.schedule-list').hide();
			$('#' + $('#dateselect').val()).show();

		});
		if (tablet === true && paidapp === true) {
		
		} else {
			/*Setup the Back button */
			$("#menu").unbind().click(arriveList);
			$("#menu").removeClass('home').addClass('black');
			$("#menu").html('Arriving');
		}
		
		/*Check to see if combo is in favourites or not */
		var currentSelection = window.localStorage.getArray("favourites").some(function(o){return o[json[depart].hash] === json[arrive].hash;});
		if(currentSelection === true) {
			$("#favourite-btn").removeClass().addClass("favourite-btn-active");
		} else {
			$("#favourite-btn").removeClass().addClass("favourite-btn-inactive");
		}
		
		/*Setup loads for the route */
		if(typeof json[depart].routes[arrive].api  != 'undefined') { //Safety check
			if (json[depart].routes[arrive].api === true && paidapp === true) {
				syncLoads(); //Run the sync loads js call from loads.js
			}
		}
		
		//Re-bind for upgrade needs
		if (paidapp === false) {
			$('#menubar li').attr('onclick','');
			$('#menubar a').on("click", function(e){
				e.preventDefault();
				upgradePrompt();
			});
		}
		
		
		/*Do the transition */
		scheduleTrans();
}

function arriveLinks(){
	$("#arrive-content").unbind();
	$("#arrive-content").on("click", "a", function () {
			window.arrive = $(this).attr("val").slice(1);
			window.arriveTitle = json[arrive].title;
			$("#arrive-content li").removeClass('active');
			$(this).parent().addClass('active');
			scheduleList();
	});
}

function arriveList() {
		/*Set the title */
		$('div#title').html('<h1>' + departTitle + ' to</h1>');
		$('#route-flip,#favourite-btn').hide();
		
		/*Load a new ad */
		loadAds();
		
		/*Setup the UL and LIs */
		arriveText = "<ul id='arrive-list' class='list'>";
		$.each(json[depart].routes, function (i, item) {
				arriveText += "<li class='list-item arrive-list-item depart-list-forward'> <a class='arrive-list-anchor' val='#" + item.hash + "'><h2>" + item.title + "</h2><p>" + item.location + "</p></a></li>";
		});
		arriveText += "</ul>";
		$("#arrive-content").html(arriveText);
		if (tablet === true && paidapp === true) {
		
		} else {
		/*Setup the Back button */
			$("#menu").unbind().click(departList);
			$("#menu").removeClass('home').addClass('back');
			$("#menu").html('Departing');
		}
		
		
		/*run the transition*/
		arriveTrans();
		
		/*Setup the link jacking*/
		arriveLinks();
}

/* If it's in the free app and tell it to sort into a nested ul, based on the unique array value above */
function nestedDepart(groupName) {
	$.each(json, function (i, item) {
		if (item.group === groupName) {
			favouriteRoutes = window.localStorage.getArray("favourites");
			departText += "<li class='list-item depart-list-item depart-list-forward " + item.group.replace(/\s/g, '') + "'> <a class='depart-list-anchor' val='#" + item.hash + "'><h2>" + item.title + "</h2><p>" + item.location + "</p><p class='hidden'>" + item.group + "</p></a></li>";
		}
	});
}

function departLinks(){
	$("#depart-content").unbind();
	$("#depart-content a").on("click", function () {
			window.depart = $(this).attr("val").slice(1);
			window.departTitle = json[depart].title;
			
			$("#depart-content li").removeClass('active');
			$(this).parent().addClass('active');
			
			if (tablet === true && paidapp === true) {
				$('#schedule-content').empty();
			}
		arriveList();
	});
}

//Functions for each list
function departList() {
		if (tablet === true) {$("#schedule-content").empty();}
		/*Set the title */
		$('div#title').html('<h1>Ferries</h1>');
		$('#route-flip,#favourite-btn').hide();
		
		/*Load a new ad */
		loadAds();
		
		/*Creates the inital UL for the depart list */
		departText = "<input type='search' id='search' placeholder='Search...'><ul class='list' id='depart-list'>";
		/*For each in the array */

		var departGroups = [""];

		$.each(json, function (i, item) {
		
			//Check to see if the group is in the departGroups array yet - Creates a fancy title then a nested list under that title
			if ($.inArray(item.group, departGroups) === -1) {
				departText += "<li class='list-title depart-list-title " + item.group.replace(/\s/g, '') + "'>" + item.group + "</li>" + "<li class='nest-li'><ul class='top-search-list " + item.group.replace(/\s/g, '') + "'>";
				departGroups.push(item.group);
				nestedDepart(item.group);
				departText+= "</ul></li>";
			}
		});
		
		/*Finish up the depart list */
		departText += "</ul>";

		/*Sort the depart list */
		$("#depart-content").html(departText);
		
		/*Setup the Menu button */
		$("#menu").unbind().click(sideMenu);
		$("#menu").removeClass('back').addClass('home');
		$("#menu").html('');
		
		/*Then fire the filter box */
		$('#search').fastLiveFilter('.top-search-list');
		
		/*The Transition */
		departTrans();
		/*Setup link hijacking */
		departLinks();
}

function flipRoutes() {
	//temporarily setup the new variablesvariables
	newDepart = arrive;
	newDepartTitle = arriveTitle;
	newArrive = depart;
	newArriveTitle = departTitle;

	//then set them over top the old
	arrive = newArrive;
	depart = newDepart;
	arriveTitle = newArriveTitle;
	departTitle = newDepartTitle;

	//The run the flip
	$("#schedule-content").css("-webkit-transform","rotateY(-90deg)").on("webkitTransitionEnd transitionend", function() {
		scheduleList();
		$("#schedule-content").off().css("-webkit-transform","rotateY(0deg)");
	});
}

function tabletEmpty () {
	$("#depart-content,#arrive-content,#schedule-content").empty();
}