const DEBUG = false;
function fnGeo_convertDecimalsToDMS(pfDecimal, pbIsLongitude){
  if(DEBUG){console.log('Decimals : ' + pfDecimal);}
  if(pbIsLongitude == true){
    if(pfDecimal < 0){
      var psOrientation = 'W';
    } else {
      var psOrientation = 'E';
    }
  } else {
    if(pfDecimal < 0){
      var psOrientation = 'S';
    } else {
      var psOrientation = 'N';
    }
  }
  if(pfDecimal < 0){
    pfDecimal = pfDecimal * -1;
  }
  var piDays = parseInt(pfDecimal);
  var pfData = pfDecimal - piDays;
  piData = pfData * 3600;
  var piMinute = parseInt(piData/60);
  var pfSecond = fnMath_round(piData - (piMinute * 60), 2);
  var psReturn = piDays + '° ' + piMinute + '\' ' + pfSecond + '\'\'' + psOrientation;
  if(DEBUG){console.log(psReturn)};
  return psReturn;
}
function fnMath_round(fVal, iNum){
  iNum = iNum || 2;
  return Math.round(fVal * Math.pow(10, iNum)) / Math.pow(10, iNum);
}

function fnMain_setInfos(oDate){
  if('geolocation' in navigator) {
    navigator.geolocation.getCurrentPosition(function(position) {
      // GPS
      var psLat = fnGeo_convertDecimalsToDMS(position.coords.latitude, false);
      var psLon = fnGeo_convertDecimalsToDMS(position.coords.longitude, true);
      $('#infosCoords').html(psLat + ' - ' + psLon);

      // Soleil
      var oSunrise = oDate.sunrise(position.coords.latitude, position.coords.longitude);
      var sSunrise = ('0' + oSunrise.getHours()).slice(-2) + ':';
      sSunrise += ('0' + oSunrise.getMinutes()).slice(-2) + ':';
      sSunrise += ('0' + oSunrise.getSeconds()).slice(-2);
      $('#infosSunrise').html(sSunrise);
      var oSunset = oDate.sunset(position.coords.latitude, position.coords.longitude);
      var sSunset = ('0' + oSunset.getHours()).slice(-2) + ':';
      sSunset += ('0' + oSunset.getMinutes()).slice(-2) + ':';
      sSunset += ('0' + oSunset.getSeconds()).slice(-2);
      $('#infosSunset').html(sSunset);

      // Durée d'ensoleillement
      var iSunTime = (oSunset.getTime() - oSunrise.getTime()) / 1000;
      var piSunTimeHour = parseInt(iSunTime/60/60);
      var piSunTimeMinute = parseInt((iSunTime - (piSunTimeHour * 60 * 60)) / 60);
      var sSunTime = ('0' + piSunTimeHour).slice(-2) + ':' + ('0' + piSunTimeMinute).slice(-2);
      $('#infosSuntime').html(sSunTime);


    });
  } else {
    $('#infosCoords').html('No GPS Informations.');
  }
  // Date
  sDate = (oDate.getYear() + 1900);
  sDate += '-';
  sDate += ('0' + (oDate.getMonth() + 1)).slice(-2);
  sDate += '-';
  sDate += ('0' + oDate.getDate()).slice(-2);
  sDate += ' ';
  sDate += ('0' + oDate.getHours()).slice(-2);
  sDate += ':';
  sDate += ('0' + oDate.getMinutes()).slice(-2);
  sDate += ':';
  sDate += ('0' + oDate.getSeconds()).slice(-2);
  $('#infosDate').html(sDate);

  // Saint du jour
  $('#infosSaint').html('');
  iYear = oDate.getYear() + 1900;
  if(iYear >= 2012 && iYear < 2014){
    console.log(iYear);
    var oCal = new ical_parser('files/nominis'+iYear+'.ics', function(cal){
      var events = cal.getEvents();
      var bFound = false;
      events.forEach(function(event){
        if(bFound == false){
          if(event.DTSTART <= oDate  && event.DTEND >= oDate){
            $('#infosSaint').html(event.SUMMARY);
            bFound = true;
          }
        }
      });
    });
  }
}

$(document).ready(function() {
  $('body').on('click', '.dateEdit', function(){
    $('#pageMain').hide();
    $('menu[type="toolbar"] a.dateEdit').hide();
    $('menu[type="toolbar"] a.dateValid').show();
    $('#pageDateEdit').show();
  });
  $('body').on('click', '.dateValid', function(){
    var sDate = $('#pageDateEdit input[type="date"]').val();
    if(sDate.length > 0){
      sDate = sDate.split('-');
      oDate = new Date(sDate[0], sDate[1]-1, sDate[2], 12, 0, 0);
      fnMain_setInfos(oDate);
    }

    $('#pageDateEdit').hide();
    $('menu[type="toolbar"] a.dateValid').hide();
    $('menu[type="toolbar"] a.dateEdit').show();
    $('#pageMain').show();
  });

  var oDateNow = new Date();
  fnMain_setInfos(oDateNow);
});
