function replaceAll(valor, antiga, nova) {
    if (valor === undefined || valor === null)
        return "";
    while (valor.indexOf(antiga) !== -1) {
        valor = valor.replace(antiga, nova);
    }
    return valor;
};

function trim(str) {
    return str.replace(/^\s+|\s+$/g, "");
};

function parseDouble(value) {
    value = trim(String(value));
    if (value.length === 0 || value === 'undefined' || value === 'null') {
        value = '0';
    }
    if (value.indexOf(',') !== -1) {
        value = value.replaceAll('.', '').replace(',', '.');
    }
    return parseFloat(value);
};

function calculo() {
    var salario = document.querySelector("#salario").value;
    salario = replaceAll(salario, ".", "");
    salario = replaceAll(salario, ",", ".");
    salario = parseDouble(salario);
    var meses = document.querySelector("#mesesTrabalhados").value;
    meses = parseDouble(meses);
    var fgtsMes = salario * 0.08;
    fgtsMes = accounting.formatMoney(fgtsMes, "R$ ", 2, ".", ",");
    var fgtsTotal = (salario * 0.08) * meses;
    fgtsTotal = accounting.formatMoney(fgtsTotal, "R$ ", 2, ".", ",");
    document.querySelector("#mes").textContent = "FGTS referente ao mês: "+String(fgtsMes);
    document.querySelector("#total").textContent = "FGTS acumulado no período: "+String(fgtsTotal);
};

function blurSalario() {
    var salario = document.querySelector("#salario").value;
    salario = replaceAll(salario, ".", "");
    salario = replaceAll(salario, ",", ".");
    salario = parseDouble(salario);
    salario = accounting.formatMoney(salario, "", 2, ".", ",");
    document.querySelector("#salario").value = salario;
};

function toolCalculo(){
	document.querySelector("#calculo").style.display = "block";
	document.querySelector("#sobre").style.display = "none";
};

function toolSobre(){
	document.querySelector("#calculo").style.display = "none";
	document.querySelector("#sobre").style.display = "block";
};

window.onload = function() {
    document.querySelector("#salario").focus();
    document.querySelector("#calcula").addEventListener("click", calculo);
    document.querySelector("#salario").addEventListener("blur", blurSalario);
    document.querySelector("#toolCalculo").addEventListener("click", toolCalculo);
    document.querySelector("#toolSobre").addEventListener("click", toolSobre);

    $(document).ready(function() {
        jQuery('body').on('keydown', 'input, select, textarea', function(e) {
            var self = $(this),
                form = self.parents('form:eq(0)'),
                focusable, next;
            if (e.keyCode === 13) {
                focusable = form.find('input,a,select,button,textarea').filter(':visible');
                next = focusable.eq(focusable.index(this) + 1);
                if (next.length) {
                    next.focus();
                } else {
                    form.submit();
                }
                return false;
            }
        });
    });


};