"use strict";
/// <reference path="jquery-1.8.3-vsdoc.js" />

function onDeviceReady() {
    console.log('onDeviceReady');
    document.addEventListener("backbutton", function () {
        console.log('backbutton pressed, activePage id: ' + $.mobile.activePage.attr('id'));
        if ($.mobile.activePage.attr('id') === 'home') {
            console.log('backbutton op home -> applicatie afsluiten');
            navigator.app.exitApp();
        } else {
            navigator.app.backHistory();
        }
    }, false);

    FB.init({ appId: "241950655953565", nativeInterface: CDV.FB, useCachedDialogs: false });
}

function onLoad() {
    document.addEventListener("deviceready", onDeviceReady, false);
}

var serviceURL = "http://www.svhonselersdijk.nl/services/";

function initElftallenSelectList() {
    $.getJSON(serviceURL + 'elftallen.php', function (data) {
        var $select = $('#select-elftal').empty();
        $select.append('<option>- Kies een team -</option>');
        $.each(data, function (index, elftal) {
            $select.append('<option value="' + elftal.wpteamid + '">' + elftal.team + '</option>');
        });

        var team = localStorage.getItem('avd.settings.teamid');
        if (team && team !== 0) {
            $select.val(team);
            $('#btnMijnTeam span').text('Mijn team - ' + $select.find('option:selected').text());
        }
    });
}

(function ($) {
    $.fn.extend({
        highlightHonselersdijk: function () {
            $('div:contains("Honselersdijk")', this).each(function () {
                $(this).css({ color: '#FF700e', fontWeight: 'bold' });
            });
            return this;
        }
    });
}(jQuery));

function getNieuwsList() {
    $.getJSON(serviceURL + 'nieuws.php', function (data) {
        $('#nieuwsList li').remove();
        var $list = $('#nieuwsList'), currentDate = '';
        $.each(data, function (index, bericht) {
            if (currentDate !== bericht.datum_nl) {
                currentDate = bericht.datum_nl;
                $list.append('<li data-role="list-divider" data-divider-theme="a">' + currentDate + '</li>');
            }

            $list.append('<li>'
			    + '<a href="#nieuwsDetails" data-nieuws-id="' + bericht.id + '">'
				/*
				// TODO: server-side een thumbnail maken van 100/100
				+ (bericht.random_foto_url != '' 
					? '<img class="ui-li-thumb" width="100" height="100" src="' + bericht.random_foto_url + '">' 
					: '')
				*/
				+ '<h4>' + bericht.titel + '</h4>'
				+ '</a></li>');
        });

        $('#nieuwsList').listview('refresh');
    }).error(function () { console.error('Fout bij aanspreken webservice'); });
}

function getGastenboekList() {
    $.getJSON(serviceURL + 'gastenboek.php', function (data) {
        $('#gastenboekList li').remove();
        var $list = $('#gastenboekList'), currentDate = '';
        $.each(data, function (index, bericht) {
            if (currentDate !== bericht.datum_nl) {
                currentDate = bericht.datum_nl;
                $list.append('<li data-role="list-divider" data-divider-theme="a">' + currentDate + '</li>');
            }

            $list.append('<li>'
				+ '<h4>' + bericht.naam + ' @ ' + bericht.tijd + '</h4>'
			    + '<p>' + bericht.bericht.fixGastenboekSmilies() + '</p>'
				+ '</li>');
        });

        $('#gastenboekList').listview('refresh');
    }).error(function () { console.error('Fout bij aanspreken webservice'); });
}

function getNieuwsBericht(data) {
    //console.log(data);
    $('#nieuwsDetails').jqmData('nieuws-id', data.id);
    $('#nieuws-titel').text(data.titel);
    $('#nieuws-datum').text(data.datum_nl);
    $('#nieuws-bericht').html(data.bericht);

    var $fotoGallery = $('#nieuws-bericht-fotos ul');
    $fotoGallery.empty();
    if (data.fotos.length > 0) {
        $.each(data.fotos, function (index, foto) {
            $fotoGallery.append('<li><a href="' + foto.url + '" rel="external"><img src="' + foto.url + '" /></a></li>');
        });
        $('a', $fotoGallery).photoSwipe({ loop: false });
    }

    $('#btnVorigNieuwsbericht, #btnVolgendNieuwsbericht').removeClass('ui-btn-active');
}

function getTweetsList() {
    var jsonSearchUrl = serviceURL + 'tweets.php';
    //console.log(jsonSearchUrl);
    $.getJSON(jsonSearchUrl, function (data) {
        $('#tweetsList li').remove();
        var $list = $('#tweetsList'), currentDate = '';
        $.each(data.statuses, function (index, tweet) {
            if (currentDate !== tweet.created_at.parseTwitterDate()) {
                currentDate = tweet.created_at.parseTwitterDate();
                $list.append('<li data-role="list-divider" data-divider-theme="a">' + currentDate + '</li>');
            }

            $list.append('<li>'
				+ '<img class="ui-li-thumb" width="80" height="80" src="' + tweet.user.profile_image_url.replace('_normal', '_bigger') + '" />'
				+ '<h4 style="margin: 0 0 6px;">' + tweet.user.name + '</h4>'
				+ '<p>' + tweet.text.parseURL().parseHashtag().parseUsername() + '</p>'
				+ '</a></li>');
        });

        $('#tweetsList').listview('refresh');
        $('#tweetsList li a').attr('rel', 'external');
    }).error(function () { console.error('Error Web address'); });
}

function getProgramma() {
    var xmlUrl = serviceURL + 'programma-2.php';

    var parseXml = function (data) {
        var $list = $('#programmaList'), currentDate = '';
        $list.empty();
        var xmlData = $.parseXML(data);
        $('wedstrijd', xmlData).each(function () {
            var $wedstrijd = $(this),
                datum = $wedstrijd.find('datum_US').text();

            if (datum !== currentDate) {
                currentDate = datum;
                $list.append('<li data-role="list-divider" data-divider-theme="a">' + datum.parseUsDate().capitalize() + '</li>');
            }

            var aanvang, veld, teamThuis, teamUit, teamThuisId, teamUitId;
            aanvang = $wedstrijd.find('aanvang').text().substr(0, 5);
            veld = $wedstrijd.find('veld').text();
            teamThuis = $wedstrijd.find('team_thuis').text();
            teamUit = $wedstrijd.find('team_uit').text();
            teamThuisId = $wedstrijd.find('team_thuis_id').text();
            teamUitId = $wedstrijd.find('team_uit_id').text();

            var mijnTeam = localStorage.getItem('avd.settings.teamid');
            var isMijnTeamClass = (teamThuisId == mijnTeam || teamUitId == mijnTeam) ? 'mijn-team' : '';

            $list.append('<li class="' + isMijnTeamClass + '"'
                 + ' data-datum="' + datum.parseUsDate().capitalize() + '"'
                 + ' data-aanvang="' + aanvang + '"'
                 + ' data-scheids="' + $wedstrijd.find('scheidsrechter').text() + '"'
                 + ' data-kk-thuis="' + $wedstrijd.find('team_thuis_kleedkamer').text() + '"'
                 + ' data-kk-uit="' + $wedstrijd.find('team_uit_kleedkamer').text() + '"'
                 + ' data-scheids="' + $wedstrijd.find('scheidsrechter').text() + '"'
                 + ' data-veld="' + veld + '"'
                 + ' data-team-uit="' + teamUit + '"'
                 + ' data-team-thuis="' + teamThuis + '"'
                 + ' data-speelt-thuis="' + $wedstrijd.find('speelt_thuis').text() + '"'
                 + ' data-acc="' + $wedstrijd.find('accommodatie').text() + '"'
                + '><a><div class="ui-grid-c">'
                    + '<div class="ui-block-a">' + aanvang + '</div>'
                    + '<div class="ui-block-b">' + teamThuis + '</div>'
                    + '<div class="ui-block-c">' + teamUit + '</div>'
                    + '<div class="ui-block-d">' + veld + '</div>'
                + '</div></a>'
            + '</li>');
        });

        $('li .ui-grid-c', $list).highlightHonselersdijk();
        $('li a', $list).click(function () {
            var $detailsContent = $('#wedstrijd-details-content'),
                $headerH1 = $('#wedstrijd-details-header h1'),
                $li = $(this).closest('li');

            $headerH1.text($li.jqmData('datum'));
            var detailsHtml = '<h3>' + $li.jqmData('aanvang') + ': ' + $li.jqmData('teamThuis') + ' - ' + $li.jqmData('teamUit') + '</h3>'
                + '<ul data=role="listview">';
            if ($li.jqmData('scheids').length > 0)
                detailsHtml += '<li>Onder leiding van: ' + $li.jqmData('scheids') + '</li>';
            if ($li.jqmData('veld').length > 0)
                detailsHtml += '<li>Veld: ' + $li.jqmData('veld') + '</li>';
            if ($li.jqmData('kk-thuis').length > 0)
                detailsHtml += '<li>Kleedkamer thuisclub: ' + $li.jqmData('kk-thuis') + '</li>';
            if ($li.jqmData('kk-uit').length > 0)
                detailsHtml += '<li>Kleedkamer uitclub: ' + $li.jqmData('kk-uit') + '</li>'
            console.log($li.jqmData('speelt-thuis'));
            if ($li.jqmData('speelt-thuis') == '0')
                detailsHtml += '<li>Accomodatie: <a rel="external" href="http://maps.google.com?q=' + $li.jqmData('acc') + '">' + $li.jqmData('acc') + '</a></li>'
            detailsHtml += '</ul>';

            $detailsContent.html(detailsHtml);
            $.mobile.changePage('#wedstrijd-details');
        });

        $list.listview('refresh');
    };

    $.get(xmlUrl).success(parseXml)
        .fail(function (e) { console.log(e); });
}

function getContactpersonenList() {
    //console.log(serviceURL + 'contactpersonen.php');
    $.getJSON(serviceURL + 'contactpersonen.php', function (data) {
        $('#contactpersonenList li').remove();
        $.each(data, function (index, persoon) {
            $('#contactpersonenList').append('<li>'
				+ '<div class="ui-grid-a">'
				+ '	<div class="ui-block-a">'
				  + persoon.naam
				  + '<br><span style="font-weight: normal;">' + persoon.functie + '</span>'
				+ '</div>'
				+ '	<div class="ui-block-b" style="font-weight: normal;">'
				+ '   <a href="mailto:' + persoon.email + '">' + persoon.email + '</a>'
				+ '   <br><a href="tel:' + persoon.telefoon + '">' + persoon.telefoon + '</a>'
				+ '   <a href="tel:' + persoon.mobiel + '">' + persoon.mobiel + '</a>'
				+ ' </div>'
				+ '</div>'
				+ '</li>');
        });

        $('#contactpersonenList').listview('refresh');
    }).error(function () { console.error('Fout bij aanspreken webservice'); });
}

$(document).bind("mobileinit", function () {
    console.log('mobileinit');
    $.support.cors = true;
    $.mobile.defaultPageTransition = 'none';
    $.mobile.allowCrossDomainPages = true;
    $.mobile.buttonMarkup.hoverDelay = 100;
    $.mobile.pageLoadErrorMessageTheme = 'a';
    $.mobile.pageLoadErrorMessage = 'Error loading page';

    $.mobile.page.prototype.options.backBtnText = "Back";
    $.mobile.page.prototype.options.addBackBtn = true;
    $.mobile.page.prototype.options.backBtnTheme = "a";
    $.mobile.page.prototype.options.headerTheme = "a";  // Page header only
    $.mobile.page.prototype.options.contentTheme = "a";
    $.mobile.page.prototype.options.footerTheme = "a";

    $.mobile.listview.prototype.options.headerTheme = "a"; // Header for nested lists
    $.mobile.listview.prototype.options.theme = "a"; // List items / content
    $.mobile.listview.prototype.options.dividerTheme = "a";  // List divider

    $.mobile.listview.prototype.options.splitTheme = "a";
    $.mobile.listview.prototype.options.countTheme = "a";
    $.mobile.listview.prototype.options.filterTheme = "a";
    $.mobile.listview.prototype.options.filterPlaceholder = "Search ...";

    initElftallenSelectList();

    $('#gastenboek').live('pageshow', getGastenboekList);
    $('#twitter').live('pageshow', getTweetsList);
    $('#programma').live('pageshow', getProgramma);
    $('#contactpersonen').live('pageinit', getContactpersonenList);
    $('#nieuws').live('pageshow', getNieuwsList);

    $('#team').live('pageinit', function () { $('#select-elftal').change(); });
    $('#langsdelijn').live('pageinit', function () {
        FB.login(function (response) {
            if (response.session) {
                alert('logged in');
            } else {
                alert('not logged in');
            }
        }, { scope: "email" });

        FB.getLoginStatus(function (response) {
            if (response.status == 'connected') {
                alert('logged in');
            } else {
                alert('not logged in');
            }
        });
    });

    $('#nieuwsList li a').live('click', function (event) {
        var id = $(this).jqmData('nieuws-id');
        var url = serviceURL + 'nieuwsbericht.php?id=' + id;

        console.log(url);
        $.mobile.showPageLoadingMsg();
        $.getJSON(url, getNieuwsBericht)
            .error(function () { console.error('Fout bij aanspreken webservice'); })
            .done(function () { $.mobile.hidePageLoadingMsg(); });
    });

    $('#nieuwsDetails').live('pageinit', function () {
        console.log('pageinit nieuwsDetails');
        // var id = $(this).jqmData('nieuws-id'); // TODO: refresh werkend maken

        var navigate = function (vooruit) {
            $.mobile.showPageLoadingMsg();
            var id = $('#nieuwsDetails').jqmData('nieuws-id'),
                $clickedLink = $('#nieuwsList').find("a[data-nieuws-id='" + id + "']"),
                $parentLi = $clickedLink.closest('li'),
                $nextLi = vooruit === -1 ? $parentLi.prevAll('.ui-btn').first() : $parentLi.nextAll('.ui-btn').first(),
                $nextLink = $nextLi.find('a');

            if ($nextLink.length > 0) {
                $nextLink.click();
            } else {
                $.mobile.hidePageLoadingMsg();
            }
        };

        //$('#nieuws-bericht').live('swiperight', function () { navigate(-1); });
        //$('#nieuws-bericht').live('swipeleft', function () { navigate(1); });
        $('#btnVorigNieuwsbericht').bind('click', function () { navigate(-1); });
        $('#btnVolgendNieuwsbericht').bind('click', function () { navigate(1); });
    });

    $('#select-elftal').live('change', function () {
        var $select = $(this);
        if ($select.val() == '- Kies een team -')
            return;

        var xmlUrl = serviceURL + 'standen-2.php?wpteamid=' + $select.val();
        console.log(xmlUrl);

        localStorage.setItem('avd.settings.teamid', $select.val());
        $('#btnMijnTeam span').text('Mijn team - ' + $select.find('option:selected').text());

        var parseXml = function (data) {
            console.log(data);
            var $container = $('#stand-container').empty();
            var $standList = $('<ul data-role="listview" data-inset="true"></ul>').appendTo($container).listview();
            var $uitslagenList = $('<ul data-role="listview" data-inset="true"></ul>').appendTo($container).listview();

            $('standen', data).each(function () {
                var $stand = $(this);
                var teamNaam = $stand.find('categorie').text();
                //console.log($ptStats);
                $standList.append('<li data-role="list-divider" data-divider-theme="a">' + teamNaam + '</li>');
                $('ranglijst ranglijstitem', $stand).each(function () {
                    var $rang = $(this);
                    var positie = $rang.attr('positie');
                    var $puntenStat = $rang.find('PT').text();
                    var $winsStat = $rang.find('WN').text();
                    var $gelijkStat = $rang.find('GL').text();
                    var $verliesStat = $rang.find('VL').text();
                    $standList.append('<li>'
                        + '  <div class="ui-grid-d">'
                        + '    <div class="ui-block-a" style="width: 60%;">' + positie + '. ' + $rang.attr('team') + '</div>'
                        + '    <div class="ui-block-b" style="width: 10%;">' + $puntenStat + '</div>'
                        + '    <div class="ui-block-c" style="width: 10%; font-weight: normal;">' + $winsStat + '</div>'
                        + '    <div class="ui-block-d" style="width: 10%; font-weight: normal;">' + $gelijkStat + '</div>'
                        + '    <div class="ui-block-e" style="width: 10%; font-weight: normal;">' + $verliesStat + '</div>'
                        + '  </div>'
                        + '</li>');
                });

                var $uitslagen = $('uitslagen uitslag', $stand);
                //console.log($uitslagen);
                if ($uitslagen.length > 0) {
                    $uitslagenList.append('<li data-role="list-divider" data-divider-theme="a">Uitslagen</li>');
                    $uitslagen.each(function () {
                        var $uitslag = $(this);
                        $uitslagenList.append('<li>'
                            + '  <div class="ui-grid-b">'
                            + '    <div class="ui-block-a" style="width: 40%;">' + $uitslag.find('team_thuis').text() + '</div>'
                            + '    <div class="ui-block-b" style="width: 40%;">' + $uitslag.find('team_uit').text() + '</div>'
                            + '    <div class="ui-block-c" style="width: 20%;">' + $uitslag.find('score').text() + '</div>'
                            + '  </div>'
                            + '</li>');
                    });
                }

                $standList.listview('refresh');
                $uitslagenList.listview('refresh');
                $('li > div', $container).highlightHonselersdijk();

                $.mobile.hidePageLoadingMsg();
            });
        };

        $.mobile.showPageLoadingMsg();
        $.ajax({ type: "GET", url: xmlUrl, dataType: "xml", success: parseXml });
    });
});