﻿"use strict";

String.prototype.parseURL = function () {
	return this.replace(/[A-Za-z]+:\/\/[A-Za-z0-9-_]+\.[A-Za-z0-9-_:%&~\?\/.=]+/g, function (url) {
		return url.link(url);
	});
};

String.prototype.parseUsername = function () {
	return this.replace(/[@]+[A-Za-z0-9-_]+/g, function (u) {
		var username = u.replace("@", "");
		return u.link("http://twitter.com/" + username);
	});
};

String.prototype.parseHashtag = function () {
	return this.replace(/[#]+[A-Za-z0-9-_]+/g, function (t) {
		var tag = t.replace("#", "%23");
		return t.link("http://search.twitter.com/search?q=" + tag);
	});
};

String.prototype.fixGastenboekSmilies = function () {
	return this.replace(/\/images\/smileys\/2\//gi, 'images/smileys/2/');
};

String.prototype.capitalize = function () {
	return this.charAt(0).toUpperCase() + this.slice(1);
};

String.prototype.parseTwitterDate = function () {
	var dayNames = ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];
	var monthNames = ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];

	var date = new Date(Date.parse(this));

	if (date.toDateString() == new Date().toDateString())
		return "vandaag";

	return dayNames[date.getDay()] + ' ' + date.getDate() + ' ' + monthNames[date.getMonth()];
};

String.prototype.parseUsDate = function () {
	var displayDateParts = this.split('-');
	var displayDate = new Date(displayDateParts[0], displayDateParts[1] - 1, displayDateParts[2]);
	return displayDate.toISOString().parseTwitterDate();
};

String.prototype.nl2br = function () {
	var breakTag = '<br>';
	return (this + '').replace(/([^>\r\n]?)(\r\n|\n\r|\r|\n)/g, '$1' + breakTag + '$2');
};