/* financa facil
developed by: Laio Pinheiro
laiopinheiro01@gmail.com
 */

// =======================================================================================================
// Cadastra um novo pagamento 
// =======================================================================================================
function salvarNovoPagar() {
  
    var $cod = retornaUltimoCodPagar();
    var $titulo = document.getElementById("titulo");
    var $valor = document.getElementById("valor"); 
    var $comentario = document.getElementById("comentario"); 
    var $pago = "N";
    var $dataconclusao = document.getElementById("data").value;

    var pagar = {
        "cod": $cod,
        "titulo": $titulo.value,
        "dataconclusao": $dataconclusao,
        "valor": $valor.value,
        "comentario": $comentario.value,
        "pago": $pago
    };

    var pagamentos = getPagamentos();
    pagamentos.push(pagar);

    if(setPagamentos(pagamentos)){
        
        adicionarNotificacao(pagar);

        $cod.value = 0;
        $titulo.value = "";
        $dataconclusao.value = "";
        $valor.value = "";
        $comentario.value = "";
        $.mobile.changePage( "#inicio", { transition: "customBounce"});
    }

}
// =======================================================================================================
// Traz o array de pagamentos
// =======================================================================================================
function getPagamentos() {
    if (!localStorage["pagamentos"])
       localStorage["pagamentos"] = JSON.stringify([]);

    return JSON.parse(localStorage["pagamentos"]);
}
// =======================================================================================================
// Grava o array com os pagamentos
// =======================================================================================================
function setPagamentos($pagamentos) {
    $pagamentos.sort(function (a, b) {
        return parseInt((a.dataconclusao.replace("-", "")).replace("-", "")) - parseInt((b.dataconclusao.replace("-", "")).replace("-", ""));
    });
    if(localStorage["pagamentos"] = JSON.stringify($pagamentos)){
        return true;
    }else{
        return false;
    }
}
// =======================================================================================================
// Retorna o ultimo codigo cadastrado mais 1, para novo pagamento
// =======================================================================================================
function retornaUltimoCodPagar() {
    var $pagamentos = getPagamentos();
    var $ultimoCod = -1;
    var $codaux;
    if (localStorage["pagamentos"]){
        for(var i = 0; i < $pagamentos.length; i++){
            $codaux = $pagamentos[i].cod;
            if($codaux > $ultimoCod){
                $ultimoCod = $codaux;
            }
        }
    }
    return $ultimoCod + 1;
}
// =======================================================================================================
// Retorna o total(soma) dos pagamentos
// =======================================================================================================
function getTotalPagamentos ($tipo) {
    //Parametro: 'S'= pago 'N'= á pagar
    var $pagamentos = getPagamentos();
    var $total = 0;

    for(var i = 0; i < $pagamentos.length; i++){
        if($pagamentos[i].pago == $tipo){
            $total += parseInt($pagamentos[i].valor*100);
        }
    }
    return $total/100;
}
// =======================================================================================================
// Detalha o que falta pagar
// =======================================================================================================
function detalharPagamento ($codigoPagamento) {
    var hash = location.hash;
    $.mobile.changePage("#detalhe-pagar", { transition: "customBounce"});
    $('#hash-pagar').val(hash);
    
    var $pagamentos = getPagamentos();
    var $detalhe = $("#divdetalhepagar");
    var $html = "";

    for(var i = 0; i < $pagamentos.length; i++){
            if($pagamentos[i].cod == $codigoPagamento){

                $html += '<div class="post-it">';

                $html += '<p class="sticky taped">';

                $html += '<span class="titulo-interno">'+$pagamentos[i].titulo+'</span><br><br>';
                
                if($pagamentos[i].dataconclusao != ""){
                    $html += '<span class="data-interno">'+ exibirDataComMesExtenso ($pagamentos[i].dataconclusao) +'</span><br><br>';                    
                }
                
                if($pagamentos[i].comentario != ""){
                    $html += '<span class="comentario-interno">'+$pagamentos[i].comentario+'</span><br><br><br>';
                }
                $html += '<span class="valor-interno-pagar">R$ '+$pagamentos[i].valor+'</span>';
                
                $html += '</p>';

                $html += '</div>';

                if($pagamentos[i].pago == 'S'){     
                    $texto_botao = "não paguei";
                }else if($pagamentos[i].pago == 'N'){
                    $texto_botao = "pagar";
                }

                $html += '<div class="ui-grid-a">';
                
                $html += '<div class="ui-block-a"><button data-theme="b" class="link-botao" onclick="mudarStatusPagamento('+$pagamentos[i].cod+');">'+$texto_botao+'</button></div>';
                $html += '<div class="ui-block-b"><button data-theme="d" class="link-botao" onclick="deletarPagamento('+$pagamentos[i].cod+');">excluir</button></div>';

                $html += '</div>';

                if($pagamentos[i].pago == 'N'){
                    $('#editar-pagamento').attr('onclick', "editarPagamento("+$pagamentos[i].cod+");");
                }

                break;
            }
    }
    $($detalhe).html($html);
    $('#detalhe-pagar').trigger("create");
}
// =======================================================================================================
// Muda o status do pagamento - 'S' = pago | 'N' = nao pago
// =======================================================================================================
function mudarStatusPagamento ($codigoPagamento) {
    var $pagamentos = getPagamentos();
    for(var i = 0; i < $pagamentos.length; i++){                   
            if($pagamentos[i].cod == $codigoPagamento){
                if($pagamentos[i].pago == 'S'){
                    $pagamentos[i].pago = 'N';
                    break; 
                }else if($pagamentos[i].pago == 'N'){
                    $pagamentos[i].pago = 'S';
                    break; 
                }
            }
    }
    if(setPagamentos($pagamentos)){
        if($.mobile.changePage("#inicio", { transition: "customBounceDown"})){
            listarTodos();
        }
    }
}
// =======================================================================================================
// Deleta um pagamento
// =======================================================================================================
function deletarPagamento ($codigoPagamento) {
    var $pagamentos = getPagamentos();

    for(var i = 0; i < $pagamentos.length; i++){                   
            if($pagamentos[i].cod == $codigoPagamento){
                $pagamentos.splice(i,1);
                break;
            }
    }

    if(setPagamentos($pagamentos)){
        $.mobile.changePage("#inicio", { transition: "customBounceDown"});
    }

}
// =======================================================================================================
// Lista o que ja foi pago
// =======================================================================================================
function listarPagos() {
    var $pagamentos = getPagamentos();
    var $listaPagar = $("#lista-pagos");
    var $lista = "";
    $($listaPagar).html('<li style="border:0px">- Aqui fica listado o que você já pagou.</li>');

    if(getTotalPagamentos('S') != 0){
        for(var i = 0; i < $pagamentos.length; i++){
            if($pagamentos[i].pago == 'S'){              
                $lista +='<li data-theme="c" style="border:0px"><a class="link-lista" onclick="detalharPagamento('+$pagamentos[i].cod+')">';
                $lista += '<span style="font-size:18px;">'+ $pagamentos[i].titulo +'</span><br>'+ $pagamentos[i].dataconclusao +' - R$'+ $pagamentos[i].valor;
                $lista += "</a><hr></li>";
            }
        }
        if($($listaPagar).html($lista)){
            $("#lista-pagos").listview("refresh");
        }
    }
    $("#lista-pagos").listview("refresh");
}
// =======================================================================================================
// Deleta historico de pagamentos
// =======================================================================================================
function apagarPagamentosHistorico ($codigoPagamento) {
    var $pagamentos = getPagamentos();
    var loopsize = $pagamentos.length;
    for(var i = 0; i < loopsize; i++){                   
            if($pagamentos[i].pago == 'S'){
                $pagamentos.splice(i,1);
                i--;
                loopsize--;
            }
    }

    if(setPagamentos($pagamentos)){
        return true;
    }
}
// =======================================================================================================
// Carrega a tela com edicao de um pagamento
// =======================================================================================================
function editarPagamento (codigoPagamento) {
    global_codigo_edicao = codigoPagamento; // aloca o codigo do pagamento em variavel global usada na edicao
    global_tipo_editar = 'P'; // guarda a origem da edicao em uma variavel global
    $.mobile.changePage("#editar", { transition: "customBounce" });
    var pagamentos = getPagamentos();

    for(var i = 0; i < pagamentos.length; i++){
        if(pagamentos[i].cod == codigoPagamento){

            $('#titulo-editar').val(pagamentos[i].titulo);
            $('#valor-editar').val(pagamentos[i].valor);
            $('#data-editar').val(pagamentos[i].dataconclusao);
            $('#comentario-editar').val(pagamentos[i].comentario);

            break;   
        }
    }
}

// =======================================================================================================
// Salva a edicao um pagamento 
// =======================================================================================================
function salvarPagamentoEditado() {
  
    var titulo = document.getElementById("titulo-editar");
    var valor = document.getElementById("valor-editar"); 
    var comentario = document.getElementById("comentario-editar"); 
    var dataconclusao = document.getElementById("data-editar");

    var pagamentos = getPagamentos();

    for(var i = 0; i < pagamentos.length; i++){
        if(pagamentos[i].cod == global_codigo_edicao){ 
            //variavel com o codigo (global_codigo_edicao) é carregada em 'editarPagamento'
            pagamentos[i].titulo = titulo.value;
            pagamentos[i].valor = valor.value;
            pagamentos[i].dataconclusao = dataconclusao.value;
            pagamentos[i].comentario = comentario.value;

            break;  
        }
    }

    if(setPagamentos(pagamentos)){
        delete global_codigo_edicao; 
        titulo.value = "";
        dataconclusao.value = "";
        valor.value = "";
        comentario.value = "";
        $.mobile.changePage( "#inicio", { transition: "customBounce"});
    }

}