/* financa facil
developed by: Laio Pinheiro
laiopinheiro01@gmail.com
 */

// =======================================================================================================
// Cadastra um novo recebimento 
// =======================================================================================================
function salvarNovoReceber() {
   
    var $cod = retornaUltimoCodReceber();
    var $titulo = document.getElementById("titulo");
    var $valor = document.getElementById("valor"); 
    var $comentario = document.getElementById("comentario"); 
    var $recebido = "N";
    var $dataconclusao = document.getElementById("data").value;

    var receber = {
        "cod": $cod,
        "titulo": $titulo.value,
        "dataconclusao": $dataconclusao,
        "valor": $valor.value,
        "comentario": $comentario.value,
        "recebido": $recebido
    };

    var recebimentos = getRecebimentos();
    recebimentos.push(receber);
    if(setRecebimentos(recebimentos)){
        $cod.value = 0;
        $titulo.value = "";
        $dataconclusao.value = "";
        $valor.value = "";
        $comentario.value = "";
        $.mobile.changePage( "#inicio", { transition: "customBounce"});
    }

}
// =======================================================================================================
// Traz o array de recebimentos
// =======================================================================================================
function getRecebimentos() {
    if (!localStorage["recebimentos"])
       localStorage["recebimentos"] = JSON.stringify([]);

    return JSON.parse(localStorage["recebimentos"]);

}
// =======================================================================================================
// Grava o array de recebimentos
// =======================================================================================================
function setRecebimentos($recebimentos) {
    $recebimentos.sort(function (a, b) {
        return parseInt((a.dataconclusao.replace("-", "")).replace("-", "")) - parseInt((b.dataconclusao.replace("-", "")).replace("-", ""));
    });
    if(localStorage["recebimentos"] = JSON.stringify($recebimentos)){
        return true;
    }else{
        return false;
    }
}
// =======================================================================================================
// Retorna o ultimo codigo cadastrado mais 1, para novo recebimento
// =======================================================================================================
function retornaUltimoCodReceber() {
    var $recebimentos = getRecebimentos();
    var $ultimoCod = -1;
    var $codaux;
    if (localStorage["recebimentos"]){
        for(var i = 0; i < $recebimentos.length; i++){
            $codaux = $recebimentos[i].cod;
            if($codaux > $ultimoCod){
                $ultimoCod = $codaux;
            }
        }
    }
    return $ultimoCod + 1;
}
// =======================================================================================================
// Retorna o total(soma) dos recebimentos
// =======================================================================================================
function getTotalRecebimentos ($tipo) {
    //Parametro: 'S'= pago 'N'= á pagar
    var $recebimentos = getRecebimentos();
    var $total = 0;

    for(var i = 0; i < $recebimentos.length; i++){
        if($recebimentos[i].recebido == $tipo){
            $total += parseInt($recebimentos[i].valor*100);
        }
    }
    return $total/100;
}
// =======================================================================================================
// Detalha o que nao foi recebido
// =======================================================================================================
function detalharRecebimento ($codigoRecebimento) {
    var hash = location.hash;
    $.mobile.changePage("#detalhe-receber", { transition: "customBounce"});
    $('#hash-receber').val(hash);

    var $recebimentos = getRecebimentos();
    var $detalhe = $("#divdetalhereceber");
    var $html = "";

    for(var i = 0; i < $recebimentos.length; i++){                   
            if($recebimentos[i].cod == $codigoRecebimento){
                // $html += '<div class="box">';

                // $html += '<div class="titulo-interno">'+$recebimentos[i].titulo+'</div>';
                
                // if($recebimentos[i].dataconclusao != ""){
                //     $html += '<div class="data-interno">'+ exibirDataComMesExtenso ($recebimentos[i].dataconclusao) +'</div>';                    
                // }
                
                // if($recebimentos[i].comentario != ""){
                //     $html += '<div class="comentario-interno">'+$recebimentos[i].comentario+'</div><br><br>';
                // }
                // $html += '<div class="valor-interno-receber">R$ '+$recebimentos[i].valor+'</div>';
                
                // $html += '</div>';


                /*===================================*/
                
                $html += '<div class="post-it">';

                $html += '<p class="sticky taped">';

                $html += '<span class="titulo-interno">'+$recebimentos[i].titulo+'</span><br><br>';
                
                if($recebimentos[i].dataconclusao != ""){
                    $html += '<span class="data-interno">'+ exibirDataComMesExtenso ($recebimentos[i].dataconclusao) +'</span><br><br>';                    
                }
                
                if($recebimentos[i].comentario != ""){
                    $html += '<span class="comentario-interno">'+$recebimentos[i].comentario+'</span><br><br><br>';
                }
                $html += '<span class="valor-interno-receber">R$ '+$recebimentos[i].valor+'</span>';
                
                $html += '</p>';

                $html += '</div>';

                /*===================================*/

                if ($recebimentos[i].recebido == 'S') {
                    $texto_botao = "não recebi";
                }else if ($recebimentos[i].recebido == 'N') {
                    $texto_botao = "receber";
                }

                $html += '<div class="ui-grid-a">';

                $html += '<div class="ui-block-a"><button data-theme="b" class="link-botao" onclick="mudarStatusRecebimento('+$recebimentos[i].cod+');">'+$texto_botao+'</button></div>';
                $html += '<div class="ui-block-b"><button data-theme="d" class="link-botao" onclick="deletarRecebimento('+$recebimentos[i].cod+');">excluir</button></div>';

                $html += '</div>';

                if($recebimentos[i].recebido == 'N'){
                    $('#editar-recebimento').attr('onclick', "editarRecebimento("+$recebimentos[i].cod+");");
                }
                
                break;

            }
    }
    $($detalhe).html($html);
    $('#detalhe-receber').trigger("create");
}
// =======================================================================================================
// Muda o status do recebimento - 'S' = Recebido | 'N' = nao recebido
// =======================================================================================================
function mudarStatusRecebimento ($codigoRecebimento) {
    var $recebimentos = getRecebimentos();
    for(var i = 0; i < $recebimentos.length; i++){                   
            if($recebimentos[i].cod == $codigoRecebimento){
                if($recebimentos[i].recebido == 'S'){
                    $recebimentos[i].recebido = 'N';
                    break; 
                }else if($recebimentos[i].recebido == 'N'){
                    $recebimentos[i].recebido = 'S';
                    break; 
                }
            }
    }
    if(setRecebimentos($recebimentos)){
        if($.mobile.changePage("#inicio", { transition: "customBounceDown"})){
            listarTodos();
        }
    }
}
// =======================================================================================================
// Deleta um recebimento
// =======================================================================================================
function deletarRecebimento ($codigoRecebimento) {
    var $recebimentos = getRecebimentos();
    var $hash = location.hash;

    for(var i = 0; i < $recebimentos.length; i++){                   
            if($recebimentos[i].cod == $codigoRecebimento){
                $recebimentos.splice(i,1);
                break;
            }
    }

    if(setRecebimentos($recebimentos)){
        $.mobile.changePage("#inicio", { transition: "customBounceDown"});
    }
}
// =======================================================================================================
// Lista o que ja foi recebido
// =======================================================================================================
function listarRecebidos() {
    var $recebimentos = getRecebimentos();
    var $listaReceber = $("#lista-recebidos");
    var $lista = "";
    $($listaReceber).html('<li style="border:0px">- Aqui fica listado o que você já recebeu.</li>');

    if(getTotalRecebimentos('S') != 0){
        for(var i = 0; i < $recebimentos.length; i++){
            if($recebimentos[i].recebido == 'S'){              
                $lista +='<li data-theme="c" style="border:0px"><a class="link-lista" onclick="detalharRecebimento('+$recebimentos[i].cod+')">';
                $lista += '<span style="font-size:18px;">'+ $recebimentos[i].titulo +'</span><br>'+$recebimentos[i].dataconclusao+' - R$'+ $recebimentos[i].valor;
                $lista += "</a><hr></li>";
            }
        }
        if($($listaReceber).html($lista)){
            $("#lista-recebidos").listview("refresh");
        }
    }
    $("#lista-recebidos").listview("refresh");
}
// =======================================================================================================
// Deleta historico de recebimentos
// =======================================================================================================
function apagarRecebimentosHistorico () {
    var $recebimentos = getRecebimentos();
    var loopsize = $recebimentos.length;
    for(var i = 0; i < loopsize; i++){                   
            if($recebimentos[i].recebido == 'S'){
                $recebimentos.splice(i,1);
                i--;
                loopsize--;
            }
    }

    if(setRecebimentos($recebimentos)){
        return true;
    }
}
// =======================================================================================================
// Carrega a tela com edicao de um recebimento
// =======================================================================================================
function editarRecebimento (codigoRecebimento) {
    global_codigo_edicao = codigoRecebimento; // aloca o codigo do recebimento em variavel global usada na edicao
    global_tipo_editar = 'R'; // guarda a origem da edicao em uma variavel global
    $.mobile.changePage("#editar", { transition: "customBounce" });
    var recebimentos = getRecebimentos();

    for(var i = 0; i < recebimentos.length; i++){
        if(recebimentos[i].cod == codigoRecebimento){

            $('#titulo-editar').val(recebimentos[i].titulo);
            $('#valor-editar').val(recebimentos[i].valor);
            $('#data-editar').val(recebimentos[i].dataconclusao);
            $('#comentario-editar').val(recebimentos[i].comentario);

            break;   
        }
    }
}

// =======================================================================================================
// Salva a edicao um recebimento 
// =======================================================================================================
function salvarRecebimentoEditado() {
  
    var titulo = document.getElementById("titulo-editar");
    var valor = document.getElementById("valor-editar"); 
    var comentario = document.getElementById("comentario-editar"); 
    var dataconclusao = document.getElementById("data-editar");

    var recebimentos = getRecebimentos();

    // percorre o array de recebimentos e modifica
    for(var i = 0; i < recebimentos.length; i++){
        if(recebimentos[i].cod == global_codigo_edicao){ 
            //variavel com o codigo é carregada em 'editarrecebimento'
            recebimentos[i].titulo = titulo.value;
            recebimentos[i].valor = valor.value;
            recebimentos[i].dataconclusao = dataconclusao.value;
            recebimentos[i].comentario = comentario.value;

            break;  
        }
    }

    if(setRecebimentos(recebimentos)){
        // limpa a variavel global com o codigo e os inputs do formulario de edicao
        global_codigo_edicao = null; 
        titulo.value = "";
        dataconclusao.value = "";
        valor.value = "";
        comentario.value = "";
        // redireciona para a tela inicial
        $.mobile.changePage( "#inicio", { transition: "customBounce"});
    }

}