/* financa facil
developed by: Laio Pinheiro
laiopinheiro01@gmail.com
 */

// =======================================================================================================
//preenche o campo de total a pagar da tela inicial
// =======================================================================================================
function exibirTotalPagar () {
var $total = document.getElementById("totalpagar"); 
    $total.value = "R$ "+ (getTotalPagamentos('N'));
}
// =======================================================================================================
//preenche o campo de total a receber da tela inicial
// =======================================================================================================
function exibirTotalReceber () {
    var $total = document.getElementById("totalreceber"); 
    $total.value = "R$ "+ (getTotalRecebimentos('N'));
}
// =======================================================================================================
//preenche o campo de saldo da tela inicial
// =======================================================================================================
function exibirSaldo () {
    var $saldo = document.getElementById("saldo"); 
    var $pagamentos = getTotalPagamentos('S');
    var $recebimentos = getTotalRecebimentos('S');

    $saldo.value = "R$ "+ (($recebimentos - $pagamentos));
}
// =======================================================================================================
// Ordena e lista pagamentos e recebimentos
// =======================================================================================================
function listarTodos () {
    var arrayGeral = Array();
    var pagamentos = getPagamentos();
    var recebimentos = getRecebimentos();

    for (var i = pagamentos.length - 1; i >= 0; i--) {
        arrayGeral.push(pagamentos[i]);
    }

    for (var i = recebimentos.length - 1; i >= 0; i--) {
        arrayGeral.push(recebimentos[i]);
    }

    //ordenar
    arrayGeral.sort(function (a, b) {
        return parseInt((a.dataconclusao.replace("-", "")).replace("-", "")) - parseInt((b.dataconclusao.replace("-", "")).replace("-", ""));
    });

    var lista = "";
    $("#lista-geral").html('<li data-theme="b" style="text-align:center; border:0px">Para adicionar pagamentos <br> e recebimentos use <br /> o botão "+" acima.</li>');

    if(arrayGeral.length != 0){
        for(var i = 0; i < arrayGeral.length; i++){
            if(arrayGeral[i].pago == 'N'){     
                lista +='<li data-theme="c" data-icon="false" style="border:0px"><a class="link-lista" onclick="detalharPagamento('+arrayGeral[i].cod+')">';
                lista +=  '<span style="font-size:18px;">'+ arrayGeral[i].titulo +'</span><br>'+ exibirDataComMesExtenso (arrayGeral[i].dataconclusao) +' - R$ <span style="color:#e74c3c;">'+ arrayGeral[i].valor +'</span>';
                lista += "</a><hr></li>";
            }
            if(arrayGeral[i].recebido == 'N'){  
                lista +='<li data-theme="c" data-icon="false" style="border:0px"><a class="link-lista" onclick="detalharRecebimento('+arrayGeral[i].cod+')">';
                lista +=  '<span style="font-size:18px;">'+ arrayGeral[i].titulo +'</span><br>'+ exibirDataComMesExtenso (arrayGeral[i].dataconclusao) +' - R$ <span style="color:#27ae60;">'+ arrayGeral[i].valor +'</span>';
                lista += "</a><hr></li>";
            }
        }
        if (lista != "") {
            if($("#lista-geral").html(lista)){
                $("#lista-geral").listview("refresh");
            }
        }
    }
    $("#lista-geral").listview("refresh");
}
// =======================================================================================================
// salvar pagamentos e recebimentos
// =======================================================================================================
function salvar() {
    var ok = false;
    if ($('#titulo').val() == '' || $('#titulo').val() == null){
        $('#popup').html('<p>opa, você esqueceu o título!</p><br /><button data-theme="c" data-role="button" class="botao-popup" onclick="$( \'#popup\' ).popup( \'close\' )">certo!</button>');
        $( "#popup" ).popup( "open", {transition: "customFlip"} );
    } else if ($('#valor').val() == '' || $('#valor').val() == null){
        $('#popup').html('<p>Ei! não vai pôr o valor?</p><br /><button data-theme="c" data-role="button" class="botao-popup" onclick="$( \'#popup\' ).popup( \'close\' )">certo!</button>');
        $( "#popup" ).popup( "open", {transition: "customFlip"} );
    } else if ($('#data').val() == '' || $('#data').val() == null){
        $('#popup').html('<p>Faltou preencher a data...</p><br /><button data-theme="c" data-role="button" class="botao-popup" onclick="$( \'#popup\' ).popup( \'close\' )">certo!</button>');
        $( "#popup" ).popup( "open", {transition: "customFlip"} );
    } 
    else{
        ok = true;
    }
    $( "#popup" ).trigger('create');
    if ($('#escolha_pagar').is(':checked') && ok){
        salvarNovoPagar();
    }else if ($('#escolha_receber').is(':checked') && ok){
        salvarNovoReceber();
    }
}
// =======================================================================================================
// transicao de pagina detalhe
// =======================================================================================================
function voltarDetalhe (tipo) {

    var tipo_hash = "";
    if (tipo == "P") {
        tipo_hash = "hash-pagar";
    } else if (tipo == "R") {
        tipo_hash = "hash-receber";
    }

    var hash = $('#'+tipo_hash).val();
    if (hash != '#historico') {
        $.mobile.changePage( "#inicio", { transition: "customBounceLat", reverse: true});
    }else{
        $.mobile.changePage( "#historico", { transition: "customBounceLat", reverse: true});
    }
}

// =======================================================================================================
// recebe uma data em padrao americano e retorna em brasileiro e com o mes por extenso
// =======================================================================================================
function exibirDataComMesExtenso (data) {
    data = data.split("-");
    var dataAux = new Date(data[0], data[1]-1, data[2], 23, 00, 00);
    var dia=dataAux.getDate();
    var mes=dataAux.getMonth();
    var ano=dataAux.getFullYear();

    switch(mes) {
        case 0:
            mes = "janeiro";
            break;
        case 1:
            mes = "fevereiro";
            break;
        case 2:
            mes = "março";
            break;
        case 3:
            mes = "abril";
            break;
        case 4:
            mes = "maio";
            break;
        case 5:
            mes = "junho";
            break;
        case 6:
            mes = "julho";
            break;
        case 7:
            mes = "agosto";
            break;
        case 8:
            mes = "setembro";
            break;
        case 9:
            mes = "outubro";
            break;
        case 10:
            mes = "novembro";
            break;
        case 11:
            mes = "dezembro";
            break;
    }

    return dia + ' de ' + mes + ' de ' + ano;

}
// =======================================================================================================
// apagar dados
// =======================================================================================================
function apagarDados () {
    apagarPagamentosHistorico();
    apagarRecebimentosHistorico(); 
    $.mobile.changePage("#inicio", { transition: "customBounce"}); 
    setTimeout(function(){
        $( "#popup-sucesso" ).html( '<p>Dados apagados com sucesso!</p><br /><button data-theme="c" data-role="button" class="botao-popup" onclick="$( \'#popup-sucesso\' ).popup( \'close\' )">certo!</button>' );
        $( "#popup-sucesso" ).popup( "open", {transition: "customFlip"} );
        $( "#popup-sucesso" ).trigger("create");
    }, 800);
}
// =======================================================================================================
// salvar edicao de pagamentos e recebimentos
// =======================================================================================================
function salvarEdicao() {

    // validacao do formulario
    var ok = false;
    if ($('#titulo-editar').val() == '' || $('#titulo-editar').val() == null){
        $('#popup-editar').html('<p>Falta o título...</p><br /><button data-theme="c" data-role="button" class="botao-popup" onclick="$( \'#popup-editar\' ).popup( \'close\' )">certo!</button>');
        $( "#popup-editar" ).popup( "open", {transition: "customFlip"} );
    } else if ($('#valor-editar').val() == '' || $('#valor-editar').val() == null){
        $('#popup-editar').html('<p>Vai ficar sem valor?</p><br /><button data-theme="c" data-role="button" class="botao-popup" onclick="$( \'#popup-editar\' ).popup( \'close\' )">certo!</button>');
        $( "#popup-editar" ).popup( "open", {transition: "customFlip"} );
    } else if ($('#data-editar').val() == '' || $('#data-editar').val() == null){
        $('#popup-editar').html('<p>Ei, esqueceu a data!</p><br /><button data-theme="c" data-role="button" class="botao-popup" onclick="$( \'#popup-editar\' ).popup( \'close\' )">certo!</button>');
        $( "#popup-editar" ).popup( "open", {transition: "customFlip"} );
    } else {
        ok = true;
    }
    $( "#popup-editar" ).trigger('create');
    // se estiver preenchido corretamente o formulario
    if (ok) { 
        if (global_tipo_editar == 'P') { 
            // no caso de pagamento
            global_tipo_editar = null;
            salvarPagamentoEditado();
        }else if (global_tipo_editar == 'R'){ 
            // se for recebimento
            global_tipo_editar = null;
            salvarRecebimentoEditado();
        }
    }
}
// =======================================================================================================
// adicionar notificacao local
// =======================================================================================================
function adicionarNotificacao(obj) {
    // console.log();
//     window.plugin.notification.local.add({
//     id:         String,  // A unique id of the notification
//     date:       Date,    // This expects a date object
//     message:    String,  // The message that is displayed
//     title:      String,  // The title of the message
//     repeat:     String,  // Either 'secondly', 'minutely', 'hourly', 'daily', 'weekly', 'monthly' or 'yearly'
//     badge:      Number,  // Displays number badge to notification
//     sound:      String,  // A sound to be played
//     json:       String,  // Data to be passed through the notification
//     autoCancel: Boolean, // Setting this flag and the notification is automatically cancelled when the user clicks it
//     ongoing:    Boolean, // Prevent clearing of notification (Android only)
// }, callback, scope);
}

// =======================================================================================================
// listar o historico
// =======================================================================================================
function listarHistorico () {
    var arrayGeralHistorico = Array();
    var pagamentos = getPagamentos();
    var recebimentos = getRecebimentos();

    for (var i = pagamentos.length - 1; i >= 0; i--) {
        arrayGeralHistorico.push(pagamentos[i]);
    }

    for (var i = recebimentos.length - 1; i >= 0; i--) {
        arrayGeralHistorico.push(recebimentos[i]);
    }

    //ordenar
    arrayGeralHistorico.sort(function (a, b) {
        return parseInt((b.dataconclusao.replace("-", "")).replace("-", "")) - parseInt((a.dataconclusao.replace("-", "")).replace("-", ""));
    });

    var lista = "";
    $("#lista-historico").html('<li data-theme="b" style="text-align:center; border:0px">Aqui fica listado o que você já pagou e recebeu!</li>');

    if(arrayGeralHistorico.length != 0){
        for(var i = 0; i < arrayGeralHistorico.length; i++){
            if(arrayGeralHistorico[i].pago == 'S'){     
                lista +='<li data-theme="c" data-icon="false" style="border:0px"><a class="link-lista" onclick="detalharPagamento('+arrayGeralHistorico[i].cod+')">';
                lista +=  '<span style="font-size:18px;">'+ arrayGeralHistorico[i].titulo +'</span><br>'+ exibirDataComMesExtenso (arrayGeralHistorico[i].dataconclusao) +' - R$ <span style="color:#e74c3c;">'+ arrayGeralHistorico[i].valor +'</span>';
                lista += "</a><hr></li>";
            }
            if(arrayGeralHistorico[i].recebido == 'S'){  
                lista +='<li data-theme="c" data-icon="false" style="border:0px"><a class="link-lista" onclick="detalharRecebimento('+arrayGeralHistorico[i].cod+')">';
                lista +=  '<span style="font-size:18px;">'+ arrayGeralHistorico[i].titulo +'</span><br>'+ exibirDataComMesExtenso (arrayGeralHistorico[i].dataconclusao) +' - R$ <span style="color:#27ae60;">'+ arrayGeralHistorico[i].valor +'</span>';
                lista += "</a><hr></li>";
            }
        }
        if (lista != "") {
            if($("#lista-historico").html(lista)){
                $("#lista-historico").listview("refresh");
            }
        }
    }
    $("#lista-historico").listview("refresh");
}
