//funo calculaPrice  chamada depois da validao do form, no arquivo happy.js
function calculaPrice() {
	var tipoCalculo = $('#tipo').val();
	var valorFinanciado = formatarDecimal($('#vf').val());
	var parcela = formatarDecimal($('#vp').val());
	var numeroParcelas = $('#np').val();
	var parcelasPagas = $('#pp').val();
	var juros = formatarDecimal($('#tx').val());

	var mensagem = '';
	var resultado = 0;

	switch (tipoCalculo)
	{
		case "sd": //Saldo Devedor
			resultado = formatarReal(price.saldoDevedor(valorFinanciado, parcela, numeroParcelas, parcelasPagas));
			mensagem += "O valor do saldo devedor  de:";
			mensagem += "\n\nR$: " + resultado;
			break;
		case "tx": //Taxa de Juros
			resultado = price.taxaJuros(valorFinanciado, numeroParcelas, parcela);
			mensagem += "O valor dos juros a.m.  de:"
			mensagem += "\n\n" + resultado + "%";
			break;
		case "vp": //Valor da Parcela
			resultado = formatarReal(price.valorParcela(valorFinanciado, numeroParcelas, juros));
			mensagem += "O valor da parcela  de:"
			mensagem += "\n\nR$: " + resultado;
			break;
	}

	mensagem += "\n\nAteno: Este clculo tm como base a tabela PRICE e no esto considerados os valores de IOF e TAC (taxa de abertura de crdito). Utilize o resultado apenas como valor de referncia.";

	alert(mensagem);
}
function formatarDecimal(numero) {
	//tira a virgula
	numero = numero.toString().replace(",",".");
	//conta quantos pontos foram digitados
	var pontos = numero.split('.');
	var pontosLength = pontos.length;
	//se foi digitado mais que um, cola todos pedacos com um unico ponto no final
	if (pontosLength > 2) {
		numero = '';
		for (var i = 0; i < pontosLength; i++) {
			if (i == (pontosLength-1)) {
				numero += "." + pontos[i];	
			} else {
				numero += pontos[i];
			}
		};
	}
	return parseFloat(numero);
}
function formatarReal(numero)
{
    var tmp = numero.toString().replace(".","");
    tmp = tmp.replace(/([0-9]{2})$/g, ",$1");
    if( tmp.length > 6 )
        tmp = tmp.replace(/([0-9]{3}),([0-9]{2}$)/g, ".$1,$2");
	if( tmp.length > 10)
        tmp = tmp.replace(/([0-9]{3}).([0-9]{3}),([0-9]{2}$)/g,".$1.$2,$3");
    return tmp;
}
window.onload = function() {
	//Validao
	$('#form').isHappy({
		fields: {
			'#vf': {
				required: true
			},
			'#vp': {
				required: true
			},
			'#np': {
				required: true
			},
			'#pp': {
				required: true
			},
			'#tx': {
				required: true
			}
		},
		unHappy : function() {
			alert('Preencha os campos assinalados em vermelho');
		}
	});
	//Reset do Form
	$('#form').on('reset',function(e){
		$('#ivp').removeClass('oculto');
		$('#ipp').removeClass('oculto');
		$('#itx').addClass('oculto');
		$('input').removeClass('unhappy');
	});
	//Select do tipo de clculo
	$('#tipo').on('change',function(e){
		var tipo = $(this).val();
		switch (tipo)
		{
			case "sd": //Saldo Devedor
				$('#ivp').removeClass('oculto');
				$('#ipp').removeClass('oculto');
				$('#itx').addClass('oculto');
				break;
			case "tx": //Taxa de Juros
				$('#ivp').removeClass('oculto');
				$('#ipp').addClass('oculto');
				$('#itx').addClass('oculto');
				break;
			case "vp": //Valor da Parcela
				$('#ivp').addClass('oculto');
				$('#ipp').addClass('oculto');
				$('#itx').removeClass('oculto');
				break;
		}
	});
	//PlaceHolder pro Android (PhoneGap)
	/*$("input[type='number']").each(function(i, el) {
	    el.type = "text";
	    el.onfocus = function(){this.type="number"};
	    el.onblur = function(){this.type="text"};
	});*/
}