var ctx;
var tela;
var width = screen.width;
var obj = ['0']; //imagem que é selecionada para formar os pares pelo usuario
var conferir = [-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1]; //será usado para conferir se todas as 16 posições estão sendo usadas
var confObj = [-1, -1, -1, -1, -1, -1, -1, -1, -1]; //será usado para conferir se o objeto está alocado em uma célula
var posObj = new Array(33);
var objAl = ['0'];
var ult = -1, level = 1, total = 40, tempo = total;
var ultMenu = 0; //ultimo menu acessado, por default é 1
var atualMenu; //menu atual
var pares = 0; //contará o número de pares formados
var parar = true; //se for true para o contador de tempo
var endTrilha = '/audio/trilha1.ogg'; //endereço da trilha de som que toca no fundo
var pausado = false; //verifica se o jogo está pausado
var funcaoEx = new Array(5); //posições: 0=> função, 1=> parametro 1, 2=> parametro 2, 3=> parametro 3, 4=> frames até executar a função
funcaoEx[0] = -1;
var fps = 10;
var now;
var then = Date.now();
var interval = 1000/fps;

function onLoad()
{
	somGO = document.getElementById('somGO');
	som = document.getElementById('som');
	som2 = document.getElementById('som2');
	somAce = document.getElementById('somAce');
	trilha = document.getElementById('trilha');
	desenharTela();
	novoNivel();
	funcaoEx[0] = 3; funcaoEx[1] = 0; funcaoEx[4] = 1;
}

function novoNivel()
{
	var i, i2, i3;
	
	//sorteio as posições dos objetos
	for(i=0; i<8; i++)
	{
		i2 = Math.floor(Math.random()*10);
		while(confObj[i2] > -1) //se for maior que -1 ela está sendo usada
		{
			i2 = Math.floor(Math.random()*10); //sorteia outra posição
		}
		confObj[i2] = 1;
		objAl[i] = i2;
	}
	
	//preenchimento das celulas
	for(i=0; i<8; i++) 
		{
			for(i2=0; i2<2; i2++)
			{
				i3 = Math.floor(Math.random()*16);
				
				//usarei o while para não substituir uma imagem por outra que já está alocada
				while(conferir[i3] > -1)
				{
					i3 = Math.floor(Math.random()*16);
				}
				obj[i3] = objAl[i]; //aloco o número da imagem na posição dentro de obj 
				
				conferir[i3] = 0; //0 quer dizer que esta posição está sendo usada
			}
		}
	//continua contador
	parar = false;
	preencherMenu(1);
	
	//desenha o novo level
	ctx.fillStyle = 'white';
	ctx.fillRect(width*0.50, width*0.05, width * 0.2, width * 0.1);
	ctx.font = (width * 0.1)+"px Serif";
	ctx.fillStyle = "black";
	ctx.fillText(level,width*0.58, width*0.05);
}

//função que desenha as celulas
function desCelula(funcEx)
{
	var i, j, celNum=0;
	var espacoL = Math.floor(width * 0.01);
	var direita = espacoL;
	var espacoC = Math.floor(tela.height * 0.01);
	var topo = Math.floor(width / 4) + espacoC;
	var altura = Math.floor((tela.height - width/4) * 0.2375);
	var largura = Math.floor(width * 0.2375);
	posObj[32] = largura;
	var celula = new Image();
	celula.src = 'img/duvida.png';
	
	ctx.clearRect(0, topo, width, tela.height - topo);
	celula.onload = function(){
		var topoImg = Math.floor((altura - largura) / 2) //será adicionado ao y da imagem só para centraliza-la
		
		//agora desenha as células
		for(i=0; i<4; i++)
		{
			for(j=0; j<4; j++)
			{
				if(confObj[celNum] != 2) //se for 2 significa que não precisa desenhar, pois já formou um par
					ctx.drawImage(celula, direita, topo + topoImg, largura, largura);
				posObj[celNum] = direita;
				posObj[celNum+16] = topo + topoImg;
				celNum++;
				direita += largura + espacoL;
			}
			direita = espacoL;
			topo += altura + espacoC;
		}
		if(typeof(funcEx) == 'function')
			funcEx.call();
	}
}

//Contador de tempo que faz mais algumas coisas além de contar dependendo do tempo
function atualizar()
{
	var delta;
	requestAnimationFrame = window.mozRequestAnimationFrame    ||
        window.webkitRequestAnimationFrame ||
        window.msRequestAnimationFrame     ||
        window.oRequestAnimationFrame
    ;
	requestAnimationFrame(atualizar);
    now = Date.now();
    delta = now - then;
    if (delta > interval) {
		then = now - (delta % interval);
		
		if(funcaoEx[0] != -1)
		{
			var funcao;
			if(funcaoEx[4] > 0)
			{
				funcaoEx[4] = funcaoEx[4] -1;
			}else{
				funcao = funcaoEx[0];
				funcaoEx[0] = -1;
				switch(funcao)
				{
					case 0:
						onLoad();
						break;
					case 1:
						acertou(funcaoEx[1], funcaoEx[2], funcaoEx[3]);
						break;
					case 2:
						errou(funcaoEx[1], funcaoEx[2]);
						break;
					case 3:
						preencherMenu(funcaoEx[1]);
						break;
					case 4:
						if(atualMenu === 2)
							imgPiscar(funcaoEx[1]);
						break;
					case 5:
						novoNivel();
						break;
				}
			}
		}
		if(!(parar))
		{
			if(tempo <= 0) //acabou o tempo
			{
				trilha.pause();
				funcaoEx[0] = 3; funcaoEx[1] = 3; funcaoEx[4] = 0;
				parar = true;
				playAudio(5);
			}else{
				//diminui o tempo
				tempo = tempo - 0.1;
				if(tempo <= 0) //acabou o tempo
					tempo = 0;
				ctx.fillStyle = 'white';
				ctx.fillRect(tela.width*0.25, tela.width*0.05,tela.width/6, tela.width*0.1)
				ctx.fillStyle = "black";
				ctx.font = (tela.width * 0.1)+"px Serif";
				ctx.textBaseline = "top";
				ctx.fillText(tempo.toFixed(0),tela.width*0.33, tela.width*0.05);
				
			}
		}
	}
}

function desenharTela()
{
		width = screen.width;
		tela.width = width;
		tela.height = screen.height;
		ctx.textAlign = "center";
		
		//desenha a area do menu
		var imgMenu = new Image();
		imgMenu.src = 'img/menu.png';
		imgMenu.onload = function(){
			ctx.drawImage(imgMenu, 0, 0, tela.width, width/4);
			//desenha o resto
			var imgMenu0 = new Image(); //logo
				imgMenu0.src = 'img/logo.png';
				imgMenu0.onload = function(){ctx.drawImage(imgMenu0, 0, 0, tela.width/6, tela.width/6);};
			var imgMenu1 = new Image();//tempo
				imgMenu1.src = 'img/time.png';
				imgMenu1.onload = function(){
					ctx.drawImage(imgMenu1, tela.width*0.25, 0, tela.width/6, tela.width/6);
					ctx.fillStyle = "black";
					ctx.font = (tela.width * 0.1)+"px Serif";
					ctx.textBaseline = "top";
					ctx.fillText(tempo.toFixed(0),tela.width*0.33, tela.width*0.05);
				};
			var imgMenu2 = new Image();//nivel
				imgMenu2.src = 'img/level.png';
				imgMenu2.onload = function(){
					ctx.drawImage(imgMenu2, tela.width*0.5, 0, tela.width/6, tela.width/6);
					ctx.fillStyle = "black";
					ctx.font = (width * 0.1)+"px Serif";
					ctx.textBaseline = "top";
					ctx.fillText(level,width*0.58, width*0.05);
				};
		};
				
		preencherMenu(atualMenu);		
}

function escolha(elem)
{
	if((!(parar)) && (confObj[elem] != 2) && (elem !== ult)) // se confObj for igual a 2 significa que o objeto já formou seu par
	{
			var celula = new Image();
			celula.src = 'img/ob'+ obj[elem] +'.png';
			celula.onload = function(){
				ctx.clearRect(posObj[elem], posObj[elem+16], posObj[32], posObj[32]);
				ctx.drawImage(celula, posObj[elem], posObj[elem+16], posObj[32], posObj[32]);
			}
            compara(elem);
            if(ult !== -2)
                ult = elem;
            else
		ult = -1;
		
	}
}

function compara(elem)
{
    if((obj[elem]) === (obj[ult]) && (elem !== ult)) //compara se os dois objetos selecionados são do mesmo tipo e não estão na mesma posição
    {
    	playAudio(2);
        parar = true; //paro o contador para fazer a animação
		funcaoEx[0] = 1; funcaoEx[1] = elem; funcaoEx[2] = ult; funcaoEx[3] = 1; funcaoEx[4] = 6;
        ult = -2; //impede que o ultimo elemento seja comparado com o próximo, pois o ultimo já tem seu par
    }else
        if(ult >= 0)
        {
        	playAudio(2);
            parar = true; //paro o contador para fazer a comparação
			funcaoEx[0] = 2; funcaoEx[1] = elem; funcaoEx[2] = ult; funcaoEx[4] = 6;
            ult =-2;
        }else
        	playAudio(1);
}

function acertou(elem1, elem2, anim)
{
	var celulaA = new Image();
	if(anim === 1)
		playAudio(4);//som de quem acerta ;)
	if(anim <= 3) //mostrará uma animação
	{
		celulaA.src = 'img/ob'+obj[elem1]+'_'+anim+'.png';
		celulaA.onload = function(){
			ctx.clearRect(posObj[elem1], posObj[elem1+16], posObj[32], posObj[32]);
			ctx.clearRect(posObj[elem2], posObj[elem2+16], posObj[32], posObj[32]);
			ctx.drawImage(celulaA, posObj[elem1], posObj[elem1+16], posObj[32], posObj[32]);
			ctx.drawImage(celulaA, posObj[elem2], posObj[elem2+16], posObj[32], posObj[32]);
			anim++;
			funcaoEx[0] = 1; funcaoEx[1] = elem1; funcaoEx[2] = elem2; funcaoEx[3] = anim; funcaoEx[4] = 20;
		}
	}else
	{
		//o lugar onde fica os dois objetos ficará vazio
		ctx.clearRect(posObj[elem1], posObj[elem1+16], posObj[32], posObj[32]);
		ctx.clearRect(posObj[elem2], posObj[elem2+16], posObj[32], posObj[32]);
		pares++;
		confObj[elem1] = 2;
		confObj[elem2] = 2;
		if(pares === 8)
		{
			level++;
			total = total - 5;
			tempo = total;
			if(level === 7)
			{
				funcaoEx[0] = 3; funcaoEx[1] = 4; funcaoEx[4] = 0;
			}else if(level === 3){
				//CB
				funcaoEx[0] = 3; funcaoEx[1] = 2; funcaoEx[4] = 0;
			}else{
				funcaoEx[0] = 3; funcaoEx[1] = 2; funcaoEx[4] = 0;
			}
		}else
			parar = false;
	}
}

//apenas muda as imagens de volta para a imagem de escolha
function errou(elem1, elem2)
{
	var celula = new Image();
	celula.src = 'img/duvida.png';
	celula.onload = function(){
		ctx.clearRect(posObj[elem1], posObj[elem1+16], posObj[32], posObj[32]);
		ctx.clearRect(posObj[elem2], posObj[elem2+16], posObj[32], posObj[32]);
		ctx.drawImage(celula, posObj[elem1], posObj[elem1+16], posObj[32], posObj[32]);
		ctx.drawImage(celula, posObj[elem2], posObj[elem2+16], posObj[32], posObj[32]);
	}
    parar = false; //continua o contador
}

function nivel()
{
	funcaoEx[0] = 5; funcaoEx[4] = 13;
	ult = -1;
	conferir = [-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1];
	confObj = [-1, -1, -1, -1, -1, -1, -1, -1, -1];
	pares = 0;
	ctx.fillStyle = "#ffffff";
	ctx.font = (width * 0.23)+"px Serif";
	ctx.textBaseline = "top";
	ctx.shadowColor = "blue";
	ctx.shadowOffsetX = 1;
	ctx.shadowOffsetY = 1;
	ctx.shadowBlur = 6;
	ctx.fillText('Level '+level,width*0.5, width/3);
	ctx.shadowOffsetX = 0;
	ctx.shadowOffsetY = 0;
	ctx.shadowBlur = 0;
	endTrilha = '/audio/trilha'+level+'.ogg';
	playAudio(3);
}

function sair()
{
	//RB
    if(navigator.app)
    {
        navigator.app.exitApp();
    }else if(navigator.device){
        navigator.device.exitApp();
    }
}

function recomecar()
{
    parar = true;
    level = 1;
    total = 40;
    tempo = total;
    desCelula(nivel);
    somGO.pause();
}
function preencherMenu(valor)
{	
	switch(valor)
	{
		case 0: //inicio do jogo
			desCelula(1);
			atualMenu = 0;
			pausado = true;
			ultMenu = 0;//ultimo menu acessado
			parar = true; //o jogo ainda não começou para fazer contagem, então é melhor deixar parado o tempo
			var come = new Image();
				come.src = 'img/jogar.png';
				come.onload = function(){
					ctx.fillStyle = "#52ff78";
					ctx.font = (width * 0.17)+"px Serif";
					ctx.textBaseline = "top";
					ctx.shadowColor = "black";
					ctx.shadowOffsetX = 0;
					ctx.shadowOffsetY = 0;
					ctx.shadowBlur = 7;
					ctx.fillText('Start Game',width*0.5, width * 0.3);
					ctx.drawImage(come, width*0.34, width /2, width/3, width*0.15);
					ctx.shadowOffsetX = 0; // integer
					ctx.shadowOffsetY = 0; // integer
					ctx.shadowBlur = 0; // integer
					var imgMenu3 = new Image(); //botão de menu
					imgMenu3.src = 'img/menuIcon1.png';
					imgMenu3.onload = function(){
						ctx.fillStyle = 'white';
						ctx.fillRect(tela.width*0.75, 0, tela.width/6, tela.width/6);
						ctx.globalAlpha=0.2;
						ctx.drawImage(imgMenu3, tela.width*0.75, 0, tela.width/6, tela.width/6);
						ctx.globalAlpha=1.0;
					};
				};
			break;
		case 1: //menu normal
			desCelula(1); //limpa a area
			pausado =false;
			ultMenu = 1;//ultimo menu acessado
			atualMenu = 1;
			//se o contador estiver parado ele vai continuar a contagem
			parar = false;
			var imgMenu3 = new Image(); //botão de menu
			imgMenu3.src = 'img/menuIcon1.png';
			imgMenu3.onload = function(){
				ctx.fillStyle = 'white';
				ctx.fillRect(tela.width*0.75, 0, tela.width/6, tela.width/6);
				ctx.drawImage(imgMenu3, tela.width*0.75, 0, tela.width/6, tela.width/6);
			};
			trilha.play();
			//EB

			break;
		case 2: //completou o nivel
			desCelula(1);
			pausado =true;
			atualMenu = 2;
			ultMenu = 2;//ultimo menu acessado
			//MB
			var cont = new Image();
			cont.src = 'img/proximo.png';
			cont.onload = function(){
				ctx.fillStyle = "white";
				ctx.font = (width * 0.2)+"px Serif";
				ctx.textBaseline = "top";
				ctx.shadowColor = "green";
				ctx.shadowOffsetX = 1;
				ctx.shadowOffsetY = 1;
				ctx.shadowBlur = 5;
				ctx.fillText('Success',width*0.5, width * 0.3);
				ctx.drawImage(cont, width*0.34, width * 0.55, width/3, width*0.15);
				ctx.shadowOffsetX = 0; // integer
				ctx.shadowOffsetY = 0; // integer
				ctx.shadowBlur = 0; // integer
				var imgMenu3 = new Image(); //botão de menu
				imgMenu3.src = 'img/menuIcon1.png';
				imgMenu3.onload = function(){
				ctx.fillStyle = 'white';
					ctx.fillRect(tela.width*0.75, 0, tela.width/6, tela.width/6);
					ctx.globalAlpha=0.2;
					ctx.drawImage(imgMenu3, tela.width*0.75, 0, tela.width/6, tela.width/6);
					ctx.globalAlpha=1.0;
					imgPiscar(2);
				};
			};
			break;
		case 3: //Game Over
			desCelula(1);
			pausado =true;
			atualMenu = 3;
			ultMenu = 3;//ultimo menu acessado
			//MB
			var rest = new Image();
			rest.src = 'img/gameOver.png';
			rest.onload = function(){
				ctx.fillStyle = "#ff0000";
				ctx.font = (width * 0.17)+"px Serif";
				ctx.textBaseline = "top";
				ctx.shadowColor = "#000000";
				ctx.shadowOffsetX = 1;
				ctx.shadowOffsetY = 1;
				ctx.shadowBlur = 7;
				ctx.fillText('Game Over',width*0.5, width * 0.3);
				ctx.shadowColor = "green";
				ctx.drawImage(rest, width*0.34, width * 0.55, width/3, width*0.15);
				ctx.shadowOffsetX = 0; // integer
				ctx.shadowOffsetY = 0; // integer
				ctx.shadowBlur = 0; // integer
				var imgMenu3 = new Image(); //botão de menu
				imgMenu3.src = 'img/menuIcon1.png';
				imgMenu3.onload = function(){
					ctx.fillStyle = 'white';
					ctx.fillRect(tela.width*0.75, 0, tela.width/6, tela.width/6);
					ctx.globalAlpha=0.2;
					ctx.drawImage(imgMenu3, tela.width*0.75, 0, tela.width/6, tela.width/6);
					ctx.globalAlpha=1.0;
				};
			};
			break;
		case 4: //terminou o jogo
			desCelula(1);
			pausado = true;
			atualMenu = 4;
			ultMenu = 4;//ultimo menu acessado
			//MB
			var trof = new Image();
			trof.src = 'img/trofeu.png';
			trof.onload = function(){
				var rest = new Image();
				rest.src = 'img/gameOver.png';
				rest.onload = function(){
					ctx.fillStyle = "#ffffff";
					ctx.font = (width * 0.13)+"px Serif";
					ctx.textBaseline = "top";
					ctx.shadowColor = "green";
					ctx.shadowOffsetX = 1;
					ctx.shadowOffsetY = 1;
					ctx.shadowBlur = 7;
					ctx.fillText('Congratulations!',width*0.5, width * 0.3);
					ctx.shadowColor = "green";
					ctx.drawImage(trof, width*0.34, width * 0.45, width/3, (width/3) * trof.height / trof.width);
					ctx.drawImage(rest, width*0.34, width * 0.85, width/3, width*0.15);
					ctx.shadowOffsetX = 0; // integer
					ctx.shadowOffsetY = 0; // integer
					ctx.shadowBlur = 0; // integer
					var imgMenu3 = new Image(); //botão de menu
					imgMenu3.src = 'img/menuIcon1.png';
					imgMenu3.onload = function(){
						ctx.fillStyle = 'white';
						ctx.fillRect(tela.width*0.75, 0, tela.width/6, tela.width/6);
						ctx.globalAlpha=0.2;
						ctx.drawImage(imgMenu3, tela.width*0.75, 0, tela.width/6, tela.width/6);
						ctx.globalAlpha=1.0;
					};
				};
			};
			break;
		case 5: //Pausa o jogo, para sair da pausa ele chama o ultimo menu acessado
			//MB
			atualMenu = 5;
			desCelula(1);
				pausado = true;
				parar = true;
				var rei = new Image();
				rei.src = 'img/gameOver.png';
				rei.onload = function(){
					ctx.fillStyle = "white";
					ctx.font = (width * 0.2)+"px Serif";
					ctx.textBaseline = "top";
					ctx.shadowColor = "green";
					ctx.shadowOffsetX = 1;
					ctx.shadowOffsetY = 1;
					ctx.shadowBlur = 5;
					ctx.fillText('Paused',width*0.5, width * 0.3);
					ctx.drawImage(rei, width*0.34, width * 0.55, width/3, width*0.15);
					ctx.shadowOffsetX = 0; // integer
					ctx.shadowOffsetY = 0; // integer
					ctx.shadowBlur = 0; // integer
					var imgMenu3 = new Image(); //botão de menu
					imgMenu3.src = 'img/menuIcon2.png';
					imgMenu3.onload = function(){
						ctx.fillStyle = 'white';
						ctx.fillRect(tela.width*0.75, 0, tela.width/6, tela.width/6);
						ctx.drawImage(imgMenu3, tela.width*0.75, 0, tela.width/6, tela.width/6);
					};
				};
				trilha.pause();
			break;
		case 6: //Pergunta se deseja reiniciar
			//MB
			atualMenu = 6;
			desCelula(1);
			pausado = true;
			var rSim = new Image();
				rSim.src = 'img/yes.png';
				rSim.onload = function(){
					ctx.fillStyle = "#FFFFFF";
					ctx.font = (width * 0.13)+"px Serif";
					ctx.textBaseline = "top";
					ctx.shadowColor = "blue" // string
					ctx.shadowOffsetX = 1; // integer
					ctx.shadowOffsetY = 1; // integer
					ctx.shadowBlur = 6; // integer
					ctx.fillText('Restart Game?',width*0.5, width * 0.3);
					ctx.drawImage(rSim, width*0.15, width /2, width/4, width*0.18);
				};
			var rNao = new Image();
				rNao.src = 'img/no.png';
				rNao.onload = function(){
					ctx.drawImage(rNao, (width*0.85 - width/4), width /2, width/4, width*0.18);
					ctx.shadowOffsetX = 0;
					ctx.shadowOffsetY = 0;
					ctx.shadowBlur = 0;
				};
			break;
	}
}

function imgPiscar(valor)
{
	switch (valor)
	{
		case 1:
			var imP = new Image();
			imP.src = 'img/proximo2.png';
			imP.onload = function(){
				ctx.drawImage(imP, width*0.34, width * 0.55, width/3, width*0.15);
				funcaoEx[0] = 4; funcaoEx[1] = 2; funcaoEx[4] = 6;
			}
			break;
		case 2:
			var imP = new Image();
			imP.src = 'img/proximo.png';
			imP.onload = function(){
				ctx.drawImage(imP, width*0.34, width * 0.55, width/3, width*0.15);
				funcaoEx[0] = 4; funcaoEx[1] = 1; funcaoEx[4] = 6;
			}
			break;
	}
}

function playAudio(valor)
{
	switch(valor)
	{
		case 1:
			//som emitido ao selecionar a primeira imagem
			if(som2.duration > 0)
			{
				som2.currentTime = 0;
				som2.pause();
			}
			som.play();
			break;
		case 2:
			//som emitido ao selecionar a segunda imagem
			if(som.duration > 0)
			{
				som.currentTime = 0;
				som.pause();
			}
			som2.play();
			break;
		case 3:
			//som de fundo :p
			trilha.pause();
			trilha.currentTime = 0;
			document.getElementById('trilha').src = endTrilha;
			break;
		case 4:
			//toquinho de acerto
			document.getElementById('somAce').src = "/audio/acertou.ogg";
			somAce.play();
			break;
		case 5:
			//som emitido no gameover
			somGO.load();
			somGO.play();
			break;
	}
}

function draw(event)
{
	var largura = event.touches[0].pageX;
	var altura = event.touches[0].pageY;
	//verifica se apertou o botão de menu
	if((altura < (width /6)) && ((largura > width*0.75) && (largura < width*0.75 + width /6)))
	{
		if(pausado)
			preencherMenu(ultMenu);
		else
			preencherMenu(5);
	}else{
		switch(atualMenu)
		{
			case 0:
				if(((altura > (width /2)) && (altura < (width /2 + width*0.15))) && ((largura > width*0.34) && (largura < (width/3 + width*0.34))))
					preencherMenu(1);
				break;
			case 1:
				if((altura > width /4) && (altura < width/4 +((tela.height - width/4) /2))) //metade de cima
				{
					if(altura < width/4 + (((tela.height - width/4) /2)) / 2) //a metade de cima da metade de cima :P
					{
						if(largura < width / 2) //lado esquerdo da metade
						{
							if(largura < width / 4) //lado esquerdo do lado esquerdo (ba dum tiss)
							{
								escolha(0);
							}else{ //lado direito do lado esquerdo
								escolha(1);
							}
						}else{ //lado direito da metade
							if(largura < width * 0.75) //lado esquerdo do lado direito
							{
								escolha(2);
							}else{ //lado direito do lado direito
								escolha(3);
							}
						}
					}else{ //metade de baixo da metade de cima
						if(largura < width / 2) //lado esquerdo da metade
						{
							if(largura < width / 4) //lado esquerdo do lado esquerdo
							{
								escolha(4);
							}else{ //lado direito do lado esquerdo
								escolha(5);
							}
						}else{ //lado direito da metade
							if(largura < width * 0.75) //lado esquerdo do lado direito
							{
								escolha(6);
							}else{ //lado direito do lado direito
								escolha(7);
							}
						}
					//ctx.fillStyle= 'black';
					//ctx.fillRect (largura, altura, 5, 5);
					}
				}else if(altura > width/4 +((tela.height - width/4) /2)){ //metade de baixo
					if(altura < width/4 +((tela.height - width/4) /2) * 1.5) //metade de cima da metade de baixo
					{
						if(largura < width / 2) //lado esquerdo da metade
						{
							if(largura < width / 4) //lado esquerdo do lado esquerdo
							{
								escolha(8);
							}else{ //lado direito do lado esquerdo
								escolha(9);
							}
						}else{ //lado direito da metade
							if(largura < width * 0.75) //lado esquerdo do lado direito
							{
								escolha(10);
							}else{ //lado direito do lado direito
								escolha(11);
							}
						}
					}else{ //metade de baixo da metade de baixo
						if(largura < width / 2) //lado esquerdo da metade
						{
							if(largura < width / 4) //lado esquerdo do lado esquerdo
							{
								escolha(12);
							}else{ //lado direito do lado esquerdo
								escolha(13);
							}
						}else{ //lado direito da metade
							if(largura < width * 0.75) //lado esquerdo do lado direito
							{
								escolha(14);
							}else{ //lado direito do lado direito
								escolha(15);
							}
						}
					}
					//ctx.fillStyle= 'black';
					//ctx.fillRect (largura, altura, 5, 5);
				}
				break;
			case 2:
				if(((altura > (width * 0.55)) && (altura < (width * 0.55 + width*0.15))) && ((largura > width*0.34) && (largura < (width/3 + width*0.34))))
				{
					desCelula(nivel);
					atualMenu = 1;
				}
				break;
			case 3:
				if(((altura > (width * 0.55)) && (altura < (width * 0.55 + width*0.15))) && ((largura > width*0.34) && (largura < (width/3 + width*0.34))))
					recomecar();
				break;
			case 4:
				if(((altura > width * 0.85) && (altura < (width * 0.85 + width*0.15))) && ((largura > width*0.34) && (largura < width*0.34 + width/3)))
					recomecar();
				break;
			case 5:
				if(((altura > (width * 0.55)) && (altura < (width * 0.55 + width*0.15))) && ((largura > width*0.34) && (largura < (width/3 + width*0.34))))
					preencherMenu(6);
				break;
			case 6:
				if((altura > width/2 && altura < (width/2 + width*0.18)) && (largura > width*0.15 && largura <(width*0.15 + width/4)))
					recomecar();
				else if((altura > width/2 && altura < (width/2 + width*0.18)) && (largura > (width*0.85 - width/4) && largura <((width*0.85 - width/4) + width/4)))
					preencherMenu(5);
				break;
		}
	}
}
function splash()
{
	tela = document.getElementById("tela");
	tela.width = screen.width;
	tela.height = screen.height;
	tela.addEventListener("touchstart", draw, false);
	ctx = tela.getContext('2d');
	ctx.fillStyle = "black";
	ctx.fillRect(0, 0, width, screen.height);
	var spl = new Image();
	spl.src = 'img/splash.png';
	spl.onload = function(){
		atualizar();
		ctx.drawImage(spl, 0, 0, tela.width, tela.width * spl.height / spl.width);
		funcaoEx[0] = 0;
		funcaoEx[4] = 30;
	}
}