
	var bks={};
	//bks.wifiDataHTML='';
	//bks.wifiData={};
	//bks.wifiSpotData={};

	//bks.cityList={};
	//bks.cityListHTML='';
	bks.citySpots={};
	//bks.citySpotHTML='';

	//bks.gpsSpots={};
	//bks.gpsSpotsHTML='';

	var bks_locator={};
	bks_locator.currentPos;
	bks_locator.map;

	bks_locator.geo_options_slow = {
	  enableHighAccuracy: true, 
	  maximumAge        : 20000, 
	  timeout           : 20000
	};

	bks_locator.geo_options_quick = {
	  enableHighAccuracy: false, 
	  maximumAge        : 40000, 
	  timeout           : 40000
	};
	
	function byCities()
	{
		$.ajax({
			url: 'http://www.findfreewifi.co.za/publicjson/getcities',
			dataType: 'json',
			success: function(results) {
				//bks.cityList=results.data;
				//bks.cityListHTML='';

				// sort array
				results.data.sort(function(a,b){
					return a.Name.localeCompare(b.Name);
				});
				var html = "";
				//console.log(results.data);
				
				// cities
				html+='<li style="height:25px;"><h2>Cities<h2></li>';	
				for(var i=0;i< results.data.length;i++){
					if(['Cape Town', 'Durban', 'Pretoria', 'Port Elizabeth', 'Johannesburg'].indexOf(results.data[i].Name) !== -1){
						html+='<li><a data-city="'+results.data[i].Name+'" href="#" class="city">';
						html+='<aside data-icon="wifi-4" data-l10n-id="wifi-4"></aside>';
						html+='<p>'+results.data[i].Name+'</p></a></li>';	
					}
					
				}

				//towns	
				html+='<li style="height:25px;"><h2>Towns</h2></li>';	
				for(var i=0;i< results.data.length;i++){
					if(['Cape Town', 'Durban', 'Pretoria', 'Port Elizabeth', 'Johannesburg'].indexOf(results.data[i].Name) !== -1)
						continue;

					html+='<li><a data-city="'+results.data[i].Name+'" href="#" class="city">';
					html+='<aside data-icon="wifi-4" data-l10n-id="wifi-4"></aside>';
					html+='<p>'+results.data[i].Name+'</p></a></li>';
				}				



				$("#cityList").html('');
				$("#cityList").append(html);
				$(".city").click(function(){
					  getSpotsFromCity(this.getAttribute("data-city"));
				 });
			
			},
			error: function() {
				addMsg('Not online');
			}
		});
		
		$("#homeDetail").removeClass('move-up').addClass('move-down');
		$("#detailCities").removeClass('move-down').addClass('move-up');
		var windowHeight = window.innerHeight || document.documentElement.clientHeight|| document.body.clientHeight;
		//console.log(windowHeight);
		$("#cityList").css("overflow-y","auto").css("height", windowHeight-55);

	}
	
	function startup(){
		$("#btnByCities").click(function(){
			$("#detailCities").removeClass('move-down').addClass('move-up');			
			byCities();
		});
		$("#btnNearby").click(function(){			
			getLocation();
		});
		$(".closeBtn").click(function(){
			$(this).parent().parent().removeClass('move-up').addClass('move-down');
			$("#homeDetail").removeClass('move-down').addClass('move-up');
		});


	}
	function getSpotData(id)
	{
		
		var wifiSpotData = {};
		for(var ii=0;ii<bks.citySpots.length;ii++){
			if(bks.citySpots[ii].ID == id){
				wifiSpotData = bks.citySpots[ii];
				break;
			}
		}
			
		if(typeof (wifiSpotData.FullDirection) !== 'undefined'){
			$("#wifiSpotDirections").html(parseFloat(wifiSpotData.DistanceFromMe).toFixed(2) + " kilometers " + wifiSpotData.FullDirection.toLowerCase() + " of me");	
			$("#liDirections").show();
		}
		else{
			$("#liDirections").hide();
		}
		$("#wifiSpotName").html(wifiSpotData.Name);
		$("#wifiSpotCoLocatedService").html(wifiSpotData.CoLocatedService);


		//console.log("time:" + wifiSpotData.ConnectionTimeLimit);
		var timeLimit = "";
		if(wifiSpotData.ConnectionTimeLimit == "0" || wifiSpotData.ConnectionTimeLimit == 0 || wifiSpotData.ConnectionTimeLimit == null || wifiSpotData.ConnectionTimeLimit == "null")
			timeLimit = "No limit";
		else
			timeLimit = wifiSpotData.ConnectionTimeLimit + " minutes";

		$("#wifiSpotConnectionTime").html(timeLimit);

		if(wifiSpotData.ConnectionDataLimit == "undefined")
			$("#wifiSpotConnectionData").html(wifiSpotData.ConnectionDataLimit + " Megs");
		else
			$("#wifiSpotConnectionData").html("Unknown");
		
		$("#wifiSpotAddress").html(wifiSpotData.Address);
		$("#wifiSpotServiceProvider").html(wifiSpotData.ServiceProvider);

		$("#detailDataView").removeClass('move-down').addClass('move-up');
		var windowHeight = window.innerHeight || document.documentElement.clientHeight|| document.body.clientHeight;
		
		$("#spotDetail").css("overflow-y","auto").css("height", windowHeight-55);
		$("#spotDetail li").each(function(i) 
		{
			if($(this).css('display') === 'block'){
				//match the container div height to their outside li
				$(this).attr('style', 'height:'+$(this).children('div').height() +'px!important');
			}
		});

	}

	function getGaiaIcon(colocatedService){
		//console.log(colocatedService);
		var icon = "wifi"
		if(colocatedService == "Restaurant")
			icon = "restaurant";
		else if(colocatedService == "Coffee Shop")
			icon = "coffee";
		else if(colocatedService == "Hotel")
			icon = "hotel";


		return '<aside style="background-image:url(css/images/icons/' + icon + '.png);width:50px;background-repeat: no-repeat;"></aside>';	
		//return '<aside data-icon="wifi-4" data-l10n-id="wifi-4"></aside>';
		//return '<aside style="background-image:url(css/images/icons/wifi.png);width:50px;background-repeat: no-repeat;float:left;position: relative;"></aside>';
		//return "wifi-1"; // <aside data-icon="' + gaiaIcon + '" data-l10n-id="' + gaiaIcon + '"></aside>
	}
	function getSpotsFromCity(cityName)
	{
		bks.citySpots = []; // clear before getting new data to prevent flash of old content
		$("#citySpotList").html('<h2>Busy fetching free  WiFi spots for ' + cityName + '</h2>');

		//console.log('getting for spot:' + spotName);
		$.ajax({
			url: 'http://www.findfreewifi.co.za/publicjson/Locations?cityName=' + cityName + '&topX=50',
			dataType: 'json',
			success: function(results) {
				bks.citySpots = results.data;
				
				var html = "";
				//console.log("data:" , results.data);
				for(var i=0;i< results.data.length;i++){
					var gaiaIcon = getGaiaIcon(results.data[i].CoLocatedService);
					html += '<li class="li-extend">';
					html += gaiaIcon;
					html += '<div>';
					html += '<a data-spot="'+results.data[i].ID+'" href="#" class="spot"><p>'+results.data[i].Name+'</p>';
					html += '<p>' + results.data[i].Address + '</p>';
					if(typeof results.data[i].DistanceFromMe !== "undefined")
						html += '<p>' + parseFloat(results.data[i].DistanceFromMe).toFixed(2) + " kilometers " + results.data[i].FullDirection.toLowerCase() + ' of me</p>';
					html += '</a></div></li>';
				}
				$("#citySpotList").html('');
				$("#citySpotList").append(html);
				$("#citySpotList li").each(function(i) 
				{
					//match the container div height to their outside li
					$(this).attr('style', 'height:'+$(this).children('div').height() +'px!important');
				});
				$(".spot").click(function(){
					  getSpotData(this.getAttribute("data-spot"));
				 });
		
			},
			error: function() {
				addMsg('Not online');
			}
		});
		$("#detailByCity").removeClass('move-down').addClass('move-up');
		var windowHeight = window.innerHeight || document.documentElement.clientHeight|| document.body.clientHeight;
		//console.log(windowHeight);
		$("#citySpotList").css("overflow-y","auto").css("height", windowHeight-55);

	}
	function getLocation(){
		navigator.geolocation.getCurrentPosition(getLocationSuccess, getLocationError, bks_locator.geo_options_quick);
	}
	function getLocationError(error){
		addMsg('Error! Code:  ' + error.code +' Msg: ' + error.message);
	}
	function getLocationSuccess(position)
	{
		 
		   $.ajax({
			url: 'http://www.findfreewifi.co.za/publicjson/locationsnear?lat='+position.coords.latitude+'&lng='+position.coords.longitude,
			dataType: 'json',
			success: function(results) {
				bks.citySpots=results.data;
				var html ='';
				for(var i=0;i< results.data.length;i++){
					var gaiaIcon = getGaiaIcon(results.data[i].CoLocatedService);
					html += '<li class="li-extend">';
					html += gaiaIcon;
					html += '<div>';
					html += '<a data-spot="'+results.data[i].ID+'" href="#" Id="a-'+ results.data[i].ID+'" class="gpsSpot">';
					html += '<p>'+results.data[i].Name+'</p>';
					html += '<p>' + parseFloat(results.data[i].DistanceFromMe).toFixed(2) + " kilometers " + results.data[i].FullDirection + ' of me</p>';
					html += '<p>' + results.data[i].Address + '</p>';
					html += '</a></div></li>';
				}
				$("#citySpotList").html('');//clear old list
				$("#citySpotList").append(html);
				$("#citySpotList li").each(function(i) 
				{
					//match the container div height to their outside li
					$(this).attr('style', 'height:'+$(this).children('div').height() +'px!important');
				});
				$(".gpsSpot").click(function(){
					  getSpotData(this.getAttribute("data-spot"));
				 });
			
			},
			error: function() {
				addMsg('Not online');
			}
		});
		$("#homeDetail").removeClass('move-up').addClass('move-down');
		$("#detailByCity").removeClass('move-down').addClass('move-up');


		var windowHeight = window.innerHeight || document.documentElement.clientHeight|| document.body.clientHeight;
		$("#citySpotList").css("overflow-y","auto").css("height", windowHeight-55);
	
	}
	function addMsg(msg){
        utils.status.show(msg,4000);    
  	}
	window.addEventListener('load', startup, false);


