jQuery.fn.center = function () {
    this.css("position","absolute");
    this.css("top", Math.max(0, (($(window).height() - $(this).height()) / 2) +  $(window).scrollTop()) + "px");
    this.css("left", Math.max(0, (($(window).width() - $(this).width()) / 2) + $(window).scrollLeft()) + "px");
    return this;
}


function isEmpty(obj) {
    for(var prop in obj) {
        if(obj.hasOwnProperty(prop))
            return false;
    }
    return true;
}

Translation.getLang(); //load and initialized Transaltion app see locale.js

var FindMe = {
	'gps': true,

	init : function() {
		//alert('init app');
		$('#appTitle').text(Translation.echo('find me'));
		$('#titleEntrance').text(Translation.echo('tap here for start'));
		$('#appTitle2').text(Translation.echo('find me'));
		$('#title2').text(Translation.echo('you location'));
		$('#textLon').text(Translation.echo('lon'));	
		$('#textLat').text(Translation.echo('lat'));			
		$('#btnGetLocation').text(Translation.echo('refresh'));
	},
	getLocation : function() {
		if ("geolocation" in navigator) {
			navigator.geolocation.getCurrentPosition(this.handle_geolocation_query, this.handle_errors);  
		} else {
		  /* geolocation IS NOT available */
		  alert('you device don\'t have GPS');
		}

	},
	handle_geolocation_query : function(position) {

			$('#textLon').text(position.coords.longitude.toFixed(6));
			$('#textLat').text(position.coords.latitude.toFixed(6));
			
			if (navigator.onLine) {
				var image_url = "http://maps.google.com/maps/api/staticmap?sensor=false&center=" + position.coords.latitude + "," +  
				position.coords.longitude + "&zoom=16&size=300x180&markers=color:red|label:Y|" +  
				position.coords.latitude + ',' + position.coords.longitude;  
				$('#map').attr('src', image_url);
				$('#map').attr('src', image_url);

			} else {
			   //no internet conection
			   $('#map').attr('src', 'img/nomap.png');
			}
			
			$('#viewSpinner').delay(500).fadeOut(200);

	},
	handle_errors : function(error) {
        switch(error.code) {  
            case error.PERMISSION_DENIED: alert("user did not share geolocation data");  
            break;  
            case error.POSITION_UNAVAILABLE: alert("could not detect current position");  
            break;  
            case error.TIMEOUT: alert("retrieving position timedout");  
            break;  
            default: alert("unknown error");  
            break;  
        }
		$('#viewSpinner').delay(1000).fadeOut('slow');
	}
	
	
}

		
$(document).ready(function(){
	
	
	$('#spinner1').center();
	//Invoke Pincode Search API
	FindMe.init();
	//WhatsMyIp.getLocalIp();
	//WhatsMyIp.getExternalIp();

	
	$("#viewState0 .content").click(function(){
		$('#viewState0').hide();
		$('#viewState1').show();
		$("#btnGetLocation").trigger('click');
	}); 
	
	$("#btnGetLocation").click(function(){
		
		$('#viewSpinner').find('img').attr('src', 'img/spinner1.png');
		$('#titleSpinner').text(Translation.echo('loading'));
		$('#viewSpinner').show();

		FindMe.getLocation();
		
	}); 
	


});
  
$(window).resize(function() {
  $('#spinner1').center();
});

  
jQuery(function($) {
$(document).on("click", "a", function(event){ 
	if ((!this.target) || (this.target =='_self')) {
		//alert('internal link');
		event.preventDefault();
		window.location = this.href;
	} else {
		//alert('external link');
	}
  });
});

