"use strict";angular.module("findMyCarApp",["LocalStorageModule","ngRoute","ngAnimate"]).constant("DevOrientationConfig",{throttleRate:3e3}).constant("GeolocationConfig",{enableHighAccuracy:!0,maximumAge:1e4,timeout:4e4}).constant("locateCarConfig",{accuracyLimit:35}).config(["$compileProvider",function(a){a.aHrefSanitizationWhitelist(/^\s*(app|https?|ftp|mailto|chrome-extension):/)}]).config(["$routeProvider",function(a){a.when("/",{templateUrl:"views/main.html",controller:"MainCtrl"}).when("/locate",{templateUrl:"views/locate.html",controller:"LocateCarCtrl"}).when("/compass",{templateUrl:"views/compass.html",controller:"CarCompassCtrl"}).otherwise({redirectTo:"/"})}]),angular.module("findMyCarApp").controller("MainCtrl",["$scope","localStorageService","geolocation",function(a,b,c){a.carPosition=b.get("car-position"),a.locationServicesAvailable="geolocation"in navigator,a.deviceOrientationAvailable="DeviceOrientationEvent"in window;var d=function(b){a.locationRecieved=b};c.getCurrent(_.partial(d,!0),_.partial(d,!1))}]),angular.module("findMyCarApp").controller("CarCompassCtrl",["$scope","geolocation","deviceOrientation","localStorageService",function(a,b,c,d){a.northBasedDirection=0,a.showInfo=!1;var e=function(b){a.direction={transform:"rotate("+b+"deg)","-ms-transform":"rotate("+b+"deg)","-webkit-transform":"rotate("+b+"deg)"}},f=function(b){a.coords=b.coords,a.carPosition=d.get("car-position");var c=new OpenLayers.LonLat(a.carPosition.longitude,a.carPosition.latitude),e=new OpenLayers.LonLat(b.coords.longitude,b.coords.latitude);a.northBasedDirection=OpenLayers.Spherical.computeHeading(e,c)},g=function(b){a.$apply(function(){a.orientation=b.alpha,a.angle=360-a.northBasedDirection-b.alpha,e(a.angle)})};a.$on("$destroy",function(){c.removeListener(g),b.removeListener(f)}),b.watch(f),c.watch(g)}]),angular.module("findMyCarApp").controller("LocateCarCtrl",["$scope","localStorageService","geolocation","locateCarConfig",function(a,b,c,d){a.carPosition=b.get("car-position"),a.showInfo=!1,a.targetAccuracy=d.accuracyLimit,a.accuracy="∞";var e=function(a){b.set("car-position",{latitude:a.coords.latitude,longitude:a.coords.longitude})},f=function(a){return a.coords.accuracy<d.accuracyLimit},g=function(b){f(b)&&(e(b),a.$apply(function(){a.positionUpdated=!0}))},h=function(b){a.$apply(function(){a.accuracy=b.coords.accuracy})};a.$on("$destroy",function(){c.removeListener(g),c.removeListener(h)}),c.watch(g),c.watch(h)}]),angular.module("findMyCarApp").service("geolocation",["GeolocationConfig",function(a){var b,c=[],d=function(a){for(var b=0;b<c.length;++b)c[b](a)};return{watch:function(e){b||(b=navigator.geolocation.watchPosition(d,function(a){console.warn("Position update failed",a)},a)),c.push(e)},getCurrent:function(a,b){return navigator.geolocation.getCurrentPosition(a,b)},removeListener:function(a){c=_.without(c,a),_.isEmpty(c)&&(navigator.geolocation.clearWatch(b),b=void 0)}}}]),angular.module("findMyCarApp").service("deviceOrientation",["DevOrientationConfig",function(a){return{watch:function(b){window.addEventListener("deviceorientation",_.throttle(b,a.throttleRate,{trailing:!1}),!0)},removeListener:function(a){window.removeEventListener("deviceorientation",a)}}}]);var scene=document.getElementById("scene");new Parallax(scene,{calibrateY:!0,invertY:!0,scalarY:0});