// Hide and Seek Configuration File


// Datatypes
// ------------------------------------------------------------------
//
// Boolean
// Booleans have two possible values true or false.
//     Example:
//         value: true
// Number
// Numbers can be represented as whole numbers or decimals.
//     Example:
//         x: -20
//         alpha: 0.4
//
// String
// String are described with quotes surrounding zero or more characters.
//     Example:
//         filename: "image1.png"
//
// Object 
// Objects are described with curly brackets surrounding 'name: value' pairs delimited by commas.
//     Example:
//         {
//             name1: value1,
//             name2: value2
//         }
//
// Array
// Arrays are described with square brackets surrounding values delimited by commas.
//     Example:
//         [
//             value1,
//             value2
//         ]

// Framework Properties
// ------------------------------------------------------------------
//
// View Properties
//     type (String)
//     filename (String): The url of image of the view is defined by the resourcePath and the filename.
//     x (Number): Location of view relative to the left of the viewport.
//     y (Number): Location of view relative to the top of the viewport.
//     offsetX (Number): Distance in pixels the image is shifted right.
//     offsetY (Number): Distance in pixels the image is shifted down.
//     numFrames (Number): Number of frames of animation. If this property is set and greater than one, the view will be a sprite.
//     frameRate (Number): Delay between frames of animation (in 1 / 60 second increments).
//         Example:
//              frameRate: 60 // The delay between frames is one second
//              frameRate: 10 // The delay between frames is on 10 / 60 or 0.6 seconds
//     loop (Boolean): If true the animation will continue to play indefinitely after started until stopped.
//     draggable (Boolean): If true the view will follow the cursor position between the touch start and touch end.
//     alpha (Number): Amount of transparency amount ranging from 0 (completely transparent) to 0.5 to 1 (completely opaque). 
//         Example:
//              alpha: 0.5 // View will be rendered at half transparency
//     ignoreTransparentPixels (Boolean): If true the hotspot will register only if the pixel's alpha component under touch position is greater than 0.
//     hotspots (Array):  Array of bounding rectangles that will act as the hotspot for the view if specified.
//         Example:
//              hotspots: [
//					{x: 38, y: 0, width: 161, height: 45},
//					{x: 9, y: 45, width: 201, height: 51}
//              ]
//     hotspotsVisible (Boolean): If true the hotspot rectangles of the view will be outlined. This is used for debug purposes only. 
//     states (Array): Array of views that describe specific states of the view.
//         Example:
//             states: [
//					{
//						type: "ON",
//						filename: "light-switch-on.png"
//					},{
//						type: "OFF",
//						filename: "light-switch-off.png"
//					}
//				]
//
// Audio Properties
//     states (Array): Array of audio sprites.
//         State Properties:
//             name (String): Type of audio state. 
//             startTime (Number): Start time of the state in seconds.
//             duration (Number): The duration of the state in seconds.
//             loop (Boolean): If true the state will loop.
//         Example:
//             states: [
//                 {
//                     type: "intro", 
//                     startTime: 0,
//                     duration: 3
//                 },
//  
// Game Properties
//     element (HTML Element): The HTML element in which the game will be populated. Usually a div element.
//         Example:
//              element: window.document.getElementById("game"),
//     device (String): What device the game is launched in (e.g. "IPHONE", "IPAD").
//     resourcePath (String): The url where all resources are relative to. Note the "/" is required.
//         Example:
//             resourcePath: "resources/"
//.    deviceOffset (Object):
//         Example:
//             deviceOffset: {
//.                iPhone: {x: -32, y: -64}
//.            }
//     rounds (Array): An array of objects containing each round's properties.
//	   startImageFilename (String): The url of image title card show at the beginning of the game.
//     audioEnabled (Boolean): If false audio will not be loaded or played.
//     audioFilename (String): The url of the audio file.

// Hide and Seek Specific Properties
// ------------------------------------------------------------------
//
// Game Properties
//
//     hud
//         Properties:
//             sidebar: Displays the number of targets found for the current round.
//                 Available States:
//                     DEFAULT: Only currently supported state.
//     audio
//         Available States:
//             INTRO: Played at the beginning of each round.
//             PAYOFF: Played after all the hidden items are found.
//             MUSIC: Loops in the background.
//			   CORRECT_HIT: Plays when a target item is touched.
//         
// Round Properties
//
//     background
//         Properties:
//            filename: Filename of the background image.
//     items: A random item is selected at the start of each round to be the correct item.
//         Available States:
//             HIDDEN: Initial state of the label.
//             DRAG: Displayed when the item is being dragged.
//             FOUND: Displayed after the item is found.
//         Properties:
//             mask: Optional view coupled with an item.
//                 Properties:
//                     wiggleOnTouch (Boolean): A touch will cause the mask's item to vibrate.
//                     foundOnTouch (Boolean): A touch will cause the mask' item to be found.
//                     touchDisabled (Boolean): Touch events on the mask will be ignored.

WM.config = {
	resourcePath: "resources/",
	deviceOffset: { //chopping of the BG image to iPhone size specs. Image BG must be 1024x768
		iPhone: {
			x: -32,
			y: -89
		}
	},
	gameIcon: "mozilla_thumb_256x256_FindTheFoods.png",
	loadingImageWhiteFilename: "loading-white.png",
	loadingImageColorFilename: "loading-color.png",
	landscapeOnlyFilename: "landscape-only.png",
	exitButtonFilename: "exit-button.png",
	startImageFilename: "HTML5_startscreen_findthefoods.jpg",
	audioEnabled: true,
	audioFilename: "audio-hideSeek-food.mp3",
	audio: { //all audio including intro, payoff, and music
		states: [
			{
				name: "intro",
				startTime: 0,
				duration: 3
			}, {
				name: "payoff",
				startTime: 4,
				duration: 4.4
			},
			{
				name: "music", 
				startTime: 10,
				duration: 20.4,
				loop: true
			}
		]
	},
	rounds: [
		{ //Round 1
			background: {
				filename: "Background-bert-ernie-kitchen.png"
			},
			itemGroups: [
				{
					items: [
						{
							states: [
								{
									type: "Hidden", //the item appearing in its hidden state, can be partial image
									filename: "Banana.png", //make a rectangle marquee in Photoshop to get the bounding rectangle of the object and export as transparent png
									x: 676, //x,y coordinates of objects can be found by opening the object in Photoshop, add on a layer mask to show the bounding rectangle, take the ruler tool and measure from top to bottom. Take this number and subtract 100 px. The x,y coordinates will then be placed here.
									y: 205
								},{
									type: "Drag", //item appearing in draggable state, should be full image even if hidden was partial
									filename: "Banana.png",
									x: 676,
									y: 205,
									draggable: true
								},{
									type: "Found", //found animation
									filename: "banana_found.png",
									x: 638,
									y: 107,
									numFrames: 12
								}
							],
							mask: { //export the mask item covering above state and add 10px to each side of the image to allow for wiggle
								foundOnTouch: true,
								states: [
									{
										type: "Default",
										filename: "Banana-mask.png",
										x: 666, //original x,y coordinates - does not include the added 10px
										y: 155
									},{
										type: "SWIPE_RIGHT",
										filename: "Banana-open-cupboard.png",
										x: 760,
										y: 157,
										draggable: false
									}
								]
							}
						}, {
							states: [
								{
									type: "Hidden",
									filename: "Beet.png",
									x: 864,
									y: 214
								},{
									type: "Drag",
									filename: "Beet.png",
									x: 864,
									y: 214,
									draggable: true
								},{
									type: "Found",
									filename: "beet1_found.png",
									x: 848,
									y: 165,
									numFrames: 14
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "Beet-mask.png",
										x: 854,
										y: 204
									}
								]
							}
						}, {
							states: [
								{
									type: "Hidden",
									filename: "Blueberries.png",
									x: 625,
									y: 385
								},{
									type: "Drag",
									filename: "Blueberries.png",
									x: 625,
									y: 385,
									draggable: true
								},{
									type: "Found",
									filename: "blueberries1_found.png",
									x: 608,
									y: 304,
									numFrames: 20
								}
							],
							mask: {
								wiggleOnTouch: true,
								foundOnTouch: false,
								states: [
									{
										type: "Default",
										filename: "Blueberries-mask.png",
										x: 596,
										y: 337,
										draggable: true,
										ignoreTransparentPixels: true
									}
								]
							}
						}, {
							states: [
								{
									type: "Hidden",
									filename: "Carrot.png",
									x: 30,
									y: 194
								},{
									type: "Drag",
									filename: "Carrot.png",
									x: 30,
									y: 194,
									draggable: true
								},{
									type: "Found",
									filename: "carrot1_found.png",
									x: 10,
									y: 105,
									numFrames: 16
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "Carrot-mask.png",
										x: 20,
										y: 184
									}
								]
							}
						}, {
							states: [
								{
									type: "Hidden",
									filename: "Eggplant.png",
									x: 230,
									y: 212
								},{
									type: "Drag",
									filename: "Eggplant.png",
									x: 230,
									y: 212,
									draggable: true
								},{
									type: "Found",
									filename: "eggplant1_found.png",
									x: 220,
									y: 152,
									numFrames: 25
								}
							],
							mask: {
								foundOnTouch: true,
								states: [
									{
										type: "Default",
										filename: "Eggplant-mask.png",
										x: 180,
										y: 155
									}, {
										type: "SWIPE_LEFT",
										filename: "Eggplant-open-cupboard.png",
										x: 120,
										y: 157,
										draggable: false
									}
								]
							}
						}, {
							states: [
								{
									type: "Hidden",
									filename: "Oranges.png",
									x: 643,
									y: 522
								},{
									type: "Drag",
									filename: "Oranges.png",
									x: 643,
									y: 522,
									draggable: true
								},{
									type: "Found",
									filename: "oranges_found.png",
									x: 630,
									y: 497,
									numFrames: 20
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "Oranges-mask.png",
										x: 633,
										y: 512
									}
								]
							}
						}, {
							states: [
								{
									type: "Hidden",
									filename: "Oscar-hidden-with-milk.png",
									x: 110,
									y: 458
								},{
									type: "Drag",
									filename: "Oscar-hidden-with-milk.png",
									x: 110,
									y: 458,
									draggable: true
								},{
									type: "Found",
									filename: "Oscar_drinks_v05_spritesheet.png",
									x: 90,
									y: 368,
									numFrames: 24
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "Oscar-with-milk-mask.png",
										x: 100,
										y: 448
									}
								]
							}
						}, {
							states: [
								{
									type: "Hidden",
									filename: "Peas.png",
									x: 396,
									y: 474
								},{
									type: "Drag",
									filename: "Peas.png",
									x: 396,
									y: 474,
									draggable: true
								},{
									type: "Found",
									filename: "peas_found.png",
									x: 379,
									y: 405,
									numFrames: 15
								}
							],
							mask: {
								wiggleOnTouch: true,
								foundOnTouch: false,
								states: [
									{
										type: "Default",
										filename: "Peas-mask.png",
										x: 386,
										y: 464,
										draggable: true,
										ignoreTransparentPixels: true
									}
								]
							}
						}, {
							states: [
								{
									type: "Hidden",
									filename: "Tomato.png",
									x: 864,
									y: 408
								},{
									type: "Drag",
									filename: "Tomato.png",
									x: 864,
									y: 408,
									draggable: true
								},{
									type: "Found",
									filename: "tomato_found.png",
									x: 800,
									y: 270,
									numFrames: 22
								}
							],
							mask: {
								wiggleOnTouch: true,
								foundOnTouch: false,
								states: [
									{
										type: "Default",
										filename: "Tomato-mask.png",
										x: 852,
										y: 376,
										draggable: true,
										ignoreTransparentPixels: true
									}
								]
							}
						}, {
							states: [
								{
									type: "Hidden",
									filename: "Watermelon.png",
									x: 490,
									y: 288
								},{
									type: "Drag",
									filename: "Watermelon.png",
									x: 490,
									y: 288,
									draggable: true
								},{
									type: "Found",
									filename: "watermelon_found.png",
									x: 470,
									y: 192,
									numFrames: 14
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "Watermelon-mask.png",
										x: 480,
										y: 278
									}
								]
							}
						}
					]
				}
			]
		}, { //Round 2
			background: {
				filename: "Background-hoopers-store.png"
			},
			itemGroups: [
				{
					items: [
						{
							states: [
								{
									type: "Hidden",
									filename: "Apple.png",
									x: 597,
									y: 509
								},{
									type: "Drag",
									filename: "Apple.png",
									x: 597,
									y: 509,
									draggable: true
								},{
									type: "Found",
									filename: "apple1_found.png",
									x: 565,
									y: 413,
									numFrames: 12
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "Apple-mask.png",
										x: 587,
										y: 499
									}
								]
							}
						}, {
							states: [
								{
									type: "Hidden",
									filename: "Blueberries.png",
									x: 349,
									y: 130
								},{
									type: "Drag",
									filename: "Blueberries.png",
									x: 349,
									y: 130,
									draggable: true
								},{
									type: "Found",
									filename: "blueberries2_found.png",
									x: 330,
									y: 48,
									numFrames: 20
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "Blueberries-mask-2.png",
										x: 339,
										y: 122
									}
								]
							}
						}, {
							states: [
								{
									type: "Hidden",
									filename: "Bread.png",
									x: 851,
									y: 368
								},{
									type: "Drag",
									filename: "Bread.png",
									x: 851,
									y: 368,
									draggable: true
								},{
									type: "Found",
									filename: "bread1_found.png",
									x: 823,
									y: 348,
									numFrames: 14
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "Bread-mask.png",
										x: 841,
										y: 358
									}
								]
							}
						}, {
							states: [
								{
									type: "Hidden",
									filename: "Eggplant.png",
									x: 402,
									y: 414
								},{
									type: "Drag",
									filename: "Eggplant.png",
									x: 402,
									y: 414,
									draggable: true
								},{
									type: "Found",
									filename: "eggplant2_found.png",
									x: 390,
									y: 360,
									numFrames: 25
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "Eggplant-mask-2.png",
										x: 392,
										y: 404
									}
								]
							}
						}, {
							states: [
								{
									type: "Hidden",
									filename: "Onion.png",
									x: 856,
									y: 520
								},{
									type: "Drag",
									filename: "Onion.png",
									x: 856,
									y: 520,
									draggable: true
								},{
									type: "Found",
									filename: "onion_found.png",
									x: 835,
									y: 395,
									numFrames: 15
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "Onion-mask.png",
										x: 846,
										y: 510
									}
								]
							}
						}, {
							states: [
								{
									type: "Hidden",
									filename: "Oscar-with-banana.png",
									x: 141,
									y: 506
								},{
									type: "Drag",
									filename: "Oscar-with-banana.png",
									x: 141,
									y: 506,
									draggable: true
								},{
									type: "Found",
									filename: "Oscar_banana_v07_spritesheet.png",
									x: 72,
									y: 428,
									numFrames: 24
								}
							],
							mask: {
								foundOnTouch: true,
								states: [
									{
										type: "Default",
										filename: "Oscar-mask-2.png",
										x: 86,
										y: 352
									}, {
										type: "SWIPE_LEFT",
										filename: "Oscar-mask-2-open-door.png",
										x: 0,
										y: 355,
										draggable: false
									}
								]
							}
						}, {
							states: [
								{
									type: "Hidden",
									filename: "Pumpkin.png",
									x: 655,
									y: 359
								},{
									type: "Drag",
									filename: "Pumpkin.png",
									x: 655,
									y: 359,
									draggable: true
								},{
									type: "Found",
									filename: "pumpkin_found.png",
									x: 630,
									y: 299,
									numFrames: 15
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "Pumpkin-mask.png",
										x: 645,
										y: 349
									}
								]
							}
						}, {
							states: [
								{
									type: "Hidden",
									filename: "Strawberries.png",
									x: 118,
									y: 119
								},{
									type: "Drag",
									filename: "Strawberries.png",
									x: 118,
									y: 119,
									draggable: true
								},{
									type: "Found",
									filename: "strawberries_found.png",
									x: 98,
									y: 105,
									numFrames: 15
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "Strawberries-mask.png",
										x: 108,
										y: 109
									}
								]
							}
						}
					]
				}
			]
		}, { //Round 3
			background: {
				filename: "Background-Hoopers-Inside-1.png"
			},
			itemGroups: [
				{
					items: [
						{
							states: [
								{
									type: "Hidden",
									filename: "Apple-in-basket.png",
									x: 33,
									y: 529
								},{
									type: "Drag",
									filename: "Apple-in-basket.png",
									x: 33,
									y: 529,
									draggable: true
								},{
									type: "Found",
									filename: "apple1_found.png",
									x: 1,
									y: 430,
									numFrames: 12
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "Apple-basket-mask.png",
										x: 33,
										y: 529
									}
								]
							}
						},
						{
							states: [
								{
									type: "Hidden",
									filename: "Beet-2.png",
									x: 810,
									y: 551
								},{
									type: "Drag",
									filename: "Beet-2.png",
									x: 810,
									y: 551,
									draggable: true
								},{
									type: "Found",
									filename: "beet2_found.png",
									x: 785,
									y: 531,
									numFrames: 14
								}
							],
							mask: {
								wiggleOnTouch: true,
								foundOnTouch: false,
								states: [
									{
										type: "Default",
										filename: "Beet-mask-2.png",
										x: 800,
										y: 541,
										draggable: true,
										ignoreTransparentPixels: true
									}
								]
							}
						}, {
							states: [
								{
									type: "Hidden",
									filename: "Blueberries.png",
									x: 868,
									y: 465
								},{
									type: "Drag",
									filename: "Blueberries.png",
									x: 868,
									y: 465,
									draggable: true
								},{
									type: "Found",
									filename: "blueberries2_found.png",
									x: 854,
									y: 384,
									numFrames: 20
								}
							],
							mask: {
								wiggleOnTouch: true,
								foundOnTouch: false,
								states: [
									{
										type: "Default",
										filename: "Blueberries-mask-3.png",
										x: 858,
										y: 341,
										draggable: true,
										ignoreTransparentPixels: true
									}
								]
							}
						}, {
							states: [
								{
									type: "Hidden",
									filename: "Broccoli.png",
									x: 34,
									y: 238
								},{
									type: "Drag",
									filename: "Broccoli.png",
									x: 34,
									y: 238,
									draggable: true
								},{
									type: "Found",
									filename: "broccoli1_found.png",
									x: 5,
									y: 215,
									numFrames: 10
								}
							],
							mask: {
								wiggleOnTouch: true,
								foundOnTouch: false,
								states: [
									{
										type: "Default",
										filename: "Broccoli-mask.png",
										x: 24,
										y: 228,
										draggable: true,
										ignoreTransparentPixels: true
									}
								]
							}
						}, {
							states: [
								{
									type: "Hidden",
									filename: "Carrot-2.png",
									x: 269,
									y: 358
								},{
									type: "Drag",
									filename: "Carrot-2.png",
									x: 269,
									y: 358,
									draggable: true
								},{
									type: "Found",
									filename: "carrot2_found.png",
									x: 249,
									y: 280,
									numFrames: 16
								}
							],
							mask: {
								wiggleOnTouch: true,
								foundOnTouch: false,
								states: [
									{
										type: "Default",
										filename: "Carrot-mask-2.png",
										x: 247,
										y: 347,
										draggable: true,
										ignoreTransparentPixels: true
									}
								]
							}
						}, {
							states: [
								{
									type: "Hidden",
									filename: "Eggplant-2.png",
									x: 365,
									y: 146
								},{
									type: "Drag",
									filename: "Eggplant-2.png",
									x: 365,
									y: 146,
									draggable: true
								},{
									type: "Found",
									filename: "eggplant3_found.png",
									x: 355,
									y: 81,
									numFrames: 25
								}
							],
							mask: {
								wiggleOnTouch: true,
								foundOnTouch: false,
								states: [
									{
										type: "Default",
										filename: "Eggplant-mask-3.png",
										x: 325,
										y: 127,
										draggable: true,
										ignoreTransparentPixels: true
									}
								]
							}
						}, {
							states: [
								{
									type: "Hidden",
									filename: "Oscar-with-Tomato.png",
									x: 488,
									y: 430
								},{
									type: "Drag",
									filename: "Oscar-with-Tomato.png",
									x: 488,
									y: 430,
									draggable: true
								},{
									type: "Found",
									filename: "Oscar_tomato_v06_spritesheet.png",
									x: 468,
									y: 333,
									numFrames: 16
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "Oscar-mask-3.png",
										x: 478,
										y: 420
									}
								]
							}
						}, {
							states: [
								{
									type: "Hidden",
									filename: "Pineapple.png",
									x: 757,
									y: 211
								},{
									type: "Drag",
									filename: "Pineapple.png",
									x: 757,
									y: 211,
									draggable: true
								},{
									type: "Found",
									filename: "pineapple1_found.png",
									x: 730,
									y: 178,
									numFrames: 17
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "Pineapple-mask.png",
										x: 747,
										y: 201
									}
								]
							}
						}, {
							states: [
								{
									type: "Hidden",
									filename: "Raspberries.png",
									x: 132,
									y: 180
								},{
									type: "Drag",
									filename: "Raspberries.png",
									x: 132,
									y: 180,
									draggable: true
								},{
									type: "Found",
									filename: "raspberries_found.png",
									x: 115,
									y: 110,
									numFrames: 17
								}
							],
							mask: {
								wiggleOnTouch: true,
								foundOnTouch: false,
								states: [
									{
										type: "Default",
										filename: "Raspberries-mask.png",
										x: 122,
										y: 115,
										draggable: true,
										ignoreTransparentPixels: true
									}
								]
							}
						}
					]
				}
			]
		}, { //Round 4
			background: {
				filename: "Background-hoopers-store-inside-1.png"
			},
			itemGroups: [
				{
					items: [
						{
							states: [
								{
									type: "Hidden",
									filename: "Beet-3.png",
									x: 824,
									y: 492
								},{
									type: "Drag",
									filename: "Beet-3.png",
									x: 824,
									y: 492,
									draggable: true
								},{
									type: "Found",
									filename: "beet3_found.png",
									x: 790,
									y: 447,
									numFrames: 14
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "Beet-mask-3.png",
										x: 814,
										y: 482
									}
								]
							}
						},
						{
							states: [
								{
									type: "Hidden",
									filename: "Blueberries.png",
									x: 720,
									y: 364
								},{
									type: "Drag",
									filename: "Blueberries.png",
									x: 720,
									y: 364,
									draggable: true
								},{
									type: "Found",
									filename: "blueberries1_found.png",
									x: 703,
									y: 283,
									numFrames: 20
								}
							]
						},
						{
							states: [
								{
									type: "Hidden",
									filename: "Broccoli-2.png",
									x: 413,
									y: 321
								},{
									type: "Drag",
									filename: "Broccoli-2.png",
									x: 413,
									y: 321,
									draggable: true
								},{
									type: "Found",
									filename: "broccoli2_found.png",
									x: 390,
									y: 300,
									numFrames: 10
								}
							],
							mask: {
								wiggleOnTouch: true,
								foundOnTouch: false,
								states: [
									{
										type: "Default",
										filename: "Broccoli-mask-2.png",
										x: 398,
										y: 309,
										draggable: true,
										ignoreTransparentPixels: true
									}
								]
							}
						},
						{
							states: [
								{
									type: "Hidden",
									filename: "Corn.png",
									x: 419,
									y: 566
								},{
									type: "Drag",
									filename: "Corn.png",
									x: 419,
									y: 566,
									draggable: true
								},{
									type: "Found",
									filename: "corn1_found.png",
									x: 400,
									y: 400,
									numFrames: 18
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "Corn-mask.png",
										x: 409,
										y: 556
									}
								]
							}
						},
						{
							states: [
								{
									type: "Hidden",
									filename: "Eggplant-4.png",
									x: 906,
									y: 319
								},{
									type: "Drag",
									filename: "Eggplant-4.png",
									x: 906,
									y: 319,
									draggable: true
								},{
									type: "Found",
									filename: "eggplant1_found.png",
									x: 890,
									y: 260,
									numFrames: 25
								}
							],
							mask: {
								wiggleOnTouch: true,
								foundOnTouch: false,
								states: [
									{
										type: "Default",
										filename: "Eggplant-mask-4.png",
										x: 896,
										y: 309,
										draggable: true,
										ignoreTransparentPixels: true
									}
								]
							}
						},
						{
							states: [
								{
									type: "Hidden",
									filename: "Oscar-with-carrot.png",
									x: 57,
									y: 456
								},{
									type: "Drag",
									filename: "Oscar-with-carrot.png",
									x: 57,
									y: 456,
									draggable: true
								},{
									type: "Found",
									filename: "Oscar_carrot_v09_spritesheet.png",
									x: 8,
									y: 345,
									numFrames: 24
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "Oscar-mask-4.png",
										x: 47,
										y: 446
									}
								]
							}
						},
						{
							states: [
								{
									type: "Hidden",
									filename: "Pineapple-2.png",
									x: 418,
									y: 149
								},{
									type: "Drag",
									filename: "Pineapple-2.png",
									x: 418,
									y: 149,
									draggable: true
								},{
									type: "Found",
									filename: "pineapple2_found.png",
									x: 408,
									y: 119,
									numFrames: 17
								}
							],
							mask: {
								wiggleOnTouch: true,
								foundOnTouch: false,
								states: [
									{
										type: "Default",
										filename: "Pineapple-mask-2.png",
										x: 398,
										y: 140,
										draggable: true,
										ignoreTransparentPixels: true
									}
								]
							}
						},
						{
							states: [
								{
									type: "Hidden",
									filename: "Strawberries-2.png",
									x: 667,
									y: 215
								},{
									type: "Drag",
									filename: "Strawberries-2.png",
									x: 667,
									y: 215,
									draggable: true
								},{
									type: "Found",
									filename: "strawberries_found.png",
									x: 650,
									y: 203,
									numFrames: 15
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "Strawberries-mask-2.png",
										x: 657,
										y: 205
									}
								]
							}
						},
						{
							states: [
								{
									type: "Hidden",
									filename: "Watermelon-2.png",
									x: 149,
									y: 184
								},{
									type: "Drag",
									filename: "Watermelon-2.png",
									x: 149,
									y: 184,
									draggable: true
								},{
									type: "Found",
									filename: "watermelon_found.png",
									x: 130,
									y: 84,
									numFrames: 14
								}
							],
							mask: {
								wiggleOnTouch: true,
								foundOnTouch: false,
								states: [
									{
										type: "Default",
										filename: "Watermelon-mask-2.png",
										x: 130,
										y: 174,
										draggable: true,
										ignoreTransparentPixels: true
									}
								]
							}
						}			
					]
				}
			]
		}, { //Round 5
			background: {
				filename: "Background-Hoopers-Store-Inside-3.png"
			},
			itemGroups: [
				{
					items: [
						{
							states: [
								{
									type: "Hidden",
									filename: "Apple-2.png",
									x: 310,
									y: 211
								},{
									type: "Drag",
									filename: "Apple-2.png",
									x: 310,
									y: 211,
									draggable: true
								},{
									type: "Found",
									filename: "apple2_found.png",
									x: 276,
									y: 111,
									numFrames: 12
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "Apple-mask-2.png",
										x: 300,
										y: 201
									}
								]
							}
						},
						{
							states: [
								{
									type: "Hidden",
									filename: "Bread-2.png",
									x: 562,
									y: 487
								},{
									type: "Drag",
									filename: "Bread-2.png",
									x: 562,
									y: 487,
									draggable: true
								},{
									type: "Found",
									filename: "bread2_found.png",
									x: 529,
									y: 445,
									numFrames: 14
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "Bread-mask-2.png",
										x: 552,
										y: 477
									}
								]
							}
						},
						{
							states: [
								{
									type: "Hidden",
									filename: "Carrot-3.png",
									x: 445,
									y: 320
								},{
									type: "Drag",
									filename: "Carrot-3.png",
									x: 445,
									y: 320,
									draggable: true
								},{
									type: "Found",
									filename: "carrot3_found.png",
									x: 425,
									y: 228,
									numFrames: 16
								}
							],
							mask: {
								wiggleOnTouch: true,
								foundOnTouch: false,
								states: [
									{
										type: "Default",
										filename: "Carrot-mask-3.png",
										x: 434,
										y: 297,
										draggable: true,
										ignoreTransparentPixels: true
									}
								]
							}
						},
						{
							states: [
								{
									type: "Hidden",
									filename: "Corn-2.png",
									x: 626,
									y: 260
								},{
									type: "Drag",
									filename: "Corn-2.png",
									x: 626,
									y: 260,
									draggable: true
								},{
									type: "Found",
									filename: "corn2_found.png",
									x: 575,
									y: 105,
									numFrames: 18
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "Corn-mask-2.png",
										x: 616,
										y: 250
									}
								]
							}
						},
						{
							states: [
								{
									type: "Hidden",
									filename: "Grapes.png",
									x: 141,
									y: 295
								},{
									type: "Drag",
									filename: "Grapes.png",
									x: 141,
									y: 295,
									draggable: true
								},{
									type: "Found",
									filename: "grape_found.png",
									x: 108,
									y: 260,
									numFrames: 12
								}
							],
							mask: {
								wiggleOnTouch: true,
								foundOnTouch: false,
								states: [
									{
										type: "Default",
										filename: "Grapes-mask.png",
										x: 126,
										y: 285,
										draggable: true,
										ignoreTransparentPixels: true
									}
								]
							}
						},
						{
							states: [
								{
									type: "Hidden",
									filename: "Oranges.png",
									x: 729,
									y: 475
								},{
									type: "Drag",
									filename: "Oranges.png",
									x: 729,
									y: 475,
									draggable: true
								},{
									type: "Found",
									filename: "oranges_found.png",
									x: 714,
									y: 440,
									numFrames: 20
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "Oranges-mask-2.png",
										x: 719,
										y: 465
									}
								]
							}
						},
						{
							states: [
								{
									type: "Hidden",
									filename: "Oscar-with-watermelon.png",
									x: 180,
									y: 484
								},{
									type: "Drag",
									filename: "Oscar-with-watermelon.png",
									x: 180,
									y: 484,
									draggable: true
								},{
									type: "Found",
									filename: "Oscar_watermelon_v05_spritesheet.png",
									x: 132,
									y: 383,
									numFrames: 24
								}
							],
							mask: {
								touchDisabled: true,
								states: [
									{
										type: "Default",
										filename: "Oscar-mask-5.png",
										x: 170,
										y: 474
									}
								]
							}
						},
						{
							states: [
								{
									type: "Hidden",
									filename: "Peas.png",
									x: 108,
									y: 181
								},{
									type: "Drag",
									filename: "Peas.png",
									x: 108,
									y: 181,
									draggable: true
								},{
									type: "Found",
									filename: "peas_found.png",
									x: 92,
									y: 112,
									numFrames: 15
								}
							]
						},
						{
							states: [
								{
									type: "Hidden",
									filename: "Strawberries.png",
									x: 895,
									y: 391
								},{
									type: "Drag",
									filename: "Strawberries.png",
									x: 895,
									y: 391,
									draggable: true
								},{
									type: "Found",
									filename: "strawberries_found.png",
									x: 875,
									y: 376,
									numFrames: 15
								}
							],
							mask: {
								wiggleOnTouch: true,
								foundOnTouch: false,
								states: [
									{
										type: "Default",
										filename: "Strawberries-mask-3.png",
										x: 875,
										y: 342,
										draggable: true,
										ignoreTransparentPixels: true
									}
								]
							}
						}
					]
				}
			]
		}
	]
};