(function(window, undefined){

var gs = [];
var interval = setInterval(function(){
	for (i in gs)
		gs[i].run();
}, 60);

var AntG = function(canvas){
	this.canvas = canvas;
    this.g = canvas.getContext("2d");

    this.objs = [];
    this.counter = 0;
    gs.push(this);
}

AntG.prototype = {
	delay: 60,

	run: function(){
		g.globalAlpha = 1;
		this.g.clearRect(0, 0, this.canvas.width, this.canvas.height);

		if(this.background)
			if (this.background.repeat)
				this.drawRepeatedBG();
			else
				this.drawSimpleBG();

		for (var i = 0; i < this.objs.length; ++i){
			var obj = this.objs[i];
			obj.animate();
			obj.draw(this.g);

			if (obj.lifeTime <= 0){
				this.objs.splice(i, 1);
				--i;
			}
		}
		this.counter++;
	},

	drawRepeatedBG: function(){
		for (var i = 0; i * this.background.width < this.canvas.width; ++i){
			for (var j = 0; j * this.background.height < this.canvas.height; ++j){
				this.g.drawImage(this.background, i * this.background.width, j * this.background.height);
			}	
		}
	},

	drawSimpleBG: function(){
		thisg.drawImage(this.background, 0, 0, this.canvas.width, this.canvas.height);
	},

	setBackground: function(url, repeat){
		var img = new Image();
		img.src = url;
		img.repeat = repeat;
		var _this = this;
		img.onload = function(){
			_this.background = img;
		}
	},

	add: function(e){
		this.objs.push(e);
		return e;
	},

	remove: function(e){
		var index = this.objs.indexOf(e);
		if (index !== -1)
			this.objs.splice(index, 1);
	}

};

/**
 * Rajzolható, mozgatható mindenségek
 * @param {Object} attr:
 *		imgData<ImageData> | url<String> | img<Image>
 *		x
 *		y
 *		[width]
 *		[height]
 *		[opacity]
 *		[xMove]
 *		[yMove]
 *      [wChange]
 *      [hChange]
 *		[fadeSpeed: mennyivel csökken az átlátszóság tickekként]
 *		[lifespan: hány tick ütán töröljük]
 *		[after: function (this = pic) ha lejárt a lifespan meghívja]
 */
var Pic = AntG.Pic = function(attr){
	if (attr.imgData){
		this.imgData = attr.imgData;

	}else if (attr.url){
		this.img = new Image();
		this.img.src = attr.url;
		var _this = this;
		this.img.onload = function(){
			if (_this.width === undefined)
				_this.width = _this.img.width;
			if (_this.height === undefined)
				_this.height = _this.img.height;
		}
	}else{
		this.img = attr.img;
	}

	this.x = attr.x;
	this.y = attr.y;
	this.width = attr.width || attr.w;
	this.height = attr.height || attr.h;
	this.opacity = attr.opacity || 1;
	this.xMove = attr.xMove || 0;
	this.yMove = attr.yMove || 0;
	this.wChange = attr.wChange || 0;
	this.hChange = attr.hChange || 0;
	this.fadeSpeed = attr.fadeSpeed || 0;
	this.lifeTime = this.lifespan = attr.lifespan || Infinity;
	this.after = attr.after;
}

Pic.prototype = {
	animate: function(){
		this.x += this.xMove;
		this.y += this.yMove;
		this.width += this.wChange;
		this.height += this.hChange;
		this.opacity -= this.fadeSpeed;
		if (this.opacity < 0)
			this.opacity = 0
		else if (this.opacity > 1)
			this.opacity = 1;

		this.lifeTime--;

		if (this.lifeTime <= 0 && this.after)
			this.after();
	},

	draw: function(g){
		g.globalAlpha = this.opacity;

		if (this.img)
			g.drawImage(this.img, this.x, this.y, this.width, this.height);
		else if (this.imgData)
			g.putImageData(this.imgData, this.x, this.y);
	}
};

window.AntG = AntG;

})(window);