(function(window, _, AntG, undefined){

var g, players, ball, interval, tickables = [];


var sounds;

var run = true;

var FingerBall = {};
FingerBall.init = function(playerCount, antg){
	g = antg;
	g.add(new AntG.Pic({
		url: "img/center.png",
		x: (window.width() - 500) / 2,
		y: (window.height() - 77) / 2,
		w: 500,
		h: 77
	}));
	g.add(new AntG.Pic({
		url: "img/line0.png",
		x: 0,
		y: 0,
		w: window.width(),
		h: 5
	}));
	g.add(new AntG.Pic({
		url: "img/line1.png",
		x: 0,
		y: window.height() - 5,
		w: window.width(),
		h: 5
	}));
	g.add(new AntG.Pic({
		url: "img/line2.png",
		x: 0,
		y: 0,
		w: 7,
		h: 1000
	}));
	g.add(new AntG.Pic({
		url: "img/line2.png",
		x: window.width() - 7,
		y: window.height() - 1000,
		w: 7,
		h: 1000
	}));

	FingerBall.players = players = [];
	if (playerCount == 2)
		players[0] = new Player(0);
	else
		players[0] = new CPU(0);
	
	players[1] = new Player(1);
	
	ball = new Ball();

	interval = setInterval(run, 60);
window.ball = ball;
window.players = players;

	sounds = {
	    sound0: new Audio("sounds/sound0.wav"),
	    sound1: new Audio("sounds/sound1.wav"),
	    goal: new Audio("sounds/goal.wav")
	};
};

FingerBall.pause = function(){
	run = !run;
}

var run = function(){
	if (!run)
		return;

	ball.run();

	var kapuSize = 10 / 32 * window.width();

	//gólok
	if (ball.pos.x > (window.width() - kapuSize) / 2 && ball.pos.x < (window.width() + kapuSize) / 2){
		if (ball.pos.y < ball.r){
			players[0].addPoint();
			if (players[0].point > 2)
				win(0)
			else
				goal();
		}else if (ball.pos.y > window.height() - ball.r){
			players[1].addPoint();
			if (players[1].point > 2)
				win(1)
			else
				goal();
		}
	}

	//playerejjek ütközés
	for (var i = players.length - 1; i >= 0; i--) {
		if (players[i].intersect()){
            sounds.sound1.play();
			var n = players[i].pos.clone().sub(ball.pos); //tengely normálvektora			
			var o = new _.Point( (ball.pos.x + players[i].pos.x) / 2, 
				(ball.pos.y + players[i].pos.y) / 2);
			var v = o.clone().sub(ball.speed);

			var a = - n.x / n.y;
			var c = n.x * o.x / n.y + o.y;
			var d = (v.x + (v.y - c) * a) / (1 + a * a);

			var t = new _.Point();
			t.x = 2 * d - v.x;
			t.y = 2 * d * a - v.y + 2 * c;

			ball.speed = o.clone().sub(t).multiply(1.1);
			ball.pos.add(ball.speed);
		}
	};

	for (var i = 0; i < tickables.length; ++i)
		tickables[i].run();
}

/**
 * a középpontot jelöli a pozíció és körökkel számolunk
 */
var Player  = FingerBall.Player = function (side) {
	this.imgR = this.r * 1.5;
	if (side === 0){
		this.pos = new _.Point( window.width() / 2 , window.height() / 4 );
	}else{
		this.pos = new _.Point(  window.width() / 2, window.height() * 3 / 4 );
	}
	this.side = side;

	this.pic = g.add(new AntG.Pic({
		url: "img/player-" + side + ".png",
		x: this.pos.x - this.imgR,
		y: this.pos.y - this.imgR,
		w: 2 * this.imgR,
		h: 2 * this.imgR
	}));

	this.point = 0;
};

Player.prototype = {
	r: 25,

	setPos: function(pos){
		if (!run)
			return;
		var old = this.pos.clone();
		if (pos.x < this.r)
			this.pos.x = this.r;
		else if (pos.x > window.width() - this.r)
			this.pos.x = window.width() - this.r;
		else
			this.pos.x = pos.x;

		if (this.side === 0 && pos.y > window.height() / 2)
			this.pos.y = window.height() / 2;
		else if (this.side === 1 && pos.y < window.height() / 2)
			this.pos.y = window.height() / 2;
		else if (pos.y < this.r)
			this.pos.y = this.r;
		else if (pos.y > window.height() - this.r)
			this.pos.y = window.height() - this.r;
		else
			this.pos.y = pos.y;

		this.pic.x = this.pos.x - this.imgR;
		this.pic.y = this.pos.y - this.imgR;

		if (this.intersect()){
			var v = this.pos.clone().sub(old);
			if(v.magnitude() > 1){
				v.multiply(ball.SPEED / v.magnitude());
				ball.speed.add(v);
			}
		}
/*
		if (this.speeds){
			this.speeds.push(this.pos.clone().sub(old).magnitude());
	        this.speeds.splice(0, 1);

			if (this.intersect()){
				var m = 0;
				for (var i = this.speeds.length - 1; i >= 0; i--) {
					m += this.speeds[i]
				};
				m /= this.speeds.length;
				m /= this.speeds[this.speeds.length - 1];
console.log(m);
console.log(this.pos.clone().sub(old).multiply(m))
				ball.speed.add(this.pos.clone().sub(old).multiply(m));
			}
		}*/
	},
	addPoint: function(){
		this.point++;
		window.$('#player-' + this.side + '-point').html(this.point);
	},
	intersect: function(){
		return this.pos.clone().sub(ball.pos).magnitude() < this.r + ball.r;
	}
};

var CPU  = FingerBall.CPU = function (side) {
	this.imgR = this.r * 1.5;
	if (side === 0){
		this.pos = new _.Point( window.width() / 2 , window.height() / 4 );
	}else{
		this.pos = new _.Point(  window.width() / 2, window.height() * 3 / 4 );
	}
	this.side = side;
	
	if (this.side === 0)
		this.kapu = new _.Point(window.width() / 2, 0);
	else
		this.kapu = new _.Point(window.width() / 2, window.height());

	this.pic = g.add(new AntG.Pic({
		url: "img/player-" + side + ".png",
		x: this.pos.x - this.imgR,
		y: this.pos.y - this.imgR,
		w: 2 * this.imgR,
		h: 2 * this.imgR
	}));

	this.point = 0;
	tickables.push(this);
};

CPU.prototype = _.clone(Player.prototype);
CPU.prototype.speed = 4;
CPU.prototype.run = function(){
	var c = new _.Point((ball.pos.x + this.kapu.x) / 2, (ball.pos.y + this.kapu.y) / 2);
	c.sub(this.pos);
	if (c.magnitude() < this.speed)
		this.setPos(this.pos.add(c));
	else{
		var a = this.speed / c.magnitude();
		this.setPos(this.pos.add( new _.Point(c.x * a, c.y * a) ));
	}
}

var Ball = function(){
	this.imgR = this.r * 1.5;
	this.pos = new _.Point( window.width() / 2, window.height() / 2 );
	this.speed = new _.Point(0, 0);
	
	this.pic = g.add(new AntG.Pic({
		url: "img/ball.png",
		x: this.pos.x - this.imgR,
		y: this.pos.y - this.imgR,
		w: 2 * this.imgR,
		h: 2 * this.imgR
	}));
};

Ball.prototype = {
	r: 14,
	SPEED: 15,
	randSpeed: function(){
		var a = Math.random() * Math.PI * 2;
		this.speed = new _.Point( Math.cos(a) * this.SPEED, Math.sin(a) * this.SPEED );
	},
	run: function(){
		var wall = false;
		if (this.pos.x + this.r > window.width() || this.pos.x - this.r < 0){
            sounds.sound0.play();
			this.speed.x *= -1;
			wall = true;
		}
		if (this.pos.y + this.r > window.height() || this.pos.y - this.r < 0){
            sounds.sound0.play();
			this.speed.y *= -1;
			wall = true;
		}

		var s = this.speed.magnitude();
		if (s != this.SPEED && s != 0 && !wall){
			var a = (this.SPEED + s + s) / 3 / s;
			this.speed.x *= a;
			this.speed.y *= a;
		}

		this.pos.x += this.speed.x;
		this.pos.y += this.speed.y;

		this.pic.x = this.pos.x - this.imgR;
		this.pic.y = this.pos.y - this.imgR;
	}
};

var goal = function(){
    sounds.goal.play();
	ball.pos = new _.Point( window.width() / 2, window.height() / 2 );
	ball.speed = new _.Point(0, 0);

	g.add(new AntG.Pic({
		url: "img/goal.png",
		x: (window.width() - 170) / 2,
		y: (window.height() - 480) / 2,
		w: 170,
		h: 440,
		fadeSpeed: .1,
		lifespan: 10
	}));
}

var win = function(player){
	g.add(new AntG.Pic({
		url: "img/wins-" + player + ".png",
		x: (window.width() - 170) / 2,
		y: (window.height() - 480) / 2,
		w: 170,
		h: 440,
		lifespan: 30,
		after: function(){
			window.location = "index.html"
		}
	}));
}

window.FingerBall = FingerBall;

})(window, Ant, AntG)