
//  format an ISO date using Moment.js
//  http://momentjs.com/
//  moment syntax example: moment(Date("2011-07-18T15:50:52")).format("MMMM YYYY")
//  usage: {{dateFormat creation_date format="MMMM YYYY"}}
Handlebars.registerHelper('dateFormat', function(context, block) {
  if (window.moment) {
    var f = block.hash.format || "MMM Do, YYYY";
    var t = context.split(/[- :]/);

    // Apply each element to the Date function
    var d = new Date(t[0], t[1]-1, t[2], t[3], t[4], t[5]);
    return moment(d).format(f);
  }else{
    return context;   //  moment plugin not available. return data as is.
  };
});

var TekRouter = Backbone.Router.extend({
  /* define the route and function maps for this router */
  routes: {
    "" : "home",
    "idiomes.html" : "loadIdiomes",
    ":idioma/page/:id" : "loadPage",
    ":idioma/page/:id/lloc/:lloc" : "loadLloc",
    ":idioma/page/:id/activitat/:activitat" : "loadActivitat",
    ":idioma/page/:id/espectacle/:espectacle" : "loadEspectacle",
    ":idioma/index.html" : "home2"
  },

  home: function(){
      // $("body").append("fasfdad<br>fadfsasddsdfs");
      //this.loadPage(1);
      var idioma = localStorage.getItem("idioma");
      if(idioma == null){
        //this.loadIdiomes();
        this.home2(1);
      } else {
        this.home2(idioma);    
      }
  },

  loadIdiomes : function  () {
    idiomes.fetch();
  },

  home2: function(idioma){
    var that = this;
    localStorage.setItem("idioma", idioma);
    if(pagines.length == 0){
      pagines.set("idioma", idioma);
      pagines.idioma = idioma;
      //pagines.pagina = id;
      pagines.fetch({ "success" :function(pagines,r,o){
        var m = pagines.at(0);
        that.loadPage(idioma, m.get("id_pagina"))
      }});
    } else {
      this.loadPage(idioma, pagines.at(0).get("id_pagina"));
    }
  },

  loadPage: function(idioma,id){
    localStorage.setItem("idioma", idioma);  
    page.set("codi", id);
    page.set("idioma", idioma);
    page.fetch().fail();
    if(pagines.length == 0){
      pagines.set("idioma", idioma);
      pagines.idioma = idioma;
      pagines.pagina = id;
      pagines.fetch();
    }
    $("body").trigger("publiOn").trigger("errorStart");
  },

  loadLloc: function(idioma, id, id_lloc){
    localStorage.setItem("idioma", idioma);
    lloc.set("codi", id);
    lloc.set("lloc", id_lloc);
    lloc.set("idioma", idioma);
    lloc.fetch();
    if(pagines.length == 0){
      pagines.set("idioma", idioma);
      pagines.idioma = idioma;
      pagines.pagina = id;
      pagines.fetch();
    }
    $("body").trigger("publiOn").trigger("errorStart");
  },

  loadActivitat: function(idioma, id, id_activitat){
    localStorage.setItem("idioma", idioma);
    activitat.set("codi", id);
    activitat.set("activitat", id_activitat);
    activitat.set("idioma", idioma);
    activitat.fetch();
    if(pagines.length == 0){
      pagines.set("idioma", idioma);
      pagines.idioma = idioma;
      pagines.pagina = id;
      pagines.fetch();
    }
    $("body").trigger("publiOn").trigger("errorStart");
  },

  loadEspectacle: function(idioma, id, id_espectacle){
    localStorage.setItem("idioma", idioma);
    espectacle.set("codi", id);
    espectacle.set("espectacle", id_espectacle);
    espectacle.set("idioma", idioma);
    espectacle.fetch();
    if(pagines.length == 0){
      pagines.set("idioma", idioma);
      pagines.idioma = idioma;
      pagines.pagina = id;
      pagines.fetch();
    }
    $("body").trigger("publiOn").trigger("errorStart");
  },

});

var tekModel = Backbone.Model.extend({
  "url_base": 'http://firadecirc.org/',
  "tekapi" : "3.1",
  parse: function(resp, xhr) {
        resp.web_url_base = this.url_base;
        return resp;
    }  
});

var tekCollection = Backbone.Collection.extend({
  "url_base": 'http://firadecirc.org/',
  "tekapi" : "3.1",
  model : tekModel,
  parse: function(resp, xhr) {
      /*var r = [];
      _.map(resp, function(n){
        n.valors.web_url_base = this.url_base;
        r.push(n.valors);
      });*/
      var r = resp;
       resp.web_url_base = this.url_base;
        return r;
    }
});

var Pagina = tekModel.extend({
   "url": function() {
    var codi = this.get("codi"), idioma = this.get("idioma");
      return this.url_base + "api" + this.tekapi + "/" + idioma + '/continguts/' + codi + ".jsonp?key=6&pass=1111&callback=?";
    }
});

var Idiomes = tekCollection.extend({
   "url": function() {
      return this.url_base + "api" + this.tekapi + '/idiomes.jsonp?key=6&pass=1111&callback=?';
    }
});

var Pagines = tekCollection.extend({
   "model" : Pagina, 
   "url": function() {
    var idioma = this.get("idioma");
      return this.url_base + "api" + this.tekapi + "/" + this.idioma + '/menumobil.jsonp?key=6&pass=1111&callback=?';
    }
});

var Llocs = tekCollection.extend({
    "url": function() {
        var codi = this.get("codi"), idioma = 1;
      return this.url_base + "api" + this.tekapi + "/" + idioma + '/continguts/' + this.codi + "/llocs.jsonp?key=6&pass=1111&callback=?";
    }
});

var Lloc = tekModel.extend({
    "url": function() {
      var codi = this.get("codi"), lloc = this.get("lloc"), idioma = 1;
      return this.url_base + "api" + this.tekapi + "/" + idioma + '/continguts/' + codi + "/llocs/" + lloc + ".jsonp?key=6&pass=1111&callback=?";
    }
});

var Activitats = tekCollection.extend({
    "url": function() {
        var codi = this.get("codi"), idioma = 1;
      return this.url_base + "api" + this.tekapi + "/" + idioma + '/continguts/' + this.codi + "/activitats.jsonp?key=6&pass=1111&callback=?";
    }
});

var Activitat = tekModel.extend({
    "url": function() {
      var codi = this.get("codi"), activitat = this.get("activitat"), idioma = 1;
      return this.url_base + "api" + this.tekapi + "/" + idioma + '/continguts/' + codi + "/activitats/" + activitat + ".jsonp?key=6&pass=1111&callback=?";
    }
});

var Espectacles = tekCollection.extend({
    "url": function() {
        var codi = this.get("codi"), idioma = 1;
      return this.url_base + "api" + this.tekapi + "/" + idioma + '/continguts/' + this.codi + "/espectacles.jsonp?key=6&pass=1111&callback=?";
    }
});

var Espectacle = tekModel.extend({
    "url": function() {
      var codi = this.get("codi"), espectacle = this.get("espectacle"), idioma = 1;
      return this.url_base + "api" + this.tekapi + "/" + idioma + '/continguts/' + codi + "/espectacles/" + espectacle + ".jsonp?key=6&pass=1111&callback=?";
    }
});


var IdiomesView = Backbone.View.extend({
  //id: 'pagina',
  el: '#pagina',
  initialize: function() {

    this.listenTo(this.collection, "sync", this.render);
    
    this.template = Handlebars.compile($("#idiomes").html());

  },

  render : function(){
      
      $("body").trigger("errorStop");

      if($("nav").hasClass("in"))$("nav").collapse("hide");
      this.$el.html( this.template({"idiomes" : this.collection.toJSON()}));
  }
});

var PageView = Backbone.View.extend({
  //id: 'pagina',
  el: '#pagina',
  initialize: function() {

    /*this.listenTo(this.model, "change", function(model, params){
      this.render();
    });*/
    this.listenTo(this.model, "sync", this.render);
    
    //this.template = _.template($("script.PaginaBase").html());
    this.template = Handlebars.compile($("#page").html());
    $("#btn_menu").on("click", function(){
      paginesview.trigger("toggleMenu");
    });
    $("#btn_home").on("click", function(){
      window.location ="#";
      paginesview.trigger("hideMenu");
    });
    var options = {
      dragLockToAxis: true,
      dragBlockHorizontal: true
    };
    //var hammertime = new Hammer(element, options);
    Hammer(document.body,options).on("swiperight", function(event) {
      paginesview.trigger("showMenu"); 
    }).on("swipeleft", function(event) {
      paginesview.trigger("hideMenu"); 
    });

    $("body").on("click", "a.system-link", function(e){
      window.open(e.target.href, '_system', 'location=yes');
      e.preventDefault();
    });

    //this.bind("error", function(){ console.log("error");});
  },

  render : function(){
      var llocsView;
      $("body").trigger("errorStop");
    //console.log(this.model.toJSON());
      if($("nav").hasClass("in"))$("nav").collapse("hide");
      this.$el.html( this.template(this.model.toJSON()));
      if(this.model.get("tipus") == 7){
        llocsView = new LLocsView({collection:llocs});
        llocs.set("codi", this.model.get("codi"));
        llocs.codi = this.model.get("codi");
        llocs.set("idioma","1");
        llocs.fetch();
      }
      if(this.model.get("tipus") == 6 || this.model.get("tipus") == 51){
        activitatsView = new ActivitatsView({collection:activitats});
       // activitats.set("codi", this.model.get("codi"));
        activitats.codi = this.model.get("codi");
        activitats.set("idioma","1");
        activitats.fetch();
      }
      if(this.model.get("tipus") == 50 || this.model.get("tipus") == 52){
        espectaclesView = new EspectaclesView({collection:espectacles});
        espectacles.codi = this.model.get("codi");
        espectacles.set("idioma","1");
        espectacles.fetch();
      }
  }
});
     
var PaginesView = Backbone.View.extend({
  //id: 'pagina',
  el: '#menu',
  initialize: function() {
    /*this.listenTo(this.model, "change", function(model, params){
      this.render();
    });*/
    this.listenTo(this.collection, "sync", this.render);
    this.listenTo(this, "showMenu", this.mostraMenu);
    this.listenTo(this, "hideMenu", this.ocultaMenu);
    this.listenTo(this, "toggleMenu", this.toggleMenu);
    //this.template = _.template($("script.PaginaBase").html());
    this.template = Handlebars.compile($("#page_menu").html());
    $(this.$el).on("click", "a", function(){
      paginesview.trigger("hideMenu");
    });
  },

  render : function(){
    //console.log(this.collection.toJSON());
    $("body").trigger("errorStop");
    this.$el.html(this.template({menu : this.collection.toJSON()}));

  },

  ocultaMenu: function(){
    $(".pagina").removeClass("pagina_show");
    $("div.side").removeClass("show");
  },

  mostraMenu: function(){
    $(".pagina").addClass("pagina_show");
    $("div.side").addClass("show");
  },

  toggleMenu: function(){
    $(".pagina").toggleClass("pagina_show");
    $("div.side").toggleClass("show");
  }


});

var LLocsView = Backbone.View.extend({
  //id: 'pagina',
  el: '#sub',
  initialize: function() {
    /*this.listenTo(this.model, "change", function(model, params){
      this.render();
    });*/
    this.listenTo(this.collection, "sync", this.render);
    //this.template = _.template($("script.PaginaBase").html());
    this.template = Handlebars.compile($("#page_llocs").html());
  },

  render : function(){
    //console.log(this.collection.toJSON());
    $("body").trigger("errorStop");
    this.$el.html(this.template({llocs : this.collection.toJSON()}));  
    $("#map").TekMap();
    _.each(this.collection.toJSON(), function(a){
        if(a.activitats.length > 0) {
          $("#map").TekMarker({lat: a.lat, lng: a.lng, draggable: false, infowindow: a.titol});
        }
    }); 
    $("#map").TekfitBounds(); 
    ubicacio.trigger("situa");
  }

});

var ActivitatsView = Backbone.View.extend({
  //id: 'pagina',
  el: '#sub2',
  initialize: function() {
    /*this.listenTo(this.model, "change", function(model, params){
      this.render();
    });*/
    
    this.listenTo(this.collection, "add2", this.render);
    this.listenTo(this.collection, "sync", this.renderDistancies);
    //this.template = _.template($("script.PaginaBase").html());
    this.template = Handlebars.compile($("#page_activitats").html()); 
    
  },

  render : function(){
    $("body").trigger("errorStop");
    this.$el.html(this.template({activitats : this.collection.toJSON()})); 
  },

  renderDistancies : function(){
    this.render();
    //calculaDistancies($, "span.distancia"); 
    ubicacio.trigger("situa");
  }

});

var ActivitatsView2 = Backbone.View.extend({
  //id: 'pagina',
  el: '#sub2',
  initialize: function() {
    /*this.listenTo(this.model, "change", function(model, params){
      this.render();
    });*/
    
    this.listenTo(this.collection, "add2", this.render);
    this.listenTo(this.collection, "sync", this.renderDistancies);
    //this.template = _.template($("script.PaginaBase").html());
    this.template = Handlebars.compile($("#page_activitats2").html()); 
    
  },

  render : function(){
    $("body").trigger("errorStop");
    this.$el.html(this.template({activitats : this.collection.toJSON()})); 
  },

  renderDistancies : function(){
    this.render();
    //calculaDistancies($, "span.distancia"); 
    ubicacio.trigger("situa");
  }

});

var LLocView = Backbone.View.extend({
  //id: 'pagina',
  el: '#pagina',
  initialize: function() {
    /*this.listenTo(this.model, "change", function(model, params){
      this.render();
    });*/
    this.listenTo(this.model, "sync", this.render);
    //this.template = _.template($("script.PaginaBase").html());
    this.template = Handlebars.compile($("#page_lloc").html());
  },

  render : function(){
    var zoom;
    //console.log(this.model.toJSON());
    $("body").trigger("errorStop");
    this.$el.html(this.template(this.model.toJSON()));
    zoom =  this.model.get("zoom");
    if(zoom === ""){
      zoom = 15;
    } else {
      zoom = parseInt(zoom, 10);
    }
    $("#map").TekMap({lat: this.model.get("lat"), lng: this.model.get("lng"),     mapoptions : {
      zoom: zoom,
      mapTypeId: google.maps.MapTypeId.ROADMAP,
      scrollwheel: false
    },});
    $("#map").TekMarker({lat: this.model.get("lat"), lng: this.model.get("lng"), draggable: false, infowindow: this.model.get("titol")}); 
    //$("#map").TekfitBounds(); 
    window.scrollTo(0, 0);
    var activitats = new Activitats;
    var r = [];
    _.map(this.model.get("activitats"), function(n){
        n.valors.web_url_base = this.url_base;
        r.push(n.valors);
      });
    var Activitatsview = new ActivitatsView({collection:activitats});
    activitats.add(r);
    activitats.trigger("add2");
    ubicacio.trigger("situa");

  }

});   

var ActivitatView = Backbone.View.extend({
  //id: 'pagina',
  el: '#pagina',
  circle : null,
  punt : null,

  events : {
    "click button.share" : "share"
  },

  initialize: function() {
    /*this.listenTo(this.model, "change", function(model, params){
      this.render();
    });*/
    this.listenTo(this.model, "sync", this.render);
    this.listenTo(ubicacio, "change", this.renderUbicacio);
    //this.template = _.template($("script.PaginaBase").html());
    this.template = Handlebars.compile($("#page_activitat").html());
  },

  share : function(e){
    var link, titol, buttton, missatge;
    button = $(e.target, this.$el);
    link = button.data("link");
    titol = button.data("title");
    missatge = button.data("missatge");
    if(window.MozActivity){
      var activity = new MozActivity({
        name: "share",
        data: {
          type: "url",
          url: link,
          name: titol,
          description: missatge
        }
      });

    } else {
      window.plugins.socialsharing.share(titol, missatge, null, link);
    }
  },

  renderUbicacio : function(){
      var userLatLng = new google.maps.LatLng(ubicacio.get("coords").latitude, ubicacio.get("coords").longitude);
      var map = $("#map").data("tekmap");

      if(map == undefined)return;
      
      if(this.circle == null){
        this.punt = new google.maps.Circle({
            center: userLatLng,
            radius: ubicacio.get("coords").accuracy/10,
            map: map,
            fillColor: '#fc0000',
            fillOpacity: 1,
            strokeColor: '#fc0000',
            strokeOpacity: 1.0,
            strokeWeight :1
          });          

        this.circle = new google.maps.Circle({
            center: userLatLng,
            radius: ubicacio.get("coords").accuracy,
            map: map,
            fillColor: '#cc0000',
            fillOpacity: 0.1,
            strokeColor: '#cc0000',
            strokeOpacity: 0.5,
            strokeWeight:1
          });

          $("#map").TekNewBound(userLatLng);
      } else {
        this.circle.setMap(map);
        this.punt.setMap(map);
        this.circle.setCenter(userLatLng);
        this.circle.setRadius(ubicacio.get("coords").accuracy);
        this.punt.setCenter(userLatLng);
        $("#map").TekNewBound(userLatLng);
      }
      
      /*.TekMarker({
        lat: parseFloat(ubicacio.get("coords").latitude), 
        lng: parseFloat(ubicacio.get("coords").longitude), 
        draggable: false, 
        
      })*/
      $("#map").TekfitBounds();
  },

  render : function(){
    var zoom;
    var lloc = this.model.get("lloc");

    $("body").trigger("errorStop");
    //console.log(this.model.toJSON());
    this.$el.html(this.template(this.model.toJSON()));
    zoom =  this.model.get("zoom");
    if(zoom === "" || zoom == undefined){
      zoom = 15;
    } else {
      zoom = parseInt(zoom, 10);
    }

    $("#map").TekMap({
      lat: parseFloat(lloc.valors.lat), 
      lng: parseFloat(lloc.valors.lng),     
      mapoptions : {
        zoom: zoom,
        mapTypeId: google.maps.MapTypeId.ROADMAP,
        scrollwheel: false
      }
    }).TekMarker({
      lat: parseFloat(lloc.valors.lat), 
      lng: parseFloat(lloc.valors.lng), 
      draggable: false, 
      infowindow: lloc.valors.titol
    }); 
    if(ubicacio.has("coords")){
      this.renderUbicacio(); 
    }
    // */
    window.scrollTo(0, 0);
    ubicacio.trigger("situa");
  }

});   


var EspectaclesView = Backbone.View.extend({
  //id: 'pagina',
  el: '#sub2',
  initialize: function() {
    this.listenTo(this.collection, "add2", this.render);
    this.listenTo(this.collection, "sync", this.render);
    this.template = Handlebars.compile($("#page_espectacles").html()); 
  },

  render : function(){
    $("body").trigger("errorStop");
    this.$el.html(this.template({espectacles : this.collection.toJSON()})); 
  },

});

var EspectacleView = Backbone.View.extend({
  //id: 'pagina',
  el: '#pagina',

  events : {
    "click button.share" : "share"
  },

  initialize: function() {
    this.listenTo(this.model, "sync", this.render);
    this.template = Handlebars.compile($("#page_espectacle").html());
  },

  share : function(e){
    var link, titol, buttton, missatge;
    button = $(e.target, this.$el);
    link = button.data("link");
    titol = button.data("title");
    missatge = button.data("missatge");
    if(window.MozActivity){
      var activity = new MozActivity({
        name: "share",
        data: {
          type: "url",
          url: link,
          name: titol,
          description: missatge
        }
      });

    } else {
      window.plugins.socialsharing.share(titol, missatge, null, link);
    }
  },

  render : function(){
    var zoom;
    var lloc = this.model.get("lloc");

    $("body").trigger("errorStop");
    //console.log(this.model.toJSON());
    this.$el.html(this.template(this.model.toJSON()));
    var activitats = new Activitats;
    var r = [];
    var espectacleActual = this.model.toJSON(); 
    _.map(this.model.get("activitats"), function(n){
        n.web_url_base = this.url_base;
        n.info_espectacle = {};
        n.info_espectacle.valors = espectacleActual;
        r.push(n);
      });
    var Activitatsview = new ActivitatsView2({collection:activitats});
    activitats.add(r);
    activitats.trigger("add2");
    ubicacio.trigger("situa");
  }

});   


var DistanciesView = Backbone.View.extend({
  el : "span.distancia",
  initialize: function() {
    this.el = "span.distancia";
    this.listenTo(this.model, "change", this.position);
  },

  position: function(){
    if(this.model.has("coords")){
      var lat = this.model.get("coords").latitude, 
          lng = this.model.get("coords").longitude, that = this;
      $(this.el).each(function(i,ele){
        var $ele = $(ele), 
          lat1 =$ele.data("lat"),
          lng1 = $(ele).data("lng");
          if(lat1 != '' && lng1 != '') {
            $ele.html(" / a " + that.distance(
              { "lat" : lat1, "lng" : lng1 },
              { "lat" : lat, "lng" : lng },
              2
            ) + "Km.");
          }
      });
    }
  },

  distance : function(p1, p2, precision){
    var R = 6371; // km
    var dLat = (p2.lat-p1.lat).toRad();
    var dLon = (p2.lng-p1.lng).toRad();
    var lat1 = p1.lat.toRad();
    var lat2 = p2.lat.toRad();
    
    var a = Math.sin(dLat/2) * Math.sin(dLat/2) +
            Math.sin(dLon/2) * Math.sin(dLon/2) * Math.cos(lat1) * Math.cos(lat2); 
    var c = 2 * Math.atan2(Math.sqrt(a), Math.sqrt(1-a)); 
    var d = R * c;
    var p = Math.pow(10,precision);
    return Math.round(d*p)/p;
  } 
});


var PubliView = Backbone.View.extend({
    el: "div.publi",

    initialize: function() {
      $("body").on("publiOn", this.render);
      $("body").on("publiOff", this.hide);
    },

    render : function(){
      $("body").addClass("page-show");
      setTimeout(function(){
        $("body").trigger("publiOff");
      }, 6000);
    },

    hide : function(){
      $("body").removeClass("page-show");
    }
 });

var ErrorView = Backbone.View.extend({
    el: "div.error",
    t : 0,

    initialize: function() {
      $("body").on("errorStart", this.start);
      $("body").on("errorStop", this.stop);
      //this.listenTo(this.model, "error", this.render);
    },

    start : function() {
       var that = Error;
       if(that.t === 0){
          that.t = setTimeout(function(){
            that.render();
          }, 5000);
       }
    },

    stop : function() {
      var that = Error;
      if(that.t!== 0) {
        clearTimeout(that.t);
        that.t = 0;
      }
    },

    render : function(){
      Error.$el.addClass("error-show");
      window.scrollTo(0,0);
      
    },

    hide : function(){
      Error.$el.removeClass("error-show");
    }
 });


moment.lang('ca');  

var myTodoRouter = new TekRouter();
var idiomes = new Idiomes;
var ubicacio = new Backbone.Model;
var page = new Pagina;
var pagines = new Pagines;
var llocs = new Llocs;
var lloc = new Lloc;
var activitats = new Activitats;
var activitat = new Activitat;
var espectacles = new Espectacles;
var espectacle = new Espectacle;


var pageview = new PageView({model:page});
var idiomesview = new IdiomesView({collection:idiomes});
var paginesview = new PaginesView({collection:pagines});
var llocview = new LLocView({model:lloc});
var Activitatview = new ActivitatView({model:activitat});
var Espectacleview = new EspectacleView({model:espectacle});
var Distancies = new DistanciesView({model:ubicacio});
var Publi = new PubliView();
var Error = new ErrorView();


Backbone.history.start();

function calculaUbicacio(ubicacio) {
  var r = {}, first = true;
  
  init();
  
  function init(){
    if(navigator.geolocation){
      navigator.geolocation.watchPosition(position);
    }

  }
  
  function position(pos){
    ubicacio.set(pos);
    if(first){
      ubicacio.on("situa", function(){ 
        ubicacio.trigger("change") 
      });
      first = false;
    } 
  } 

  return r;
}



document.addEventListener("deviceready", onDeviceReady, false);

function onDeviceReady() {
    // Now safe to use device APIs
    if(navigator.splashscreen){
      navigator.splashscreen.hide();
    } 
    calculaUbicacio(ubicacio);  
    console.log("ubicacio");
}

  
if (typeof(Number.prototype.toRad) === "undefined") {
  Number.prototype.toRad = function() {
    return this * Math.PI / 180;
  };
}

/** Converts radians to numeric (signed) degrees */
if (typeof(Number.prototype.toDeg) === "undefined") {
  Number.prototype.toDeg = function() {
    return this * 180 / Math.PI;
  };
}