// Ionic Starter App

// angular.module is a global place for creating, registering and retrieving Angular modules
// 'starter' is the name of this angular module example (also set in a <body> attribute in index.html)
// the 2nd parameter is an array of 'requires'
// 'starter.services' is found in services.js
// 'starter.controllers' is found in controllers.js
angular.module('starter', ['ionic', 'starter.controllers', 'starter.services'])

  .run(function ($ionicPlatform) {
    $ionicPlatform.ready(function () {
      // Hide the accessory bar by default (remove this to show the accessory bar above the keyboard
      // for form inputs)
      if (window.cordova && window.cordova.plugins && window.cordova.plugins.Keyboard) {
        cordova.plugins.Keyboard.hideKeyboardAccessoryBar(true);
        cordova.plugins.Keyboard.disableScroll(true);

      }
      if (window.StatusBar) {
        // org.apache.cordova.statusbar required
        StatusBar.styleLightContent();
      }
      //admob plugin
      //if(window.plugins && window.plugins.AdMob) {
      //  var admob_key = device.platform == "Android" ? "pub-8240006416607654" : "IOS_PUBLISHER_KEY";
      //  var admob = window.plugins.AdMob;
      //  admob.createBannerView(
      //    {
      //      'publisherId': admob_key,
      //      'adSize': admob.AD_SIZE.BANNER,
      //      'bannerAtTop': false
      //    },
      //    function() {
      //      admob.requestAd(
      //        { 'isTesting': false },
      //        function() {
      //          admob.showAd(true);
      //        },
      //        function() { console.log('failed to request ad'); }
      //      );
      //    },
      //    function() { console.log('failed to create banner view'); }
      //  );
      //}

    });
  })

  .config(function ($stateProvider, $urlRouterProvider) {
    $stateProvider

      .state('tab', {
        url: '/tab',
        abstract: true,
        templateUrl: 'templates/tabs.html'
      })

      .state('fav_book', {
        url: '/fav_book',
        abstract: true,
        templateUrl: 'templates/fav_book.html'
      })

      .state('tab.all_books', {
        url: '/all_books/:type',
        views: {
          'tab-dash': {
            templateUrl: 'templates/all_books.html',
            controller: 'books'
          }
        }
      })

      .state('tab.new_testament', {
        url: '/new_testament/:type',
        views: {
          'tab-chats': {
            templateUrl: 'templates/new_testament.html',
            controller: 'books'
          }
        }
      })

      .state('chapters', {
        url: '/chapters/:book',
        templateUrl: 'templates/chapters.html',
        controller: "chapter"
      })

      .state('pages', {
        url: '/pages/:book/:verse',
        templateUrl: 'templates/pages.html',
        controller: 'pages'
      })

      .state('fav_book.favorites', {
        cache: false,
        url: '/favorites',
        views: {
          'tab-fav': {
            templateUrl: 'templates/favorites.html',
            controller: 'favorites'
          }
        }
      })

      .state('fav_book.bookmarks', {
        cache: false,
        url: '/bookmarks',
        views: {
          'tab-book': {
            templateUrl: 'templates/bookmarks.html',
            controller: 'bookmarks'
          }
        }
      })

      .state('tab.old_testament', {
        url: '/old_testament/:type',
        views: {
          'tab-account': {
            templateUrl: 'templates/old_testament.html',
            controller: 'books'
          }
        }
      });

    // if none of the above states are matched, use this as the fallback
    $urlRouterProvider.otherwise('/tab/all_books/1');

  });
