angular.module('starter.controllers', [])

  .controller('app', function ($rootScope, $scope, LocalStore, $location) {
      $scope.sortState = "A-Z"; // the next sort state
      $scope.book = ""; // data in the current book
      $scope.current = ""; //current chapter
      $scope.total = ""; // total chapters
      $scope.headerClass = ['bar-assertive'];
      $scope.tabClass = ['tabs-color-active-assertive'];
      $scope.numberClass = ['assertive-bg'];
      $scope.labelColor = ['assertive'];
      $scope.noteColor = ['balanced'];
      $scope.buttonClass = ['button-assertive'];
      $scope.night = [];
      $scope.count = 1;


      // setup
      if (LocalStore.get('favorite', '-1') === '-1') {
          LocalStore.setObject('favorite', []);
      }
      if (LocalStore.get('bookmark', '-1') === '-1') {
          LocalStore.setObject('bookmark', []);
      }

      if (LocalStore.get('book_version', '-1') === '-1') {
          LocalStore.set('book_version', 'KJV');
      }

      $scope.book_version = LocalStore.get('book_version', 'NKJV');
      //Todo: keep versions eg. v 1.0 , v 1.0.2
      //Todo: keep sort state in storage

      $scope.favorites = function () {
          $location.path("/fav_book/favorites");
      };

      $scope.changeVersion = function () {
          if ($scope.count == 4)
              $scope.count = 1;
          else
              $scope.count += 1;

          if ($scope.count == 1)
              $scope.book_version = "KJV";
          else if ($scope.count == 2)
              $scope.book_version = "NKJV";
          else if ($scope.count == 3)
              $scope.book_version = "NIV";
          else
              $scope.book_version = "ESV";
          LocalStore.set('book_version', $scope.book_version);

          $rootScope.$broadcast('change_version', $scope.book_version);

      }

      $scope.home = function () {
          $location.path("/tab/all_books/1")
      };

      $scope.sort = function () {
          if ($scope.sortState === "A-Z") {
              $rootScope.$broadcast('sort', "A-Z");
              $scope.sortState = "Default";
          }
          else {
              $rootScope.$broadcast('sort', "Default");
              $scope.sortState = "A-Z";
          }
      };

      $rootScope.$on('bookName', function (event, data) {
          $scope.book = data;
      });

      $rootScope.$on('currentVerse', function (event, data) {
          $scope.current = data;
      });

      $rootScope.$on('total', function (event, data) {
          $scope.total = data;
      });

  })

  .controller('books', function ($rootScope, $scope, Books, $stateParams, $location) {
      $scope.books = [];
      var sorted = [];
      var unsorted = [];

      Books.all($stateParams.type).then(function (data) {
          unsorted = angular.copy(data.data);
          sorted = angular.copy(data.data);
          sorted.sort();
          if (angular.equals($scope.sortState, 'A-Z'))
              $scope.books = unsorted;
          else
              $scope.books = sorted;
      });

      $rootScope.$on('sort', function (event, data) {
          if (angular.equals(data, 'Default'))
              $scope.books = unsorted;
          else
              $scope.books = sorted;
      });

      $scope.goToChapters = function (book) {
          $location.path("/chapters/" + book);
      };

      $rootScope.$broadcast('sortable', true);

  })

  .controller('chapter', function ($scope, $rootScope, $stateParams, Chapter, $location) {
      $rootScope.$broadcast('sortable', false);
      $scope.chapters = {};
      var book = $stateParams.book;

      $rootScope.$broadcast('bookName', book);

      Chapter.getBook(book,$scope.book_version).then(
        function (data) {
            $scope.chapters = data.data.chapters;
        }
      );

      $scope.goToVerse = function (verse) {
          $location.path("/pages/" + book + "/" + verse);
      }

  })

  .controller('pages', function ($scope, Chapter, $stateParams, $rootScope, $ionicPopover,
                                 LocalStore, $ionicLoading, $ionicPopup, $ionicScrollDelegate) {
      $scope.books = {};
      var book = {};
      $scope.selected = {
          verse: "",
          book: $stateParams.book,
          chapter: $stateParams.verse
      };

      $rootScope.$broadcast('currentVerse', $stateParams.verse);

      Chapter.getBook($stateParams.book,$scope.book_version).then(function (data) {
          book = angular.copy(data);
          $scope.books = data.data.chapters[$stateParams.verse - 1].verses;
          $rootScope.$broadcast('total', data.data.chapters.length);
      });

      $scope.swipeRight = function () {
          var nextVerse = ($stateParams.verse - 1);

          if (!(nextVerse <= 0)) {
              $scope.books = book.data.chapters[nextVerse - 1].verses;
              $stateParams.verse = nextVerse;
              $rootScope.$broadcast('currentVerse', $stateParams.verse);
              $ionicScrollDelegate.scrollTop(true);
          }
      };

      $scope.swipeLeft = function () {
          var nextVerse = ($stateParams.verse - 1) + 2;

          if (!(nextVerse > book.data.chapters.length)) {
              $scope.books = book.data.chapters[nextVerse - 1].verses;
              $stateParams.verse = nextVerse;
              $rootScope.$broadcast('currentVerse', $stateParams.verse);
              $ionicScrollDelegate.scrollTop(true);
          }
      };

      $ionicPopover.fromTemplateUrl('templates/popover.html', {
          scope: $scope
      }).then(function (popover) {
          $scope.popover = popover;
      });

      $scope.openPopover = function ($event, verse) {
          $scope.selected.verse = verse;
          $scope.popover.show($event);
      };

      $scope.closePopover = function () {
          $scope.popover.hide();
      };

      $scope.favorite = function () {
          var favorite = LocalStore.getObject('favorite');
          favorite.push($scope.selected);
          LocalStore.setObject('favorite', favorite);
          $scope.closePopover();
          $ionicLoading.show({
              template: 'Added to favorites ',
              duration: 1000
          });
      };

      $scope.bookmark = function (note) {
          var data = {
              selected: $scope.selected,
              note: note
          };
          var bookmarks = LocalStore.getObject('bookmark');
          bookmarks.push(data);
          LocalStore.setObject('bookmark', bookmarks);
          $scope.closePopover();
          $ionicLoading.show({
              template: 'Added to bookmarks ',
              duration: 1000
          });
      };

      $scope.openBookmark = function () {
          $scope.closePopover();
          $scope.data = {
              text: "",
              cancel: '0'
          };

          $ionicPopup.show({
              template: '<span> <textarea rows="6" ng-model="data.text" name="bookmark_note"></textarea></span>',
              title: 'Enter your notes',
              scope: $scope,
              buttons: [{
                  text: 'Cancel',
                  onTap: function () {
                      $scope.data.cancel = '1';
                      return $scope.data;
                  }
              }, {
                  text: '<b>Save</b>',
                  type: $scope.buttonClass,
                  onTap: function () {
                      return $scope.data;
                  }
              }]
          }).then(function (res) {
              if (res.cancel === "0") {
                  $scope.bookmark(res.text);
              }
          });

      };

      $rootScope.$on('change_version', function (event, data) {
          Chapter.getBook($stateParams.book, $scope.book_version).then(function (data) {
              book = angular.copy(data);
              $scope.books = data.data.chapters[$stateParams.verse - 1].verses;
              $rootScope.$broadcast('total', data.data.chapters.length);
          });
      });

  })

  .controller('favorites', function ($scope, LocalStore, Chapter, $ionicPopover, $rootScope) {
      var favorites = LocalStore.getObject('favorite');
      $scope.verseData = [];
      $scope.selected = {
          fav: ""
      };


      angular.forEach(favorites, function (favorite) {
          Chapter.getBook(favorite.book, $scope.book_version)
            .then(function (data) {
                var verse = data.data.chapters[favorite.chapter - 1]
                  .verses[favorite.verse - 1][favorite.verse];
                var details = {
                    data: verse,
                    book: favorite.book,
                    chapter: favorite.chapter,
                    verse: favorite.verse
                };
                $scope.verseData.push(details);
            })
      });


      $ionicPopover.fromTemplateUrl('templates/fav_delete.html', {
          scope: $scope
      }).then(function (popover) {
          $scope.popover = popover;
      });

      $scope.openDelete = function ($event, id) {
          $scope.selected.fav = id;
          $scope.popover.show($event);
      };

      $scope.delete = function () {
          favorites.splice($scope.selected.fav, 1);
          $scope.verseData.splice($scope.selected.fav, 1);
          LocalStore.setObject('favorite', favorites);
          $scope.popover.hide();
      };

  })

  .controller('bookmarks', function ($scope, LocalStore, Chapter, $ionicPopover, $ionicPopup) {
      var bookmarks = LocalStore.getObject('bookmark');
      $scope.verseData = [];
      $scope.selected = {
          book: ""
      };

      angular.forEach(bookmarks, function (bookmark) {
          Chapter.getBook(bookmark.selected.book, $scope.book_version)
            .then(function (data) {
                var verse = data.data.chapters[bookmark.selected.chapter - 1]
                  .verses[bookmark.selected.verse - 1][bookmark.selected.verse];
                var details = {
                    data: verse,
                    book: bookmark.selected.book,
                    chapter: bookmark.selected.chapter,
                    verse: bookmark.selected.verse,
                    note: bookmark.note
                };
                $scope.verseData.push(details);
            })
      });

      $ionicPopover.fromTemplateUrl('templates/book_delete_edit.html', {
          scope: $scope
      }).then(function (popover) {
          $scope.popover = popover;
      });

      $scope.openOptions = function ($event, id) {
          $scope.selected.book = id;
          $scope.popover.show($event);
      };

      $scope.delete = function () {
          bookmarks.splice($scope.selected.book, 1);
          $scope.verseData.splice($scope.selected.book, 1);
          LocalStore.setObject('bookmark', bookmarks);
          $scope.popover.hide();
      };

      $scope.edit = function () {
          $scope.data = {
              text: $scope.verseData[$scope.selected.book].note,
              cancel: '0'
          };

          $ionicPopup.show({
              template: '<span> <textarea rows="6" ng-model="data.text" name="bookmark_note"></textarea></span>',
              title: 'Enter your notes',
              scope: $scope,
              buttons: [{
                  text: 'Cancel',
                  onTap: function () {
                      $scope.data.cancel = '1';
                      return $scope.data;
                  }
              }, {
                  text: '<b>Save</b>',
                  type: $scope.buttonClass,
                  onTap: function () {
                      return $scope.data;
                  }
              }]
          }).then(function (res) {
              if (res.cancel === "0") {
                  bookmarks[$scope.selected.book].note = res.text;
                  $scope.verseData[$scope.selected.book].note = res.text;
                  LocalStore.setObject('bookmark', bookmarks)
              }
              $scope.popover.hide();
          });
      }

  });
