angular.module('starter.services', [])

  .factory('Books', function ($http) {
    return {
      all: function (type) {
        if (type === "1")
          return $http.get('data/Books.json');
        else if (type === "2")
          return $http.get('data/new_testament.json');
        else if (type === "3")
          return $http.get('data/old_testament.json');
        else
          return $http.get('data/Books.json');
      }
    }
  })

  .factory('Chapter', function ($http) {
    return {
      getBook: function (book,book_version) {
          return $http.get('data/' + book_version+ '/' + book.split(" ").join("") + '.json');
      }
    }
  })

  .factory('LocalStore', function ($window) {
    return {
      set: function (key, value) {
        $window.localStorage[key] = value;
      },
      get: function (key, defaultValue) {
        return $window.localStorage[key] || defaultValue;
      },
      setObject: function (key, value) {
        $window.localStorage[key] = JSON.stringify(value);
      },
      getObject: function (key) {
        return JSON.parse($window.localStorage[key] || '{}');
      }
    }
  });
