$(document).ready(function () {

    var KORALIK_SRC = "img/koralik.png";
    var KORALIK_BRIGHT_SRC = "img/koralik_bright.png";
    var VERTICAL_LINE = "img/vertical_line.png";
    console.log("initializing Soroban game");

    var XID_REGEXP = /x([0-9]+)y/;
    var YID_REGEXP = /y([0-9]+)/;

    $("img").click(function (event) {
        event.preventDefault();

        var imgId = event.target.id;
        var imgSrc = event.target.src;

        if (imgSrc.indexOf(KORALIK_BRIGHT_SRC) == -1) {
            console.log('Clicked element is not a rod.');
            return;
        }

        var matchesX = XID_REGEXP.exec(imgId);
        var x = parseInt(matchesX[1]);

        var matchesY = YID_REGEXP.exec(imgId);
        var y = parseInt(matchesY[1]);

        console.log('Clicked image with posX: ' + x + ' and posY: ' + y);

        //   $(this).addClass("hidden");

        moveRod($(this), x, y);

    });

    function moveRod(clickedElement, x, y) {
        clickedElement.attr("src", VERTICAL_LINE).attr('onmouseover', '').attr('onmouseout', '');
        var elId;
        var upId;
        if (y == 0) {
            elId = "#x" + x + "y" + (y + 1);
            setKoralik(elId);
        } else if (y == 1) {
            elId = "#x" + x + "y" + (y - 1);
            setKoralik(elId);
        } else {
            moveRods(x, y);
        }
    }

    function moveRods(x, y) {
        var elId;
        if (findEmptySpace(x, y) == 1) {
            for (var l = 0; l < y - 2; l++) {
                elId = "#x" + x + "y" + (y - l - 1);
                setKoralik(elId);
            }
        } else {
            for (var k = 0; k < 6 - y; k++) {
                elId = "#x" + x + "y" + (y + k + 1);
                setKoralik(elId);
            }
        }
    }

    function setKoralik(elId) {
        $(elId).attr("src", KORALIK_SRC).attr('onmouseover', "this.src='img/koralik_bright.png'")
            .attr('onmouseout', "this.src='img/koralik.png'");
    }

    function findEmptySpace(x, y) {
        var found;
        for (var i = 2; i <= 6; i++) {
            var id = "#x" + x + "y" + (i);
            if ($(id).attr('src').indexOf(VERTICAL_LINE) != -1) {
                found = i;
                break;
            }
        }

        if (y > found) return 1; //found up
        else return -1; //found down
    }

    $('#resetButton').click(function (event) {
        $("#sorobanTable tr").each(function () {

            $('td', this).each(function () {
                var img = $(this).find('img');

                var imgId = img.attr('id');

                if (typeof imgId != 'undefined') {
                    var matchesY = YID_REGEXP.exec(imgId);
                    var y = parseInt(matchesY[1]);

                    if (y == 1 || y == 2) {
                        $('#' + imgId).attr("src", VERTICAL_LINE).attr('onmouseover', '').attr('onmouseout', '');
                    } else {
                        setKoralik('#'+imgId);
                    }

                }
            })

        });
    });

});