'use strict';

angular.module('myApp', [
	'ngRoute',
	'myApp.filters',
	'myApp.services',
	'myApp.directives',
	'myApp.controllers'
	])
.factory("LinpackWorker",['$q','$rootScope',function($q,$rootScope){

	var worker = new Worker('./tests/linpack.js');
	var defer;
	var result = 0;

	worker.addEventListener('message', function(e) {
		defer.resolve(e.data);
		result = e.data.score;
		$rootScope.$broadcast('workerend');
	}, false);

	return {
		doWork : function(myData){
			defer = $q.defer();
            worker.postMessage(myData); // Send data to our worker. 
            return defer.promise;
        },
        getResult : function() {
        	return result;
        }
    };

}])
.config(['$locationProvider', '$routeProvider', function($locationProvider, $routeProvider) {
	$routeProvider.when('/main', {templateUrl: 'partials/mainview.html', controller: 'MainController'});
	$routeProvider.otherwise({redirectTo: '/main'});
}]);

var jquery = angular.module('jquery',[]);
jquery.factory('jquery', function(){
	return window.$;
});

