var tx1, tx2;
var SWIPE_THRESHOLD = 100;
var currentPage = 0;

$(document).ready(function(){
	
	$("#pagesblock > div").addClass("swipepage");
	
	var NUM_PAGES = $(".swipepage").size();
	var pageWidth = parseInt($("#swipeDiv").css("width").split("px")[0]);
	$(".swipepage").css("float","left");
	$(".swipepage").css("height",$("#swipeDiv").css("height"));
	$(".swipepage").css("width",pageWidth+"px");
	$("#pagesblock").css("width",(pageWidth*3)+"px");
	console.log(""+pageWidth);
	
	var el = document.getElementById("swipeDiv");
	el.addEventListener("touchmove", pMove, false);
	el.addEventListener("touchstart", tStart, false);
	el.addEventListener("touchend", tEnd, false);
	
	function tStart(e){
		var touches = e.changedTouches;
		tx1 = touches[0].pageX;
		
	}
	function tEnd(e){
		var touches = e.changedTouches;
		tx2 = touches[0].pageX;
		if(tx1 < tx2 - SWIPE_THRESHOLD){
			setPage(currentPage-1);
		}else if(tx1 - SWIPE_THRESHOLD > tx2){
			setPage(currentPage+1);
		}else{
			setPage(currentPage);
		}
		$("#title").text(""+currentPage);
	}
	
	function setPage(num){
		if(num < NUM_PAGES && num >= 0){
			if(num>currentPage){
				$(".swipepage").eq(num).animate({marginLeft:"0px"});
				for(var c = currentPage;c<num;c++){
					$(".swipepage").eq(c).animate({marginLeft:"-"+pageWidth});
				}
				console.log("next");
			}else if(num>currentPage){
				for(var c = currentPage;c>num;c--){
					$(".swipepage").eq(c-1).animate({marginLeft:"0px"});
				}
				console.log("prev");
			}else{
				$(".swipepage").eq(num).animate({marginLeft:"0px"});
			}
			currentPage=num;
		}else{
			$(".swipepage").eq(currentPage).animate({marginLeft:"0px"});
		}
	}
	function pMove(e){
		var touches = e.changedTouches;
		var move =touches[0].pageX-tx1;
		$(".swipepage").eq(currentPage).css("marginLeft",move+"px");
	}
	
});