/*
 This file is part of Firexplorer.

 Firexplorer is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 Firexplorer is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Firexplorer.  If not, see <http://www.gnu.org/licenses/>.
 */

var driveUnit="sdcard"; //the current drive in the explorer
var CurrentPath = new function(val){
    var value = val;

    this.getValue = function(){
        return value;
    };

    this.setValue = function(val){
        pathHistory.push(val);
        value = val;
    };
}; //(object) variable that indicates the current path of explorer

var pathHistory=[]; //history of explorer




var exp_actions = new function() {

    this.goUp = function(){
        if(CurrentPath.getValue()!=''){
            var backPath;
            if(CurrentPath.getValue().indexOf("/")===-1){
                backPath='/';
            }else{
                backPath=CurrentPath.getValue().substring(0,CurrentPath.getValue().lastIndexOf('/'));
            }
            loader.loadDirectory(backPath);
            console.log('going back to:' + backPath);
        }
    }; //function to access the directory above.

    this.goBack = function(){

        if(pathHistory.length>1){

            pathHistory.pop();
            loader.loadDirectory(pathHistory[pathHistory.length-1]);
            pathHistory.pop();

        }
    }; //function to go back in history.

}; //class to go back or go up in explorer.

var loader = new function() {

    this.loadFile = function(filePath){
        var sdcard = navigator.getDeviceStorage('sdcard');

        var getfile = sdcard.get(filePath);

        getfile.onsuccess = function () {
            var thisFile=this.result;
            var thisFileExt=thisFile.name.substring(thisFile.name.lastIndexOf('.')+1);
            var thisFileType=genericFunctions.GetFileTypeFromExt(thisFileExt);

            if(thisFileType!=''){ //check if file extension is registered.
                var openFile = new MozActivity({
                    name: "open",
                    data: {
                        type: thisFileType,
                        blob: thisFile
                    }
                });
            }else{ //try to open the file although its extension isn't registered.
                var openFile = new MozActivity({
                    name: "open",
                    data: {
                        blob: thisFile
                    }
                });
            }
        }

        getfile.onerror = function () {
            console.warn("Unable to get the file: " + this.error);
        }
    }; //function to execute a file.
    this.loadDirectory=function(Path){
    $('#listcontent').empty();
    if(Path=='/'){ //when path is */* the meaning is to load root directory, which is *(empty)* for the API
        Path='';
    }
    if(Path!=''){
        CurrentPath.setValue(Path);
        lvList.changePathLabel('/' + driveUnit + '/' + CurrentPath.getValue());
    }else{
        CurrentPath.setValue('');
        lvList.changePathLabel('/' + driveUnit);
    }
    var lastDirectoryAdded;

    var files = navigator.getDeviceStorage(driveUnit); //get files of Path

    var cursor; //cursor for enumerate files

    var DirectoryBuffer=[]; //to make folders list at begining
    var FileBuffer=[];

    cursor=files.enumerate(Path);

    cursor.onsuccess = function () {
        if(this.result){

            //ALTERNATIVE METHOD, more tangled. Don't try to understand it or you will die. The worst of all is that it works, and faster :/
            /*var file = this.result;
            var absolutename=file.name;
            if(Path!='/'){
                absolutename=absolutename.substring(Path.length+1);
            }
            if(absolutename.indexOf("/")===-1){
                //lvList.addFile(file.name);
                FileBuffer.push(file.name)
            }else{
                //var dirname=absolutename.substring(0,absolutename.indexOf("/"));
                if(absolutename!=lastDirectoryAdded){ //check if dir is already added
                    if (Path == '/') {
                        //lvList.addDirectory(dirname);
                        DirectoryBuffer.push(absolutename);
                    } else {
                        //lvList.addDirectory(Path + '/' + dirname);
                        FileBuffer.push(Path + '/' + absolutename);
                    }
                    lastDirectoryAdded=absolutename;
                }
            }*/


            var fileName=this.result.name.substring(this.result.name.lastIndexOf('/'));
            var filePath=this.result.name;


            if (CurrentPath.getValue() == '') { //we're in root folder, else, we aren't

                if(filePath.indexOf('/')===-1){ //it is a file, that is why there isn't any subfolder
                    FileBuffer.push(filePath);
                }else{//it is a directory
                    var directoryPath=filePath.substring(filePath,filePath.indexOf('/'));
                    if(lastDirectoryAdded!=directoryPath){ //Have we already listed this directory?? If not,
                        DirectoryBuffer.push(directoryPath);
                    }
                    lastDirectoryAdded=directoryPath;
                }

            }else{

                if(filePath.substring(0,filePath.lastIndexOf('/'))==CurrentPath.getValue()){ //if file is on actually folder, list it
                    FileBuffer.push(filePath);
                }else{ //otherwise, that's a file in another directory and we try to list it

                    var directoryName=filePath.substring(CurrentPath.getValue().length); //remove the path before folder
                    directoryName=directoryName.substring(1);
                    directoryName=directoryName.substring(0,directoryName.indexOf("/")); //remove the path after fold
                    var directoryPath=CurrentPath.getValue() + '/' + directoryName;

                    if(lastDirectoryAdded!=directoryPath){ //Have we already listed this directory?? If not,
                        DirectoryBuffer.push(directoryPath);
                    }
                    lastDirectoryAdded=directoryPath;
                }

            }

            console.log('File "' + fileName + '" listed');
            this.continue();
        }else{
            for(var i= 0; i<DirectoryBuffer.length; i++){ //listing directories at beginnin
                lvList.addDirectory(DirectoryBuffer[i]);
            }
            for(var i= 0; i<FileBuffer.length; i++){ //listing directories at beginnin
                lvList.addFile(FileBuffer[i]);
            }
            UpdateEvents();
        }

        /*if (!this.done) {
            this.continue();
        }else{
            UpdateEvents();
        }*/
    };


    cursor.onerror = function () {
        console.warn("No file found: " + this.error);
    };
}; //function to execute a directory (loads it). Too much code, can you improve it? Maybe?

}; //class to execute files or directories.

var lvList = new function() {

    this.addDirectory = function (folderPath){
        var folderName=folderPath.substring(folderPath.lastIndexOf('/')+1);
        $("#listcontent").append("<li class=\"fileItem\" data-icon=\"arrow-r\" explosy-itemtype=\"directory\" explosy-isselected=\"false\" explosy-itempath=\"" + folderPath + "\"><a href=\"#\" class=\"lf\"><img src=\"images/fileicons/folder.png\"><h2>"+folderName+"</h2><p>Directory</p></a></li>");
        $("#listcontent").listview("refresh");
        //UpdateEvents();
    } //function to add listview directory item to listview
    this.addFile = function (filePath){
        var fileName=filePath.substring(filePath.lastIndexOf('/')+1);
        var IconFile='/images/fileicons/nofile.png';
        var FileType='File';
        if(fileName.indexOf('.') !== -1)
        {
            FileType=fileName.substring(fileName.lastIndexOf('.')+1);

            var supportedFiles = ['aac','dat','folder','key','otp','py','txt','aiff','dmg','gif','mid','ots','qt',
                'wav','ai','doc','h',' mp3','ott','rar','xls','avi','dotx','hpp','mp4','rb','xlsx','dwg','html','mpg',
                'pdf','rtf','xml','bmp','dxf','ics','php','sql','yml','c','','eps','iso','odf','png','tga','zip','cpp',
                'exe','java','ods','ppt','tgz','css','flv','jpg','odt','psd','tiff']; //files with image
            for(var i=0;i<supportedFiles.length;i++){
                if(FileType==supportedFiles[i]){
                    IconFile='/images/fileicons/' + FileType + '.png';
                }

            }
            FileType=FileType.toUpperCase() + ' file';
        }
        $("#listcontent").append("<li class=\"fileItem\" data-icon=\"arrow-r\" explosy-itemtype=\"file\" explosy-isselected=\"false\" explosy-itempath=\"" + filePath + "\"><a href=\"#\" class=\"lf\"><img src=\"" + IconFile + "\"><h2>"+fileName+"</h2><p>" + FileType + "</p></a></li>");
        $("#listcontent").listview("refresh");
    }        //function to add listview file item to listview
    this.changePathLabel = function (newText){
        $('#pathtextbox').text(newText);
        if ($('#pathtextbox')[0].scrollWidth >  $('#pathtextbox').width()) { //if text overflow, the align text to left
            $('#pathtextbox').css('direction','rtl');
        }else{
            $('#pathtextbox').css('direction','ltr');
        }
    } //function to update the path label



}; //class to UI items related to the files.

var genericFunctions = new function() {

   /**
    * @return {string}
    */
   this.GetFileTypeFromExt = function(ext){

       if(ext=='vcf'){return "webcontacts/contact"}
       if(ext=='jpg'){return "image/jpeg"}
       if(ext=='png'){return "image/png"}
       if(ext=='gif'){return "image/gif"}
       if(ext=='bmp'){return "image/bmp"}
       if(ext=='mp3'){return "audio/mpeg"}
       if(ext=='ogg'){return "audio/ogg"}
       if(ext=='jpg'){return "image/jpeg"}
       if(ext=='mp4'){return "video/mp4"}
       if(ext=='3gp'){return "video/3gp"}
       return '';
   }; //get file web type of firefox-compatible files.

   this.showWarning = function(text){

       $('body').append("<section role=\'warningmsg\' id=\'temporalwarning\'>" + text + "</section>");

       window.setTimeout(function() {
           $("#temporalwarning").remove();
       }, 2000);

   }; //shows a warning message with firefox os status UX.

   this.createTestFile = function(){
       var sdcard = navigator.getDeviceStorage("sdcard");
       var file   = new Blob(["TESTFILEOEOEOEOEOEOE    I HOPE THAT YOU WILL CONTRIBUTE WITH THIS PROJECT   I LOVE YOU KID  d^-^b"], {type: "text/plain"});

       var request = sdcard.addNamed(file, "test.txt");

       request.onsuccess = function () {
           var name = this.result;
           console.log('File "' + name + '" written');
       };

       // An error typically occur if a file with the same name already exist
       request.onerror = function () {
           console.warn('Unable to write the file: ' + this.error);
       };
   } //creates a test file in current drive.

}; //class to contain functions used by the app in general.
          
          
          
          
          
