/*
 This file is part of Firexplorer.

 Firexplorer is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 Firexplorer is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Firexplorer.  If not, see <http://www.gnu.org/licenses/>.
 */

var selectionMode=false; //property that indicates if selection mode is enabled.


var fileHandlingUI = new function () {

    this.ToggleSelectionMode = function (newMode) {
        if (selectionMode == false && newMode == true) {

            selectionMode = true;
            $(".fileItem").each(function () {
                $(this).attr('data-icon', 'check');
                $(this).find('.ui-icon').addClass('ui-icon-' + 'check');
                $(this).find('.ui-icon').removeClass('ui-icon-' + 'arrow-r');
                $(this).find('.ui-icon').css('visibility', 'hidden');
            });

            $('#pagecontainer').css('background', 'linear-gradient(to bottom,  #feffff 0%,#ddf1f9 56%,#a0d8ef 100%)');
            showFooter(true);
            //$.backstretch('http://dl.dropbox.com/u/515046/www/outside.jpg');
            //$('body').css({background : linear-gradient(to bottom,  #feffff 0%,#ddf1f9 56%,#a0d8ef 100%)});

        } else if (selectionMode == true && newMode == false) {

            selectionMode = false;
            $(".fileItem").each(function () {
                $(this).attr('explosy-isselected', 'false');
                $(this).attr('data-icon', 'arrow-r');
                $(this).find('.ui-icon').addClass('ui-icon-' + 'arrow-r');
                $(this).find('.ui-icon').removeClass('ui-icon-' + 'check');
                $(this).find('.ui-icon').css('visibility', 'visible');
            });
            $('#pagecontainer').css('background', '');
            showFooter(false);

        }

    }; //function to activate the file selection mode

    this.UpdateButtons = function () {
        var isAnySelected = false;
        $(".fileItem").each(function () { //check if there's any file item selected
            if ($(this).attr('explosy-isselected') == 'true') {
                isAnySelected = true;
            }
        });

        if (isAnySelected == true) { //if there's some item selected
            $('#footer-cut-button').css('background', 'linear-gradient(to bottom, #7d7e7d 0%,#0e0e0e 100%)');	//buttons enabled
            $('#footer-copy-button').css('background', 'linear-gradient(to bottom, #7d7e7d 0%,#0e0e0e 100%)');


            //the next functions are to enable hovering
            $("#footer-cut-button").on("mouseover", function () {
                $(this).css("background", "linear-gradient(to bottom, #7d7e7d 0%,#0e0e0e 80%)");
            });
            $("#footer-cut-button").on("mouseleave", function () {
                $(this).css("background", "linear-gradient(to bottom, #7d7e7d 0%,#0e0e0e 100%)");
            });
            $("#footer-copy-button").on("mouseover", function () {
                $(this).css("background", "linear-gradient(to bottom, #7d7e7d 0%,#0e0e0e 80%)");
            });
            $("#footer-copy-button").on("mouseleave", function () {
                $(this).css("background", "linear-gradient(to bottom, #7d7e7d 0%,#0e0e0e 100%)");
            });

        } else {
            $('#footer-cut-button').css('background', '#0e0e0e'); //buttons disabled
            $('#footer-copy-button').css('background', '#0e0e0e');

            //the next functions are to disable hovering
            $("#footer-cut-button").off('mouseover');
            $("#footer-cut-button").off('mouseleave');
            $("#footer-copy-button").off('mouseover');
            $("#footer-copy-button").off('mouseleave');

        }

    }; //function to enable or disable the file operations' buttons depending if files are selected.


    this.FileMoveWindow = new function () {

        this.operationsCompleted=0; //propieties of that window
        this.operationsToComplete=0;
        this.copyMode='';

        this.Show = function (value) { //function to show or hide that window

            if(value==true){
                $('FileMoveWindow').css('display','block');
            }else{
                $('FileMoveWindow').css('display','none');
            }


        };

        this.UpdateProgress = function () { //function to update the progress of that window

        };


    }; //class to manage the window shown during file operations

    var showFooter = function (newValue) {

        var footerVisibility = $('#footercontainer').css('display');

        if (footerVisibility == "none" && newValue == true) {
            //$('#footercontainer').css('display','block');
            //$('#pagecontainer').css('bottom','40px');


            //$( "#footercontainer" ).show();
            $("#footercontainer").slideDown("slow", function () {
                $('#pagecontainer').css('bottom', '40px');
            });
            //$('#footerwrapper').css('display','block');
        } else if (footerVisibility == "block" && newValue == false) {
            //$('#footercontainer').css('display','none');
            $('#pagecontainer').css('bottom', '0px');
            $("#footercontainer").slideUp("slow");
            //$('#footerwrapper').css('display','none');
        }

    }; //function to show or hide the file operations' footer; private


}; //class to manage the file operations' UI elements.

var fileHandling = new function(){

    this.ClipboardFiles = []; //properties that can modify the file moving process.
    this.DestinyPath='';
    this.copyMode='';


    this.MoveFiles = function(){
        if(fileHandlingUI.copyMode=='copy'){
            fileHandlingUI.FileMoveWindow.operationsToComplete=fileHandling.ClipboardFiles.length;
            fileHandlingUI.FileMoveWindow.copyMode='copy';
        }else if(fileHandlingUI.copyMode=='cut'){
            fileHandlingUI.FileMoveWindow.operationsToComplete=fileHandling.ClipboardFiles.length*2; //we will duplicate maximum progress,
            fileHandlingUI.FileMoveWindow.copyMode='cut';                                            //x1 for moving processes, and x2 for copying
        }
        fileHandlingUI.FileMoveWindow.Show(true);

		for(var i=0; i<fileHandling.ClipboardFiles.length; i++){

            var sdcard = navigator.getDeviceStorage('sdcard');

            var getsourcefilerequest = sdcard.get(fileHandling.ClipboardFiles[i]);

            getsourcefilerequest.onsuccess = function () {
                var SourceFile=this.result;

                var newFilePath=fileHandling.DestinyPath + '/' + SourceFile.name; //this is gonna be the new path of the file
                if(newFilePath.substring(0,1)=='/'){newFilePath=newFilePath.substring(1);}
                var moverequest = sdcard.addNamed(SourceFile, newFilePath);

                moverequest.onsuccess = function () {
                    console.log('One File moved');

                    fileHandlingUI.FileMoveWindow.operationsCompleted=fileHandlingUI.FileMoveWindow.operationsCompleted+1; //as we copied the file, the progress is updated
                    fileHandlingUI.FileMoveWindow.UpdateProgress();

                    if(fileHandling.copyMode=='cut'){ //if it is necessary, we will delete the original
                        var deletesourcerequest = sdcard.delete(SourceFile);

                        deletesourcerequest.onsuccess = function () {
                            console.log("File deleted");
                        };

                        deletesourcerequest.onerror = function () {
                            console.log("Unable to delete the file: " + this.error);
                        };
                        fileHandlingUI.FileMoveWindow.operationsCompleted=fileHandlingUI.FileMoveWindow.operationsCompleted+1; //as we copied the file, the progress is updated
                        fileHandlingUI.FileMoveWindow.UpdateProgress();
                    }

                };

                moverequest.onerror = function () {
                    console.warn('Unable to write the file: ' + this.error);
                }


            };
            getsourcefilerequest.onerror = function () {
                console.warn("Unable to get the file: " + this.error);
            }




			

			
	    }
    }; //function to start file moving. files->array DestinyPath->String copyMode->String(can be -cut- or -copy-)
}; //class to manage file operations process.


// TODO List:

//Fix file deleting in move operations
//Copy & paste functions
//OK - put the code beautiful
//OK - Find icons for buttons
//OK - Make the text fit with top textbox
//OK - design icon






