/*
 This file is part of Firexplorer.

 Firexplorer is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 Firexplorer is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Firexplorer.  If not, see <http://www.gnu.org/licenses/>.
 */

$(document).ready(function() {


    //routines to load
    loader.loadDirectory('/');


    //friend events
    $("#footer-close-button").click(function(){
        fileHandlingUI.ToggleSelectionMode(false);
    });

    $('#footer-copy-button').click(function(){
        fileHandling.copyMode='copy';
        //next 2 lines are for debugging proposal
        fileHandling.DestinyPath='copyinsideme';
        fileHandling.MoveFiles();
    });

    $('#footer-cut-button').click(function(){
        fileHandling.copyMode='cut';
        //next 2 lines are for debugging proposal
        fileHandling.DestinyPath='copyinsideme';
        fileHandling.MoveFiles();
    });

    $('#nav-back').click(function(){
        exp_actions.goBack()

    });

    $('#nav-up').click(function(){
        exp_actions.goUp()

    });

}); //event that loads at startup

function UpdateEvents(){
	
	$(".fileItem").click(function(){
  	var itemPath = $(this).attr('explosy-itempath');
	var itemType=$(this).attr('explosy-itemtype');
	if(selectionMode==false){ //we're not in selectionMode, so open the element
		if(itemType=="file"){
			loader.loadFile(itemPath);
		}else if(itemType=="directory"){
			loader.loadDirectory(itemPath);
		}
	}else{ //we are in selection mode, so select the element
	
		if(itemType!="directory"){ //firexplorer can't work with directories (yet)
	
			var isSelected=$(this).attr('explosy-isselected');
			if(isSelected=='true'){ //unselect element
				$(this).attr('explosy-isselected','false');
				$(this).find('.ui-icon').css('visibility','hidden');

                fileHandling.ClipboardFiles.splice(fileHandling.ClipboardFiles.indexOf($(this).attr('explosy-itempath')),1);//remove item from file clipboard
			}else{ //select element
				$(this).attr('explosy-isselected','true');
				$(this).find('.ui-icon').css('visibility','visible');

                fileHandling.ClipboardFiles.push($(this).attr('explosy-itempath')); //add item to file clipboard
			}
		}
		fileHandlingUI.UpdateButtons(); //this function check if there's any item selected. If so, enable or disable copy buttons.
	}
	});  //when a fileItem is clicked (we can be in selectionMode)
	
}  //this function adds their events to each fileItem show.