var $hxClasses = $hxClasses || {},$estr = function() { return js.Boot.__string_rec(this,''); };
function $extend(from, fields) {
	function inherit() {}; inherit.prototype = from; var proto = new inherit();
	for (var name in fields) proto[name] = fields[name];
	return proto;
}
var EReg = $hxClasses["EReg"] = function(r,opt) {
	opt = opt.split("u").join("");
	this.r = new RegExp(r,opt);
};
EReg.__name__ = ["EReg"];
EReg.prototype = {
	customReplace: function(s,f) {
		var buf = new StringBuf();
		while(true) {
			if(!this.match(s)) break;
			buf.b += Std.string(this.matchedLeft());
			buf.b += Std.string(f(this));
			s = this.matchedRight();
		}
		buf.b += Std.string(s);
		return buf.b;
	}
	,replace: function(s,by) {
		return s.replace(this.r,by);
	}
	,split: function(s) {
		var d = "#__delim__#";
		return s.replace(this.r,d).split(d);
	}
	,matchedPos: function() {
		if(this.r.m == null) throw "No string matched";
		return { pos : this.r.m.index, len : this.r.m[0].length};
	}
	,matchedRight: function() {
		if(this.r.m == null) throw "No string matched";
		var sz = this.r.m.index + this.r.m[0].length;
		return this.r.s.substr(sz,this.r.s.length - sz);
	}
	,matchedLeft: function() {
		if(this.r.m == null) throw "No string matched";
		return this.r.s.substr(0,this.r.m.index);
	}
	,matched: function(n) {
		return this.r.m != null && n >= 0 && n < this.r.m.length?this.r.m[n]:(function($this) {
			var $r;
			throw "EReg::matched";
			return $r;
		}(this));
	}
	,match: function(s) {
		if(this.r.global) this.r.lastIndex = 0;
		this.r.m = this.r.exec(s);
		this.r.s = s;
		return this.r.m != null;
	}
	,r: null
	,__class__: EReg
}
var HxOverrides = $hxClasses["HxOverrides"] = function() { }
HxOverrides.__name__ = ["HxOverrides"];
HxOverrides.dateStr = function(date) {
	var m = date.getMonth() + 1;
	var d = date.getDate();
	var h = date.getHours();
	var mi = date.getMinutes();
	var s = date.getSeconds();
	return date.getFullYear() + "-" + (m < 10?"0" + m:"" + m) + "-" + (d < 10?"0" + d:"" + d) + " " + (h < 10?"0" + h:"" + h) + ":" + (mi < 10?"0" + mi:"" + mi) + ":" + (s < 10?"0" + s:"" + s);
}
HxOverrides.strDate = function(s) {
	switch(s.length) {
	case 8:
		var k = s.split(":");
		var d = new Date();
		d.setTime(0);
		d.setUTCHours(k[0]);
		d.setUTCMinutes(k[1]);
		d.setUTCSeconds(k[2]);
		return d;
	case 10:
		var k = s.split("-");
		return new Date(k[0],k[1] - 1,k[2],0,0,0);
	case 19:
		var k = s.split(" ");
		var y = k[0].split("-");
		var t = k[1].split(":");
		return new Date(y[0],y[1] - 1,y[2],t[0],t[1],t[2]);
	default:
		throw "Invalid date format : " + s;
	}
}
HxOverrides.cca = function(s,index) {
	var x = s.charCodeAt(index);
	if(x != x) return undefined;
	return x;
}
HxOverrides.substr = function(s,pos,len) {
	if(pos != null && pos != 0 && len != null && len < 0) return "";
	if(len == null) len = s.length;
	if(pos < 0) {
		pos = s.length + pos;
		if(pos < 0) pos = 0;
	} else if(len < 0) len = s.length + len - pos;
	return s.substr(pos,len);
}
HxOverrides.remove = function(a,obj) {
	var i = 0;
	var l = a.length;
	while(i < l) {
		if(a[i] == obj) {
			a.splice(i,1);
			return true;
		}
		i++;
	}
	return false;
}
HxOverrides.iter = function(a) {
	return { cur : 0, arr : a, hasNext : function() {
		return this.cur < this.arr.length;
	}, next : function() {
		return this.arr[this.cur++];
	}};
}
var IntIter = $hxClasses["IntIter"] = function(min,max) {
	this.min = min;
	this.max = max;
};
IntIter.__name__ = ["IntIter"];
IntIter.prototype = {
	next: function() {
		return this.min++;
	}
	,hasNext: function() {
		return this.min < this.max;
	}
	,max: null
	,min: null
	,__class__: IntIter
}
var Lambda = $hxClasses["Lambda"] = function() { }
Lambda.__name__ = ["Lambda"];
Lambda.array = function(it) {
	var a = new Array();
	var $it0 = $iterator(it)();
	while( $it0.hasNext() ) {
		var i = $it0.next();
		a.push(i);
	}
	return a;
}
Lambda.list = function(it) {
	var l = new List();
	var $it0 = $iterator(it)();
	while( $it0.hasNext() ) {
		var i = $it0.next();
		l.add(i);
	}
	return l;
}
Lambda.map = function(it,f) {
	var l = new List();
	var $it0 = $iterator(it)();
	while( $it0.hasNext() ) {
		var x = $it0.next();
		l.add(f(x));
	}
	return l;
}
Lambda.mapi = function(it,f) {
	var l = new List();
	var i = 0;
	var $it0 = $iterator(it)();
	while( $it0.hasNext() ) {
		var x = $it0.next();
		l.add(f(i++,x));
	}
	return l;
}
Lambda.has = function(it,elt,cmp) {
	if(cmp == null) {
		var $it0 = $iterator(it)();
		while( $it0.hasNext() ) {
			var x = $it0.next();
			if(x == elt) return true;
		}
	} else {
		var $it1 = $iterator(it)();
		while( $it1.hasNext() ) {
			var x = $it1.next();
			if(cmp(x,elt)) return true;
		}
	}
	return false;
}
Lambda.exists = function(it,f) {
	var $it0 = $iterator(it)();
	while( $it0.hasNext() ) {
		var x = $it0.next();
		if(f(x)) return true;
	}
	return false;
}
Lambda.foreach = function(it,f) {
	var $it0 = $iterator(it)();
	while( $it0.hasNext() ) {
		var x = $it0.next();
		if(!f(x)) return false;
	}
	return true;
}
Lambda.iter = function(it,f) {
	var $it0 = $iterator(it)();
	while( $it0.hasNext() ) {
		var x = $it0.next();
		f(x);
	}
}
Lambda.filter = function(it,f) {
	var l = new List();
	var $it0 = $iterator(it)();
	while( $it0.hasNext() ) {
		var x = $it0.next();
		if(f(x)) l.add(x);
	}
	return l;
}
Lambda.fold = function(it,f,first) {
	var $it0 = $iterator(it)();
	while( $it0.hasNext() ) {
		var x = $it0.next();
		first = f(x,first);
	}
	return first;
}
Lambda.count = function(it,pred) {
	var n = 0;
	if(pred == null) {
		var $it0 = $iterator(it)();
		while( $it0.hasNext() ) {
			var _ = $it0.next();
			n++;
		}
	} else {
		var $it1 = $iterator(it)();
		while( $it1.hasNext() ) {
			var x = $it1.next();
			if(pred(x)) n++;
		}
	}
	return n;
}
Lambda.empty = function(it) {
	return !$iterator(it)().hasNext();
}
Lambda.indexOf = function(it,v) {
	var i = 0;
	var $it0 = $iterator(it)();
	while( $it0.hasNext() ) {
		var v2 = $it0.next();
		if(v == v2) return i;
		i++;
	}
	return -1;
}
Lambda.concat = function(a,b) {
	var l = new List();
	var $it0 = $iterator(a)();
	while( $it0.hasNext() ) {
		var x = $it0.next();
		l.add(x);
	}
	var $it1 = $iterator(b)();
	while( $it1.hasNext() ) {
		var x = $it1.next();
		l.add(x);
	}
	return l;
}
var List = $hxClasses["List"] = function() {
	this.length = 0;
};
List.__name__ = ["List"];
List.prototype = {
	map: function(f) {
		var b = new List();
		var l = this.h;
		while(l != null) {
			var v = l[0];
			l = l[1];
			b.add(f(v));
		}
		return b;
	}
	,filter: function(f) {
		var l2 = new List();
		var l = this.h;
		while(l != null) {
			var v = l[0];
			l = l[1];
			if(f(v)) l2.add(v);
		}
		return l2;
	}
	,join: function(sep) {
		var s = new StringBuf();
		var first = true;
		var l = this.h;
		while(l != null) {
			if(first) first = false; else s.b += Std.string(sep);
			s.b += Std.string(l[0]);
			l = l[1];
		}
		return s.b;
	}
	,toString: function() {
		var s = new StringBuf();
		var first = true;
		var l = this.h;
		s.b += Std.string("{");
		while(l != null) {
			if(first) first = false; else s.b += Std.string(", ");
			s.b += Std.string(Std.string(l[0]));
			l = l[1];
		}
		s.b += Std.string("}");
		return s.b;
	}
	,iterator: function() {
		return { h : this.h, hasNext : function() {
			return this.h != null;
		}, next : function() {
			if(this.h == null) return null;
			var x = this.h[0];
			this.h = this.h[1];
			return x;
		}};
	}
	,remove: function(v) {
		var prev = null;
		var l = this.h;
		while(l != null) {
			if(l[0] == v) {
				if(prev == null) this.h = l[1]; else prev[1] = l[1];
				if(this.q == l) this.q = prev;
				this.length--;
				return true;
			}
			prev = l;
			l = l[1];
		}
		return false;
	}
	,clear: function() {
		this.h = null;
		this.q = null;
		this.length = 0;
	}
	,isEmpty: function() {
		return this.h == null;
	}
	,pop: function() {
		if(this.h == null) return null;
		var x = this.h[0];
		this.h = this.h[1];
		if(this.h == null) this.q = null;
		this.length--;
		return x;
	}
	,last: function() {
		return this.q == null?null:this.q[0];
	}
	,first: function() {
		return this.h == null?null:this.h[0];
	}
	,push: function(item) {
		var x = [item,this.h];
		this.h = x;
		if(this.q == null) this.q = x;
		this.length++;
	}
	,add: function(item) {
		var x = [item];
		if(this.h == null) this.h = x; else this.q[1] = x;
		this.q = x;
		this.length++;
	}
	,length: null
	,q: null
	,h: null
	,__class__: List
}
var Reflect = $hxClasses["Reflect"] = function() { }
Reflect.__name__ = ["Reflect"];
Reflect.hasField = function(o,field) {
	return Object.prototype.hasOwnProperty.call(o,field);
}
Reflect.field = function(o,field) {
	var v = null;
	try {
		v = o[field];
	} catch( e ) {
	}
	return v;
}
Reflect.setField = function(o,field,value) {
	o[field] = value;
}
Reflect.getProperty = function(o,field) {
	var tmp;
	return o == null?null:o.__properties__ && (tmp = o.__properties__["get_" + field])?o[tmp]():o[field];
}
Reflect.setProperty = function(o,field,value) {
	var tmp;
	if(o.__properties__ && (tmp = o.__properties__["set_" + field])) o[tmp](value); else o[field] = value;
}
Reflect.callMethod = function(o,func,args) {
	return func.apply(o,args);
}
Reflect.fields = function(o) {
	var a = [];
	if(o != null) {
		var hasOwnProperty = Object.prototype.hasOwnProperty;
		for( var f in o ) {
		if(hasOwnProperty.call(o,f)) a.push(f);
		}
	}
	return a;
}
Reflect.isFunction = function(f) {
	return typeof(f) == "function" && !(f.__name__ || f.__ename__);
}
Reflect.compare = function(a,b) {
	return a == b?0:a > b?1:-1;
}
Reflect.compareMethods = function(f1,f2) {
	if(f1 == f2) return true;
	if(!Reflect.isFunction(f1) || !Reflect.isFunction(f2)) return false;
	return f1.scope == f2.scope && f1.method == f2.method && f1.method != null;
}
Reflect.isObject = function(v) {
	if(v == null) return false;
	var t = typeof(v);
	return t == "string" || t == "object" && !v.__enum__ || t == "function" && (v.__name__ || v.__ename__);
}
Reflect.deleteField = function(o,f) {
	if(!Reflect.hasField(o,f)) return false;
	delete(o[f]);
	return true;
}
Reflect.copy = function(o) {
	var o2 = { };
	var _g = 0, _g1 = Reflect.fields(o);
	while(_g < _g1.length) {
		var f = _g1[_g];
		++_g;
		o2[f] = Reflect.field(o,f);
	}
	return o2;
}
Reflect.makeVarArgs = function(f) {
	return function() {
		var a = Array.prototype.slice.call(arguments);
		return f(a);
	};
}
var Std = $hxClasses["Std"] = function() { }
Std.__name__ = ["Std"];
Std["is"] = function(v,t) {
	return js.Boot.__instanceof(v,t);
}
Std.string = function(s) {
	return js.Boot.__string_rec(s,"");
}
Std["int"] = function(x) {
	return x | 0;
}
Std.parseInt = function(x) {
	var v = parseInt(x,10);
	if(v == 0 && (HxOverrides.cca(x,1) == 120 || HxOverrides.cca(x,1) == 88)) v = parseInt(x);
	if(isNaN(v)) return null;
	return v;
}
Std.parseFloat = function(x) {
	return parseFloat(x);
}
Std.random = function(x) {
	return Math.floor(Math.random() * x);
}
var StringBuf = $hxClasses["StringBuf"] = function() {
	this.b = "";
};
StringBuf.__name__ = ["StringBuf"];
StringBuf.prototype = {
	toString: function() {
		return this.b;
	}
	,addSub: function(s,pos,len) {
		this.b += HxOverrides.substr(s,pos,len);
	}
	,addChar: function(c) {
		this.b += String.fromCharCode(c);
	}
	,add: function(x) {
		this.b += Std.string(x);
	}
	,b: null
	,__class__: StringBuf
}
var StringTools = $hxClasses["StringTools"] = function() { }
StringTools.__name__ = ["StringTools"];
StringTools.urlEncode = function(s) {
	return encodeURIComponent(s);
}
StringTools.urlDecode = function(s) {
	return decodeURIComponent(s.split("+").join(" "));
}
StringTools.htmlEscape = function(s) {
	return s.split("&").join("&amp;").split("<").join("&lt;").split(">").join("&gt;");
}
StringTools.htmlUnescape = function(s) {
	return s.split("&gt;").join(">").split("&lt;").join("<").split("&amp;").join("&");
}
StringTools.startsWith = function(s,start) {
	return s.length >= start.length && HxOverrides.substr(s,0,start.length) == start;
}
StringTools.endsWith = function(s,end) {
	var elen = end.length;
	var slen = s.length;
	return slen >= elen && HxOverrides.substr(s,slen - elen,elen) == end;
}
StringTools.isSpace = function(s,pos) {
	var c = HxOverrides.cca(s,pos);
	return c >= 9 && c <= 13 || c == 32;
}
StringTools.ltrim = function(s) {
	var l = s.length;
	var r = 0;
	while(r < l && StringTools.isSpace(s,r)) r++;
	if(r > 0) return HxOverrides.substr(s,r,l - r); else return s;
}
StringTools.rtrim = function(s) {
	var l = s.length;
	var r = 0;
	while(r < l && StringTools.isSpace(s,l - r - 1)) r++;
	if(r > 0) return HxOverrides.substr(s,0,l - r); else return s;
}
StringTools.trim = function(s) {
	return StringTools.ltrim(StringTools.rtrim(s));
}
StringTools.rpad = function(s,c,l) {
	var sl = s.length;
	var cl = c.length;
	while(sl < l) if(l - sl < cl) {
		s += HxOverrides.substr(c,0,l - sl);
		sl = l;
	} else {
		s += c;
		sl += cl;
	}
	return s;
}
StringTools.lpad = function(s,c,l) {
	var ns = "";
	var sl = s.length;
	if(sl >= l) return s;
	var cl = c.length;
	while(sl < l) if(l - sl < cl) {
		ns += HxOverrides.substr(c,0,l - sl);
		sl = l;
	} else {
		ns += c;
		sl += cl;
	}
	return ns + s;
}
StringTools.replace = function(s,sub,by) {
	return s.split(sub).join(by);
}
StringTools.hex = function(n,digits) {
	var s = "";
	var hexChars = "0123456789ABCDEF";
	do {
		s = hexChars.charAt(n & 15) + s;
		n >>>= 4;
	} while(n > 0);
	if(digits != null) while(s.length < digits) s = "0" + s;
	return s;
}
StringTools.fastCodeAt = function(s,index) {
	return s.charCodeAt(index);
}
StringTools.isEOF = function(c) {
	return c != c;
}
var ValueType = $hxClasses["ValueType"] = { __ename__ : ["ValueType"], __constructs__ : ["TNull","TInt","TFloat","TBool","TObject","TFunction","TClass","TEnum","TUnknown"] }
ValueType.TNull = ["TNull",0];
ValueType.TNull.toString = $estr;
ValueType.TNull.__enum__ = ValueType;
ValueType.TInt = ["TInt",1];
ValueType.TInt.toString = $estr;
ValueType.TInt.__enum__ = ValueType;
ValueType.TFloat = ["TFloat",2];
ValueType.TFloat.toString = $estr;
ValueType.TFloat.__enum__ = ValueType;
ValueType.TBool = ["TBool",3];
ValueType.TBool.toString = $estr;
ValueType.TBool.__enum__ = ValueType;
ValueType.TObject = ["TObject",4];
ValueType.TObject.toString = $estr;
ValueType.TObject.__enum__ = ValueType;
ValueType.TFunction = ["TFunction",5];
ValueType.TFunction.toString = $estr;
ValueType.TFunction.__enum__ = ValueType;
ValueType.TClass = function(c) { var $x = ["TClass",6,c]; $x.__enum__ = ValueType; $x.toString = $estr; return $x; }
ValueType.TEnum = function(e) { var $x = ["TEnum",7,e]; $x.__enum__ = ValueType; $x.toString = $estr; return $x; }
ValueType.TUnknown = ["TUnknown",8];
ValueType.TUnknown.toString = $estr;
ValueType.TUnknown.__enum__ = ValueType;
var Type = $hxClasses["Type"] = function() { }
Type.__name__ = ["Type"];
Type.getClass = function(o) {
	if(o == null) return null;
	return o.__class__;
}
Type.getEnum = function(o) {
	if(o == null) return null;
	return o.__enum__;
}
Type.getSuperClass = function(c) {
	return c.__super__;
}
Type.getClassName = function(c) {
	var a = c.__name__;
	return a.join(".");
}
Type.getEnumName = function(e) {
	var a = e.__ename__;
	return a.join(".");
}
Type.resolveClass = function(name) {
	var cl = $hxClasses[name];
	if(cl == null || !cl.__name__) return null;
	return cl;
}
Type.resolveEnum = function(name) {
	var e = $hxClasses[name];
	if(e == null || !e.__ename__) return null;
	return e;
}
Type.createInstance = function(cl,args) {
	switch(args.length) {
	case 0:
		return new cl();
	case 1:
		return new cl(args[0]);
	case 2:
		return new cl(args[0],args[1]);
	case 3:
		return new cl(args[0],args[1],args[2]);
	case 4:
		return new cl(args[0],args[1],args[2],args[3]);
	case 5:
		return new cl(args[0],args[1],args[2],args[3],args[4]);
	case 6:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5]);
	case 7:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5],args[6]);
	case 8:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5],args[6],args[7]);
	default:
		throw "Too many arguments";
	}
	return null;
}
Type.createEmptyInstance = function(cl) {
	function empty() {}; empty.prototype = cl.prototype;
	return new empty();
}
Type.createEnum = function(e,constr,params) {
	var f = Reflect.field(e,constr);
	if(f == null) throw "No such constructor " + constr;
	if(Reflect.isFunction(f)) {
		if(params == null) throw "Constructor " + constr + " need parameters";
		return f.apply(e,params);
	}
	if(params != null && params.length != 0) throw "Constructor " + constr + " does not need parameters";
	return f;
}
Type.createEnumIndex = function(e,index,params) {
	var c = e.__constructs__[index];
	if(c == null) throw index + " is not a valid enum constructor index";
	return Type.createEnum(e,c,params);
}
Type.getInstanceFields = function(c) {
	var a = [];
	for(var i in c.prototype) a.push(i);
	HxOverrides.remove(a,"__class__");
	HxOverrides.remove(a,"__properties__");
	return a;
}
Type.getClassFields = function(c) {
	var a = Reflect.fields(c);
	HxOverrides.remove(a,"__name__");
	HxOverrides.remove(a,"__interfaces__");
	HxOverrides.remove(a,"__properties__");
	HxOverrides.remove(a,"__super__");
	HxOverrides.remove(a,"prototype");
	return a;
}
Type.getEnumConstructs = function(e) {
	var a = e.__constructs__;
	return a.slice();
}
Type["typeof"] = function(v) {
	switch(typeof(v)) {
	case "boolean":
		return ValueType.TBool;
	case "string":
		return ValueType.TClass(String);
	case "number":
		if(Math.ceil(v) == v % 2147483648.0) return ValueType.TInt;
		return ValueType.TFloat;
	case "object":
		if(v == null) return ValueType.TNull;
		var e = v.__enum__;
		if(e != null) return ValueType.TEnum(e);
		var c = v.__class__;
		if(c != null) return ValueType.TClass(c);
		return ValueType.TObject;
	case "function":
		if(v.__name__ || v.__ename__) return ValueType.TObject;
		return ValueType.TFunction;
	case "undefined":
		return ValueType.TNull;
	default:
		return ValueType.TUnknown;
	}
}
Type.enumEq = function(a,b) {
	if(a == b) return true;
	try {
		if(a[0] != b[0]) return false;
		var _g1 = 2, _g = a.length;
		while(_g1 < _g) {
			var i = _g1++;
			if(!Type.enumEq(a[i],b[i])) return false;
		}
		var e = a.__enum__;
		if(e != b.__enum__ || e == null) return false;
	} catch( e ) {
		return false;
	}
	return true;
}
Type.enumConstructor = function(e) {
	return e[0];
}
Type.enumParameters = function(e) {
	return e.slice(2);
}
Type.enumIndex = function(e) {
	return e[1];
}
Type.allEnums = function(e) {
	var all = [];
	var cst = e.__constructs__;
	var _g = 0;
	while(_g < cst.length) {
		var c = cst[_g];
		++_g;
		var v = Reflect.field(e,c);
		if(!Reflect.isFunction(v)) all.push(v);
	}
	return all;
}
var co = co || {}
if(!co.doubleduck) co.doubleduck = {}
co.doubleduck.BaseAssets = $hxClasses["co.doubleduck.BaseAssets"] = function() {
};
co.doubleduck.BaseAssets.__name__ = ["co","doubleduck","BaseAssets"];
co.doubleduck.BaseAssets._localizedAssets = null;
co.doubleduck.BaseAssets.loader = function() {
	if(co.doubleduck.BaseAssets._loader == null) {
		co.doubleduck.BaseAssets._loader = new createjs.LoadQueue(true);
		co.doubleduck.BaseAssets._loader.installPlugin(createjs.LoadQueue.SOUND);
		co.doubleduck.BaseAssets._loader.onFileLoad = co.doubleduck.BaseAssets.handleFileLoaded;
		co.doubleduck.BaseAssets._loader.onError = co.doubleduck.BaseAssets.handleLoadError;
		co.doubleduck.BaseAssets._loader.setMaxConnections(10);
	}
	return co.doubleduck.BaseAssets._loader;
}
co.doubleduck.BaseAssets.loadAndCall = function(uri,callbackFunc) {
	co.doubleduck.BaseAssets.loader().loadFile(uri);
	co.doubleduck.BaseAssets._loadCallbacks[uri] = callbackFunc;
}
co.doubleduck.BaseAssets.finishLoading = function(manifest,sounds) {
	if(co.doubleduck.SoundManager.available) {
		var _g1 = 0, _g = sounds.length;
		while(_g1 < _g) {
			var currSound = _g1++;
			manifest.push(sounds[currSound] + co.doubleduck.SoundManager.EXTENSION);
			co.doubleduck.SoundManager.initSound(sounds[currSound]);
		}
	}
	if(co.doubleduck.BaseAssets._useLocalStorage) co.doubleduck.BaseAssets.loadFromLocalStorage(manifest);
	if(manifest.length == 0) {
		if(co.doubleduck.BaseAssets.onLoadAll != null) co.doubleduck.BaseAssets.onLoadAll();
	}
	if(co.doubleduck.BaseGame.isLocalized && co.doubleduck.BaseAssets._localizedAssets != null) {
		var _g1 = 0, _g = manifest.length;
		while(_g1 < _g) {
			var itemIndex = _g1++;
			var currItem = manifest[itemIndex];
			currItem = co.doubleduck.BaseAssets.getLocalisedImage(currItem);
			manifest[itemIndex] = currItem;
		}
	}
	co.doubleduck.BaseAssets.loader().onProgress = co.doubleduck.BaseAssets.handleProgress;
	co.doubleduck.BaseAssets.loader().onFileLoad = co.doubleduck.BaseAssets.manifestFileLoad;
	co.doubleduck.BaseAssets.loader().loadManifest(manifest);
	co.doubleduck.BaseAssets.loader().load();
}
co.doubleduck.BaseAssets.loadAll = function(manifest,sounds) {
	manifest[manifest.length] = "images/duckling/orientation_error_port.png";
	manifest[manifest.length] = "images/duckling/orientation_error_land.png";
	manifest[manifest.length] = "images/duckling/page_marker.png";
}
co.doubleduck.BaseAssets.setLocalizedAssets = function(assets) {
	co.doubleduck.BaseAssets._localizedAssets = assets;
}
co.doubleduck.BaseAssets.audioLoaded = function(event) {
	co.doubleduck.BaseAssets._cacheData[event.item.src] = event;
}
co.doubleduck.BaseAssets.manifestFileLoad = function(event) {
	if(co.doubleduck.BaseAssets._useLocalStorage && event != null) {
		var utils = new ddjsutils();
		try {
			var fileName = event.item.src;
			if(HxOverrides.substr(fileName,fileName.length - 3,null) == "jpg") return;
			co.doubleduck.BasePersistence.setValue(event.item.src,utils.getBase64Image(event.result));
		} catch( err ) {
		}
	}
}
co.doubleduck.BaseAssets.loadFromLocalStorage = function(manifest) {
	var entriesToRemove = new Array();
	var _g1 = 0, _g = manifest.length;
	while(_g1 < _g) {
		var i = _g1++;
		var entry = manifest[i];
		var value = co.doubleduck.BasePersistence.getValue(entry);
		if(value != null) {
			var bmp = new createjs.Bitmap("data:image/png;base64," + value);
			co.doubleduck.BaseAssets._cacheData[entry] = bmp.image;
			entriesToRemove.push(manifest[i]);
		}
	}
	var _g1 = 0, _g = entriesToRemove.length;
	while(_g1 < _g) {
		var j = _g1++;
		HxOverrides.remove(manifest,entriesToRemove[j]);
	}
}
co.doubleduck.BaseAssets.handleProgress = function(event) {
	co.doubleduck.BaseAssets.loaded = event.loaded;
	if(event.loaded == event.total) {
		co.doubleduck.BaseAssets.loader().onProgress = null;
		co.doubleduck.BaseAssets.onLoadAll();
	}
}
co.doubleduck.BaseAssets.handleLoadError = function(event) {
}
co.doubleduck.BaseAssets.handleFileLoaded = function(event) {
	if(event != null) {
		co.doubleduck.BaseAssets._cacheData[event.item.src] = event.result;
		var callbackFunc = Reflect.field(co.doubleduck.BaseAssets._loadCallbacks,event.item.src);
		if(callbackFunc != null) callbackFunc();
	}
}
co.doubleduck.BaseAssets.getAsset = function(uri) {
	var cache = Reflect.field(co.doubleduck.BaseAssets._cacheData,uri);
	if(cache == null) {
		if(co.doubleduck.BaseAssets.loader().getResult(uri) != null) {
			cache = co.doubleduck.BaseAssets.loader().getResult(uri);
			co.doubleduck.BaseAssets._cacheData[uri] = cache;
		}
	}
	return cache;
}
co.doubleduck.BaseAssets.getLocalisedImage = function(image) {
	var currItem = image;
	if(co.doubleduck.BaseAssets._localizedAssets != null && Lambda.indexOf(co.doubleduck.BaseAssets._localizedAssets,currItem) != -1) {
		var delim = ".png";
		var delimIndex = currItem.indexOf(delim);
		var localisedItem = HxOverrides.substr(currItem,0,delimIndex);
		localisedItem += "-" + co.doubleduck.BaseGame.activeLocale + ".png";
		return localisedItem;
	}
	return currItem;
}
co.doubleduck.BaseAssets.getRawImage = function(uri) {
	uri = co.doubleduck.BaseAssets.getLocalisedImage(uri);
	var cache = co.doubleduck.BaseAssets.getAsset(uri);
	if(cache == null) {
		var bmp = new createjs.Bitmap(uri);
		co.doubleduck.BaseAssets._cacheData[uri] = bmp.image;
		cache = bmp.image;
		null;
	}
	return cache;
}
co.doubleduck.BaseAssets.getImage = function(uri,mouseEnabled) {
	if(mouseEnabled == null) mouseEnabled = false;
	var result = new createjs.Bitmap(co.doubleduck.BaseAssets.getRawImage(uri));
	result.mouseEnabled = mouseEnabled;
	return result;
}
co.doubleduck.BaseAssets.prototype = {
	__class__: co.doubleduck.BaseAssets
}
co.doubleduck.Assets = $hxClasses["co.doubleduck.Assets"] = function() {
	co.doubleduck.BaseAssets.call(this);
};
co.doubleduck.Assets.__name__ = ["co","doubleduck","Assets"];
co.doubleduck.Assets.loadAll = function() {
	var manifest = new Array();
	var sounds = new Array();
	sounds.push("sound/button_press");
	sounds.push("sound/catch_item");
	sounds.push("sound/fish_bonus");
	sounds.push("sound/got_fish");
	sounds.push("sound/got_trash");
	sounds.push("sound/level_fail");
	sounds.push("sound/level_pass");
	sounds.push("sound/menu-theme");
	sounds.push("sound/multiplier_bonus");
	sounds.push("sound/time_bonus");
	co.doubleduck.BaseAssets.loadAll(manifest,sounds);
	var localisedAssets = [];
	manifest.push("images/general/bg1.jpg");
	manifest.push("images/general/bg2.jpg");
	manifest.push("images/general/bg3.jpg");
	manifest.push("images/general/bg4.jpg");
	manifest.push("images/splash/logo.png");
	manifest.push("images/menu/level_icons.png");
	manifest.push("images/menu/arrow_right.png");
	manifest.push("images/menu/arrow_left.png");
	manifest.push("images/menu/help.png");
	manifest.push("images/menu/sound.png");
	manifest.push("images/menu/help_screen.png");
	manifest.push("images/menu/gotit.png");
	localisedAssets = localisedAssets.concat(["images/menu/gotit.png","images/menu/help_screen.png"]);
	var _g = 0;
	while(_g < 10) {
		var i = _g++;
		manifest.push("images/general/font_small/" + i + ".png");
		manifest.push("images/menu/menu_font/" + i + ".png");
	}
	manifest.push("images/general/font_small/comma.png");
	manifest.push("images/session/hook.png");
	manifest.push("images/session/laser_short.png");
	manifest.push("images/session/laser_long.png");
	manifest.push("images/session/tnt.png");
	manifest.push("images/session/fish1.png");
	manifest.push("images/session/fish1b.png");
	manifest.push("images/session/fish2.png");
	manifest.push("images/session/fish3.png");
	manifest.push("images/session/fish4.png");
	manifest.push("images/session/fish5.png");
	manifest.push("images/session/bad1.png");
	manifest.push("images/session/bad2.png");
	manifest.push("images/session/time.png");
	manifest.push("images/session/timeicon.png");
	manifest.push("images/session/xp.png");
	manifest.push("images/session/explosion.png");
	manifest.push("images/session/turn_good.png");
	manifest.push("images/session/paused.png");
	manifest.push("images/session/pause_btn.png");
	manifest.push("images/session/hud.png");
	manifest.push("images/session/1bomb.png");
	manifest.push("images/session/2bomb.png");
	localisedAssets = localisedAssets.concat(["images/session/get.png","images/session/go.png","images/session/goal.png","images/session/in.png","images/session/paused.png","images/session/points.png"]);
	manifest.push("images/session/message_overlay.png");
	manifest.push("images/session/get.png");
	manifest.push("images/session/in.png");
	manifest.push("images/session/moves.png");
	manifest.push("images/session/go.png");
	manifest.push("images/session/points.png");
	manifest.push("images/session/level_end/got.png");
	manifest.push("images/session/level_end/in.png");
	manifest.push("images/session/level_end/win.png");
	manifest.push("images/session/level_end/failed.png");
	manifest.push("images/session/level_end/failure_hooks.png");
	manifest.push("images/session/level_end/failure_time.png");
	manifest.push("images/session/level_end/menu.png");
	manifest.push("images/session/level_end/next.png");
	manifest.push("images/session/level_end/retry.png");
	manifest.push("images/session/level_end/stars_base.png");
	manifest.push("images/session/level_end/1star.png");
	manifest.push("images/session/level_end/2star.png");
	manifest.push("images/session/level_end/3star.png");
	manifest.push("images/session/level_end/fast_hook1.png");
	manifest.push("images/session/level_end/fast_hook2.png");
	manifest.push("images/session/level_end/dynamite1.png");
	manifest.push("images/session/level_end/dynamite2.png");
	manifest.push("images/session/level_end/laser_hook1.png");
	manifest.push("images/session/level_end/laser_hook2.png");
	manifest.push("images/session/level_end/endgame.png");
	localisedAssets = localisedAssets.concat(["images/session/level_end/dynamite1.png","images/session/level_end/dynamite2.png","images/session/level_end/endgame.png","images/session/level_end/failed.png","images/session/level_end/failure_hooks.png","images/session/level_end/failure_time.png","images/session/level_end/fast_hook1.png","images/session/level_end/fast_hook2.png","images/session/level_end/got.png","images/session/level_end/in.png","images/session/level_end/laser_hook1.png","images/session/level_end/laser_hook2.png","images/session/level_end/win.png"]);
	co.doubleduck.BaseAssets.setLocalizedAssets(localisedAssets);
	co.doubleduck.BaseAssets.finishLoading(manifest,sounds);
}
co.doubleduck.Assets.__super__ = co.doubleduck.BaseAssets;
co.doubleduck.Assets.prototype = $extend(co.doubleduck.BaseAssets.prototype,{
	__class__: co.doubleduck.Assets
});
co.doubleduck.BaseGame = $hxClasses["co.doubleduck.BaseGame"] = function(stage) {
	this._waitingToStart = false;
	this._orientError = null;
	this._prevWinSize = new createjs.Rectangle(0,0,1,1);
	if(co.doubleduck.BaseGame._wantLandscape) {
		co.doubleduck.BaseGame.MAX_HEIGHT = 320;
		co.doubleduck.BaseGame.MAX_WIDTH = 570;
	} else {
		co.doubleduck.BaseGame.MAX_HEIGHT = 570;
		co.doubleduck.BaseGame.MAX_WIDTH = 320;
	}
	if(co.doubleduck.BaseGame.DEBUG) co.doubleduck.BasePersistence.clearAll();
	var isGS3Stock = /Android 4.0.4/.test(navigator.userAgent);
	isGS3Stock = isGS3Stock && /GT-I9300/.test(navigator.userAgent);
	isGS3Stock = isGS3Stock && !/Chrome/.test(navigator.userAgent);
	if(isGS3Stock) {
		var loc = window.location.href;
		if(loc.lastIndexOf("index.html") != -1) loc = HxOverrides.substr(loc,0,loc.lastIndexOf("index.html"));
		loc += "error.html";
		window.location.href=loc;
		return;
	}
	co.doubleduck.Persistence.initGameData();
	co.doubleduck.BaseGame._stage = stage;
	co.doubleduck.BaseGame._stage.onTick = $bind(this,this.handleStageTick);
	co.doubleduck.BaseGame._viewport = new createjs.Rectangle(0,0,1,1);
	co.doubleduck.BaseGame.hammer = new Hammer(js.Lib.document.getElementById("stageCanvas"));
	viewporter.preventPageScroll = true;
	viewporter.change($bind(this,this.handleViewportChanged));
	if(viewporter.ACTIVE) {
		viewporter.preventPageScroll = true;
		viewporter.change($bind(this,this.handleViewportChanged));
		if(co.doubleduck.BaseGame._wantLandscape != viewporter.isLandscape()) {
			if(co.doubleduck.BaseGame._wantLandscape) co.doubleduck.BaseAssets.loadAndCall(co.doubleduck.BaseGame.ORIENT_LAND_URI,$bind(this,this.waitForOrientation)); else co.doubleduck.BaseAssets.loadAndCall(co.doubleduck.BaseGame.ORIENT_PORT_URI,$bind(this,this.waitForOrientation));
		} else co.doubleduck.BaseAssets.loadAndCall(co.doubleduck.BaseGame.LOGO_URI,$bind(this,this.loadBarFill));
	} else co.doubleduck.BaseAssets.loadAndCall(co.doubleduck.BaseGame.LOGO_URI,$bind(this,this.loadBarFill));
};
co.doubleduck.BaseGame.__name__ = ["co","doubleduck","BaseGame"];
co.doubleduck.BaseGame._stage = null;
co.doubleduck.BaseGame._wantLandscape = null;
co.doubleduck.BaseGame.MAX_HEIGHT = null;
co.doubleduck.BaseGame.MAX_WIDTH = null;
co.doubleduck.BaseGame.activeLocale = null;
co.doubleduck.BaseGame.availableLocales = null;
co.doubleduck.BaseGame.defaultLocale = null;
co.doubleduck.BaseGame.hammer = null;
co.doubleduck.BaseGame.getViewport = function() {
	return co.doubleduck.BaseGame._viewport;
}
co.doubleduck.BaseGame.getScreenSize = function() {
	if(co.doubleduck.BaseGame._wantLandscape) return new createjs.Rectangle(0,0,Math.floor(co.doubleduck.BaseGame._viewport.width / co.doubleduck.BaseGame._scale),co.doubleduck.BaseGame.MAX_HEIGHT); else return new createjs.Rectangle(0,0,co.doubleduck.BaseGame.MAX_WIDTH,Math.floor(co.doubleduck.BaseGame._viewport.height / co.doubleduck.BaseGame._scale));
}
co.doubleduck.BaseGame.getScale = function() {
	return co.doubleduck.BaseGame._scale;
}
co.doubleduck.BaseGame.getStage = function() {
	return co.doubleduck.BaseGame._stage;
}
co.doubleduck.BaseGame.prototype = {
	setScale: function() {
		var fixedVal = co.doubleduck.BaseGame._viewport.width;
		var varVal = co.doubleduck.BaseGame._viewport.height;
		var idealFixed = co.doubleduck.BaseGame.MAX_WIDTH;
		var idealVar = co.doubleduck.BaseGame.MAX_HEIGHT;
		if(co.doubleduck.BaseGame._wantLandscape) {
			fixedVal = co.doubleduck.BaseGame._viewport.height;
			varVal = co.doubleduck.BaseGame._viewport.width;
			idealFixed = co.doubleduck.BaseGame.MAX_HEIGHT;
			idealVar = co.doubleduck.BaseGame.MAX_WIDTH;
		}
		var regScale = varVal / idealVar;
		if(fixedVal >= varVal) co.doubleduck.BaseGame._scale = regScale; else if(idealFixed * regScale < fixedVal) co.doubleduck.BaseGame._scale = fixedVal / idealFixed; else co.doubleduck.BaseGame._scale = regScale;
	}
	,handleViewportChanged: function() {
		if(co.doubleduck.BaseGame._wantLandscape != viewporter.isLandscape()) {
			if(this._orientError == null) {
				var err = co.doubleduck.BaseGame.ORIENT_PORT_URI;
				if(co.doubleduck.BaseGame._wantLandscape) err = co.doubleduck.BaseGame.ORIENT_LAND_URI;
				this._orientError = co.doubleduck.BaseAssets.getImage(err);
				this._orientError.regX = this._orientError.image.width / 2;
				this._orientError.regY = this._orientError.image.height / 2;
				this._orientError.x = co.doubleduck.BaseGame._viewport.height / 2;
				this._orientError.y = co.doubleduck.BaseGame._viewport.width / 2;
				co.doubleduck.BaseGame._stage.addChildAt(this._orientError,co.doubleduck.BaseGame._stage.getNumChildren());
				co.doubleduck.BaseGame._stage.update();
			}
		} else if(this._orientError != null) {
			co.doubleduck.BaseGame._stage.removeChild(this._orientError);
			this._orientError = null;
			if(createjs.Ticker.getPaused()) co.doubleduck.BaseGame._stage.update();
			if(this._waitingToStart) {
				this._waitingToStart = false;
				co.doubleduck.BaseAssets.loadAndCall(co.doubleduck.BaseGame.LOGO_URI,$bind(this,this.loadBarFill));
			}
		}
	}
	,focused: function() {
		co.doubleduck.SoundManager.unmute();
	}
	,blured: function(e) {
		co.doubleduck.SoundManager.mute();
	}
	,handleResize: function(e) {
		var isFirefox = /Firefox/.test(navigator.userAgent);
		var isAndroid = /Android/.test(navigator.userAgent);
		var screenW = js.Lib.window.innerWidth;
		var screenH = js.Lib.window.innerHeight;
		co.doubleduck.BaseGame._stage.canvas.width = screenW;
		co.doubleduck.BaseGame._stage.canvas.height = screenH;
		var shouldResize = co.doubleduck.BaseGame._wantLandscape == viewporter.isLandscape() || !viewporter.ACTIVE;
		if(shouldResize) {
			if(isFirefox) {
				screenH = Math.floor(co.doubleduck.Main.getFFHeight());
				var ffEstimate = Math.ceil((js.Lib.window.screen.height - 110) * (screenW / js.Lib.window.screen.width));
				if(!isAndroid) ffEstimate = Math.ceil(js.Lib.window.screen.height * (screenW / js.Lib.window.screen.width));
				if(ffEstimate < screenH) screenH = Math.floor(ffEstimate);
			}
			var wrongSize = screenH < screenW;
			if(co.doubleduck.BaseGame._wantLandscape) wrongSize = screenH > screenW;
			if(!viewporter.ACTIVE || !wrongSize) {
				co.doubleduck.BaseGame._viewport.width = screenW;
				co.doubleduck.BaseGame._viewport.height = screenH;
				this.setScale();
			}
			if(this._orientError != null && isFirefox) this.handleViewportChanged();
		} else if(isFirefox) this.handleViewportChanged();
		if(createjs.Ticker.getPaused()) co.doubleduck.BaseGame._stage.update();
	}
	,handleBackToMenu: function() {
		this._session.destroy();
		co.doubleduck.BaseGame._stage.removeChild(this._session);
		this._session = null;
		this._menu = new co.doubleduck.Menu();
		co.doubleduck.BaseGame._stage.addChildAt(this._menu,0);
		this._menu.onPlayClick = $bind(this,this.handlePlayClick);
	}
	,handleRestart: function(properties) {
		this._session.destroy();
		co.doubleduck.BaseGame._stage.removeChild(this._session);
		this._session = null;
		this.startSession(properties);
	}
	,handleSessionEnd: function() {
	}
	,handlePlayClick: function(properties) {
		co.doubleduck.BaseGame._stage.removeChild(this._menu);
		this.startSession(properties);
		this._menu.destroy();
		this._menu = null;
	}
	,startSession: function(properties) {
		this._session = new co.doubleduck.Session(properties);
		this._session.onBackToMenu = $bind(this,this.handleBackToMenu);
		this._session.onRestart = $bind(this,this.handleRestart);
		this._session.onSessionEnd = $bind(this,this.handleSessionEnd);
		co.doubleduck.BaseGame._stage.addChild(this._session);
	}
	,showMenu: function() {
		this._menu = new co.doubleduck.Menu();
		co.doubleduck.BaseGame._stage.addChildAt(this._menu,0);
		this._menu.onPlayClick = $bind(this,this.handlePlayClick);
	}
	,alphaFade: function(fadeElement) {
		if(fadeElement != null && js.Boot.__instanceof(fadeElement,createjs.Bitmap)) this._fadedText = fadeElement; else if(this._fadedText == null) return;
		if(this._fadedText.alpha == 0) createjs.Tween.get(this._fadedText).to({ alpha : 1},750).call($bind(this,this.alphaFade)); else if(this._fadedText.alpha == 1) createjs.Tween.get(this._fadedText).to({ alpha : 0},1500).call($bind(this,this.alphaFade));
	}
	,showGameSplash: function() {
	}
	,splashEnded: function() {
		js.Lib.document.body.bgColor = "#000000";
		co.doubleduck.BaseGame._stage.removeChild(this._splash);
		this._splash = null;
		js.Lib.window.onresize = $bind(this,this.handleResize);
		this.handleResize(null);
		this.showGameSplash();
	}
	,handleDoneLoading: function() {
		createjs.Tween.get(this._splash).wait(200).to({ alpha : 0},800).call($bind(this,this.splashEnded));
		co.doubleduck.BaseGame._stage.removeChild(this._loadingBar);
		co.doubleduck.BaseGame._stage.removeChild(this._loadingStroke);
	}
	,updateLoading: function() {
		if(co.doubleduck.BaseAssets.loaded != 1) {
			this._loadingBar.visible = true;
			var percent = co.doubleduck.BaseAssets.loaded;
			var barMask = new createjs.Shape();
			barMask.graphics.beginFill("#00000000");
			barMask.graphics.drawRect(this._loadingBar.x - this._loadingBar.image.width / 2,this._loadingBar.y,this._loadingBar.image.width * percent | 0,this._loadingBar.image.height);
			barMask.graphics.endFill();
			this._loadingBar.mask = barMask;
			co.doubleduck.Utils.waitAndCall(this,10,$bind(this,this.updateLoading));
		}
	}
	,exitFocus: function() {
		var hidden = document.mozHidden;
		if(hidden) co.doubleduck.SoundManager.mute(false); else if(!co.doubleduck.SoundManager.getPersistedMute()) co.doubleduck.SoundManager.unmute(false);
	}
	,showSplash: function() {
		if(viewporter.ACTIVE) js.Lib.document.body.bgColor = "#00A99D"; else js.Lib.document.body.bgColor = "#D94D00";
		this._splash = co.doubleduck.BaseAssets.getImage(co.doubleduck.BaseGame.LOGO_URI);
		this._splash.regX = this._splash.image.width / 2;
		this._splash.x = js.Lib.window.innerWidth / 2;
		if(co.doubleduck.BaseGame._wantLandscape) this._splash.y = 20; else this._splash.y = 90;
		co.doubleduck.BaseGame._stage.addChild(this._splash);
		this._loadingStroke = co.doubleduck.BaseAssets.getImage(co.doubleduck.BaseGame.LOAD_STROKE_URI);
		this._loadingStroke.regX = this._loadingStroke.image.width / 2;
		co.doubleduck.BaseGame._stage.addChildAt(this._loadingStroke,0);
		this._loadingBar = co.doubleduck.BaseAssets.getImage(co.doubleduck.BaseGame.LOAD_FILL_URI);
		this._loadingBar.regX = this._loadingBar.image.width / 2;
		co.doubleduck.BaseGame._stage.addChildAt(this._loadingBar,1);
		this._loadingBar.x = js.Lib.window.innerWidth / 2;
		this._loadingBar.y = this._splash.y + 192;
		this._loadingStroke.x = this._loadingBar.x;
		this._loadingStroke.y = this._loadingBar.y;
		this._loadingBar.visible = false;
		this.updateLoading();
		co.doubleduck.BaseGame._stage.canvas.width = js.Lib.window.innerWidth;
		co.doubleduck.BaseGame._stage.canvas.height = js.Lib.window.innerHeight;
		co.doubleduck.BaseAssets.onLoadAll = $bind(this,this.handleDoneLoading);
		co.doubleduck.Assets.loadAll();
	}
	,loadLocale: function() {
		if(co.doubleduck.BaseGame.isLocalized) {
			var lang = navigator.language;
			lang = HxOverrides.substr(lang.toLowerCase(),0,2);
			if(co.doubleduck.BaseGame.availableLocales != null && co.doubleduck.BaseGame.availableLocales.length > 0) {
				if(Lambda.indexOf(co.doubleduck.BaseGame.availableLocales,lang) != -1) {
					co.doubleduck.BaseGame.activeLocale = lang;
					this.showSplash();
					return;
				} else {
					co.doubleduck.BaseGame.activeLocale = co.doubleduck.BaseGame.defaultLocale;
					this.showSplash();
					return;
				}
			} else {
				co.doubleduck.BaseGame.activeLocale = co.doubleduck.BaseGame.defaultLocale;
				if(co.doubleduck.BaseGame.defaultLocale == null) throw "DDException: default locale not set";
			}
		}
		this.showSplash();
	}
	,waitForOrientation: function() {
		this._waitingToStart = true;
		if(this._orientError == null) {
			this._orientError = this.getErrorImage();
			this._orientError.regX = this._orientError.image.width / 2;
			this._orientError.regY = this._orientError.image.height / 2;
			this._orientError.x = js.Lib.window.innerWidth / 2;
			this._orientError.y = js.Lib.window.innerHeight / 2;
			co.doubleduck.BaseGame._stage.addChildAt(this._orientError,co.doubleduck.BaseGame._stage.getNumChildren());
		}
	}
	,getErrorImage: function() {
		if(co.doubleduck.BaseGame._wantLandscape) return co.doubleduck.BaseAssets.getImage(co.doubleduck.BaseGame.ORIENT_LAND_URI); else return co.doubleduck.BaseAssets.getImage(co.doubleduck.BaseGame.ORIENT_PORT_URI);
	}
	,loadBarStroke: function() {
		co.doubleduck.BaseAssets.loadAndCall(co.doubleduck.BaseGame.LOAD_STROKE_URI,$bind(this,this.loadLocale));
	}
	,loadBarFill: function() {
		co.doubleduck.BaseAssets.loadAndCall(co.doubleduck.BaseGame.LOAD_FILL_URI,$bind(this,this.loadBarStroke));
	}
	,handleStageTick: function() {
		if(js.Lib.window.innerWidth != this._prevWinSize.width || js.Lib.window.innerHeight != this._prevWinSize.height) {
			this._prevWinSize.width = js.Lib.window.innerWidth;
			this._prevWinSize.height = js.Lib.window.innerHeight;
			this.handleResize(null);
		}
	}
	,_prevWinSize: null
	,_fadedText: null
	,_loadingStroke: null
	,_loadingBar: null
	,_waitingToStart: null
	,_orientError: null
	,_session: null
	,_menu: null
	,_splash: null
	,__class__: co.doubleduck.BaseGame
}
co.doubleduck.BaseMenu = $hxClasses["co.doubleduck.BaseMenu"] = function() {
	createjs.Container.call(this);
};
co.doubleduck.BaseMenu.__name__ = ["co","doubleduck","BaseMenu"];
co.doubleduck.BaseMenu.__super__ = createjs.Container;
co.doubleduck.BaseMenu.prototype = $extend(createjs.Container.prototype,{
	destroy: function() {
		this.onPlayClick = null;
	}
	,onPlayClick: null
	,__class__: co.doubleduck.BaseMenu
});
co.doubleduck.BasePersistence = $hxClasses["co.doubleduck.BasePersistence"] = function() { }
co.doubleduck.BasePersistence.__name__ = ["co","doubleduck","BasePersistence"];
co.doubleduck.BasePersistence.localStorageSupported = function() {
	var result = null;
	try {
		localStorage.setItem("test","test");
		localStorage.removeItem("test");
		result = true;
	} catch( e ) {
		result = false;
	}
	return result;
}
co.doubleduck.BasePersistence.getValue = function(key) {
	if(!co.doubleduck.BasePersistence.available) return "0";
	var val = localStorage[co.doubleduck.BasePersistence.GAME_PREFIX + key];
	return val;
}
co.doubleduck.BasePersistence.setValue = function(key,value) {
	if(!co.doubleduck.BasePersistence.available) return;
	localStorage[co.doubleduck.BasePersistence.GAME_PREFIX + key] = value;
}
co.doubleduck.BasePersistence.clearAll = function() {
	if(!co.doubleduck.BasePersistence.available) return;
	localStorage.clear();
}
co.doubleduck.BasePersistence.initVar = function(initedVar,defaultVal) {
	if(defaultVal == null) defaultVal = "0";
	var value = co.doubleduck.BasePersistence.getValue(initedVar);
	if(value == null) try {
		co.doubleduck.BasePersistence.setValue(initedVar,defaultVal);
	} catch( e ) {
		co.doubleduck.BasePersistence.available = false;
	}
}
co.doubleduck.BasePersistence.getDynamicValue = function(key) {
	if(!co.doubleduck.BasePersistence.available) return { };
	var val = localStorage[co.doubleduck.BasePersistence.GAME_PREFIX + key];
	return val;
}
co.doubleduck.BasePersistence.setDynamicValue = function(key,value) {
	if(!co.doubleduck.BasePersistence.available) return;
	localStorage[co.doubleduck.BasePersistence.GAME_PREFIX + key] = value;
}
co.doubleduck.BasePersistence.initDynamicVar = function(initedVar,defaultVal) {
	var value = co.doubleduck.BasePersistence.getDynamicValue(initedVar);
	if(value == null) try {
		co.doubleduck.BasePersistence.setDynamicValue(initedVar,defaultVal);
	} catch( e ) {
		co.doubleduck.BasePersistence.available = false;
	}
}
co.doubleduck.BasePersistence.printAll = function() {
	var ls = localStorage;
	var localStorageLength = ls.length;
	var _g = 0;
	while(_g < localStorageLength) {
		var entry = _g++;
		null;
	}
}
co.doubleduck.BaseSession = $hxClasses["co.doubleduck.BaseSession"] = function() {
	createjs.Container.call(this);
};
co.doubleduck.BaseSession.__name__ = ["co","doubleduck","BaseSession"];
co.doubleduck.BaseSession.__super__ = createjs.Container;
co.doubleduck.BaseSession.prototype = $extend(createjs.Container.prototype,{
	destroy: function() {
		createjs.Ticker.removeListener(this);
		this.onRestart = null;
		this.onBackToMenu = null;
		this.onSessionEnd = null;
		this.onNextLevel = null;
	}
	,sessionEnded: function() {
		if(this.onSessionEnd != null) {
			createjs.Ticker.setPaused(false);
			this.onSessionEnd();
		}
	}
	,handleReplayClick: function(properties) {
		if(this.onRestart != null) {
			createjs.Ticker.setPaused(false);
			this.onRestart(properties);
		}
	}
	,handleMenuClick: function() {
		if(this.onBackToMenu != null) {
			createjs.Ticker.setPaused(false);
			this.onBackToMenu();
		}
	}
	,_replayBtn: null
	,_menuBtn: null
	,onNextLevel: null
	,onBackToMenu: null
	,onSessionEnd: null
	,onRestart: null
	,__class__: co.doubleduck.BaseSession
});
co.doubleduck.LabeledContainer = $hxClasses["co.doubleduck.LabeledContainer"] = function(bmp) {
	createjs.Container.call(this);
	this._bitmap = bmp;
	if(this._bitmap != null) {
		if(js.Boot.__instanceof(this._bitmap,createjs.Bitmap)) {
			this._bmp = this._bitmap;
			this.image = this._bmp.image;
		} else if(js.Boot.__instanceof(this._bitmap,createjs.BitmapAnimation)) {
			this.anim = this._bitmap;
			this.image = { width : this.anim.spriteSheet._frameWidth, height : this.anim.spriteSheet._frameHeight};
		}
	}
};
co.doubleduck.LabeledContainer.__name__ = ["co","doubleduck","LabeledContainer"];
co.doubleduck.LabeledContainer.__super__ = createjs.Container;
co.doubleduck.LabeledContainer.prototype = $extend(createjs.Container.prototype,{
	getLabel: function() {
		return this._label;
	}
	,addBitmap: function() {
		this.addChild(this._bitmap);
	}
	,addCenteredBitmap: function() {
		this._bitmap.regX = this.image.width / 2;
		this._bitmap.regY = this.image.height / 2;
		this._bitmap.x = this.image.width / 2;
		this._bitmap.y = this.image.height / 2;
		this.addChild(this._bitmap);
	}
	,addBitmapLabel: function(label,fontType,padding,centered) {
		if(centered == null) centered = true;
		if(padding == null) padding = 0;
		if(fontType == null) fontType = "";
		if(this._bitmapText != null) this.removeChild(this._bitmapText);
		var fontHelper = new co.doubleduck.FontHelper(fontType);
		this._bitmapText = fontHelper.getNumber(Std.parseInt(label),1,true,null,padding,centered);
		if(this.image != null) {
			this._bitmapText.x = this.image.width / 2;
			this._bitmapText.y = this.image.height / 2;
		}
		this._label = label;
		this.addChild(this._bitmapText);
	}
	,scaleBitmapFont: function(scale) {
		this._bitmapText.scaleX = this._bitmapText.scaleY = scale;
	}
	,shiftLabel: function(shiftX,shiftY) {
		this._bitmapText.x *= shiftX;
		this._bitmapText.y *= shiftY;
	}
	,setBitmapLabelY: function(ly) {
		this._bitmapText.y = ly;
	}
	,setBitmapLabelX: function(lx) {
		this._bitmapText.x = lx;
	}
	,getBitmapLabelWidth: function() {
		var maxWidth = 0;
		var _g1 = 0, _g = this._bitmapText.getNumChildren();
		while(_g1 < _g) {
			var digit = _g1++;
			var currentDigit = js.Boot.__cast(this._bitmapText.getChildAt(digit) , createjs.Bitmap);
			var endsAt = currentDigit.x + currentDigit.image.width;
			if(endsAt > maxWidth) maxWidth = endsAt;
		}
		return maxWidth;
	}
	,setLabelY: function(ly) {
		this._text.y = ly;
	}
	,setLabelX: function(lx) {
		this._text.x = lx;
	}
	,addLabel: function(label,color) {
		if(color == null) color = "#000000";
		if(this._text != null) this.removeChild(this._text);
		this._label = label;
		this._text = new createjs.Text(label,"bold 22px Arial",color);
		this._text.regY = this._text.getMeasuredHeight() / 2;
		this._text.textAlign = "center";
		if(this._bitmap != null) {
			this._text.x = this._bitmap.x;
			this._text.y = this._bitmap.y;
		}
		this.addChild(this._text);
	}
	,changeText: function(txt) {
	}
	,_bitmapText: null
	,_text: null
	,_bmp: null
	,_bitmap: null
	,_label: null
	,anim: null
	,image: null
	,__class__: co.doubleduck.LabeledContainer
});
co.doubleduck.Button = $hxClasses["co.doubleduck.Button"] = function(bmp,pauseAffected,clickType,clickSound) {
	if(clickType == null) clickType = 2;
	if(pauseAffected == null) pauseAffected = true;
	this._lastClickTime = 0;
	co.doubleduck.LabeledContainer.call(this,bmp);
	if(clickSound == null && co.doubleduck.Button._defaultSound != null) this._clickSound = co.doubleduck.Button._defaultSound; else this._clickSound = clickSound;
	this._bitmap.mouseEnabled = true;
	this._clickType = clickType;
	this._pauseAffected = pauseAffected;
	if(clickType == co.doubleduck.Button.CLICK_TYPE_TOGGLE) {
		var initObject = { };
		var size = this.image.width / 2;
		initObject.images = [this.image];
		initObject.frames = { width : size, height : this.image.height, regX : size / 2, regY : this.image.height / 2};
		this._states = new createjs.BitmapAnimation(new createjs.SpriteSheet(initObject));
		this._states.gotoAndStop(0);
		this.onClick = $bind(this,this.handleToggle);
		this.addChild(this._states);
	} else this.addCenteredBitmap();
	this.onPress = $bind(this,this.handlePress);
};
co.doubleduck.Button.__name__ = ["co","doubleduck","Button"];
co.doubleduck.Button.setDefaultSound = function(sound) {
	co.doubleduck.Button._defaultSound = sound;
}
co.doubleduck.Button.__super__ = co.doubleduck.LabeledContainer;
co.doubleduck.Button.prototype = $extend(co.doubleduck.LabeledContainer.prototype,{
	handleEndPressTint: function() {
		co.doubleduck.Utils.tintBitmap(this._bmp,1,1,1,1);
		if(createjs.Ticker.getPaused()) co.doubleduck.BaseGame.getStage().update();
	}
	,setToggle: function(flag) {
		if(flag) this._states.gotoAndStop(0); else this._states.gotoAndStop(1);
	}
	,handleToggle: function(e) {
		if(this.onToggle == null) return;
		if(this._lastClickPos == null) this._lastClickPos = new createjs.Point(0,0);
		if((this._lastClickPos.x < e.stageX + 1 || this._lastClickPos.x > e.stageX + 1) && (this._lastClickPos.y < e.stageY + 1 || this._lastClickPos.y > e.stageY + 1)) {
			var now = createjs.Ticker.getTime(true);
			if(now < this._lastClickTime + 500) return;
		}
		this._lastClickPos.x = e.stageX;
		this._lastClickPos.y = e.stageY;
		this._lastClickTime = createjs.Ticker.getTime(true);
		this._states.gotoAndStop(1 - this._states.currentFrame);
		this.onToggle();
	}
	,handlePress: function(event) {
		if(createjs.Ticker.getPaused() && this._pauseAffected) return;
		if(this._clickType == co.doubleduck.Button.CLICK_TYPE_HOLD) {
			if(this.onHoldStart != null) {
				this.onHoldStart();
				event.onMouseUp = this.onHoldFinish;
			}
		}
		if(this.onClick != null) {
			if(this._clickSound != null) co.doubleduck.SoundManager.playEffect(this._clickSound);
			switch(this._clickType) {
			case co.doubleduck.Button.CLICK_TYPE_TINT:
				if(this._bmp != null) {
					co.doubleduck.Utils.tintBitmap(this._bmp,0.55,0.55,0.55,1);
					var tween = createjs.Tween.get(this._bmp);
					tween.ignoreGlobalPause = true;
					tween.wait(200).call($bind(this,this.handleEndPressTint));
					if(createjs.Ticker.getPaused()) co.doubleduck.BaseGame.getStage().update();
				}
				break;
			case co.doubleduck.Button.CLICK_TYPE_JUICY:
				this._juiceTween = createjs.Tween.get(this._bitmap);
				this._juiceTween.ignoreGlobalPause = true;
				var startScaleX = this._bitmap.scaleX;
				var startScaleY = this._bitmap.scaleY;
				this._bitmap.scaleX = startScaleX * 1.25;
				this._bitmap.scaleY = startScaleY * 0.75;
				this._juiceTween.to({ scaleX : startScaleX, scaleY : startScaleY},500,createjs.Ease.elasticOut);
				break;
			case co.doubleduck.Button.CLICK_TYPE_SCALE:
				this._juiceTween = createjs.Tween.get(this._bitmap);
				this._juiceTween.ignoreGlobalPause = true;
				var startScaleX = this._bitmap.scaleX;
				var startScaleY = this._bitmap.scaleY;
				this._bitmap.scaleX = startScaleX * 1.18;
				this._bitmap.scaleY = startScaleY * 1.18;
				this._juiceTween.to({ scaleX : startScaleX, scaleY : startScaleY},200,createjs.Ease.elasticOut);
				break;
			case co.doubleduck.Button.CLICK_TYPE_TOGGLE:
				break;
			case co.doubleduck.Button.CLICK_TYPE_NONE:
				break;
			case co.doubleduck.Button.CLICK_TYPE_HOLD:
				throw "Use onHoldStart with CLICK_TYPE_HOLD, not onClick";
				break;
			}
		}
	}
	,setNoSound: function() {
		this._clickSound = null;
	}
	,_lastClickPos: null
	,_lastClickTime: null
	,_clickSound: null
	,_juiceTween: null
	,_clickType: null
	,_pauseAffected: null
	,_states: null
	,onHoldFinish: null
	,onHoldStart: null
	,onToggle: null
	,__class__: co.doubleduck.Button
});
co.doubleduck.Collectable = $hxClasses["co.doubleduck.Collectable"] = function(collectableType,fishId,xp,speedMultiplier,uri,isGood,swimSpeed,waitTime,rotationRange,expandInterval) {
	if(expandInterval == null) expandInterval = 0;
	if(rotationRange == null) rotationRange = 0;
	createjs.Container.call(this);
	this._fishId = fishId;
	this._collectableType = collectableType;
	this._xp = xp;
	this._speedMultiplier = speedMultiplier;
	this._isGood = isGood;
	this._direction = 1;
	this._waitTime = waitTime;
	this._isBeingPulled = false;
	this._swimSpeed = swimSpeed;
	this._isCollectable = true;
	this._nextTimeToExpand = null;
	this._expandInterval = expandInterval;
	this._swimOutTime = null;
	this._isSwimmingOut = false;
	this._collectable = co.doubleduck.BaseAssets.getImage("images/session/" + uri + ".png");
	if(this._expandInterval > 0) {
		var now = createjs.Ticker.getTime(true);
		this._nextTimeToExpand = now + this._expandInterval * 1000;
		this._expandedBmp = co.doubleduck.BaseAssets.getImage("images/session/" + uri + "b.png");
		this._expandedBmp.alpha = 0;
		this._expandedBmp.regX = this._expandedBmp.image.width / 2;
		this._expandedBmp.regY = this._expandedBmp.image.height / 2;
	}
	if(this._collectableType == co.doubleduck.CollectableType.Bad || this._collectableType == co.doubleduck.CollectableType.Good) {
		if(Std.random(2) == 0) this._direction = 1; else {
			this._direction = -1;
			this._collectable.x = this._collectable.image.width;
		}
		if(this._expandedBmp != null) this._expandedBmp.scaleX *= this._direction;
		this._collectable.scaleX *= this._direction;
	}
	this.addChild(this._collectable);
	if(this._expandedBmp != null) this.addChild(this._expandedBmp);
	this.regX = this._collectable.image.width / 2;
	this.regY = this._collectable.image.height / 2;
	if(this._expandedBmp != null) {
		this._expandedBmp.x = this._collectable.x + this._collectable.image.width / 2 * this._direction;
		this._expandedBmp.y = this._collectable.y + this._collectable.image.height / 2;
	}
	this.rotation = Std.random(js.Boot.__cast(rotationRange * 2 , Int)) - rotationRange;
	this.onTick = $bind(this,this.handleTick);
};
co.doubleduck.Collectable.__name__ = ["co","doubleduck","Collectable"];
co.doubleduck.Collectable.__super__ = createjs.Container;
co.doubleduck.Collectable.prototype = $extend(createjs.Container.prototype,{
	isCollectable: function() {
		return this._isCollectable;
	}
	,pullCollectable: function() {
		createjs.Tween.removeTweens(this);
		this._isBeingPulled = true;
	}
	,getType: function() {
		return this._collectableType;
	}
	,collect: function() {
		if(this._collectableType == co.doubleduck.CollectableType.Good) co.doubleduck.SoundManager.playEffect("sound/got_fish"); else if(this._collectableType == co.doubleduck.CollectableType.Bad) co.doubleduck.SoundManager.playEffect("sound/got_trash"); else if(this._collectableType == co.doubleduck.CollectableType.Time) co.doubleduck.SoundManager.playEffect("sound/time_bonus"); else if(this._collectableType == co.doubleduck.CollectableType.XP) co.doubleduck.SoundManager.playEffect("sound/multiplier_bonus"); else if(this._collectableType == co.doubleduck.CollectableType.TurnGood) co.doubleduck.SoundManager.playEffect("sound/fish_bonus");
		this.onCollect(this._collectableType,this._fishId);
	}
	,finishSwimOut: function() {
		this.onSwimOut(this);
	}
	,swimOut: function() {
		var swimOutX;
		if(this._direction == 1) swimOutX = co.doubleduck.BaseGame.getScreenSize().width + this._collectable.image.width; else swimOutX = -this._collectable.image.width;
		var timeToSwim = Math.abs(this.x - swimOutX) * 30 / (this._swimSpeed * 0.5 + Math.random() * this._swimSpeed * 0.5);
		createjs.Tween.get(this).to({ x : swimOutX},timeToSwim,createjs.Ease.sineIn).call($bind(this,this.finishSwimOut));
	}
	,finishSwimIn: function() {
		var now = createjs.Ticker.getTime(true);
		this._swimOutTime = now + this._waitTime * 1000;
	}
	,swimIn: function() {
		this._goalX = this.x;
		if(this._direction == 1) this.x = -this._collectable.image.width; else this.x = co.doubleduck.BaseGame.getScreenSize().width + this._collectable.image.width;
		var timeToSwim = Math.abs(this.x - this._goalX) * 30 / (this._swimSpeed * 0.5 + Math.random() * this._swimSpeed * 0.5);
		createjs.Tween.get(this).to({ x : this._goalX},timeToSwim,createjs.Ease.sineOut).call($bind(this,this.finishSwimIn));
		this.floatInWater();
	}
	,floatInWater: function() {
		createjs.Tween.get(this).to({ y : this.y + 10},1500,createjs.Ease.linear).wait(200).to({ y : this.y},1500,createjs.Ease.linear).wait(200).call($bind(this,this.floatInWater));
	}
	,getFinalHitbox: function() {
		if(this._goalX == null) return this.getHitbox();
		return new createjs.Rectangle(this._goalX - this._collectable.image.width * 0.5,this.y - this._collectable.image.height * 0.5,this._collectable.image.width,this._collectable.image.height);
	}
	,getHitbox: function() {
		return new createjs.Rectangle(this.x - this._collectable.image.width * 0.5,this.y - this._collectable.image.height * 0.5,this._collectable.image.width,this._collectable.image.height);
	}
	,getIsGood: function() {
		return this._isGood;
	}
	,getSpeedMultiplier: function() {
		return this._speedMultiplier;
	}
	,getXP: function() {
		return this._xp;
	}
	,changeCollectable: function(xp,speedMultiplier,uri) {
		if(!this._isGood) {
			this.rotation = 0;
			this._xp = xp;
			this._speedMultiplier = speedMultiplier;
			this._collectable.image = co.doubleduck.BaseAssets.getRawImage("images/session/" + uri + ".png");
			this.regX = this._collectable.image.width / 2;
			this.regY = this._collectable.image.height / 2;
			if(this._direction == -1) this._collectable.x = this._collectable.image.width;
			this._isGood = true;
		}
	}
	,handleTick: function(elapsed) {
		var now = createjs.Ticker.getTime(true);
		if(this._isBeingPulled) {
			this.onTick = null;
			return;
		} else if(this._nextTimeToExpand != null && now >= this._nextTimeToExpand) {
			this._nextTimeToExpand = now + this._expandInterval * 1000;
			if(this._isCollectable) {
				this._isCollectable = false;
				this._expandedBmp.scaleX = this._expandedBmp.scaleY = 0.8 * this._direction;
				var shakeDelay = 40;
				var shakeTween = createjs.Tween.get(this).to({ rotation : 2},30,createjs.Ease.sineInOut);
				var _g = 0;
				while(_g < 4) {
					var i = _g++;
					shakeTween = shakeTween.to({ rotation : -2},60,createjs.Ease.sineInOut);
					shakeTween = shakeTween.to({ rotation : 2},60,createjs.Ease.sineInOut);
					shakeDelay += 80;
				}
				shakeTween = shakeTween.to({ rotation : 0},30,createjs.Ease.sineInOut);
				createjs.Tween.get(this._collectable).wait(shakeDelay).to({ scaleX : 1.2 * this._direction, scaleY : 1.2, alpha : 0},100,createjs.Ease.circInOut);
				createjs.Tween.get(this._expandedBmp).wait(shakeDelay).to({ alpha : 1, scaleX : this._direction, scaleY : 1},100,createjs.Ease.circInOut);
			} else {
				this._isCollectable = true;
				var shakeTween = createjs.Tween.get(this).to({ rotation : 4},35,createjs.Ease.sineInOut);
				var _g = 0;
				while(_g < 3) {
					var i = _g++;
					shakeTween = shakeTween.to({ rotation : -4},70,createjs.Ease.sineInOut);
					shakeTween = shakeTween.to({ rotation : 4},70,createjs.Ease.sineInOut);
				}
				shakeTween = shakeTween.to({ rotation : 0},35,createjs.Ease.sineInOut);
				createjs.Tween.get(this._expandedBmp).to({ scaleX : 0.85 * this._direction, scaleY : 0.85},260,createjs.Ease.circIn).to({ alpha : 0, scaleX : 0.6 * this._direction, scaleY : 0.6},200,createjs.Ease.circOut);
				createjs.Tween.get(this._collectable).wait(220).to({ scaleX : this._direction, scaleY : 1, alpha : 1},220,createjs.Ease.circInOut);
			}
		}
		if(!this._isSwimmingOut && this._swimOutTime != null && now >= this._swimOutTime) {
			this._isSwimmingOut = true;
			this.swimOut();
		}
	}
	,_expandInterval: null
	,_nextTimeToExpand: null
	,_isCollectable: null
	,_fishId: null
	,_swimSpeed: null
	,_swimOutTime: null
	,_waitTime: null
	,_goalX: null
	,_direction: null
	,_isSwimmingOut: null
	,_isBeingPulled: null
	,_isGood: null
	,_xp: null
	,_speedMultiplier: null
	,_collectableType: null
	,_expandedBmp: null
	,_collectable: null
	,onSwimOut: null
	,onCollect: null
	,__class__: co.doubleduck.Collectable
});
co.doubleduck.CollectableType = $hxClasses["co.doubleduck.CollectableType"] = { __ename__ : ["co","doubleduck","CollectableType"], __constructs__ : ["Good","Bad","Time","XP","TurnGood"] }
co.doubleduck.CollectableType.Good = ["Good",0];
co.doubleduck.CollectableType.Good.toString = $estr;
co.doubleduck.CollectableType.Good.__enum__ = co.doubleduck.CollectableType;
co.doubleduck.CollectableType.Bad = ["Bad",1];
co.doubleduck.CollectableType.Bad.toString = $estr;
co.doubleduck.CollectableType.Bad.__enum__ = co.doubleduck.CollectableType;
co.doubleduck.CollectableType.Time = ["Time",2];
co.doubleduck.CollectableType.Time.toString = $estr;
co.doubleduck.CollectableType.Time.__enum__ = co.doubleduck.CollectableType;
co.doubleduck.CollectableType.XP = ["XP",3];
co.doubleduck.CollectableType.XP.toString = $estr;
co.doubleduck.CollectableType.XP.__enum__ = co.doubleduck.CollectableType;
co.doubleduck.CollectableType.TurnGood = ["TurnGood",4];
co.doubleduck.CollectableType.TurnGood.toString = $estr;
co.doubleduck.CollectableType.TurnGood.__enum__ = co.doubleduck.CollectableType;
co.doubleduck.DataLoader = $hxClasses["co.doubleduck.DataLoader"] = function() { }
co.doubleduck.DataLoader.__name__ = ["co","doubleduck","DataLoader"];
co.doubleduck.DataLoader._gameplayData = null;
co.doubleduck.DataLoader.getSettingsByLevel = function(currLevel) {
	return co.doubleduck.DataLoader.getGameplayData().level_settings[currLevel - 1];
}
co.doubleduck.DataLoader.getLevelCount = function() {
	return co.doubleduck.DataLoader.getGameplayData().level_settings.length;
}
co.doubleduck.DataLoader.getGameplayData = function() {
	if(co.doubleduck.DataLoader._gameplayData == null) {
		co.doubleduck.DataLoader._gameplayData = new GameplayDB();
		co.doubleduck.DataLoader._gameplayData = co.doubleduck.DataLoader._gameplayData.getGameplayData();
	}
	return co.doubleduck.DataLoader._gameplayData;
}
co.doubleduck.FontHelper = $hxClasses["co.doubleduck.FontHelper"] = function(type) {
	this._fontType = type;
};
co.doubleduck.FontHelper.__name__ = ["co","doubleduck","FontHelper"];
co.doubleduck.FontHelper.prototype = {
	getNumber: function(num,scale,forceContainer,dims,padding,centered) {
		if(centered == null) centered = true;
		if(padding == null) padding = 0;
		if(forceContainer == null) forceContainer = false;
		if(scale == null) scale = 1;
		if(num >= 0 && num < 10) {
			var result = new createjs.Container();
			var bmp = this.getDigit(num);
			bmp.scaleX = bmp.scaleY = scale;
			result.addChild(bmp);
			if(centered) {
				result.regX = bmp.image.width / 2;
				result.regY = bmp.image.height / 2;
			}
			if(forceContainer) {
				if(dims != null) {
					dims.width = bmp.image.width;
					dims.height = bmp.image.height;
				}
				return result;
			} else return bmp;
		} else {
			var result = new createjs.Container();
			var numString = "" + num;
			var digits = new Array();
			var totalWidth = 0;
			digits[digits.length] = this.getDigit(Std.parseInt(HxOverrides.substr(numString,0,1)));
			digits[0].scaleX = digits[0].scaleY = scale;
			result.addChild(digits[0]);
			totalWidth += digits[0].image.width * scale;
			if(numString.length == 4 || numString.length == 7) {
				this._lastComma = this.getComma();
				this._lastComma.scaleX = this._lastComma.scaleY = scale;
				this._lastComma.x = digits[0].x + digits[0].image.width + padding;
				result.addChild(this._lastComma);
				totalWidth += this._lastComma.image.width * scale;
			}
			var _g1 = 1, _g = numString.length;
			while(_g1 < _g) {
				var i = _g1++;
				var index = digits.length;
				digits[index] = this.getDigit(Std.parseInt(HxOverrides.substr(numString,i,1)));
				if(numString.length - i == 3 || numString.length - i == 6) digits[index].x = this._lastComma.x + this._lastComma.image.width + padding; else digits[index].x = digits[index - 1].x + digits[index - 1].image.width + padding;
				digits[index].scaleX = digits[index].scaleY = scale;
				result.addChild(digits[index]);
				totalWidth += digits[index].image.width * scale + padding;
				if(numString.length - i == 4 || numString.length - i == 7) {
					this._lastComma = this.getComma();
					this._lastComma.scaleX = this._lastComma.scaleY = scale;
					this._lastComma.x = digits[index].x + digits[index].image.width + padding;
					result.addChild(this._lastComma);
					totalWidth += this._lastComma.image.width * scale + padding;
				}
			}
			if(centered) {
				result.regX = totalWidth / 2;
				result.regY = digits[0].image.height / 2;
			}
			if(dims != null) {
				dims.width = totalWidth;
				dims.height = digits[0].image.height;
			}
			return result;
		}
	}
	,getDigit: function(digit) {
		var digit1 = co.doubleduck.BaseAssets.getImage(this._fontType + digit + ".png");
		return digit1;
	}
	,getComma: function() {
		return co.doubleduck.BaseAssets.getImage(this._fontType + "comma.png");
	}
	,_fontType: null
	,_lastComma: null
	,__class__: co.doubleduck.FontHelper
}
co.doubleduck.Game = $hxClasses["co.doubleduck.Game"] = function(stage) {
	co.doubleduck.BaseGame._wantLandscape = false;
	co.doubleduck.BaseGame.isLocalized = true;
	co.doubleduck.BaseGame.defaultLocale = "en";
	co.doubleduck.BaseGame.availableLocales = ["es","en"];
	co.doubleduck.BaseGame.call(this,stage);
};
co.doubleduck.Game.__name__ = ["co","doubleduck","Game"];
co.doubleduck.Game.__super__ = co.doubleduck.BaseGame;
co.doubleduck.Game.prototype = $extend(co.doubleduck.BaseGame.prototype,{
	doneWithSlide: function() {
		this.showMenu();
		co.doubleduck.BaseGame._stage.removeChild(this._splashBox);
		this._splashBox.removeAllChildren();
		this._splashBox = null;
		this._logo = null;
		this._bg1 = null;
		this._bg2 = null;
		this._bg3 = null;
	}
	,slideUp: function() {
		var pos = this._bg1.image.height + this._bg2.image.height + this._bg3.image.height;
		pos *= co.doubleduck.BaseGame.getScale();
		pos = co.doubleduck.BaseGame.getViewport().height - pos;
		createjs.Tween.get(this._logo).to({ y : co.doubleduck.BaseGame.getViewport().height * 0.2},500,createjs.Ease.sineIn);
		createjs.Tween.get(this._splashBox).to({ y : pos},600,createjs.Ease.sineInOut).call($bind(this,this.doneWithSlide));
	}
	,showGameSplash: function() {
		this._splashBox = new createjs.Container();
		co.doubleduck.BaseGame._stage.addChild(this._splashBox);
		this._bg1 = co.doubleduck.Utils.getCenteredImage("images/general/bg1.jpg",true);
		this._bg1.x = co.doubleduck.BaseGame.getViewport().width / 2;
		this._bg1.regY = 0;
		this._splashBox.addChild(this._bg1);
		this._bg2 = co.doubleduck.Utils.getCenteredImage("images/general/bg2.jpg",true);
		this._bg2.x = co.doubleduck.BaseGame.getViewport().width / 2;
		this._bg2.regY = 0;
		this._bg2.y = this._bg1.y + this._bg1.image.height * co.doubleduck.BaseGame.getScale();
		this._splashBox.addChild(this._bg2);
		this._bg3 = co.doubleduck.Utils.getCenteredImage("images/general/bg3.jpg",true);
		this._bg3.x = co.doubleduck.BaseGame.getViewport().width / 2;
		this._bg3.regY = 0;
		this._bg3.y = this._bg2.y + this._bg2.image.height * co.doubleduck.BaseGame.getScale();
		this._splashBox.addChild(this._bg3);
		this._logo = co.doubleduck.Utils.getCenteredImage("images/splash/logo.png",true);
		this._logo.x = co.doubleduck.BaseGame.getViewport().width / 2;
		this._logo.y = co.doubleduck.BaseGame.getViewport().height * 0.1;
		this._logo.alpha = 0;
		this._splashBox.addChild(this._logo);
		createjs.Tween.get(this._logo).to({ alpha : 1, y : co.doubleduck.BaseGame.getViewport().height * 0.2},1200,createjs.Ease.sineOut).wait(400).call($bind(this,this.slideUp));
	}
	,_logo: null
	,_bg3: null
	,_bg2: null
	,_bg1: null
	,_splashBox: null
	,__class__: co.doubleduck.Game
});
co.doubleduck.GameManager = $hxClasses["co.doubleduck.GameManager"] = function() { }
co.doubleduck.GameManager.__name__ = ["co","doubleduck","GameManager"];
co.doubleduck.GameManager._sessionRunning = null;
co.doubleduck.GameManager.isSessionRunning = function() {
	return co.doubleduck.GameManager._sessionRunning;
}
co.doubleduck.GameManager.setSessionRunning = function(sessionRunning) {
	co.doubleduck.GameManager._sessionRunning = sessionRunning;
}
co.doubleduck.GameModes = $hxClasses["co.doubleduck.GameModes"] = function() {
};
co.doubleduck.GameModes.__name__ = ["co","doubleduck","GameModes"];
co.doubleduck.GameModes.prototype = {
	__class__: co.doubleduck.GameModes
}
co.doubleduck.GoalType = $hxClasses["co.doubleduck.GoalType"] = { __ename__ : ["co","doubleduck","GoalType"], __constructs__ : ["Points","Fish"] }
co.doubleduck.GoalType.Points = ["Points",0];
co.doubleduck.GoalType.Points.toString = $estr;
co.doubleduck.GoalType.Points.__enum__ = co.doubleduck.GoalType;
co.doubleduck.GoalType.Fish = ["Fish",1];
co.doubleduck.GoalType.Fish.toString = $estr;
co.doubleduck.GoalType.Fish.__enum__ = co.doubleduck.GoalType;
co.doubleduck.LimitType = $hxClasses["co.doubleduck.LimitType"] = { __ename__ : ["co","doubleduck","LimitType"], __constructs__ : ["Time","Moves"] }
co.doubleduck.LimitType.Time = ["Time",0];
co.doubleduck.LimitType.Time.toString = $estr;
co.doubleduck.LimitType.Time.__enum__ = co.doubleduck.LimitType;
co.doubleduck.LimitType.Moves = ["Moves",1];
co.doubleduck.LimitType.Moves.toString = $estr;
co.doubleduck.LimitType.Moves.__enum__ = co.doubleduck.LimitType;
co.doubleduck.LaserType = $hxClasses["co.doubleduck.LaserType"] = { __ename__ : ["co","doubleduck","LaserType"], __constructs__ : ["None","ShortLaser","LongLaser"] }
co.doubleduck.LaserType.None = ["None",0];
co.doubleduck.LaserType.None.toString = $estr;
co.doubleduck.LaserType.None.__enum__ = co.doubleduck.LaserType;
co.doubleduck.LaserType.ShortLaser = ["ShortLaser",1];
co.doubleduck.LaserType.ShortLaser.toString = $estr;
co.doubleduck.LaserType.ShortLaser.__enum__ = co.doubleduck.LaserType;
co.doubleduck.LaserType.LongLaser = ["LongLaser",2];
co.doubleduck.LaserType.LongLaser.toString = $estr;
co.doubleduck.LaserType.LongLaser.__enum__ = co.doubleduck.LaserType;
co.doubleduck.GoalContainer = $hxClasses["co.doubleduck.GoalContainer"] = function(goalAmount,goalType,limitAmount,limitType,fishId) {
	if(fishId == null) fishId = -1;
	this.Y_SPACING = 20;
	this.X_SPACING = 10;
	this.MARGIN = 40;
	createjs.Container.call(this);
	if(co.doubleduck.GoalContainer._fontSmall == null) co.doubleduck.GoalContainer._fontSmall = new co.doubleduck.FontHelper("images/general/font_small/");
	this._bg = co.doubleduck.Utils.getCenteredImage("images/session/message_overlay.png",false);
	this._bg.x = co.doubleduck.BaseGame.getScreenSize().width / 2;
	this._bg.y = co.doubleduck.BaseGame.getScreenSize().height / 2;
	this.addChild(this._bg);
	this._get = co.doubleduck.Utils.getCenteredImage("images/session/get.png",false);
	this._get.regY = 0;
	this._get.x = co.doubleduck.BaseGame.getScreenSize().width / 2;
	this._get.y = co.doubleduck.BaseGame.getScreenSize().height / 2 - this._bg.image.height / 2 + this.MARGIN;
	this.addChild(this._get);
	var dims = new createjs.Rectangle(0,0,0,0);
	this._goalAmount = co.doubleduck.GoalContainer._fontSmall.getNumber(goalAmount,1,true,dims,-1);
	this._goalAmount.regX = 0;
	this._goalAmount.regY = dims.height / 2;
	var totalW = dims.width;
	this._goalAmount.y = this._get.y + this._get.image.height + this.Y_SPACING;
	if(goalType == co.doubleduck.GoalType.Points) {
		this._goalType = co.doubleduck.Utils.getCenteredImage("images/session/points.png",false);
		this._goalType.y = this._get.y + this._get.image.height + this.Y_SPACING;
	} else {
		this._goalType = co.doubleduck.Utils.getCenteredImage("images/session/fish" + fishId + ".png",false);
		this._goalType.y = this._get.y + this._get.image.height + this.Y_SPACING;
	}
	this._goalType.regX = this._goalType.image.width;
	totalW += this._goalType.image.width + this.X_SPACING;
	this._goalAmount.x = co.doubleduck.BaseGame.getScreenSize().width / 2 - totalW / 2;
	this._goalType.x = co.doubleduck.BaseGame.getScreenSize().width / 2 + totalW / 2;
	this.addChild(this._goalType);
	this.addChild(this._goalAmount);
	this._in = co.doubleduck.Utils.getCenteredImage("images/session/in.png",false);
	this._in.regY = 0;
	this._in.x = co.doubleduck.BaseGame.getScreenSize().width / 2;
	this._in.y = this._goalType.y + this.Y_SPACING;
	this.addChild(this._in);
	var dims1 = new createjs.Rectangle(0,0,0,0);
	this._limitAmount = co.doubleduck.GoalContainer._fontSmall.getNumber(limitAmount,1,true,dims1,-1);
	this._limitAmount.regX = 0;
	this._limitAmount.regY = dims1.height / 2;
	var totalW1 = dims1.width;
	this._limitAmount.y = this._in.y + this.Y_SPACING + this._in.image.height;
	if(limitType == co.doubleduck.LimitType.Time) {
		this._limitType = co.doubleduck.Utils.getCenteredImage("images/session/timeicon.png",false);
		this._limitType.y = this._limitAmount.y;
	} else {
		this._limitType = co.doubleduck.Utils.getCenteredImage("images/session/moves.png",false);
		this._limitType.y = this._limitAmount.y;
	}
	this._limitType.regX = this._limitType.image.width;
	totalW1 += this._limitType.image.width + this.X_SPACING;
	this._limitAmount.x = co.doubleduck.BaseGame.getScreenSize().width / 2 - totalW1 / 2;
	this._limitType.x = co.doubleduck.BaseGame.getScreenSize().width / 2 + totalW1 / 2;
	this.addChild(this._limitType);
	this.addChild(this._limitAmount);
	this._btnGo = new co.doubleduck.Button(co.doubleduck.BaseAssets.getImage("images/session/go.png"));
	this._btnGo.regX = this._btnGo.image.width / 2;
	this._btnGo.regY = this._btnGo.image.height;
	this._btnGo.x = co.doubleduck.BaseGame.getScreenSize().width / 2;
	this._btnGo.y = this._bg.y + this._bg.image.height / 2 - this.MARGIN;
	this._btnGo.onClick = $bind(this,this.handleGoClick);
	this.addChild(this._btnGo);
};
co.doubleduck.GoalContainer.__name__ = ["co","doubleduck","GoalContainer"];
co.doubleduck.GoalContainer._fontSmall = null;
co.doubleduck.GoalContainer.__super__ = createjs.Container;
co.doubleduck.GoalContainer.prototype = $extend(createjs.Container.prototype,{
	handleGoClick: function() {
		this._btnGo.mouseEnabled = false;
		if(this.onGo != null) this.onGo();
	}
	,_limitAmount: null
	,_goalAmount: null
	,_btnGo: null
	,_limitType: null
	,_in: null
	,_goalType: null
	,_get: null
	,_bg: null
	,onGo: null
	,Y_SPACING: null
	,X_SPACING: null
	,MARGIN: null
	,__class__: co.doubleduck.GoalContainer
});
co.doubleduck.Hook = $hxClasses["co.doubleduck.Hook"] = function(extendSpeed,laserType) {
	this._tntSpeed = 500;
	this.ORIGINAL_LENGTH = 30;
	this._extentionSpeed = extendSpeed;
	this._length = this.ORIGINAL_LENGTH;
	this._isExtending = false;
	createjs.Container.call(this);
	this._line = new createjs.Shape();
	this._line.graphics.beginStroke("#000000");
	this._line.graphics.setStrokeStyle(2);
	this._line.graphics.moveTo(0,0);
	this._line.graphics.lineTo(0,this._length);
	this._line.graphics.endStroke();
	this.addChild(this._line);
	this._hook = co.doubleduck.BaseAssets.getImage("images/session/hook.png");
	this._hook.regX = this._hook.image.width / 2;
	this._hook.x = 0;
	this._hook.y = this._length;
	this.addChild(this._hook);
	if(laserType != co.doubleduck.LaserType.None) {
		if(laserType == co.doubleduck.LaserType.ShortLaser) this._laser = co.doubleduck.BaseAssets.getImage("images/session/laser_short.png"); else this._laser = co.doubleduck.BaseAssets.getImage("images/session/laser_long.png");
		this._laser.regX = this._laser.image.width / 2;
		this._laser.regY = -this._laser.y;
		this._laser.x = 0;
		this._laser.y = this._hook.y;
		this.addChild(this._laser);
	}
	this.onTick = $bind(this,this.handleTick);
};
co.doubleduck.Hook.__name__ = ["co","doubleduck","Hook"];
co.doubleduck.Hook.__super__ = createjs.Container;
co.doubleduck.Hook.prototype = $extend(createjs.Container.prototype,{
	getIsPulling: function() {
		return this._isPulling;
	}
	,addHookedCollectable: function(hookedCollectable) {
		co.doubleduck.SoundManager.playEffect("sound/catch_item");
		hookedCollectable.pullCollectable();
		var localPoint = this.globalToLocal(hookedCollectable.x,hookedCollectable.y);
		hookedCollectable.x = localPoint.x;
		hookedCollectable.y = localPoint.y;
		hookedCollectable.rotation -= this.rotation;
		this._pulledCollectable = hookedCollectable;
		this._isPulling = true;
		this._extentionSpeed *= this._pulledCollectable.getSpeedMultiplier();
		this.addChild(this._pulledCollectable);
		createjs.Tween.get(this._pulledCollectable).to({ x : this._hook.x, y : this._hook.y + this._hook.image.height / 2 - this._extentionSpeed * 0.2, rotation : this.rotation},200,createjs.Ease.sineIn);
	}
	,getWidth: function() {
		return this._hook.image.width;
	}
	,getHookHitbox: function() {
		var originPoint = this.localToGlobal(0,this._hook.y);
		originPoint = this.parent.globalToLocal(originPoint.x,originPoint.y);
		var hitbox = new createjs.Rectangle(originPoint.x - this._hook.image.width * 0.25,originPoint.y,this._hook.image.width * 0.5,this._hook.image.height * 0.5);
		return hitbox;
	}
	,startRetract: function() {
		this._isRetracting = true;
		this._isExtending = false;
		this._extentionSpeed *= -1;
		this.onStartedRetracting();
	}
	,endExplosion: function() {
		this.removeChild(this._explosionAnimation);
		this._explosionAnimation = null;
	}
	,showExplosion: function(x,y) {
		var bmpExplosion = co.doubleduck.BaseAssets.getImage("images/session/explosion.png");
		var initExplosionObject = { };
		initExplosionObject.images = [bmpExplosion.image];
		initExplosionObject.frames = { width : 149, height : 120.5, regX : 74.5, regY : 60.25};
		initExplosionObject.animations = { explode : { frames : [0,1,2,3,4,5], frequency : 20}};
		this._explosionAnimation = new createjs.BitmapAnimation(new createjs.SpriteSheet(initExplosionObject));
		this._explosionAnimation.x = x;
		this._explosionAnimation.y = y;
		this.addChild(this._explosionAnimation);
		this._explosionAnimation.onAnimationEnd = $bind(this,this.endExplosion);
		this._explosionAnimation.play();
	}
	,fireTnt: function() {
		if(!this._isFiringTnt) {
			this._tnt = co.doubleduck.BaseAssets.getImage("images/session/tnt.png");
			this._tnt.regX = this._tnt.image.width / 2;
			this._tnt.x = 0;
			this._tnt.y = 0;
			this.addChild(this._tnt);
			this._isFiringTnt = true;
		}
	}
	,handleTick: function(elapsed) {
		if(elapsed != null) {
			if(this._isExtending || this._isRetracting) {
				this._length += this._extentionSpeed * (elapsed / 1000);
				if(this._isFiringTnt) {
					this._tnt.y += this._tntSpeed * (elapsed / 1000);
					if(this._tnt.y + this._tnt.image.height >= this._pulledCollectable.y) {
						this.showExplosion(this._tnt.x,this._tnt.y);
						this._extentionSpeed /= this._pulledCollectable.getSpeedMultiplier();
						this.onDestoryedCollectable(this._pulledCollectable);
						this.removeChild(this._pulledCollectable);
						this.removeChild(this._tnt);
						this._tnt = null;
						this._isPulling = false;
						this._pulledCollectable = null;
						this._isFiringTnt = false;
					}
				}
				if(this._extentionSpeed < 0 && this._length < this.ORIGINAL_LENGTH) {
					this._length = this.ORIGINAL_LENGTH;
					this._extentionSpeed *= -1;
					this._isRetracting = false;
					if(this._isPulling) {
						this._extentionSpeed /= this._pulledCollectable.getSpeedMultiplier();
						this.removeChild(this._pulledCollectable);
						this._isPulling = false;
						this._pulledCollectable = null;
					}
					this.onFinishedRetracting();
				}
				this.removeChild(this._line);
				this._line = new createjs.Shape();
				this._line.graphics.beginStroke("#000000");
				this._line.graphics.setStrokeStyle(2);
				this._line.graphics.moveTo(0,0);
				this._line.graphics.lineTo(0,this._length);
				this._line.graphics.endStroke();
				this.addChildAt(this._line,0);
				this._hook.y = this._length;
				if(this._isPulling) this._pulledCollectable.y += this._extentionSpeed * (elapsed / 1000);
			}
		}
	}
	,startExtending: function() {
		this._isExtending = true;
	}
	,_explosionAnimation: null
	,_tntSpeed: null
	,_extentionSpeed: null
	,_length: null
	,_endY: null
	,_endX: null
	,_isPulling: null
	,_isFiringTnt: null
	,_isRetracting: null
	,_isExtending: null
	,_pulledCollectable: null
	,_tnt: null
	,_laser: null
	,_hook: null
	,_line: null
	,onDestoryedCollectable: null
	,onStartedRetracting: null
	,onFinishedRetracting: null
	,ORIGINAL_LENGTH: null
	,__class__: co.doubleduck.Hook
});
co.doubleduck.Hud = $hxClasses["co.doubleduck.Hud"] = function(limitType,limit,goal,fishId,tntLeft) {
	this.BUTTON_X_PADDING = 20;
	this.MARGIN = 30;
	createjs.Container.call(this);
	if(co.doubleduck.Hud._fontSmall == null) co.doubleduck.Hud._fontSmall = new co.doubleduck.FontHelper("images/general/font_small/");
	this._tntLeft = tntLeft;
	this._hudBmp = co.doubleduck.BaseAssets.getImage("images/session/hud.png");
	this.addChild(this._hudBmp);
	var goalScore = new createjs.Text("","10px Arial","#DDBB33");
	goalScore.textAlign = "center";
	if(co.doubleduck.BaseGame.activeLocale == "es") goalScore.text = "OBJECTIVO: " + goal; else goalScore.text = "GOAL: " + goal;
	goalScore.x = this._hudPad + 65;
	goalScore.y = 30;
	this.addChild(goalScore);
	if(fishId != -1) {
		this._fishIcon = co.doubleduck.Utils.getCenteredImage("images/session/fish" + fishId + ".png",false);
		this._fishIcon.scaleX = this._fishIcon.scaleY = 13 / this._fishIcon.image.height;
		this._fishIcon.x = goalScore.x + goalScore.getMeasuredWidth() / 2 + 15;
		this._fishIcon.y = goalScore.y + goalScore.getMeasuredHeight() / 2;
		this.addChild(this._fishIcon);
	}
	if(this._tntLeft > 0) {
		this._tntLeftIcon = co.doubleduck.BaseAssets.getImage("images/session/" + this._tntLeft + "bomb.png",false);
		this._tntLeftIcon.regX = this._tntLeftIcon.image.width;
		this._tntLeftIcon.regY = 0;
		this._tntLeftIcon.x = co.doubleduck.BaseGame.getScreenSize().width;
		this._tntLeftIcon.y = 0;
		this.addChild(this._tntLeftIcon);
	}
	this._hudPad = 20;
	this.LIMIT_TYPE = limitType;
	this._btnPause = new co.doubleduck.Button(co.doubleduck.BaseAssets.getImage("images/session/pause_btn.png"));
	this._btnPause.x = co.doubleduck.BaseGame.getScreenSize().width - this._hudPad - this._btnPause.image.width;
	this._btnPause.y = co.doubleduck.BaseGame.getScreenSize().height - this._hudPad - this._btnPause.image.height;
	this._btnPause.onClick = $bind(this,this.handlePauseClick);
	this.addChild(this._btnPause);
	if(this.LIMIT_TYPE == co.doubleduck.LimitType.Time) {
		this._limitType = co.doubleduck.BaseAssets.getImage("images/session/timeicon.png");
		this._limitType.x = this._hudPad - 10;
		this._limitType.scaleX = this._limitType.scaleY = 0.5;
		this._limitType.y = 35 + this._limitType.image.height * this._limitType.scaleY;
		this.addChild(this._limitType);
		this._timeLeft = limit;
		this._timeLeftRounded = Math.round(this._timeLeft);
		this.updateTimeLeft();
		this.onTick = $bind(this,this.handleTick);
	} else {
		this._limitType = co.doubleduck.BaseAssets.getImage("images/session/moves.png");
		this._limitType.x = this._hudPad - 10;
		this._limitType.scaleX = this._limitType.scaleY = 0.5;
		this._limitType.y = 35 + this._limitType.image.height * this._limitType.scaleY;
		this.addChild(this._limitType);
		this.updateMovesLeft(limit);
	}
	this.createPauseMenu();
};
co.doubleduck.Hud.__name__ = ["co","doubleduck","Hud"];
co.doubleduck.Hud._fontSmall = null;
co.doubleduck.Hud.__super__ = createjs.Container;
co.doubleduck.Hud.prototype = $extend(createjs.Container.prototype,{
	handleResumeClick: function() {
		co.doubleduck.GameManager.setSessionRunning(true);
		createjs.Ticker.setPaused(false);
		this._btnRetry.mouseEnabled = false;
		this._btnMenu.mouseEnabled = false;
		this._btnResume.mouseEnabled = false;
		this._pauseContainer.visible = false;
	}
	,handleMenuClick: function() {
		createjs.Ticker.setPaused(false);
		this._btnRetry.mouseEnabled = false;
		this._btnMenu.mouseEnabled = false;
		this._btnResume.mouseEnabled = false;
		createjs.Tween.get(this).to({ alpha : 0},300,createjs.Ease.sineOut);
		this.onQuitGame();
	}
	,handleRetryClick: function() {
		createjs.Ticker.setPaused(false);
		this._btnRetry.mouseEnabled = false;
		this._btnMenu.mouseEnabled = false;
		this._btnResume.mouseEnabled = false;
		createjs.Tween.get(this).to({ alpha : 0},300,createjs.Ease.sineOut);
		this.onRetryClick();
	}
	,handlePauseClick: function() {
		this._btnRetry.mouseEnabled = true;
		this._btnMenu.mouseEnabled = true;
		this._btnResume.mouseEnabled = true;
		this._pauseContainer.visible = true;
		co.doubleduck.GameManager.setSessionRunning(false);
		createjs.Ticker.setPaused(true);
		this.getStage().update();
	}
	,updateMovesLeft: function(limit) {
		if(this._limitDisplay != null) this.removeChild(this._limitDisplay);
		var dims = new createjs.Rectangle(0,0,0,0);
		this._limitDisplay = co.doubleduck.Hud._fontSmall.getNumber(limit,1,true,dims,-1);
		this._limitDisplay.regX = 0;
		var totalW = dims.width;
		this._limitDisplay.x = this._hudPad + this._limitType.image.width * this._limitType.scaleX;
		this._limitDisplay.y = dims.height + 35;
		this.addChild(this._limitDisplay);
	}
	,getCurrentTime: function() {
		return this._timeLeftRounded;
	}
	,addTime: function(timeAddition) {
		this._timeLeft += timeAddition;
		this._timeLeftRounded += timeAddition;
		this.updateTimeLeft();
	}
	,updateTimeLeft: function() {
		if(this._limitDisplay != null) this.removeChild(this._limitDisplay);
		var dims = new createjs.Rectangle(0,0,0,0);
		this._limitDisplay = co.doubleduck.Hud._fontSmall.getNumber(this._timeLeftRounded,1,true,dims,-1);
		this._limitDisplay.regX = 0;
		var totalW = dims.width;
		this._limitDisplay.x = this._hudPad + this._limitType.image.width * this._limitType.scaleX;
		this._limitDisplay.y = dims.height + 35;
		this.addChild(this._limitDisplay);
	}
	,updateGoalScore: function(score) {
		if(this._xp != null) this.removeChild(this._xp);
		var dims = new createjs.Rectangle(0,0,0,0);
		this._xp = co.doubleduck.Hud._fontSmall.getNumber(score,1,true,dims,-1);
		this._xp.regY = 0;
		var totalW = dims.width;
		this._xp.x = this._hudPad + 45;
		this._xp.y = 2;
		this.addChild(this._xp);
	}
	,handleTick: function(elapsed) {
		if(co.doubleduck.GameManager.isSessionRunning()) {
			this._timeLeft -= elapsed / 1000;
			if(this._timeLeftRounded - 1 >= this._timeLeft && this._timeLeftRounded >= 0) {
				this._timeLeftRounded--;
				if(this._timeLeftRounded < 0) this.onTimeLimitReached(); else this.updateTimeLeft();
			}
		}
	}
	,createPauseMenu: function() {
		this._pauseContainer = new createjs.Container();
		this._pauseWindow = co.doubleduck.Utils.getCenteredImage("images/session/paused.png",false);
		this._pauseWindow.x = co.doubleduck.BaseGame.getScreenSize().width / 2;
		this._pauseWindow.y = co.doubleduck.BaseGame.getScreenSize().height / 2;
		this._pauseContainer.addChild(this._pauseWindow);
		this._btnRetry = new co.doubleduck.Button(co.doubleduck.BaseAssets.getImage("images/session/level_end/retry.png"));
		this._btnRetry.regX = this._btnRetry.image.width / 2;
		this._btnRetry.regY = this._btnRetry.image.height;
		this._btnRetry.onClick = $bind(this,this.handleRetryClick);
		this._btnRetry.y = this._pauseWindow.y + this._pauseWindow.image.height * 0.5 - this.MARGIN;
		this._btnRetry.x = this._pauseWindow.x;
		this._pauseContainer.addChild(this._btnRetry);
		this._btnMenu = new co.doubleduck.Button(co.doubleduck.BaseAssets.getImage("images/session/level_end/menu.png"));
		this._btnMenu.regX = this._btnMenu.image.width;
		this._btnMenu.regY = this._btnMenu.image.height;
		this._btnMenu.onClick = $bind(this,this.handleMenuClick);
		this._btnMenu.y = this._pauseWindow.y + this._pauseWindow.image.height * 0.5 - this.MARGIN;
		this._btnMenu.x = this._btnRetry.x - this._btnRetry.image.width * 0.5 - this.BUTTON_X_PADDING;
		this._pauseContainer.addChild(this._btnMenu);
		this._btnResume = new co.doubleduck.Button(co.doubleduck.BaseAssets.getImage("images/session/level_end/next.png"));
		this._btnResume.regX = 0;
		this._btnResume.regY = this._btnResume.image.height;
		this._btnResume.onClick = $bind(this,this.handleResumeClick);
		this._btnResume.y = this._pauseWindow.y + this._pauseWindow.image.height * 0.5 - this.MARGIN;
		this._btnResume.x = this._btnRetry.x + this._btnRetry.image.width * 0.5 + this.BUTTON_X_PADDING;
		this._pauseContainer.addChild(this._btnResume);
		this._pauseContainer.visible = false;
		this.addChild(this._pauseContainer);
	}
	,decreaseTnt: function() {
		this._tntLeft--;
		if(this._tntLeft > 0) {
			this.removeChild(this._tntLeftIcon);
			this._tntLeftIcon = co.doubleduck.BaseAssets.getImage("images/session/" + this._tntLeft + "bomb.png",false);
			this._tntLeftIcon.regX = this._tntLeftIcon.image.width;
			this._tntLeftIcon.regY = 0;
			this._tntLeftIcon.x = co.doubleduck.BaseGame.getScreenSize().width;
			this._tntLeftIcon.y = 0;
			this.addChild(this._tntLeftIcon);
		} else this.removeChild(this._tntLeftIcon);
	}
	,_hudPad: null
	,_timeLeft: null
	,_timeLeftRounded: null
	,_tntLeftIcon: null
	,_tntLeft: null
	,_fishIcon: null
	,_limitType: null
	,_btnMenu: null
	,_btnResume: null
	,_btnRetry: null
	,_pauseWindow: null
	,_pauseContainer: null
	,_btnPause: null
	,_hudBmp: null
	,_limitDisplay: null
	,_xp: null
	,LIMIT_TYPE: null
	,onRetryClick: null
	,onQuitGame: null
	,onTimeLimitReached: null
	,BUTTON_X_PADDING: null
	,MARGIN: null
	,__class__: co.doubleduck.Hud
});
co.doubleduck.LevelEndContainer = $hxClasses["co.doubleduck.LevelEndContainer"] = function(success,starsAmount,unlockName,isFinalLevel,goal,goalType,limit,limitType,fishId) {
	this.STAR_SPACING = 10;
	this.BUTTON_Y_PADDING = 20;
	this.BUTTON_X_PADDING = 20;
	this.MARGIN = 30;
	this.Y_SPACING = 10;
	this.X_SPACING = 5;
	createjs.Container.call(this);
	this._scoreLimitType = limitType;
	this._isFinalLevel = isFinalLevel;
	if(success) {
		this._scoreGoal = goal;
		this._scoreGoalType = goalType;
		this._scoreLimit = limit;
		this._fishId = fishId;
		this.showSuccess(starsAmount,isFinalLevel,unlockName);
	} else this.showFailed();
};
co.doubleduck.LevelEndContainer.__name__ = ["co","doubleduck","LevelEndContainer"];
co.doubleduck.LevelEndContainer._fontSmall = null;
co.doubleduck.LevelEndContainer.__super__ = createjs.Container;
co.doubleduck.LevelEndContainer.prototype = $extend(createjs.Container.prototype,{
	handleResumeClick: function() {
		this._btnRetry.mouseEnabled = false;
		this._btnMenu.mouseEnabled = false;
		if(this._btnNext != null) this._btnNext.mouseEnabled = false;
		createjs.Tween.get(this).to({ alpha : 0},500,createjs.Ease.sineIn).call(this.onNextClick);
	}
	,handleMenuClick: function() {
		this._btnRetry.mouseEnabled = false;
		this._btnMenu.mouseEnabled = false;
		if(this._btnNext != null) this._btnNext.mouseEnabled = false;
		createjs.Tween.get(this).to({ alpha : 0},500,createjs.Ease.sineIn).call(this.onQuitGame);
	}
	,handleRetryClick: function() {
		this._btnRetry.mouseEnabled = false;
		this._btnMenu.mouseEnabled = false;
		if(this._btnNext != null) this._btnNext.mouseEnabled = false;
		createjs.Tween.get(this).to({ alpha : 0},500,createjs.Ease.sineIn).call(this.onRetryClick);
	}
	,hideUnlock: function() {
		this._unlockText.mouseEnabled = false;
		this._overlay.mouseEnabled = false;
		createjs.Tween.get(this._overlay).to({ alpha : 0},300);
		createjs.Tween.get(this._unlockText).to({ alpha : 0, scaleX : 1.5, scaleY : 1.5},300,createjs.Ease.quintOut);
	}
	,showUnlock: function() {
		if(this._unlockText != null) {
			this._overlay = new createjs.Shape();
			this._overlay.graphics.beginFill("#000000");
			this._overlay.graphics.drawRect(0,0,co.doubleduck.BaseGame.getScreenSize().width,co.doubleduck.BaseGame.getScreenSize().height);
			this._overlay.graphics.endFill();
			this._overlay.alpha = 0;
			this._overlay.mouseEnabled = true;
			this._overlay.onClick = $bind(this,this.hideUnlock);
			this.addChild(this._overlay);
			this._unlockText.onClick = $bind(this,this.hideUnlock);
			this._unlockText.mouseEnabled = true;
			this.addChild(this._unlockText);
			createjs.Tween.get(this._overlay).to({ alpha : 0.7},300);
			createjs.Tween.get(this._unlockText).to({ alpha : 1, scaleX : 1, scaleY : 1},300,createjs.Ease.quintOut);
		}
	}
	,showButtons: function() {
		createjs.Tween.get(this._btnMenu).to({ alpha : 1},300,createjs.Ease.sineIn);
		createjs.Tween.get(this._btnRetry).to({ alpha : 1},300,createjs.Ease.sineIn).call($bind(this,this.showUnlock));
		if(this._btnNext != null) createjs.Tween.get(this._btnNext).to({ alpha : 1},300,createjs.Ease.sineIn);
	}
	,showScreen: function() {
		if(this._stars != null) {
			createjs.Tween.get(this._header).to({ alpha : 1, scaleX : 1, scaleY : 1},300,createjs.Ease.quintOut);
			var _g1 = 0, _g = this._stars.length;
			while(_g1 < _g) {
				var j = _g1++;
				if(j + 1 == this._stars.length) createjs.Tween.get(this._stars[j]).wait(300 + 400 * j).to({ alpha : 1, scaleX : 1, scaleY : 1},300,createjs.Ease.quintOut).call($bind(this,this.showButtons)); else createjs.Tween.get(this._stars[j]).wait(300 + 400 * j).to({ alpha : 1, scaleX : 1, scaleY : 1},300,createjs.Ease.quintOut);
			}
			createjs.Tween.get(this._scoreContainer).to({ alpha : 1},300,createjs.Ease.sineIn);
			co.doubleduck.SoundManager.playEffect("sound/level_pass");
		} else this.showButtons();
	}
	,createScoreDisplay: function() {
		if(co.doubleduck.LevelEndContainer._fontSmall == null) co.doubleduck.LevelEndContainer._fontSmall = new co.doubleduck.FontHelper("images/general/font_small/");
		this._scoreContainer = new createjs.Container();
		this._get = co.doubleduck.Utils.getCenteredImage("images/session/level_end/got.png",false);
		this._get.regX = this._get.image.width;
		if(!this._isFinalLevel) this._get.y = this._starBase.y + this._starBase.image.height + this.Y_SPACING * 2; else this._get.y = this._starBase.y + this._starBase.image.height + this.Y_SPACING;
		this._scoreContainer.addChild(this._get);
		var dims = new createjs.Rectangle(0,0,0,0);
		this._goalAmount = co.doubleduck.LevelEndContainer._fontSmall.getNumber(this._scoreGoal,1,true,dims,-1);
		this._goalAmount.regX = 0;
		this._goalAmount.regY = dims.height / 2;
		var totalW = dims.width;
		this._goalAmount.y = this._get.y;
		totalW += this._get.image.width + this.X_SPACING;
		this._goalAmount.x = co.doubleduck.BaseGame.getScreenSize().width / 2 + this.X_SPACING;
		this._get.x = co.doubleduck.BaseGame.getScreenSize().width / 2 - this.X_SPACING;
		this._scoreContainer.addChild(this._goalAmount);
		this._in = co.doubleduck.Utils.getCenteredImage("images/session/level_end/in.png",false);
		this._in.regX = this._in.image.width;
		this._in.x = co.doubleduck.BaseGame.getScreenSize().width / 2;
		if(!this._isFinalLevel) this._in.y = this._get.y + this._get.image.height + this.Y_SPACING / 2; else this._in.y = this._get.y + this._get.image.height + this.Y_SPACING / 4;
		var totalW1 = this._in.image.width;
		this._scoreContainer.addChild(this._in);
		var dims1 = new createjs.Rectangle(0,0,0,0);
		this._limitAmount = co.doubleduck.LevelEndContainer._fontSmall.getNumber(this._scoreLimit,1,true,dims1,-1);
		this._limitAmount.regX = 0;
		this._limitAmount.regY = dims1.height / 2;
		totalW1 += dims1.width;
		this._limitAmount.y = this._in.y;
		if(this._scoreLimitType == co.doubleduck.LimitType.Time) {
			this._limitType = co.doubleduck.Utils.getCenteredImage("images/session/timeicon.png",false);
			this._limitType.y = this._limitAmount.y;
		} else {
			this._limitType = co.doubleduck.Utils.getCenteredImage("images/session/moves.png",false);
			this._limitType.y = this._limitAmount.y;
		}
		this._limitType.regX = 0;
		totalW1 += this._limitType.image.width + this.X_SPACING;
		this._limitAmount.x = co.doubleduck.BaseGame.getScreenSize().width / 2;
		this._limitType.x = this._limitAmount.x + dims1.width + this.X_SPACING;
		this._in.x = this._limitAmount.x - this.X_SPACING;
		this._scoreContainer.addChild(this._limitType);
		this._scoreContainer.addChild(this._limitAmount);
		this._scoreContainer.alpha = 0;
		this.addChild(this._scoreContainer);
	}
	,showSuccess: function(starsAmount,isFinalLevel,unlockName) {
		if(!isFinalLevel) this._bg = co.doubleduck.Utils.getCenteredImage("images/session/message_overlay.png",false); else this._bg = co.doubleduck.Utils.getCenteredImage("images/session/level_end/endgame.png",false);
		this._bg.x = co.doubleduck.BaseGame.getScreenSize().width / 2;
		this._bg.y = co.doubleduck.BaseGame.getScreenSize().height / 2;
		this.addChild(this._bg);
		this._header = co.doubleduck.Utils.getCenteredImage("images/session/level_end/win.png",false);
		this._header.x = co.doubleduck.BaseGame.getScreenSize().width / 2;
		this._header.regY = 0;
		this._header.alpha = 0;
		this._header.scaleX = 0.2;
		this._header.scaleY = 0.2;
		this._header.y = this._bg.y - this._bg.image.height / 2 + this.MARGIN;
		if(!isFinalLevel) this.addChild(this._header);
		this._starBase = co.doubleduck.Utils.getCenteredImage("images/session/level_end/stars_base.png",false);
		this._starBase.regY = 0;
		this._starBase.x = co.doubleduck.BaseGame.getScreenSize().width / 2;
		if(!isFinalLevel) this._starBase.y = this._header.y + this._header.image.height; else this._starBase.y = this._header.y + this._header.image.height + 5;
		this.addChild(this._starBase);
		this._stars = new Array();
		var _g = 0;
		while(_g < starsAmount) {
			var i = _g++;
			var _newStar = co.doubleduck.Utils.getCenteredImage("images/session/level_end/" + (i + 1) + "star.png",false);
			_newStar.regY = 0;
			_newStar.x = co.doubleduck.BaseGame.getScreenSize().width / 2;
			_newStar.y = this._starBase.y;
			_newStar.alpha = 0;
			_newStar.scaleX = 2;
			_newStar.scaleY = 2;
			this._stars.push(_newStar);
			this.addChild(_newStar);
		}
		if(unlockName != "") {
			this._unlockText = co.doubleduck.Utils.getCenteredImage("images/session/level_end/" + unlockName + ".png",false);
			this._unlockText.x = co.doubleduck.BaseGame.getScreenSize().width / 2;
			this._unlockText.y = this._starBase.y + this._starBase.image.height + this.Y_SPACING * 2;
			this._unlockText.alpha = 0;
			this._unlockText.scaleX = this._unlockText.scaleY = 2;
		}
		this._btnRetry = new co.doubleduck.Button(co.doubleduck.BaseAssets.getImage("images/session/level_end/retry.png"));
		this._btnRetry.regX = this._btnRetry.image.width / 2;
		this._btnRetry.regY = this._btnRetry.image.height;
		this._btnRetry.onClick = $bind(this,this.handleRetryClick);
		this._btnRetry.y = this._bg.y + this._bg.image.height * 0.5 - this.MARGIN;
		this._btnRetry.x = this._bg.x;
		this._btnRetry.alpha = 0;
		this._btnMenu = new co.doubleduck.Button(co.doubleduck.BaseAssets.getImage("images/session/level_end/menu.png"));
		this._btnMenu.regX = this._btnMenu.image.width;
		this._btnMenu.regY = this._btnMenu.image.height;
		this._btnMenu.onClick = $bind(this,this.handleMenuClick);
		this._btnMenu.y = this._bg.y + this._bg.image.height * 0.5 - this.MARGIN;
		this._btnMenu.x = this._btnRetry.x - this._btnRetry.image.width * 0.5 - this.BUTTON_X_PADDING;
		this._btnMenu.alpha = 0;
		if(!isFinalLevel) {
			this._btnNext = new co.doubleduck.Button(co.doubleduck.BaseAssets.getImage("images/session/level_end/next.png"));
			this._btnNext.regX = 0;
			this._btnNext.regY = this._btnNext.image.height;
			this._btnNext.onClick = $bind(this,this.handleResumeClick);
			this._btnNext.y = this._bg.y + this._bg.image.height * 0.5 - this.MARGIN;
			this._btnNext.x = this._btnRetry.x + this._btnRetry.image.width * 0.5 + this.BUTTON_X_PADDING;
			this._btnNext.alpha = 0;
			this.addChild(this._btnNext);
		} else {
			this._btnRetry.regX = 0;
			this._btnRetry.x = this._bg.x + this.BUTTON_X_PADDING / 2;
			this._btnMenu.regX = this._btnMenu.image.width;
			this._btnMenu.x = this._bg.x - this.BUTTON_X_PADDING / 2;
		}
		this.createScoreDisplay();
		this.addChild(this._btnRetry);
		this.addChild(this._btnMenu);
	}
	,showFailed: function() {
		if(this._scoreLimitType == co.doubleduck.LimitType.Moves) this._bg = co.doubleduck.Utils.getCenteredImage("images/session/level_end/failure_hooks.png",false); else this._bg = co.doubleduck.Utils.getCenteredImage("images/session/level_end/failure_time.png",false);
		this._bg.x = co.doubleduck.BaseGame.getScreenSize().width / 2;
		this._bg.y = co.doubleduck.BaseGame.getScreenSize().height / 2;
		this.addChild(this._bg);
		this._btnRetry = new co.doubleduck.Button(co.doubleduck.BaseAssets.getImage("images/session/level_end/retry.png"));
		this._btnRetry.regX = 0;
		this._btnRetry.regY = this._btnRetry.image.height;
		this._btnRetry.onClick = $bind(this,this.handleRetryClick);
		this._btnRetry.y = this._bg.y + this._bg.image.height * 0.5 - this.BUTTON_Y_PADDING;
		this._btnRetry.x = this._bg.x + this.BUTTON_X_PADDING / 2;
		this._btnRetry.alpha = 0;
		this.addChild(this._btnRetry);
		this._btnMenu = new co.doubleduck.Button(co.doubleduck.BaseAssets.getImage("images/session/level_end/menu.png"));
		this._btnMenu.regX = this._btnMenu.image.width;
		this._btnMenu.regY = this._btnMenu.image.height;
		this._btnMenu.onClick = $bind(this,this.handleMenuClick);
		this._btnMenu.y = this._bg.y + this._bg.image.height * 0.5 - this.BUTTON_Y_PADDING;
		this._btnMenu.x = this._bg.x - this.BUTTON_X_PADDING / 2;
		this._btnMenu.alpha = 0;
		this.addChild(this._btnMenu);
		co.doubleduck.SoundManager.playEffect("sound/level_fail");
	}
	,_isFinalLevel: null
	,_fishId: null
	,_scoreLimitType: null
	,_scoreLimit: null
	,_scoreGoalType: null
	,_scoreGoal: null
	,_scoreContainer: null
	,_limitAmount: null
	,_goalAmount: null
	,_btnGo: null
	,_limitType: null
	,_in: null
	,_goalType: null
	,_get: null
	,_starContainer: null
	,_starBase: null
	,_stars: null
	,_endGameMessage: null
	,_btnRetry: null
	,_btnNext: null
	,_btnMenu: null
	,_unlockText: null
	,_header: null
	,_bg: null
	,_overlay: null
	,onQuitGame: null
	,onRetryClick: null
	,onNextClick: null
	,STAR_SPACING: null
	,BUTTON_Y_PADDING: null
	,BUTTON_X_PADDING: null
	,MARGIN: null
	,Y_SPACING: null
	,X_SPACING: null
	,__class__: co.doubleduck.LevelEndContainer
});
co.doubleduck.Main = $hxClasses["co.doubleduck.Main"] = function() { }
co.doubleduck.Main.__name__ = ["co","doubleduck","Main"];
co.doubleduck.Main._stage = null;
co.doubleduck.Main._game = null;
co.doubleduck.Main._ffHeight = null;
co.doubleduck.Main.main = function() {
	co.doubleduck.Main.testFFHeight();
	createjs.Ticker.useRAF = true;
	createjs.Ticker.setFPS(60);
	co.doubleduck.Main._stage = new createjs.Stage(js.Lib.document.getElementById("stageCanvas"));
	co.doubleduck.Main._game = new co.doubleduck.Game(co.doubleduck.Main._stage);
	createjs.Ticker.addListener(co.doubleduck.Main._stage);
	createjs.Touch.enable(co.doubleduck.Main._stage,true,false);
}
co.doubleduck.Main.testFFHeight = function() {
	var isAplicable = /Firefox/.test(navigator.userAgent);
	if(isAplicable && viewporter.ACTIVE) co.doubleduck.Main._ffHeight = js.Lib.window.innerHeight;
}
co.doubleduck.Main.getFFHeight = function() {
	return co.doubleduck.Main._ffHeight;
}
co.doubleduck.Menu = $hxClasses["co.doubleduck.Menu"] = function() {
	this._currLevelScreen = 0;
	this._isMoving = false;
	this._isInHelp = false;
	co.doubleduck.BaseMenu.call(this);
	co.doubleduck.Button.setDefaultSound("sound/button_press");
	this.scaleX = this.scaleY = co.doubleduck.BaseGame.getScale();
	this._bg2 = co.doubleduck.BaseAssets.getImage("images/general/bg2.jpg");
	this._bg2.regX = this._bg2.image.width / 2;
	this._bg2.x = co.doubleduck.BaseGame.getScreenSize().width / 2;
	this._bg2.regY = this._bg2.image.height;
	this._bg3 = co.doubleduck.BaseAssets.getImage("images/general/bg3.jpg");
	this._bg3.regX = this._bg3.image.width / 2;
	this._bg3.x = this._bg2.x;
	this._bg3.regY = this._bg3.image.height;
	this._bg3.y = co.doubleduck.BaseGame.getScreenSize().height;
	this._bg2.y = this._bg3.y - this._bg3.image.height + 1;
	this.addChild(this._bg2);
	this.addChild(this._bg3);
	this._levelButtons = new Array();
	this._levelsLayer = new createjs.Container();
	this._levelsLayer.mouseEnabled = false;
	co.doubleduck.Utils.waitAndCall(this,1000,$bind(this,this.enableLevelClick));
	if(co.doubleduck.Menu._iconSpritesheet == null) {
		var img = co.doubleduck.BaseAssets.getRawImage("images/menu/level_icons.png");
		var initObject = { };
		initObject.images = [img];
		initObject.frames = { width : img.width / 5, height : img.height, regX : 0, regY : 0};
		initObject.animations = { };
		initObject.animations.locked = { frames : 4, frequency : 20};
		var _g = 0;
		while(_g < 4) {
			var i = _g++;
			initObject.animations["star" + i] = { frames : i, frequency : 20};
		}
		co.doubleduck.Menu._iconSpritesheet = new createjs.SpriteSheet(initObject);
	}
	var _g1 = 0, _g = Math.ceil(co.doubleduck.DataLoader.getLevelCount() / co.doubleduck.Menu.LEVELS_PER_SCREEN);
	while(_g1 < _g) {
		var i = _g1++;
		var _g3 = 0, _g2 = co.doubleduck.Menu.LEVELS_PER_SCREEN;
		while(_g3 < _g2) {
			var j = _g3++;
			var lvlNum = i * co.doubleduck.Menu.LEVELS_PER_SCREEN + j + 1;
			if(lvlNum > co.doubleduck.DataLoader.getLevelCount()) break;
			var currLvl = new co.doubleduck.Button(new createjs.BitmapAnimation(co.doubleduck.Menu._iconSpritesheet));
			currLvl.name = "" + lvlNum;
			currLvl.regX = currLvl.image.width / 2;
			currLvl.regY = currLvl.image.height / 2;
			currLvl.x = co.doubleduck.BaseGame.getScreenSize().width * (0.33 + j % (co.doubleduck.Menu.LEVELS_PER_SCREEN / 3) * 0.33);
			currLvl.x += co.doubleduck.BaseGame.getScreenSize().width * i;
			currLvl.y = co.doubleduck.BaseGame.getScreenSize().height * (0.14 + Math.floor(j / (co.doubleduck.Menu.LEVELS_PER_SCREEN / 3)) * 0.22);
			if(lvlNum <= co.doubleduck.Persistence.getLastLevel()) {
				var stars = co.doubleduck.Persistence.getStarRating(lvlNum);
				currLvl.anim.gotoAndStop("star" + stars);
				currLvl.addBitmapLabel("" + lvlNum,"images/menu/menu_font/",-25);
				currLvl.shiftLabel(1,0.8);
				currLvl.scaleBitmapFont(0.74);
				currLvl.onClick = $bind(this,this.handleLevelClick);
			} else currLvl.anim.gotoAndStop("locked");
			this._levelButtons[lvlNum - 1] = currLvl;
			this._levelsLayer.addChild(currLvl);
		}
	}
	this._levelsLayer.alpha = 0;
	this.addChild(this._levelsLayer);
	createjs.Tween.get(this._levelsLayer).wait(100).to({ alpha : 1},400);
	this._menuRightBtn = new co.doubleduck.Button(co.doubleduck.BaseAssets.getImage("images/menu/arrow_right.png"));
	this._menuRightBtn.regX = this._menuRightBtn.image.width;
	this._menuRightBtn.regY = this._menuRightBtn.image.height / 2;
	this._menuRightBtn.x = co.doubleduck.BaseGame.getScreenSize().width;
	this._menuRightBtn.y = co.doubleduck.BaseGame.getScreenSize().height * 0.475;
	this._menuRightBtn.onClick = $bind(this,this.goToNext);
	this._menuRightBtn.alpha = 0;
	this.addChild(this._menuRightBtn);
	createjs.Tween.get(this._menuRightBtn).to({ alpha : 1},300);
	this._menuLeftBtn = new co.doubleduck.Button(co.doubleduck.BaseAssets.getImage("images/menu/arrow_left.png"));
	this._menuLeftBtn.regX = 0;
	this._menuLeftBtn.regY = this._menuLeftBtn.image.height / 2;
	this._menuLeftBtn.x = 0;
	this._menuLeftBtn.y = this._menuRightBtn.y;
	this._menuLeftBtn.onClick = $bind(this,this.goToPrev);
	this._menuLeftBtn.alpha = 0;
	this.addChild(this._menuLeftBtn);
	createjs.Tween.get(this._menuLeftBtn).to({ alpha : 1},300);
	this._helpBtn = new co.doubleduck.Button(co.doubleduck.BaseAssets.getImage("images/menu/help.png"));
	this._helpBtn.regX = 0;
	this._helpBtn.regY = this._helpBtn.image.height;
	this._helpBtn.x = 22;
	this._helpBtn.y = co.doubleduck.BaseGame.getScreenSize().height - 20;
	this._helpBtn.onClick = $bind(this,this.showHelpMenu);
	this._helpBtn.alpha = 0;
	this.addChild(this._helpBtn);
	createjs.Tween.get(this._helpBtn).to({ alpha : 1},200);
	if(co.doubleduck.SoundManager.available) {
		this._muteBtn = new co.doubleduck.Button(co.doubleduck.BaseAssets.getImage("images/menu/sound.png"),true,co.doubleduck.Button.CLICK_TYPE_TOGGLE);
		this.addChild(this._muteBtn);
		this._muteBtn.regX = this._muteBtn.image.width / 4;
		this._muteBtn.regY = this._muteBtn.image.height / 2;
		this._muteBtn.x = co.doubleduck.BaseGame.getScreenSize().width - 22;
		this._muteBtn.y = this._helpBtn.y;
		this._muteBtn.setToggle(!co.doubleduck.SoundManager.isMuted());
		this._muteBtn.onToggle = $bind(this,this.handleMuteToggle);
		this._muteBtn.alpha = 0;
		this.addChild(this._muteBtn);
		createjs.Tween.get(this._muteBtn).to({ alpha : 1},200);
	}
	var gotoLevel = co.doubleduck.Session.getLastLevelId();
	if(gotoLevel == -1) gotoLevel = co.doubleduck.Persistence.getLastLevel();
	gotoLevel--;
	this.goToWorld(Math.floor(gotoLevel / co.doubleduck.Menu.LEVELS_PER_SCREEN),true);
	this.setArrowBtnVisibility();
	co.doubleduck.BaseGame.hammer.onswipe = $bind(this,this.handleSwipe);
	this._themeMusic = co.doubleduck.SoundManager.playMusic("sound/menu-theme");
};
co.doubleduck.Menu.__name__ = ["co","doubleduck","Menu"];
co.doubleduck.Menu.__super__ = co.doubleduck.BaseMenu;
co.doubleduck.Menu.prototype = $extend(co.doubleduck.BaseMenu.prototype,{
	goToPrev: function() {
		if(this._currLevelScreen <= 0) return;
		if(this._isInHelp) return;
		this.goToWorld(this._currLevelScreen - 1);
		this.setArrowBtnVisibility();
	}
	,goToNext: function() {
		if(this._currLevelScreen >= Math.floor((co.doubleduck.DataLoader.getLevelCount() - 1) / co.doubleduck.Menu.LEVELS_PER_SCREEN)) return;
		if(this._isInHelp) return;
		this.goToWorld(this._currLevelScreen + 1);
		this.setArrowBtnVisibility();
	}
	,handleTick: function(elapsed) {
		var delta = co.doubleduck.Menu.WORLD_MOVE_EASE * elapsed;
		delta = Math.min(delta,0.2);
		delta *= this._targetLevelsPos - this._levelsLayer.x;
		this._levelsLayer.x += delta;
		if(Math.abs(delta) >= 1) this._levelsLayer.mouseEnabled = false; else this._levelsLayer.mouseEnabled = true;
		if(Math.abs(this._targetLevelsPos - this._levelsLayer.x) < 1) {
			this._levelsLayer.x = this._targetLevelsPos;
			this._levelsLayer.mouseEnabled = true;
			this._isMoving = false;
			this.onTick = null;
		}
	}
	,setArrowBtnVisibility: function() {
		this._menuRightBtn.visible = this._currLevelScreen < Math.floor((co.doubleduck.DataLoader.getLevelCount() - 1) / co.doubleduck.Menu.LEVELS_PER_SCREEN);
		this._menuLeftBtn.visible = this._currLevelScreen > 0;
	}
	,goToWorld: function(id,force) {
		if(force == null) force = false;
		this._targetLevelsPos = id * co.doubleduck.BaseGame.getScreenSize().width * -1;
		this._currLevelScreen = id;
		if(force) this._levelsLayer.x = this._targetLevelsPos; else if(!this._isMoving) {
			this.onTick = $bind(this,this.handleTick);
			this._isMoving = true;
		}
	}
	,handleLevelClick: function(e) {
		var levelID = Std.parseInt(e.target.name);
		this._chosenLevel = levelID;
		if(this._themeMusic != null) this._themeMusic.stop();
		this._levelsLayer.mouseEnabled = false;
		if(co.doubleduck.SoundManager.available) this._muteBtn.onClick = null;
		this._helpBtn.onClick = null;
		if(co.doubleduck.SoundManager.available) createjs.Tween.get(this._muteBtn).to({ alpha : 0},140);
		createjs.Tween.get(this._helpBtn).to({ alpha : 0},140);
		createjs.Tween.get(this._menuRightBtn).to({ alpha : 0},140);
		createjs.Tween.get(this._menuLeftBtn).to({ alpha : 0},140);
		createjs.Tween.get(this._levelsLayer).to({ alpha : 0},500);
		if(this.onPlayClick != null) {
			var properties = { level : this._chosenLevel};
			this.onPlayClick(properties);
		}
	}
	,closeHelp: function() {
		co.doubleduck.BaseGame.hammer.onswipe = $bind(this,this.handleSwipe);
		this._isInHelp = false;
		createjs.Tween.removeTweens(this._helpScreen);
		createjs.Tween.removeTweens(this._helpBtn);
		createjs.Tween.get(this._helpScreen).to({ alpha : 0},1000,createjs.Ease.sineOut);
		this._helpBtn.onClick = $bind(this,this.showHelpMenu);
		this._levelsLayer.mouseEnabled = true;
		if(this._muteBtn != null) this._muteBtn.alpha = 1;
		this.setArrowBtnVisibility();
		this._helpBtn.alpha = 1;
	}
	,showHelpMenu: function() {
		if(this._helpScreen != null) {
			this._helpScreen.visible = false;
			this.removeChild(this._helpScreen);
			this._helpScreen = null;
		}
		this._helpScreen = new co.doubleduck.PagedHelp("images/menu/help_screen.png",null,"images/menu/gotit.png",new Array());
		this._helpScreen.x = co.doubleduck.BaseGame.getScreenSize().width / 2;
		this._helpScreen.y = co.doubleduck.BaseGame.getScreenSize().height * 0.475;
		this._helpScreen.setButtonsPos(0.79,0.95);
		this._helpScreen.onGotIt = $bind(this,this.closeHelp);
		this.addChild(this._helpScreen);
		this._helpScreen.alpha = 0;
		if(this._muteBtn != null) this._muteBtn.alpha = 0;
		this._helpScreen.enableSwipe();
		this._isInHelp = true;
		createjs.Tween.get(this._helpScreen).to({ alpha : 1},1000,createjs.Ease.sineOut);
		createjs.Tween.get(this._helpBtn).to({ alpha : 0},1000,createjs.Ease.sineOut);
		this._helpScreen.visible = true;
		this._helpBtn.onClick = null;
		this._levelsLayer.mouseEnabled = false;
		this._menuRightBtn.visible = this._menuLeftBtn.visible = false;
	}
	,handleMuteToggle: function() {
		co.doubleduck.SoundManager.toggleMute();
	}
	,handleSwipe: function(event) {
		if(event.direction == "left") this.goToNext(); else if(event.direction == "right") this.goToPrev();
	}
	,preLevelTutorial: function(level) {
		var e = { target : { name : "" + level}};
		this.handleLevelClick(e);
		this._helpBtn.visible = false;
	}
	,enableLevelClick: function() {
		this._levelsLayer.mouseEnabled = true;
	}
	,_chosenLevel: null
	,_levelsLayer: null
	,_currLevelScreen: null
	,_isMoving: null
	,_targetLevelsPos: null
	,_menuLeftBtn: null
	,_menuRightBtn: null
	,_helpScreen: null
	,_helpBtn: null
	,_muteBtn: null
	,_snow: null
	,_bg3: null
	,_bg2: null
	,_isInHelp: null
	,_themeMusic: null
	,_levelButtons: null
	,__class__: co.doubleduck.Menu
});
co.doubleduck.PagedHelp = $hxClasses["co.doubleduck.PagedHelp"] = function(backUri,nextBtnUri,gotItBtnUri,pages) {
	createjs.Container.call(this);
	this._background = co.doubleduck.BaseAssets.getImage(backUri);
	this.addChild(this._background);
	this.regX = this._background.image.width / 2;
	this.regY = this._background.image.height / 2;
	this._contentLayer = new createjs.Container();
	if(pages.length > 0) {
		var _g1 = 0, _g = pages.length;
		while(_g1 < _g) {
			var i = _g1++;
			this.addPage(pages[i],i);
		}
		this.addChild(this._contentLayer);
		this._pagesCount = pages.length;
		this._mask = new createjs.Shape();
		this._mask.graphics.beginFill("#000000");
		this._mask.graphics.drawRect(20,20,this._background.image.width - 40,this._background.image.height - 40);
		this._mask.graphics.endFill();
		this._contentLayer.mask = this._mask;
	} else this._pagesCount = 0;
	if(nextBtnUri != null && nextBtnUri != "") {
		this._nextBtn = new co.doubleduck.Button(co.doubleduck.BaseAssets.getImage(nextBtnUri),true,co.doubleduck.Button.CLICK_TYPE_SCALE);
		this._nextBtn.regX = this._nextBtn.image.width / 2;
		this._nextBtn.regY = this._nextBtn.image.height / 2;
		this._nextBtn.onClick = $bind(this,this.handleNextClick);
		this.addChild(this._nextBtn);
	}
	this._gotItBtn = new co.doubleduck.Button(co.doubleduck.BaseAssets.getImage(gotItBtnUri),true,co.doubleduck.Button.CLICK_TYPE_SCALE);
	this._gotItBtn.regX = this._gotItBtn.image.width / 2;
	this._gotItBtn.regY = this._gotItBtn.image.height / 2;
	this._gotItBtn.onClick = $bind(this,this.handleGotItClick);
	this.addChild(this._gotItBtn);
	this.setButtonsPos();
	this._currPage = 0;
	this.enableSwipe();
	this.addPageMarkers();
	this.setButtonsVis();
};
co.doubleduck.PagedHelp.__name__ = ["co","doubleduck","PagedHelp"];
co.doubleduck.PagedHelp.__super__ = createjs.Container;
co.doubleduck.PagedHelp.prototype = $extend(createjs.Container.prototype,{
	createPageMarker: function() {
		var img = co.doubleduck.BaseAssets.getRawImage("images/duckling/page_marker.png");
		var initObject = { };
		initObject.images = [img];
		initObject.frames = { width : 16, height : 18};
		initObject.animations = { };
		initObject.animations.idle = { frames : 0, frequency : 20};
		initObject.animations.active = { frames : 1, frequency : 20};
		var pageMarker = new createjs.BitmapAnimation(new createjs.SpriteSheet(initObject));
		pageMarker.gotoAndStop("idle");
		return pageMarker;
	}
	,handleNextClick: function() {
		this._currPage++;
		if(this._currPage >= this._pagesCount) {
			this._currPage = this._pagesCount - 1;
			return;
		}
		this._pageMarkers[this._currPage - 1].gotoAndStop("idle");
		this._pageMarkers[this._currPage].gotoAndStop("active");
		createjs.Tween.get(this._contentLayer).to({ x : -1 * this._background.image.width * this._currPage},200,createjs.Ease.sineOut);
		this.setButtonsVis();
	}
	,handlePrevClick: function() {
		this._currPage--;
		if(this._currPage < 0) {
			this._currPage = 0;
			return;
		}
		this._pageMarkers[this._currPage + 1].gotoAndStop("idle");
		this._pageMarkers[this._currPage].gotoAndStop("active");
		createjs.Tween.get(this._contentLayer).to({ x : -1 * this._background.image.width * this._currPage},200,createjs.Ease.sineOut);
		this.setButtonsVis();
	}
	,setButtonsVis: function() {
		if(this._pagesCount == 0) {
			this._gotItBtn.visible = true;
			return;
		}
		if(this._currPage == this._pagesCount - 1) {
			this._gotItBtn.visible = true;
			this._nextBtn.visible = false;
		} else {
			this._gotItBtn.visible = false;
			this._nextBtn.visible = true;
		}
	}
	,handleSwipe: function(event) {
		if(event.direction == "left") this.handleNextClick(); else if(event.direction == "right") this.handlePrevClick();
	}
	,handleGotItClick: function() {
		if(this.onGotIt != null) this.onGotIt();
	}
	,addPageMarkers: function() {
		if(this._pagesCount == 0) return;
		this._pageMarkers = new Array();
		var totalWidth = 0;
		this._markersLayer = new createjs.Container();
		var _g1 = 0, _g = this._pagesCount;
		while(_g1 < _g) {
			var currPage = _g1++;
			var pageMarker = this.createPageMarker();
			this._pageMarkers.push(pageMarker);
			if(currPage != 0) {
				pageMarker.x = this._pageMarkers[currPage - 1].x + this._pageMarkers[currPage - 1].spriteSheet._frameWidth + 5;
				totalWidth += 5;
			}
			totalWidth += pageMarker.spriteSheet._frameWidth;
			this._markersLayer.addChild(pageMarker);
		}
		this._markersLayer.y = this._background.image.height * 0.80;
		this._markersLayer.x = this._background.image.width / 2;
		this._markersLayer.regX = totalWidth / 2;
		this.addChild(this._markersLayer);
		this._pageMarkers[0].gotoAndStop("active");
	}
	,addPage: function(pageUri,index) {
		var page = co.doubleduck.BaseAssets.getImage(pageUri);
		page.x += this._background.image.width * index;
		this._contentLayer.addChild(page);
	}
	,goToPage: function(page) {
		this._pageMarkers[this._currPage].gotoAndStop("idle");
		this._currPage = page;
		this._pageMarkers[this._currPage].gotoAndStop("active");
		this._contentLayer.x = -1 * this._background.image.width * this._currPage;
		this.setButtonsVis();
	}
	,changeContentMask: function(topPad,bottomPad,leftPad,rightPad) {
		this._mask.graphics.clear();
		this._mask.graphics.beginFill("#000000");
		this._mask.graphics.drawRect(leftPad,topPad,this._background.image.width - (rightPad + leftPad),this._background.image.height - (bottomPad + topPad));
		this._mask.graphics.endFill();
	}
	,rewindPages: function() {
		this.goToPage(0);
	}
	,enableSwipe: function() {
		co.doubleduck.BaseGame.hammer.onswipe = $bind(this,this.handleSwipe);
	}
	,setMarkersPos: function(percentY,percentX) {
		if(percentX == null) percentX = 0.5;
		this._markersLayer.y = this._background.image.height * percentY;
		this._markersLayer.x = this._background.image.width * percentX;
	}
	,setButtonsPos: function(percentX,percentY) {
		if(percentY == null) percentY = 0.5;
		if(percentX == null) percentX = 0.5;
		if(this._nextBtn != null) {
			this._nextBtn.x = this._background.image.width * percentX;
			this._nextBtn.y = this._background.image.height * percentY;
		}
		this._gotItBtn.x = this._background.image.width * percentX;
		this._gotItBtn.y = this._background.image.height * percentY;
	}
	,_currPage: null
	,_pagesCount: null
	,_gotItBtn: null
	,_nextBtn: null
	,_pageMarkers: null
	,_markersLayer: null
	,_mask: null
	,_contentLayer: null
	,_background: null
	,onGotIt: null
	,__class__: co.doubleduck.PagedHelp
});
co.doubleduck.Persistence = $hxClasses["co.doubleduck.Persistence"] = function() { }
co.doubleduck.Persistence.__name__ = ["co","doubleduck","Persistence"];
co.doubleduck.Persistence.initGameData = function() {
	co.doubleduck.BasePersistence.GAME_PREFIX = "FISHFRED_";
	if(!co.doubleduck.BasePersistence.available) return;
	co.doubleduck.BasePersistence.initVar(co.doubleduck.Persistence.XP,"0");
	co.doubleduck.BasePersistence.initVar(co.doubleduck.Persistence.LAST_LEVEL,"1");
	var _g1 = 0, _g = co.doubleduck.DataLoader.getLevelCount();
	while(_g1 < _g) {
		var i = _g1++;
		co.doubleduck.BasePersistence.initVar(co.doubleduck.Persistence.STAR_PREFIX + (i + 1),"0");
	}
}
co.doubleduck.Persistence.setXp = function(xp) {
	co.doubleduck.BasePersistence.setValue(co.doubleduck.Persistence.XP,xp + "");
}
co.doubleduck.Persistence.getXp = function() {
	return Std.parseInt(co.doubleduck.BasePersistence.getValue(co.doubleduck.Persistence.XP));
}
co.doubleduck.Persistence.setLastLevel = function(level) {
	co.doubleduck.BasePersistence.setValue(co.doubleduck.Persistence.LAST_LEVEL,level + "");
}
co.doubleduck.Persistence.getLastLevel = function() {
	return Std.parseInt(co.doubleduck.BasePersistence.getValue(co.doubleduck.Persistence.LAST_LEVEL));
}
co.doubleduck.Persistence.getStarRating = function(lvl) {
	return Std.parseInt(co.doubleduck.BasePersistence.getValue(co.doubleduck.Persistence.STAR_PREFIX + lvl));
}
co.doubleduck.Persistence.setStarRating = function(lvl,rating) {
	co.doubleduck.BasePersistence.setValue(co.doubleduck.Persistence.STAR_PREFIX + lvl,"" + rating);
}
co.doubleduck.Persistence.__super__ = co.doubleduck.BasePersistence;
co.doubleduck.Persistence.prototype = $extend(co.doubleduck.BasePersistence.prototype,{
	__class__: co.doubleduck.Persistence
});
co.doubleduck.Session = $hxClasses["co.doubleduck.Session"] = function(properties) {
	this.MAX_ANGLE = 35;
	co.doubleduck.BaseSession.call(this);
	this.LEVEL_ID = properties.level;
	co.doubleduck.Session._lastLevelId = this.LEVEL_ID;
	this._hitboxes = new Array();
	this.loadSettings();
	this._powerupCount = 0;
	this._currentPoints = 0;
	this._isDoubleXP = false;
	this._isFiringTnt = false;
	co.doubleduck.GameManager.setSessionRunning(true);
	this.scaleX = this.scaleY = co.doubleduck.BaseGame.getScale();
	this.showLevelGoal();
};
co.doubleduck.Session.__name__ = ["co","doubleduck","Session"];
co.doubleduck.Session.getLastLevelId = function() {
	return co.doubleduck.Session._lastLevelId;
}
co.doubleduck.Session.__super__ = co.doubleduck.BaseSession;
co.doubleduck.Session.prototype = $extend(co.doubleduck.BaseSession.prototype,{
	nextLevel: function() {
		if(this.onRestart != null) this.onRestart({ level : this.LEVEL_ID + 1});
	}
	,retryLevel: function() {
		if(this.onRestart != null) this.onRestart({ level : this.LEVEL_ID});
	}
	,switchToMenu: function() {
		if(this.onBackToMenu != null) this.onBackToMenu();
	}
	,slideElement: function(element,delta) {
		return createjs.Tween.get(element).to({ y : element.y + delta},1100,createjs.Ease.sineInOut);
	}
	,showEndLevelMessage: function() {
		createjs.Tween.get(this._endGame).to({ alpha : 1},500,createjs.Ease.sineIn).call(($_=this._endGame,$bind($_,$_.showScreen)));
	}
	,slideToSomething: function(functionToCall) {
		this._overlay.mouseEnabled = false;
		var delta = co.doubleduck.BaseGame.getScreenSize().height - this._bg3.image.height;
		this.slideElement(this._hook,delta);
		this.slideElement(this._collectableLayer,delta);
		this.slideElement(this._bg2,delta);
		this.slideElement(this._bg3,delta);
		this.slideElement(this._bg4,delta).call(functionToCall);
		createjs.Tween.get(this._hook).to({ alpha : 0},500);
	}
	,slideToRetry: function() {
		this.slideToSomething($bind(this,this.retryLevel));
	}
	,slideToMenu: function() {
		this.slideToSomething($bind(this,this.switchToMenu));
	}
	,slideToEndLevelMessage: function() {
		this.slideToSomething($bind(this,this.showEndLevelMessage));
	}
	,getUnlockedText: function() {
		var unlockText = "";
		if(this.LEVEL_ID + 1 != co.doubleduck.Persistence.getLastLevel()) return "";
		if(this.LEVEL_ID + 1 == js.Boot.__cast(co.doubleduck.DataLoader.getGameplayData().speed_one_unlock.unlock_level , Int)) unlockText = "fast_hook1";
		if(this.LEVEL_ID + 1 == js.Boot.__cast(co.doubleduck.DataLoader.getGameplayData().speed_two_unlock.unlock_level , Int)) unlockText = "fast_hook2";
		if(this.LEVEL_ID + 1 == js.Boot.__cast(co.doubleduck.DataLoader.getGameplayData().short_laser_unlock.unlock_level , Int)) unlockText = "laser_hook1";
		if(this.LEVEL_ID + 1 == js.Boot.__cast(co.doubleduck.DataLoader.getGameplayData().long_laser_unlock.unlock_level , Int)) unlockText = "laser_hook2";
		if(this.LEVEL_ID + 1 == js.Boot.__cast(co.doubleduck.DataLoader.getGameplayData().tnt_one_unlock.unlock_level , Int)) unlockText = "dynamite1";
		if(this.LEVEL_ID + 1 == js.Boot.__cast(co.doubleduck.DataLoader.getGameplayData().tnt_two_unlock.unlock_level , Int)) unlockText = "dynamite2";
		return unlockText;
	}
	,handleGameOver: function() {
		if(co.doubleduck.GameManager.isSessionRunning()) {
			co.doubleduck.GameManager.setSessionRunning(false);
			createjs.Tween.removeTweens(this._hook);
			if(this.LIMIT_TYPE == co.doubleduck.LimitType.Time) this.LIMIT = this._hud.getCurrentTime();
			var levelStars = 0;
			if(this._currentPoints >= this.GOAL) {
				if(this.ONE_STAR - this.LIMIT <= this.THREE_STAR) {
					levelStars = 3;
					null;
				} else if(this.ONE_STAR - this.LIMIT <= this.TWO_STAR) {
					levelStars = 2;
					null;
				} else {
					levelStars = 1;
					null;
				}
				if(co.doubleduck.Persistence.getStarRating(this.LEVEL_ID) < levelStars) co.doubleduck.Persistence.setStarRating(this.LEVEL_ID,levelStars);
				if(co.doubleduck.Persistence.getLastLevel() == this.LEVEL_ID && this.LEVEL_ID < co.doubleduck.DataLoader.getLevelCount()) co.doubleduck.Persistence.setLastLevel(this.LEVEL_ID + 1);
			}
			this._overlay.mouseEnabled = false;
			var unlockedText = "";
			if(levelStars > 0) unlockedText = this.getUnlockedText();
			createjs.Tween.get(this._hud).to({ alpha : 0},500,createjs.Ease.sineIn);
			this._endGame = new co.doubleduck.LevelEndContainer(levelStars > 0,levelStars,unlockedText,this.LEVEL_ID == co.doubleduck.DataLoader.getLevelCount(),this._currentPoints,this.GOAL_TYPE,this.ONE_STAR - this.LIMIT,this.LIMIT_TYPE,this.FISH_ID);
			this._endGame.onRetryClick = $bind(this,this.retryLevel);
			this._endGame.onQuitGame = $bind(this,this.switchToMenu);
			this._endGame.onNextClick = $bind(this,this.nextLevel);
			this._endGame.alpha = 0;
			this.addChild(this._endGame);
			this.slideToEndLevelMessage();
		}
	}
	,showHitboxes: function() {
		var _g1 = 0, _g = this._hitboxes.length;
		while(_g1 < _g) {
			var i = _g1++;
			this._collectableLayer.removeChild(this._hitboxes[i]);
		}
		var _g1 = 0, _g = this._collectables.length;
		while(_g1 < _g) {
			var i = _g1++;
			var debugHitbox;
			var obsRect = this._collectables[i].getFinalHitbox();
			debugHitbox = new createjs.Shape();
			debugHitbox.graphics.beginFill("#FF0000");
			debugHitbox.graphics.drawRect(obsRect.x,obsRect.y,obsRect.width,obsRect.height);
			debugHitbox.graphics.endFill();
			debugHitbox.alpha = 0.4;
			this._hitboxes.push(debugHitbox);
			this._collectableLayer.addChild(debugHitbox);
		}
	}
	,timeLimitReached: function() {
		co.doubleduck.GameManager.setSessionRunning(false);
		createjs.Tween.removeTweens(this._hook);
		this._overlay.mouseEnabled = false;
		createjs.Tween.get(this._hud).to({ alpha : 0},500,createjs.Ease.sineIn);
		this._endGame = new co.doubleduck.LevelEndContainer(false,0,"",false,0,null,0,this.LIMIT_TYPE,0);
		this._endGame.onRetryClick = $bind(this,this.retryLevel);
		this._endGame.onQuitGame = $bind(this,this.switchToMenu);
		this._endGame.alpha = 0;
		this.addChild(this._endGame);
		this.slideToEndLevelMessage();
	}
	,turnBadToGood: function() {
		var _g1 = 0, _g = this._collectables.length;
		while(_g1 < _g) {
			var i = _g1++;
			if(this._collectables[i].getType() == co.doubleduck.CollectableType.Bad) {
				var collectableData = this._fishProbabilityArray[Std.random(this._fishProbabilityArray.length)];
				this._collectables[i].changeCollectable(collectableData.xp,collectableData.speed_multiplier,collectableData.name);
			}
		}
	}
	,handleSwimOut: function(swamOutCollectable) {
		switch( (swamOutCollectable.getType())[1] ) {
		case 2:
			this._powerupCount--;
			break;
		case 3:
			this._powerupCount--;
			break;
		case 4:
			this._powerupCount--;
			break;
		case 0:
			this._goodCollectablesCount--;
			break;
		case 1:
			this._badCollectablesCount--;
			break;
		default:
		}
		HxOverrides.remove(this._collectables,swamOutCollectable);
		this._collectableLayer.removeChild(swamOutCollectable);
		swamOutCollectable = null;
	}
	,handleCollect: function(collectedType,fishId) {
		switch( (collectedType)[1] ) {
		case 2:
			this._hud.addTime(js.Boot.__cast(co.doubleduck.DataLoader.getGameplayData().time_powerup.value , Int));
			this._powerupCount--;
			break;
		case 3:
			this._isDoubleXP = true;
			this._powerupCount--;
			break;
		case 4:
			this.turnBadToGood();
			this._powerupCount--;
			break;
		case 0:
			this._goodCollectablesCount--;
			if(fishId == this.FISH_ID) this._currentPoints++;
			break;
		case 1:
			this._badCollectablesCount--;
			break;
		default:
		}
	}
	,addCollectable: function(isGood,swimIn) {
		if(swimIn == null) swimIn = false;
		var newCollectable;
		if(this._unlockedPowerups.length > 0 && this._powerupCount < this.MAX_POWERUPS && Math.random() < this.POWERUP_CHANCE) {
			var collectableData = this._unlockedPowerups[Std.random(this._unlockedPowerups.length)];
			newCollectable = new co.doubleduck.Collectable(collectableData.type,0,collectableData.xp,collectableData.speed_multiplier,collectableData.name,isGood,this.SWIM_SPEED * collectableData.swim_speed_multiplier,this.WAIT_TIME);
			newCollectable.onCollect = $bind(this,this.handleCollect);
			newCollectable.onSwimOut = $bind(this,this.handleSwimOut);
		} else if(isGood) {
			var collectableData = this._fishProbabilityArray[Std.random(this._fishProbabilityArray.length)];
			newCollectable = new co.doubleduck.Collectable(co.doubleduck.CollectableType.Good,collectableData.id,collectableData.xp,collectableData.speed_multiplier,collectableData.name,isGood,this.SWIM_SPEED * collectableData.swim_speed_multiplier,this.WAIT_TIME,0,collectableData.expand_interval);
			newCollectable.onCollect = $bind(this,this.handleCollect);
			newCollectable.onSwimOut = $bind(this,this.handleSwimOut);
		} else {
			var collectableData = this._badProbabilityArray[Std.random(this._badProbabilityArray.length)];
			newCollectable = new co.doubleduck.Collectable(co.doubleduck.CollectableType.Bad,0,collectableData.xp,collectableData.speed_multiplier,collectableData.name,isGood,this.SWIM_SPEED * collectableData.swim_speed_multiplier,this.WAIT_TIME,30);
			newCollectable.onCollect = $bind(this,this.handleCollect);
			newCollectable.onSwimOut = $bind(this,this.handleSwimOut);
		}
		var replace = 5;
		while(replace > 0) {
			newCollectable.x = Std.random(Math.floor(co.doubleduck.BaseGame.getScreenSize().width * 0.8)) + co.doubleduck.BaseGame.getScreenSize().width * 0.1;
			newCollectable.y = Std.random(Math.floor(co.doubleduck.BaseGame.getScreenSize().height - js.Boot.__cast(co.doubleduck.DataLoader.getGameplayData().spawn_top_height , Int) - js.Boot.__cast(co.doubleduck.DataLoader.getGameplayData().spawn_bottom_margin , Int))) + js.Boot.__cast(co.doubleduck.DataLoader.getGameplayData().spawn_top_height , Int);
			var overlap = false;
			var _g = 0, _g1 = this._collectables;
			while(_g < _g1.length) {
				var collectable = _g1[_g];
				++_g;
				var collectableHitbox = collectable.getHitbox();
				var globalPoint = this._collectableLayer.localToGlobal(collectableHitbox.x,collectableHitbox.y);
				collectableHitbox.x = globalPoint.x;
				collectableHitbox.y = globalPoint.y;
				if(co.doubleduck.Utils.rectOverlap(newCollectable.getFinalHitbox(),collectable.getFinalHitbox())) overlap = true;
			}
			if(overlap) {
				replace--;
				if(replace == 0) return;
			} else replace = 0;
		}
		switch(newCollectable.getType()) {
		case co.doubleduck.CollectableType.Good:
			this._goodCollectablesCount++;
			break;
		case co.doubleduck.CollectableType.Bad:
			this._badCollectablesCount++;
			break;
		default:
			this._powerupCount++;
		}
		this._collectables.push(newCollectable);
		if(!swimIn) {
			this._collectableLayer.addChild(newCollectable);
			newCollectable.floatInWater();
		} else {
			newCollectable.swimIn();
			this._collectableLayer.addChild(newCollectable);
		}
	}
	,spawnCollectableIfNeeded: function() {
		var now = createjs.Ticker.getTime(true);
		if(now >= this._nextCollectableSpawnCheck) {
			if(this._goodCollectablesCount < this.MIN_GOOD_COLLECTABLES) this.addCollectable(true,true); else if(this._badCollectablesCount < this.MIN_BAD_COLLECTABLES) this.addCollectable(false,true);
			this._nextCollectableSpawnCheck = now + this._spawnCheckRatio * 1000;
		}
	}
	,handleFinishedRetracting: function() {
		this._isRetracting = false;
		if(this._hookSwingDirection > 0) {
			var percentLeft = 1 - (this._hook.rotation - this.MAX_ANGLE) / (-this.MAX_ANGLE * 2);
			if(percentLeft < 0.1) createjs.Tween.get(this._hook).to({ rotation : -this.MAX_ANGLE},this._rotationSpeed * percentLeft,createjs.Ease.sineOut).call($bind(this,this.swingHookLeft)); else createjs.Tween.get(this._hook).to({ rotation : -this.MAX_ANGLE * 0.9},this._rotationSpeed * percentLeft * 0.9).to({ rotation : -this.MAX_ANGLE},this._rotationSpeed * 0.1,createjs.Ease.sineOut).call($bind(this,this.swingHookLeft));
		} else {
			var percentLeft = 1 - (this._hook.rotation + this.MAX_ANGLE) / (this.MAX_ANGLE * 2);
			if(percentLeft < 0.1) createjs.Tween.get(this._hook).to({ rotation : this.MAX_ANGLE},this._rotationSpeed * percentLeft,createjs.Ease.sineOut).call($bind(this,this.swingHookRight)); else createjs.Tween.get(this._hook).to({ rotation : this.MAX_ANGLE * 0.9},this._rotationSpeed * percentLeft * 0.9).to({ rotation : this.MAX_ANGLE},this._rotationSpeed * 0.1,createjs.Ease.sineOut).call($bind(this,this.swingHookRight));
		}
		if(this._isPulling && !this._isFiringTnt) {
			if(this.GOAL_TYPE == co.doubleduck.GoalType.Points) {
				var additionalPoints;
				if(this._isDoubleXP) {
					additionalPoints = this._pulledCollectable.getXP() * Math.floor(co.doubleduck.DataLoader.getGameplayData().xp_powerup.value);
					this._isDoubleXP = false;
				} else additionalPoints = this._pulledCollectable.getXP();
				this._currentPoints = js.Boot.__cast(Math.max(0,this._currentPoints + additionalPoints) , Int);
			}
			this._pulledCollectable.collect();
			this._hud.updateGoalScore(this._currentPoints);
			HxOverrides.remove(this._collectables,this._pulledCollectable);
			this._pulledCollectable = null;
		}
		this._isPulling = false;
		this._isFiringTnt = false;
		if(this.LIMIT_TYPE == co.doubleduck.LimitType.Moves && this.LIMIT == 0 || this._currentPoints >= this.GOAL) this.handleGameOver();
	}
	,handleStartedRectracting: function() {
		this._isExtending = false;
		this._isRetracting = true;
	}
	,handleClick: function() {
		if(!this._isExtending && !this._isRetracting) {
			this._isExtending = true;
			createjs.Tween.removeTweens(this._hook);
			this._hook.startExtending();
			if(this.LIMIT_TYPE == co.doubleduck.LimitType.Moves) {
				this.LIMIT--;
				this._hud.updateMovesLeft(this.LIMIT);
			}
		} else if(this._isPulling && !this._isFiringTnt && this._tntAvailable > 0) {
			this._isFiringTnt = true;
			this._hook.fireTnt();
			this._hud.decreaseTnt();
			this._tntAvailable--;
			if(this.LIMIT_TYPE == co.doubleduck.LimitType.Moves) {
				this.LIMIT++;
				this._hud.updateMovesLeft(this.LIMIT);
			}
		}
	}
	,debugHook: function() {
		if(this._hookHitbox != null) this.removeChild(this._hookHitbox);
		var hitbox = this._hook.getHookHitbox();
		var localPoint = this.globalToLocal(hitbox.x,hitbox.y);
		hitbox.x = hitbox.x;
		hitbox.y = hitbox.y;
		this._hookHitbox = new createjs.Shape();
		this._hookHitbox.graphics.beginFill("#FF0000");
		this._hookHitbox.graphics.drawRect(hitbox.x,hitbox.y,hitbox.width,hitbox.height);
		this._hookHitbox.graphics.endFill();
		this._hookHitbox.alpha = 0.5;
		this.addChild(this._hookHitbox);
	}
	,handleTick: function(elapsed) {
		if(!this._isRetracting) {
			var hookHitbox = this._hook.getHookHitbox();
			if(co.doubleduck.Utils.rectOverlap(hookHitbox,this._leftBorder) || co.doubleduck.Utils.rectOverlap(hookHitbox,this._rightBorder) || co.doubleduck.Utils.rectOverlap(hookHitbox,this._bottomBorder)) this._hook.startRetract(); else {
				var _g1 = 0, _g = this._collectables.length;
				while(_g1 < _g) {
					var i = _g1++;
					var collectableHitbox = this._collectables[i].getHitbox();
					if(co.doubleduck.Utils.rectOverlap(hookHitbox,collectableHitbox)) {
						if(this._collectables[i].isCollectable()) {
							this._isPulling = true;
							this._pulledCollectable = this._collectables[i];
							createjs.Tween.removeTweens(this._pulledCollectable);
							var globalPoint = this._collectableLayer.localToGlobal(this._pulledCollectable.x,this._pulledCollectable.y);
							this._pulledCollectable.x = globalPoint.x;
							this._pulledCollectable.y = globalPoint.y;
							this._hook.addHookedCollectable(this._pulledCollectable);
							this._collectableLayer.removeChild(this._pulledCollectable);
						}
						this._hook.startRetract();
						break;
					}
				}
			}
		}
		this.spawnCollectableIfNeeded();
	}
	,swingHookRight: function() {
		if(co.doubleduck.GameManager.isSessionRunning()) {
			this._hookSwingDirection = 1;
			createjs.Tween.get(this._hook).to({ rotation : this.MAX_ANGLE * 0.9},this._rotationSpeed * 0.1,createjs.Ease.sineIn).to({ rotation : -this.MAX_ANGLE * 0.9},this._rotationSpeed * 0.9).to({ rotation : -this.MAX_ANGLE},this._rotationSpeed * 0.1,createjs.Ease.sineOut).call($bind(this,this.swingHookLeft));
		}
	}
	,swingHookLeft: function() {
		if(co.doubleduck.GameManager.isSessionRunning()) {
			this._hookSwingDirection = -1;
			createjs.Tween.get(this._hook).to({ rotation : -this.MAX_ANGLE * 0.9},this._rotationSpeed * 0.1,createjs.Ease.sineIn).to({ rotation : this.MAX_ANGLE * 0.9},this._rotationSpeed * 0.9).to({ rotation : this.MAX_ANGLE},this._rotationSpeed * 0.1,createjs.Ease.sineOut).call($bind(this,this.swingHookRight));
		}
	}
	,debugBorders: function(border) {
		var _border = new createjs.Shape();
		_border.graphics.beginFill("#FF0000");
		_border.graphics.drawRect(border.x,border.y,border.width,border.height);
		_border.graphics.endFill();
		_border.alpha = 0.5;
		this.addChild(_border);
	}
	,loadSettings: function() {
		var settings = co.doubleduck.DataLoader.getSettingsByLevel(this.LEVEL_ID);
		this.MIN_GOOD_COLLECTABLES = js.Boot.__cast(settings.min_fish , Int);
		this.MIN_BAD_COLLECTABLES = js.Boot.__cast(settings.min_bad , Int);
		this.MAX_POWERUPS = js.Boot.__cast(settings.max_powerups , Int);
		this.POWERUP_CHANCE = js.Boot.__cast(settings.powerup_chance , Float);
		this.BG_URI = settings.background;
		this._spawnCheckRatio = js.Boot.__cast(settings.spawn_check_ratio , Float);
		this._rotationSpeed = js.Boot.__cast(co.doubleduck.DataLoader.getGameplayData().swing_speed , Int);
		this.HOOK_MIN_LENGTH = js.Boot.__cast(co.doubleduck.DataLoader.getGameplayData().line_length , Int);
		this.WAIT_TIME = js.Boot.__cast(settings.wait_time , Float);
		this.SWIM_SPEED = js.Boot.__cast(settings.swim_speed , Float);
		this.GOAL = js.Boot.__cast(settings.goal , Int);
		this.ONE_STAR = js.Boot.__cast(settings.one_star , Int);
		this.TWO_STAR = js.Boot.__cast(settings.two_star , Int);
		this.THREE_STAR = js.Boot.__cast(settings.three_star , Int);
		this.LIMIT = this.ONE_STAR;
		var latestLevel = co.doubleduck.Persistence.getLastLevel();
		this._hookExtendSpeed = js.Boot.__cast(co.doubleduck.DataLoader.getGameplayData().hook_speed , Float);
		if(latestLevel >= js.Boot.__cast(co.doubleduck.DataLoader.getGameplayData().speed_one_unlock.unlock_level , Int)) {
			this._hookExtendSpeed = js.Boot.__cast(co.doubleduck.DataLoader.getGameplayData().speed_one_unlock.speed , Float);
			if(latestLevel >= js.Boot.__cast(co.doubleduck.DataLoader.getGameplayData().speed_two_unlock.unlock_level , Int)) this._hookExtendSpeed = js.Boot.__cast(co.doubleduck.DataLoader.getGameplayData().speed_two_unlock.speed , Float);
		}
		this._laserType = co.doubleduck.LaserType.None;
		if(latestLevel >= js.Boot.__cast(co.doubleduck.DataLoader.getGameplayData().short_laser_unlock.unlock_level , Int)) {
			this._laserType = co.doubleduck.LaserType.ShortLaser;
			if(latestLevel >= js.Boot.__cast(co.doubleduck.DataLoader.getGameplayData().long_laser_unlock.unlock_level , Int)) this._laserType = co.doubleduck.LaserType.LongLaser;
		}
		if(latestLevel >= js.Boot.__cast(co.doubleduck.DataLoader.getGameplayData().tnt_one_unlock.unlock_level , Int)) {
			this._tntAvailable = js.Boot.__cast(co.doubleduck.DataLoader.getGameplayData().tnt_one_unlock.amount , Int);
			if(latestLevel >= js.Boot.__cast(co.doubleduck.DataLoader.getGameplayData().tnt_two_unlock.unlock_level , Int)) this._tntAvailable = js.Boot.__cast(co.doubleduck.DataLoader.getGameplayData().tnt_two_unlock.amount , Int);
		}
		if(settings.goal_type == "points") {
			this.GOAL_TYPE = co.doubleduck.GoalType.Points;
			this.FISH_ID = -1;
		} else {
			this.GOAL_TYPE = co.doubleduck.GoalType.Fish;
			this.FISH_ID = settings.fish_id;
		}
		if(settings.limit_type == "time") this.LIMIT_TYPE = co.doubleduck.LimitType.Time; else this.LIMIT_TYPE = co.doubleduck.LimitType.Moves;
		this._unlockedPowerups = new Array();
		var powerUp = co.doubleduck.DataLoader.getGameplayData().xp_powerup;
		powerUp.type = co.doubleduck.CollectableType.XP;
		var _g1 = 0, _g = settings.powerup_probability[0];
		while(_g1 < _g) {
			var i = _g1++;
			this._unlockedPowerups.push(powerUp);
		}
		var powerUp1 = co.doubleduck.DataLoader.getGameplayData().time_powerup;
		powerUp1.type = co.doubleduck.CollectableType.Time;
		var _g1 = 0, _g = settings.powerup_probability[1];
		while(_g1 < _g) {
			var i = _g1++;
			this._unlockedPowerups.push(powerUp1);
		}
		var powerUp2 = co.doubleduck.DataLoader.getGameplayData().turn_good_powerup;
		powerUp2.type = co.doubleduck.CollectableType.TurnGood;
		var _g1 = 0, _g = settings.powerup_probability[2];
		while(_g1 < _g) {
			var i = _g1++;
			this._unlockedPowerups.push(powerUp2);
		}
		this._fishProbabilityArray = new Array();
		var _g1 = 0, _g = settings.fish_probability.length;
		while(_g1 < _g) {
			var i = _g1++;
			var collectableData = co.doubleduck.DataLoader.getGameplayData().good_collectables[i];
			var _g3 = 0, _g2 = settings.fish_probability[i];
			while(_g3 < _g2) {
				var j = _g3++;
				this._fishProbabilityArray.push(collectableData);
			}
		}
		this._badProbabilityArray = new Array();
		var _g1 = 0, _g = settings.bad_probability.length;
		while(_g1 < _g) {
			var i = _g1++;
			var collectableData = co.doubleduck.DataLoader.getGameplayData().bad_collectables[i];
			var _g3 = 0, _g2 = settings.bad_probability[i];
			while(_g3 < _g2) {
				var j = _g3++;
				this._badProbabilityArray.push(collectableData);
			}
		}
	}
	,startTimings: function() {
		createjs.Tween.get(this._hud).to({ alpha : 1},300,createjs.Ease.sineIn);
		this._overlay.onPress = $bind(this,this.handleClick);
		this._nextCollectableSpawnCheck = createjs.Ticker.getTime(true) + this._spawnCheckRatio * 1000;
		this.onTick = $bind(this,this.handleTick);
		this.swingHookLeft();
	}
	,initLevel: function() {
		this._collectables = new Array();
		this._collectableLayer = new createjs.Container();
		this._leftBorder = new createjs.Rectangle(-50,0,50,co.doubleduck.BaseGame.getScreenSize().height);
		this._rightBorder = new createjs.Rectangle(co.doubleduck.BaseGame.getScreenSize().width,0,50,co.doubleduck.BaseGame.getScreenSize().height);
		this._bottomBorder = new createjs.Rectangle(0,co.doubleduck.BaseGame.getScreenSize().height,co.doubleduck.BaseGame.getScreenSize().width,50);
		this._bg4 = co.doubleduck.Utils.getCenteredImage("images/general/bg4.jpg",false);
		this._bg4.regY = 0;
		this._bg4.x = this._bg2.x;
		this._bg4.y = this._bg3.y - 1;
		this.addChild(this._bg4);
		this._hook = new co.doubleduck.Hook(this._hookExtendSpeed,this._laserType);
		this._hook.x = co.doubleduck.BaseGame.getScreenSize().width / 2;
		this._hook.onStartedRetracting = $bind(this,this.handleStartedRectracting);
		this._hook.onFinishedRetracting = $bind(this,this.handleFinishedRetracting);
		this._hook.onDestoryedCollectable = $bind(this,this.handleSwimOut);
		this._hook.rotation = -this.MAX_ANGLE;
		this._hook.y = 105;
		this._hook.alpha = 0;
		this.addChild(this._hook);
		this.addChild(this._collectableLayer);
		this._overlay = new createjs.Shape();
		this._overlay.graphics.beginFill("#000000");
		this._overlay.graphics.drawRect(0,0,co.doubleduck.BaseGame.getScreenSize().width,co.doubleduck.BaseGame.getScreenSize().height);
		this._overlay.graphics.endFill();
		this._overlay.alpha = 0.01;
		this._overlay.mouseEnabled = true;
		this.addChild(this._overlay);
		this._hud = new co.doubleduck.Hud(this.LIMIT_TYPE,this.LIMIT,this.GOAL,this.FISH_ID,this._tntAvailable);
		this._hud.updateGoalScore(0);
		this._hud.onTimeLimitReached = $bind(this,this.timeLimitReached);
		this._hud.onQuitGame = $bind(this,this.slideToMenu);
		this._hud.onRetryClick = $bind(this,this.slideToRetry);
		this._hud.alpha = 0;
		this.addChild(this._hud);
		var delta = this._bg3.image.height - co.doubleduck.BaseGame.getScreenSize().height;
		this._hook.y -= delta;
		this.slideElement(this._hook,delta);
		this._collectableLayer.y -= delta;
		this.slideElement(this._collectableLayer,delta);
		this.slideElement(this._bg2,delta);
		this.slideElement(this._bg3,delta);
		this.slideElement(this._bg4,delta).call($bind(this,this.startTimings));
		createjs.Tween.get(this._hook).to({ alpha : 1},500);
	}
	,handleGoClick: function() {
		createjs.Tween.get(this._goals).to({ alpha : 0},500,createjs.Ease.sineOut).call($bind(this,this.initLevel));
	}
	,showLevelGoal: function() {
		this._bg2 = co.doubleduck.Utils.getCenteredImage("images/general/bg2.jpg",false);
		this._bg2.regY = this._bg2.image.height;
		this._bg2.x = co.doubleduck.BaseGame.getScreenSize().width / 2;
		this.addChild(this._bg2);
		this._bg3 = co.doubleduck.Utils.getCenteredImage("images/general/bg3.jpg",false);
		this._bg3.regY = this._bg3.image.height;
		this._bg3.x = this._bg2.x;
		this._bg3.y = co.doubleduck.BaseGame.getScreenSize().height;
		this._bg2.y = this._bg3.y - this._bg3.image.height + 1;
		this.addChild(this._bg3);
		this._goals = new co.doubleduck.GoalContainer(this.GOAL,this.GOAL_TYPE,this.LIMIT,this.LIMIT_TYPE,this.FISH_ID);
		this._goals.onGo = $bind(this,this.handleGoClick);
		this._goals.alpha = 0;
		this.addChild(this._goals);
		createjs.Tween.get(this._goals).to({ alpha : 1},500,createjs.Ease.sineIn);
	}
	,_hitboxes: null
	,_hookHitbox: null
	,_badProbabilityArray: null
	,_fishProbabilityArray: null
	,_unlockedPowerups: null
	,_isDoubleXP: null
	,_spawnCheckRatio: null
	,_nextCollectableSpawnCheck: null
	,_powerupCount: null
	,_badCollectablesCount: null
	,_goodCollectablesCount: null
	,_collectables: null
	,_collectableLayer: null
	,_tntAvailable: null
	,_pulledCollectable: null
	,_isFiringTnt: null
	,_isPulling: null
	,_isRetracting: null
	,_isExtending: null
	,_rotationSpeed: null
	,_angle: null
	,_laserType: null
	,_hookExtendSpeed: null
	,_hookSwingDirection: null
	,_hook: null
	,_currentPoints: null
	,_bottomBorder: null
	,_rightBorder: null
	,_leftBorder: null
	,_endGame: null
	,_goals: null
	,_hud: null
	,_overlay: null
	,_bg4: null
	,_bg3: null
	,_bg2: null
	,LEVEL_ID: null
	,THREE_STAR: null
	,TWO_STAR: null
	,ONE_STAR: null
	,FISH_ID: null
	,LIMIT: null
	,GOAL: null
	,LIMIT_TYPE: null
	,GOAL_TYPE: null
	,BG_URI: null
	,SWIM_SPEED: null
	,WAIT_TIME: null
	,POWERUP_CHANCE: null
	,MAX_POWERUPS: null
	,MIN_BAD_COLLECTABLES: null
	,MIN_GOOD_COLLECTABLES: null
	,MAX_ANGLE: null
	,HOOK_MIN_LENGTH: null
	,__class__: co.doubleduck.Session
});
co.doubleduck.SoundType = $hxClasses["co.doubleduck.SoundType"] = { __ename__ : ["co","doubleduck","SoundType"], __constructs__ : ["WEB_AUDIO","AUDIO_FX","AUDIO_NO_OVERLAP","HOWLER","NONE"] }
co.doubleduck.SoundType.WEB_AUDIO = ["WEB_AUDIO",0];
co.doubleduck.SoundType.WEB_AUDIO.toString = $estr;
co.doubleduck.SoundType.WEB_AUDIO.__enum__ = co.doubleduck.SoundType;
co.doubleduck.SoundType.AUDIO_FX = ["AUDIO_FX",1];
co.doubleduck.SoundType.AUDIO_FX.toString = $estr;
co.doubleduck.SoundType.AUDIO_FX.__enum__ = co.doubleduck.SoundType;
co.doubleduck.SoundType.AUDIO_NO_OVERLAP = ["AUDIO_NO_OVERLAP",2];
co.doubleduck.SoundType.AUDIO_NO_OVERLAP.toString = $estr;
co.doubleduck.SoundType.AUDIO_NO_OVERLAP.__enum__ = co.doubleduck.SoundType;
co.doubleduck.SoundType.HOWLER = ["HOWLER",3];
co.doubleduck.SoundType.HOWLER.toString = $estr;
co.doubleduck.SoundType.HOWLER.__enum__ = co.doubleduck.SoundType;
co.doubleduck.SoundType.NONE = ["NONE",4];
co.doubleduck.SoundType.NONE.toString = $estr;
co.doubleduck.SoundType.NONE.__enum__ = co.doubleduck.SoundType;
if(!co.doubleduck.audio) co.doubleduck.audio = {}
co.doubleduck.audio.AudioAPI = $hxClasses["co.doubleduck.audio.AudioAPI"] = function() { }
co.doubleduck.audio.AudioAPI.__name__ = ["co","doubleduck","audio","AudioAPI"];
co.doubleduck.audio.AudioAPI.prototype = {
	setVolume: null
	,pause: null
	,stop: null
	,playMusic: null
	,playEffect: null
	,init: null
	,__class__: co.doubleduck.audio.AudioAPI
}
co.doubleduck.audio.WebAudioAPI = $hxClasses["co.doubleduck.audio.WebAudioAPI"] = function(src) {
	this._src = src;
	this.loadAudioFile(this._src);
};
co.doubleduck.audio.WebAudioAPI.__name__ = ["co","doubleduck","audio","WebAudioAPI"];
co.doubleduck.audio.WebAudioAPI.__interfaces__ = [co.doubleduck.audio.AudioAPI];
co.doubleduck.audio.WebAudioAPI.context = null;
co.doubleduck.audio.WebAudioAPI.webAudioInit = function() {
	co.doubleduck.audio.WebAudioAPI.context = new webkitAudioContext();
}
co.doubleduck.audio.WebAudioAPI.saveBuffer = function(buffer,name) {
	co.doubleduck.audio.WebAudioAPI._buffers[name] = buffer;
}
co.doubleduck.audio.WebAudioAPI.decodeError = function() {
	null;
}
co.doubleduck.audio.WebAudioAPI.prototype = {
	setVolume: function(volume) {
		if(this._gainNode != null) this._gainNode.gain.value = volume;
	}
	,pause: function() {
	}
	,stop: function(fadeOut) {
		if(fadeOut == null) fadeOut = 0;
		if(this._source != null) this._source.noteOff(0);
	}
	,playMusic: function(volume,loop,fadeIn) {
		if(fadeIn == null) fadeIn = 0;
		if(loop == null) loop = true;
		if(volume == null) volume = 1;
		this.playBuffer(this._src,loop);
		this.setVolume(volume);
	}
	,playEffect: function(volume,overrideOtherEffects,loop,fadeIn) {
		if(fadeIn == null) fadeIn = 0;
		if(loop == null) loop = false;
		if(overrideOtherEffects == null) overrideOtherEffects = true;
		if(volume == null) volume = 1;
		this.playBuffer(this._src,loop);
		this.setVolume(volume);
	}
	,playBuffer: function(name,loop) {
		if(loop == null) loop = false;
		if(this._gainNode == null) {
			this._gainNode = co.doubleduck.audio.WebAudioAPI.context.createGainNode();
			this._gainNode.connect(co.doubleduck.audio.WebAudioAPI.context.destination);
		}
		this._buffer = Reflect.getProperty(co.doubleduck.audio.WebAudioAPI._buffers,this._src);
		if(this._buffer == null) return;
		this._source = co.doubleduck.audio.WebAudioAPI.context.createBufferSource();
		this._source.buffer = this._buffer;
		this._source.loop = loop;
		this._source.connect(this._gainNode);
		this._source.noteOn(0);
	}
	,loadAudioFile: function(src) {
		var request = new XMLHttpRequest();
		request.open("get",src,true);
		request.responseType = "arraybuffer";
		request.onload = function() { co.doubleduck.audio.WebAudioAPI.context.decodeAudioData(request.response, function(decodedBuffer) { buffer = decodedBuffer; co.doubleduck.audio.WebAudioAPI.saveBuffer(buffer,src); }, co.doubleduck.audio.WebAudioAPI.decodeError) }
		request.send();
	}
	,init: function() {
	}
	,_source: null
	,_gainNode: null
	,_buffer: null
	,_src: null
	,__class__: co.doubleduck.audio.WebAudioAPI
}
co.doubleduck.SoundManager = $hxClasses["co.doubleduck.SoundManager"] = function() {
};
co.doubleduck.SoundManager.__name__ = ["co","doubleduck","SoundManager"];
co.doubleduck.SoundManager.engineType = null;
co.doubleduck.SoundManager.EXTENSION = null;
co.doubleduck.SoundManager.getPersistedMute = function() {
	var mute = co.doubleduck.BasePersistence.getValue("mute");
	if(mute == "0") {
		mute = "false";
		co.doubleduck.SoundManager.setPersistedMute(false);
	}
	return mute == "true";
}
co.doubleduck.SoundManager.setPersistedMute = function(mute) {
	var val = "true";
	if(!mute) val = "false";
	co.doubleduck.BasePersistence.setValue("mute",val);
}
co.doubleduck.SoundManager.isSoundAvailable = function() {
	var isFirefox = /Firefox/.test(navigator.userAgent);
	var isChrome = /Chrome/.test(navigator.userAgent);
	var isMobile = /Mobile/.test(navigator.userAgent);
	var isAndroid = /Android/.test(navigator.userAgent);
	var isAndroid4 = /Android 4/.test(navigator.userAgent);
	var isSafari = /Safari/.test(navigator.userAgent);
	var agent = navigator.userAgent;
	var reg = new EReg("iPhone OS 6","");
	var isIOS6 = reg.match(agent) && isSafari && isMobile;
	var isIpad = /iPad/.test(navigator.userAgent);
	isIpad = isIpad && /OS 6/.test(navigator.userAgent);
	isIOS6 = isIOS6 || isIpad;
	if(isFirefox) {
		co.doubleduck.SoundManager.engineType = co.doubleduck.SoundType.AUDIO_FX;
		co.doubleduck.SoundManager.EXTENSION = ".ogg";
		return true;
	}
	if(isChrome && (!isAndroid && !isMobile)) {
		co.doubleduck.SoundManager.engineType = co.doubleduck.SoundType.WEB_AUDIO;
		co.doubleduck.audio.WebAudioAPI.webAudioInit();
		co.doubleduck.SoundManager.EXTENSION = ".ogg";
		return true;
	}
	co.doubleduck.SoundManager.engineType = co.doubleduck.SoundType.NONE;
	co.doubleduck.BasePersistence.initVar("mute");
	return false;
}
co.doubleduck.SoundManager.mute = function(persisted) {
	if(persisted == null) persisted = true;
	if(!co.doubleduck.SoundManager.available) return;
	co.doubleduck.SoundManager._muted = true;
	var _g1 = 0, _g = Reflect.fields(co.doubleduck.SoundManager._cache).length;
	while(_g1 < _g) {
		var currSound = _g1++;
		var mySound = Reflect.getProperty(co.doubleduck.SoundManager._cache,Reflect.fields(co.doubleduck.SoundManager._cache)[currSound]);
		if(mySound != null) mySound.setVolume(0);
	}
	if(persisted) co.doubleduck.SoundManager.setPersistedMute(co.doubleduck.SoundManager._muted);
}
co.doubleduck.SoundManager.unmute = function(persisted) {
	if(persisted == null) persisted = true;
	if(!co.doubleduck.SoundManager.available) return;
	co.doubleduck.SoundManager._muted = false;
	try {
		var _g1 = 0, _g = Reflect.fields(co.doubleduck.SoundManager._cache).length;
		while(_g1 < _g) {
			var currSound = _g1++;
			var mySound = Reflect.getProperty(co.doubleduck.SoundManager._cache,Reflect.fields(co.doubleduck.SoundManager._cache)[currSound]);
			if(mySound != null) mySound.setVolume(1);
		}
	} catch( e ) {
		null;
	}
	if(persisted) co.doubleduck.SoundManager.setPersistedMute(co.doubleduck.SoundManager._muted);
}
co.doubleduck.SoundManager.toggleMute = function() {
	if(co.doubleduck.SoundManager._muted) co.doubleduck.SoundManager.unmute(); else co.doubleduck.SoundManager.mute();
}
co.doubleduck.SoundManager.isMuted = function() {
	co.doubleduck.SoundManager._muted = co.doubleduck.SoundManager.getPersistedMute();
	return co.doubleduck.SoundManager._muted;
}
co.doubleduck.SoundManager.getAudioInstance = function(src) {
	if(!co.doubleduck.SoundManager.available) return new co.doubleduck.audio.DummyAudioAPI();
	src += co.doubleduck.SoundManager.EXTENSION;
	var audio = Reflect.getProperty(co.doubleduck.SoundManager._cache,src);
	if(audio == null) {
		switch( (co.doubleduck.SoundManager.engineType)[1] ) {
		case 1:
			audio = new co.doubleduck.audio.AudioFX(src);
			break;
		case 0:
			audio = new co.doubleduck.audio.WebAudioAPI(src);
			break;
		case 2:
			audio = new co.doubleduck.audio.NonOverlappingAudio(src);
			break;
		case 3:
			audio = new co.doubleduck.audio.HowlerAudio(src);
			break;
		case 4:
			return new co.doubleduck.audio.DummyAudioAPI();
		}
		Reflect.setProperty(co.doubleduck.SoundManager._cache,src,audio);
	}
	return audio;
}
co.doubleduck.SoundManager.playEffect = function(src,volume,optional) {
	if(optional == null) optional = false;
	if(volume == null) volume = 1;
	if(optional && co.doubleduck.SoundManager.engineType == co.doubleduck.SoundType.AUDIO_NO_OVERLAP) return new co.doubleduck.audio.DummyAudioAPI();
	var audio = co.doubleduck.SoundManager.getAudioInstance(src);
	var playVolume = volume;
	if(co.doubleduck.SoundManager._muted) playVolume = 0;
	audio.playEffect(playVolume);
	return audio;
}
co.doubleduck.SoundManager.playMusic = function(src,volume,loop) {
	if(loop == null) loop = true;
	if(volume == null) volume = 1;
	var audio = co.doubleduck.SoundManager.getAudioInstance(src);
	var playVolume = volume;
	if(co.doubleduck.SoundManager._muted) playVolume = 0;
	audio.playMusic(playVolume,loop);
	return audio;
}
co.doubleduck.SoundManager.initSound = function(src) {
	co.doubleduck.SoundManager.getAudioInstance(src);
}
co.doubleduck.SoundManager.prototype = {
	__class__: co.doubleduck.SoundManager
}
co.doubleduck.Utils = $hxClasses["co.doubleduck.Utils"] = function() { }
co.doubleduck.Utils.__name__ = ["co","doubleduck","Utils"];
co.doubleduck.Utils.dateDeltaInDays = function(day1,day2) {
	var delta = Math.abs(day2.getTime() - day1.getTime());
	return delta / 86400000;
}
co.doubleduck.Utils.getTodayDate = function() {
	var newDate = new Date();
	return HxOverrides.dateStr(newDate);
}
co.doubleduck.Utils.getHour = function() {
	var newDate = new Date();
	return newDate.getHours();
}
co.doubleduck.Utils.rectOverlap = function(r1,r2) {
	var r1TopLeft = new createjs.Point(r1.x,r1.y);
	var r1BottomRight = new createjs.Point(r1.x + r1.width,r1.y + r1.height);
	var r1TopRight = new createjs.Point(r1.x + r1.width,r1.y);
	var r1BottomLeft = new createjs.Point(r1.x,r1.y + r1.height);
	var r2TopLeft = new createjs.Point(r2.x,r2.y);
	var r2BottomRight = new createjs.Point(r2.x + r2.width,r2.y + r2.height);
	var r2TopRight = new createjs.Point(r2.x + r2.width,r2.y);
	var r2BottomLeft = new createjs.Point(r2.x,r2.y + r2.height);
	if(co.doubleduck.Utils.rectContainPoint(r2TopLeft,r2BottomRight,r1TopLeft)) return true;
	if(co.doubleduck.Utils.rectContainPoint(r2TopLeft,r2BottomRight,r1BottomRight)) return true;
	if(co.doubleduck.Utils.rectContainPoint(r2TopLeft,r2BottomRight,r1TopRight)) return true;
	if(co.doubleduck.Utils.rectContainPoint(r2TopLeft,r2BottomRight,r1BottomLeft)) return true;
	if(co.doubleduck.Utils.rectContainPoint(r1TopLeft,r1BottomRight,r2TopLeft)) return true;
	if(co.doubleduck.Utils.rectContainPoint(r1TopLeft,r1BottomRight,r2BottomRight)) return true;
	if(co.doubleduck.Utils.rectContainPoint(r1TopLeft,r1BottomRight,r2TopRight)) return true;
	if(co.doubleduck.Utils.rectContainPoint(r1TopLeft,r1BottomRight,r2BottomLeft)) return true;
	return false;
}
co.doubleduck.Utils.overlap = function(obj1,obj1Width,obj1Height,obj2,obj2Width,obj2Height) {
	var o1TopLeft = new createjs.Point(obj1.x - obj1.regX * co.doubleduck.BaseGame.getScale(),obj1.y - obj1.regY * co.doubleduck.BaseGame.getScale());
	var o1BottomRight = new createjs.Point(o1TopLeft.x - obj1.regX * co.doubleduck.BaseGame.getScale() + obj1Width * co.doubleduck.BaseGame.getScale(),o1TopLeft.y + obj1Height * co.doubleduck.BaseGame.getScale() - obj1.regY * co.doubleduck.BaseGame.getScale());
	var o1TopRight = new createjs.Point(o1BottomRight.x - obj1.regX * co.doubleduck.BaseGame.getScale(),o1TopLeft.y - obj1.regY * co.doubleduck.BaseGame.getScale());
	var o1BottomLeft = new createjs.Point(o1TopLeft.x - obj1.regX * co.doubleduck.BaseGame.getScale(),o1BottomRight.y - obj1.regY * co.doubleduck.BaseGame.getScale());
	var o2TopLeft = new createjs.Point(obj2.x - obj2.regX * co.doubleduck.BaseGame.getScale(),obj2.y - obj2.regY * co.doubleduck.BaseGame.getScale());
	var o2BottomRight = new createjs.Point(o2TopLeft.x + obj2Width * co.doubleduck.BaseGame.getScale() - obj2.regX * co.doubleduck.BaseGame.getScale(),o2TopLeft.y + obj2Height * co.doubleduck.BaseGame.getScale() - obj2.regY * co.doubleduck.BaseGame.getScale());
	var o2TopRight = new createjs.Point(o2BottomRight.x - obj2.regX * co.doubleduck.BaseGame.getScale(),o2TopLeft.y - obj2.regY * co.doubleduck.BaseGame.getScale());
	var o2BottomLeft = new createjs.Point(o2TopLeft.x - obj2.regX * co.doubleduck.BaseGame.getScale(),o2BottomRight.y - obj2.regY * co.doubleduck.BaseGame.getScale());
	if(co.doubleduck.Utils.rectContainPoint(o2TopLeft,o2BottomRight,o1TopLeft)) return true;
	if(co.doubleduck.Utils.rectContainPoint(o2TopLeft,o2BottomRight,o1BottomRight)) return true;
	if(co.doubleduck.Utils.rectContainPoint(o2TopLeft,o2BottomRight,o1TopRight)) return true;
	if(co.doubleduck.Utils.rectContainPoint(o2TopLeft,o2BottomRight,o1BottomLeft)) return true;
	if(co.doubleduck.Utils.rectContainPoint(o1TopLeft,o1BottomRight,o2TopLeft)) return true;
	if(co.doubleduck.Utils.rectContainPoint(o1TopLeft,o1BottomRight,o2BottomRight)) return true;
	if(co.doubleduck.Utils.rectContainPoint(o1TopLeft,o1BottomRight,o2TopRight)) return true;
	if(co.doubleduck.Utils.rectContainPoint(o1TopLeft,o1BottomRight,o2BottomLeft)) return true;
	return false;
}
co.doubleduck.Utils.rectContainPoint = function(rectTopLeft,rectBottomRight,point) {
	return point.x >= rectTopLeft.x && point.x <= rectBottomRight.x && point.y >= rectTopLeft.y && point.y <= rectBottomRight.y;
}
co.doubleduck.Utils.objectContains = function(dyn,memberName) {
	return Reflect.hasField(dyn,memberName);
}
co.doubleduck.Utils.contains = function(arr,obj) {
	var _g = 0;
	while(_g < arr.length) {
		var element = arr[_g];
		++_g;
		if(element == obj) return true;
	}
	return false;
}
co.doubleduck.Utils.isMobileFirefox = function() {
	var isFirefox = /Firefox/.test(navigator.userAgent);
	return isFirefox && viewporter.ACTIVE;
}
co.doubleduck.Utils.get = function(x,y,tiles,columns) {
	return tiles[columns * y + x];
}
co.doubleduck.Utils.getBitmapLabel = function(label,fontType,padding) {
	if(padding == null) padding = 0;
	if(fontType == null) fontType = "";
	var fontHelper = new co.doubleduck.FontHelper(fontType);
	var bitmapText = fontHelper.getNumber(Std.parseInt(label),1,true,null,padding);
	return bitmapText;
}
co.doubleduck.Utils.concatWithoutDuplicates = function(array,otherArray) {
	var _g = 0;
	while(_g < otherArray.length) {
		var element = otherArray[_g];
		++_g;
		co.doubleduck.Utils.addToArrayWithoutDuplicates(array,element);
	}
	return array;
}
co.doubleduck.Utils.addToArrayWithoutDuplicates = function(array,element) {
	var _g = 0;
	while(_g < array.length) {
		var currElement = array[_g];
		++_g;
		if(currElement == element) return array;
	}
	array.push(element);
	return array;
}
co.doubleduck.Utils.getImageData = function(image) {
	var ctx = co.doubleduck.Utils.getCanvasContext();
	var img = co.doubleduck.BaseAssets.getImage(image);
	ctx.drawImage(img.image,0,0);
	return ctx.getImageData(0,0,img.image.width,img.image.height);
}
co.doubleduck.Utils.getCanvasContext = function() {
	var dom = js.Lib.document.createElement("Canvas");
	var canvas = dom;
	return canvas.getContext("2d");
}
co.doubleduck.Utils.joinArrays = function(a1,a2) {
	var arr = a1.slice();
	var _g = 0;
	while(_g < a2.length) {
		var el = a2[_g];
		++_g;
		arr.push(el);
	}
	return arr;
}
co.doubleduck.Utils.getRandomElement = function(arr) {
	return arr[Std.random(arr.length)];
}
co.doubleduck.Utils.splitArray = function(arr,parts) {
	var arrs = new Array();
	var _g = 0;
	while(_g < parts) {
		var p = _g++;
		arrs.push(new Array());
	}
	var currArr = 0;
	while(arr.length > 0) {
		arrs[currArr].push(arr.pop());
		currArr++;
		currArr %= parts;
	}
	return arrs;
}
co.doubleduck.Utils.map = function(value,aMin,aMax,bMin,bMax) {
	if(bMax == null) bMax = 1;
	if(bMin == null) bMin = 0;
	if(value <= aMin) return bMin;
	if(value >= aMax) return bMax;
	return (value - aMin) * (bMax - bMin) / (aMax - aMin) + bMin;
}
co.doubleduck.Utils.waitAndCall = function(parent,delay,func,args) {
	createjs.Tween.get(parent).wait(delay).call(func,args);
}
co.doubleduck.Utils.tintBitmap = function(src,redMultiplier,greenMultiplier,blueMultiplier,alphaMultiplier) {
	var colorFilter = new createjs.ColorFilter(redMultiplier,greenMultiplier,blueMultiplier,alphaMultiplier);
	src.cache(src.x,src.y,src.image.width,src.image.height);
	src.filters = [colorFilter];
	src.updateCache();
}
co.doubleduck.Utils.containBitmaps = function(bitmapList,spacing,isRow,dims) {
	if(isRow == null) isRow = true;
	if(spacing == null) spacing = 0;
	var totalWidth = 0;
	var totalHeight = 0;
	var result = new createjs.Container();
	var _g1 = 0, _g = bitmapList.length;
	while(_g1 < _g) {
		var currBitmap = _g1++;
		var bmp = bitmapList[currBitmap];
		bmp.regY = bmp.image.height / 2;
		if(currBitmap != 0) {
			if(isRow) {
				bmp.x = bitmapList[currBitmap - 1].x + bitmapList[currBitmap - 1].image.width + spacing;
				if(bmp.image.height > totalHeight) totalHeight = bmp.image.height;
				totalWidth += bmp.image.width + spacing;
			} else {
				bmp.y = bitmapList[currBitmap - 1].y + bitmapList[currBitmap - 1].image.height + spacing;
				if(bmp.image.width > totalWidth) totalWidth = bmp.image.width;
				totalHeight += bmp.image.height + spacing;
			}
		} else {
			totalWidth = bmp.image.width;
			totalHeight = bmp.image.height;
		}
		result.addChild(bmp);
	}
	result.regX = totalWidth / 2;
	result.regY = totalHeight / 2;
	if(dims != null) {
		dims.width = totalWidth;
		dims.height = totalHeight;
	}
	return result;
}
co.doubleduck.Utils.getCenteredImage = function(name,scaleToGame) {
	if(scaleToGame == null) scaleToGame = false;
	var img = co.doubleduck.BaseAssets.getImage(name);
	img.regX = img.image.width / 2;
	img.regY = img.image.height / 2;
	if(scaleToGame) img.scaleX = img.scaleY = co.doubleduck.BaseGame.getScale();
	return img;
}
co.doubleduck.Utils.setCenterReg = function(bmp) {
	bmp.regX = bmp.image.width / 2;
	bmp.regY = bmp.image.height / 2;
}
co.doubleduck.Utils.shuffleArray = function(arr) {
	var tmp, j, i = arr.length;
	while(i > 0) {
		j = Math.random() * i | 0;
		tmp = arr[--i];
		arr[i] = arr[j];
		arr[j] = tmp;
	}
}
co.doubleduck.Utils.scaleObject = function(obj) {
	obj.scaleX = obj.scaleY = co.doubleduck.BaseGame.getScale();
}
co.doubleduck.Utils.getRectangle = function(rect,color) {
	var ret = new createjs.Shape();
	ret.graphics.beginFill(color);
	ret.graphics.drawRect(rect.x,rect.y,rect.width,rect.height);
	ret.graphics.endFill();
	return ret;
}
co.doubleduck.Utils.getDistance = function(p1,p2) {
	var distX = p1.x - p2.x;
	var distY = p1.y - p2.y;
	var dist = Math.sqrt(distX * distX + distY * distY);
	return dist;
}
co.doubleduck.Utils.average = function(arr) {
	var sum = 0;
	var _g = 0;
	while(_g < arr.length) {
		var i = arr[_g];
		++_g;
		sum += i;
	}
	return sum / arr.length;
}
co.doubleduck.Utils.radToDeg = function(rad) {
	return rad * 180 / Math.PI;
}
co.doubleduck.Utils.degToRad = function(deg) {
	return deg * Math.PI / 180;
}
co.doubleduck.Utils.sign = function(num) {
	if(num < 0) return -1; else if(num > 0) return 1;
	return 0;
}
co.doubleduck.Utils.loadSpriteSheet = function(imgPath,numberOfFrames,animName,animFrequency,centerReg) {
	if(centerReg == null) centerReg = true;
	if(animFrequency == null) animFrequency = 1;
	var ret;
	var data = { };
	var img = co.doubleduck.BaseAssets.getRawImage(imgPath);
	var numFrames = numberOfFrames;
	var imageHeight = 0;
	var imageWidth = 0;
	if(img.width > img.height) {
		imageWidth = img.width / numFrames;
		imageHeight = img.height;
	} else {
		imageHeight = img.height / numFrames;
		imageWidth = img.width;
	}
	if(centerReg) data.frames = { width : imageWidth, height : imageHeight, regX : imageWidth / 2, regY : imageHeight / 2}; else data.frames = { width : imageWidth, height : imageHeight};
	data.images = [img];
	data.animations = { };
	var framesArr = [];
	var _g = 0;
	while(_g < numFrames) {
		var i = _g++;
		framesArr.push(i);
	}
	data[animName] = { frames : framesArr, frequency : 5};
	ret = new createjs.SpriteSheet(data);
	return ret;
}
co.doubleduck.audio.AudioFX = $hxClasses["co.doubleduck.audio.AudioFX"] = function(src) {
	this._jsAudio = null;
	this._src = src;
	this._loop = false;
	this._volume = 1;
};
co.doubleduck.audio.AudioFX.__name__ = ["co","doubleduck","audio","AudioFX"];
co.doubleduck.audio.AudioFX.__interfaces__ = [co.doubleduck.audio.AudioAPI];
co.doubleduck.audio.AudioFX._currentlyPlaying = null;
co.doubleduck.audio.AudioFX.prototype = {
	setVolume: function(volume) {
		this._volume = volume;
		if(this._jsAudio != null) this._jsAudio.setVolume(volume);
	}
	,pause: function() {
	}
	,stop: function(fadeOut) {
		if(fadeOut == null) fadeOut = 0;
		this._jsAudio.stop();
	}
	,playMusic: function(volume,loop,fadeIn) {
		if(fadeIn == null) fadeIn = 0;
		if(loop == null) loop = true;
		if(volume == null) volume = 1;
		if(this._jsAudio == null) this.load(loop);
		this._jsAudio.play();
		this.setVolume(volume);
	}
	,playEffect: function(volume,overrideOtherEffects,loop,fadeIn) {
		if(fadeIn == null) fadeIn = 0;
		if(loop == null) loop = false;
		if(overrideOtherEffects == null) overrideOtherEffects = true;
		if(volume == null) volume = 1;
		if(this._jsAudio == null) this.load(loop,co.doubleduck.SoundManager.audioPoolSize);
		this._jsAudio.play();
		this.setVolume(volume);
	}
	,load: function(isLoop,pool) {
		if(pool == null) pool = 1;
		var pathNoExtension = this._src;
		this._jsAudio = AudioFX(pathNoExtension, { loop: isLoop, pool: pool });
	}
	,init: function() {
	}
	,_volume: null
	,_loop: null
	,_jsAudio: null
	,_src: null
	,__class__: co.doubleduck.audio.AudioFX
}
co.doubleduck.audio.DummyAudioAPI = $hxClasses["co.doubleduck.audio.DummyAudioAPI"] = function() {
};
co.doubleduck.audio.DummyAudioAPI.__name__ = ["co","doubleduck","audio","DummyAudioAPI"];
co.doubleduck.audio.DummyAudioAPI.__interfaces__ = [co.doubleduck.audio.AudioAPI];
co.doubleduck.audio.DummyAudioAPI.prototype = {
	setVolume: function(volume) {
	}
	,pause: function() {
	}
	,stop: function(fadeOut) {
		if(fadeOut == null) fadeOut = 0;
	}
	,playMusic: function(volume,loop,fadeIn) {
		if(fadeIn == null) fadeIn = 0;
		if(loop == null) loop = true;
		if(volume == null) volume = 1;
	}
	,playEffect: function(volume,overrideOtherEffects,loop,fadeIn) {
		if(fadeIn == null) fadeIn = 0;
		if(loop == null) loop = false;
		if(overrideOtherEffects == null) overrideOtherEffects = true;
		if(volume == null) volume = 1;
	}
	,init: function() {
	}
	,__class__: co.doubleduck.audio.DummyAudioAPI
}
co.doubleduck.audio.HowlerAudio = $hxClasses["co.doubleduck.audio.HowlerAudio"] = function(src) {
	this._jsAudio = null;
	this._src = src;
	this._loop = false;
	this._volume = 1;
};
co.doubleduck.audio.HowlerAudio.__name__ = ["co","doubleduck","audio","HowlerAudio"];
co.doubleduck.audio.HowlerAudio.__interfaces__ = [co.doubleduck.audio.AudioAPI];
co.doubleduck.audio.HowlerAudio._currentlyPlaying = null;
co.doubleduck.audio.HowlerAudio.prototype = {
	setVolume: function(volume) {
		this._volume = volume;
		if(this._jsAudio != null) this._jsAudio.volume = volume;
	}
	,pause: function() {
	}
	,stop: function(fadeOut) {
		if(fadeOut == null) fadeOut = 0;
		this._jsAudio.stop();
	}
	,playMusic: function(volume,loop,fadeIn) {
		if(fadeIn == null) fadeIn = 0;
		if(loop == null) loop = true;
		if(volume == null) volume = 1;
		if(this._jsAudio == null) this.load(loop);
		this._jsAudio.play();
		this.setVolume(volume);
	}
	,playEffect: function(volume,overrideOtherEffects,loop,fadeIn) {
		if(fadeIn == null) fadeIn = 0;
		if(loop == null) loop = false;
		if(overrideOtherEffects == null) overrideOtherEffects = true;
		if(volume == null) volume = 1;
		if(this._jsAudio == null) this.load(loop,1);
		this._jsAudio.play();
		this.setVolume(volume);
	}
	,load: function(isLoop,pool) {
		if(pool == null) pool = 1;
		var pathNoExtension = this._src;
		var myUrls = new Array();
		myUrls.push(this._src + ".mp3");
		myUrls.push(this._src + ".ogg");
		this._jsAudio = new Howl({urls: myUrls, loop: false});
	}
	,init: function() {
	}
	,_volume: null
	,_loop: null
	,_jsAudio: null
	,_src: null
	,__class__: co.doubleduck.audio.HowlerAudio
}
co.doubleduck.audio.NonOverlappingAudio = $hxClasses["co.doubleduck.audio.NonOverlappingAudio"] = function(src) {
	this._src = src;
	this.load();
	this._isMusic = false;
};
co.doubleduck.audio.NonOverlappingAudio.__name__ = ["co","doubleduck","audio","NonOverlappingAudio"];
co.doubleduck.audio.NonOverlappingAudio.__interfaces__ = [co.doubleduck.audio.AudioAPI];
co.doubleduck.audio.NonOverlappingAudio._currentlyPlaying = null;
co.doubleduck.audio.NonOverlappingAudio.prototype = {
	getSrc: function() {
		return this._src;
	}
	,audio: function() {
		return this._audio;
	}
	,setVolume: function(volume) {
		if(this._audio != null) this._audio.volume = volume;
	}
	,pause: function() {
		if(this._audio != null) this._audio.pause();
	}
	,stop: function(fadeOut) {
		if(fadeOut == null) fadeOut = 0;
		if(this._isMusic) co.doubleduck.audio.NonOverlappingAudio._musicPlaying = false;
		if(this._audio != null) {
			this._audio.removeEventListener("ended",$bind(this,this.handleEnded));
			this._audio.currentTime = 0;
			this._audio.pause();
		}
	}
	,playMusic: function(volume,loop,fadeIn) {
		if(fadeIn == null) fadeIn = 0;
		if(loop == null) loop = false;
		if(volume == null) volume = 1;
		if(co.doubleduck.audio.NonOverlappingAudio._currentlyPlaying != null) co.doubleduck.audio.NonOverlappingAudio._currentlyPlaying.stop();
		this._isMusic = true;
		co.doubleduck.audio.NonOverlappingAudio._musicPlaying = true;
		this._audio.play();
		this._audio.volume = volume;
		this._audio.loop = loop;
		if(!loop) this._audio.addEventListener("ended",$bind(this,this.stop));
	}
	,handleEnded: function() {
		this._audio.removeEventListener("ended",$bind(this,this.handleEnded));
		this._audio.currentTime = 0;
	}
	,handleTimeUpdate: function() {
		if(this._audio.currentTime >= this._audio.duration - 0.3) this.stop();
	}
	,playEffect: function(volume,overrideOtherEffects,loop,fadeIn) {
		if(fadeIn == null) fadeIn = 0;
		if(loop == null) loop = false;
		if(overrideOtherEffects == null) overrideOtherEffects = true;
		if(volume == null) volume = 1;
		if(co.doubleduck.audio.NonOverlappingAudio._musicPlaying) return;
		if(overrideOtherEffects && co.doubleduck.audio.NonOverlappingAudio._currentlyPlaying != null) co.doubleduck.audio.NonOverlappingAudio._currentlyPlaying.stop();
		this._audio.play();
		this._audio.volume = volume;
		this._audio.loop = loop;
		if(!loop) this._audio.addEventListener("ended",$bind(this,this.stop));
		co.doubleduck.audio.NonOverlappingAudio._currentlyPlaying = this;
	}
	,handleError: function() {
	}
	,handleCanPlay: function() {
	}
	,load: function() {
		this._audio = new Audio();
		this._audio.src = this._src;
		this._audio.initialTime = 0;
		this._audio.addEventListener("canplaythrough",$bind(this,this.handleCanPlay));
		this._audio.addEventListener("onerror",$bind(this,this.handleError));
	}
	,init: function() {
	}
	,_isMusic: null
	,_audio: null
	,_src: null
	,__class__: co.doubleduck.audio.NonOverlappingAudio
}
var haxe = haxe || {}
haxe.Log = $hxClasses["haxe.Log"] = function() { }
haxe.Log.__name__ = ["haxe","Log"];
haxe.Log.trace = function(v,infos) {
	js.Boot.__trace(v,infos);
}
haxe.Log.clear = function() {
	js.Boot.__clear_trace();
}
haxe.Public = $hxClasses["haxe.Public"] = function() { }
haxe.Public.__name__ = ["haxe","Public"];
haxe.StackItem = $hxClasses["haxe.StackItem"] = { __ename__ : ["haxe","StackItem"], __constructs__ : ["CFunction","Module","FilePos","Method","Lambda"] }
haxe.StackItem.CFunction = ["CFunction",0];
haxe.StackItem.CFunction.toString = $estr;
haxe.StackItem.CFunction.__enum__ = haxe.StackItem;
haxe.StackItem.Module = function(m) { var $x = ["Module",1,m]; $x.__enum__ = haxe.StackItem; $x.toString = $estr; return $x; }
haxe.StackItem.FilePos = function(s,file,line) { var $x = ["FilePos",2,s,file,line]; $x.__enum__ = haxe.StackItem; $x.toString = $estr; return $x; }
haxe.StackItem.Method = function(classname,method) { var $x = ["Method",3,classname,method]; $x.__enum__ = haxe.StackItem; $x.toString = $estr; return $x; }
haxe.StackItem.Lambda = function(v) { var $x = ["Lambda",4,v]; $x.__enum__ = haxe.StackItem; $x.toString = $estr; return $x; }
haxe.Stack = $hxClasses["haxe.Stack"] = function() { }
haxe.Stack.__name__ = ["haxe","Stack"];
haxe.Stack.callStack = function() {
	var oldValue = Error.prepareStackTrace;
	Error.prepareStackTrace = function(error,callsites) {
		var stack = [];
		var _g = 0;
		while(_g < callsites.length) {
			var site = callsites[_g];
			++_g;
			var method = null;
			var fullName = site.getFunctionName();
			if(fullName != null) {
				var idx = fullName.lastIndexOf(".");
				if(idx >= 0) {
					var className = HxOverrides.substr(fullName,0,idx);
					var methodName = HxOverrides.substr(fullName,idx + 1,null);
					method = haxe.StackItem.Method(className,methodName);
				}
			}
			stack.push(haxe.StackItem.FilePos(method,site.getFileName(),site.getLineNumber()));
		}
		return stack;
	};
	var a = haxe.Stack.makeStack(new Error().stack);
	a.shift();
	Error.prepareStackTrace = oldValue;
	return a;
}
haxe.Stack.exceptionStack = function() {
	return [];
}
haxe.Stack.toString = function(stack) {
	var b = new StringBuf();
	var _g = 0;
	while(_g < stack.length) {
		var s = stack[_g];
		++_g;
		b.b += Std.string("\nCalled from ");
		haxe.Stack.itemToString(b,s);
	}
	return b.b;
}
haxe.Stack.itemToString = function(b,s) {
	var $e = (s);
	switch( $e[1] ) {
	case 0:
		b.b += Std.string("a C function");
		break;
	case 1:
		var m = $e[2];
		b.b += Std.string("module ");
		b.b += Std.string(m);
		break;
	case 2:
		var line = $e[4], file = $e[3], s1 = $e[2];
		if(s1 != null) {
			haxe.Stack.itemToString(b,s1);
			b.b += Std.string(" (");
		}
		b.b += Std.string(file);
		b.b += Std.string(" line ");
		b.b += Std.string(line);
		if(s1 != null) b.b += Std.string(")");
		break;
	case 3:
		var meth = $e[3], cname = $e[2];
		b.b += Std.string(cname);
		b.b += Std.string(".");
		b.b += Std.string(meth);
		break;
	case 4:
		var n = $e[2];
		b.b += Std.string("local function #");
		b.b += Std.string(n);
		break;
	}
}
haxe.Stack.makeStack = function(s) {
	if(typeof(s) == "string") {
		var stack = s.split("\n");
		var m = [];
		var _g = 0;
		while(_g < stack.length) {
			var line = stack[_g];
			++_g;
			m.push(haxe.StackItem.Module(line));
		}
		return m;
	} else return s;
}
if(!haxe.unit) haxe.unit = {}
haxe.unit.TestCase = $hxClasses["haxe.unit.TestCase"] = function() {
};
haxe.unit.TestCase.__name__ = ["haxe","unit","TestCase"];
haxe.unit.TestCase.__interfaces__ = [haxe.Public];
haxe.unit.TestCase.prototype = {
	assertEquals: function(expected,actual,c) {
		this.currentTest.done = true;
		if(actual != expected) {
			this.currentTest.success = false;
			this.currentTest.error = "expected '" + Std.string(expected) + "' but was '" + Std.string(actual) + "'";
			this.currentTest.posInfos = c;
			throw this.currentTest;
		}
	}
	,assertFalse: function(b,c) {
		this.currentTest.done = true;
		if(b == true) {
			this.currentTest.success = false;
			this.currentTest.error = "expected false but was true";
			this.currentTest.posInfos = c;
			throw this.currentTest;
		}
	}
	,assertTrue: function(b,c) {
		this.currentTest.done = true;
		if(b == false) {
			this.currentTest.success = false;
			this.currentTest.error = "expected true but was false";
			this.currentTest.posInfos = c;
			throw this.currentTest;
		}
	}
	,print: function(v) {
		haxe.unit.TestRunner.print(v);
	}
	,tearDown: function() {
	}
	,setup: function() {
	}
	,currentTest: null
	,__class__: haxe.unit.TestCase
}
haxe.unit.TestResult = $hxClasses["haxe.unit.TestResult"] = function() {
	this.m_tests = new List();
	this.success = true;
};
haxe.unit.TestResult.__name__ = ["haxe","unit","TestResult"];
haxe.unit.TestResult.prototype = {
	toString: function() {
		var buf = new StringBuf();
		var failures = 0;
		var $it0 = this.m_tests.iterator();
		while( $it0.hasNext() ) {
			var test = $it0.next();
			if(test.success == false) {
				buf.b += Std.string("* ");
				buf.b += Std.string(test.classname);
				buf.b += Std.string("::");
				buf.b += Std.string(test.method);
				buf.b += Std.string("()");
				buf.b += Std.string("\n");
				buf.b += Std.string("ERR: ");
				if(test.posInfos != null) {
					buf.b += Std.string(test.posInfos.fileName);
					buf.b += Std.string(":");
					buf.b += Std.string(test.posInfos.lineNumber);
					buf.b += Std.string("(");
					buf.b += Std.string(test.posInfos.className);
					buf.b += Std.string(".");
					buf.b += Std.string(test.posInfos.methodName);
					buf.b += Std.string(") - ");
				}
				buf.b += Std.string(test.error);
				buf.b += Std.string("\n");
				if(test.backtrace != null) {
					buf.b += Std.string(test.backtrace);
					buf.b += Std.string("\n");
				}
				buf.b += Std.string("\n");
				failures++;
			}
		}
		buf.b += Std.string("\n");
		if(failures == 0) buf.b += Std.string("OK "); else buf.b += Std.string("FAILED ");
		buf.b += Std.string(this.m_tests.length);
		buf.b += Std.string(" tests, ");
		buf.b += Std.string(failures);
		buf.b += Std.string(" failed, ");
		buf.b += Std.string(this.m_tests.length - failures);
		buf.b += Std.string(" success");
		buf.b += Std.string("\n");
		return buf.b;
	}
	,add: function(t) {
		this.m_tests.add(t);
		if(!t.success) this.success = false;
	}
	,success: null
	,m_tests: null
	,__class__: haxe.unit.TestResult
}
haxe.unit.TestRunner = $hxClasses["haxe.unit.TestRunner"] = function() {
	this.result = new haxe.unit.TestResult();
	this.cases = new List();
};
haxe.unit.TestRunner.__name__ = ["haxe","unit","TestRunner"];
haxe.unit.TestRunner.print = function(v) {
	var msg = StringTools.htmlEscape(js.Boot.__string_rec(v,"")).split("\n").join("<br/>");
	var d = document.getElementById("haxe:trace");
	if(d == null) alert("haxe:trace element not found"); else d.innerHTML += msg;
}
haxe.unit.TestRunner.customTrace = function(v,p) {
	haxe.unit.TestRunner.print(p.fileName + ":" + p.lineNumber + ": " + Std.string(v) + "\n");
}
haxe.unit.TestRunner.prototype = {
	runCase: function(t) {
		var old = haxe.Log.trace;
		haxe.Log.trace = haxe.unit.TestRunner.customTrace;
		var cl = Type.getClass(t);
		var fields = Type.getInstanceFields(cl);
		haxe.unit.TestRunner.print("Class: " + Type.getClassName(cl) + " ");
		var _g = 0;
		while(_g < fields.length) {
			var f = fields[_g];
			++_g;
			var fname = f;
			var field = Reflect.field(t,f);
			if(StringTools.startsWith(fname,"test") && Reflect.isFunction(field)) {
				t.currentTest = new haxe.unit.TestStatus();
				t.currentTest.classname = Type.getClassName(cl);
				t.currentTest.method = fname;
				t.setup();
				try {
					field.apply(t,new Array());
					if(t.currentTest.done) {
						t.currentTest.success = true;
						haxe.unit.TestRunner.print(".");
					} else {
						t.currentTest.success = false;
						t.currentTest.error = "(warning) no assert";
						haxe.unit.TestRunner.print("W");
					}
				} catch( $e0 ) {
					if( js.Boot.__instanceof($e0,haxe.unit.TestStatus) ) {
						var e = $e0;
						haxe.unit.TestRunner.print("F");
						t.currentTest.backtrace = haxe.Stack.toString(haxe.Stack.exceptionStack());
					} else {
					var e = $e0;
					haxe.unit.TestRunner.print("E");
					if(e.message != null) t.currentTest.error = "exception thrown : " + Std.string(e) + " [" + Std.string(e.message) + "]"; else t.currentTest.error = "exception thrown : " + Std.string(e);
					t.currentTest.backtrace = haxe.Stack.toString(haxe.Stack.exceptionStack());
					}
				}
				this.result.add(t.currentTest);
				t.tearDown();
			}
		}
		haxe.unit.TestRunner.print("\n");
		haxe.Log.trace = old;
	}
	,run: function() {
		this.result = new haxe.unit.TestResult();
		var $it0 = this.cases.iterator();
		while( $it0.hasNext() ) {
			var c = $it0.next();
			this.runCase(c);
		}
		haxe.unit.TestRunner.print(this.result.toString());
		return this.result.success;
	}
	,add: function(c) {
		this.cases.add(c);
	}
	,cases: null
	,result: null
	,__class__: haxe.unit.TestRunner
}
haxe.unit.TestStatus = $hxClasses["haxe.unit.TestStatus"] = function() {
	this.done = false;
	this.success = false;
};
haxe.unit.TestStatus.__name__ = ["haxe","unit","TestStatus"];
haxe.unit.TestStatus.prototype = {
	backtrace: null
	,posInfos: null
	,classname: null
	,method: null
	,error: null
	,success: null
	,done: null
	,__class__: haxe.unit.TestStatus
}
var js = js || {}
js.Boot = $hxClasses["js.Boot"] = function() { }
js.Boot.__name__ = ["js","Boot"];
js.Boot.__unhtml = function(s) {
	return s.split("&").join("&amp;").split("<").join("&lt;").split(">").join("&gt;");
}
js.Boot.__trace = function(v,i) {
	var msg = i != null?i.fileName + ":" + i.lineNumber + ": ":"";
	msg += js.Boot.__string_rec(v,"");
	var d;
	if(typeof(document) != "undefined" && (d = document.getElementById("haxe:trace")) != null) d.innerHTML += js.Boot.__unhtml(msg) + "<br/>"; else if(typeof(console) != "undefined" && console.log != null) console.log(msg);
}
js.Boot.__clear_trace = function() {
	var d = document.getElementById("haxe:trace");
	if(d != null) d.innerHTML = "";
}
js.Boot.isClass = function(o) {
	return o.__name__;
}
js.Boot.isEnum = function(e) {
	return e.__ename__;
}
js.Boot.getClass = function(o) {
	return o.__class__;
}
js.Boot.__string_rec = function(o,s) {
	if(o == null) return "null";
	if(s.length >= 5) return "<...>";
	var t = typeof(o);
	if(t == "function" && (o.__name__ || o.__ename__)) t = "object";
	switch(t) {
	case "object":
		if(o instanceof Array) {
			if(o.__enum__) {
				if(o.length == 2) return o[0];
				var str = o[0] + "(";
				s += "\t";
				var _g1 = 2, _g = o.length;
				while(_g1 < _g) {
					var i = _g1++;
					if(i != 2) str += "," + js.Boot.__string_rec(o[i],s); else str += js.Boot.__string_rec(o[i],s);
				}
				return str + ")";
			}
			var l = o.length;
			var i;
			var str = "[";
			s += "\t";
			var _g = 0;
			while(_g < l) {
				var i1 = _g++;
				str += (i1 > 0?",":"") + js.Boot.__string_rec(o[i1],s);
			}
			str += "]";
			return str;
		}
		var tostr;
		try {
			tostr = o.toString;
		} catch( e ) {
			return "???";
		}
		if(tostr != null && tostr != Object.toString) {
			var s2 = o.toString();
			if(s2 != "[object Object]") return s2;
		}
		var k = null;
		var str = "{\n";
		s += "\t";
		var hasp = o.hasOwnProperty != null;
		for( var k in o ) { ;
		if(hasp && !o.hasOwnProperty(k)) {
			continue;
		}
		if(k == "prototype" || k == "__class__" || k == "__super__" || k == "__interfaces__" || k == "__properties__") {
			continue;
		}
		if(str.length != 2) str += ", \n";
		str += s + k + " : " + js.Boot.__string_rec(o[k],s);
		}
		s = s.substring(1);
		str += "\n" + s + "}";
		return str;
	case "function":
		return "<function>";
	case "string":
		return o;
	default:
		return String(o);
	}
}
js.Boot.__interfLoop = function(cc,cl) {
	if(cc == null) return false;
	if(cc == cl) return true;
	var intf = cc.__interfaces__;
	if(intf != null) {
		var _g1 = 0, _g = intf.length;
		while(_g1 < _g) {
			var i = _g1++;
			var i1 = intf[i];
			if(i1 == cl || js.Boot.__interfLoop(i1,cl)) return true;
		}
	}
	return js.Boot.__interfLoop(cc.__super__,cl);
}
js.Boot.__instanceof = function(o,cl) {
	try {
		if(o instanceof cl) {
			if(cl == Array) return o.__enum__ == null;
			return true;
		}
		if(js.Boot.__interfLoop(o.__class__,cl)) return true;
	} catch( e ) {
		if(cl == null) return false;
	}
	switch(cl) {
	case Int:
		return Math.ceil(o%2147483648.0) === o;
	case Float:
		return typeof(o) == "number";
	case Bool:
		return o === true || o === false;
	case String:
		return typeof(o) == "string";
	case Dynamic:
		return true;
	default:
		if(o == null) return false;
		if(cl == Class && o.__name__ != null) return true; else null;
		if(cl == Enum && o.__ename__ != null) return true; else null;
		return o.__enum__ == cl;
	}
}
js.Boot.__cast = function(o,t) {
	if(js.Boot.__instanceof(o,t)) return o; else throw "Cannot cast " + Std.string(o) + " to " + Std.string(t);
}
js.Lib = $hxClasses["js.Lib"] = function() { }
js.Lib.__name__ = ["js","Lib"];
js.Lib.document = null;
js.Lib.window = null;
js.Lib.debug = function() {
	debugger;
}
js.Lib.alert = function(v) {
	alert(js.Boot.__string_rec(v,""));
}
js.Lib.eval = function(code) {
	return eval(code);
}
js.Lib.setErrorHandler = function(f) {
	js.Lib.onerror = f;
}
function $iterator(o) { if( o instanceof Array ) return function() { return HxOverrides.iter(o); }; return typeof(o.iterator) == 'function' ? $bind(o,o.iterator) : o.iterator; };
var $_;
function $bind(o,m) { var f = function(){ return f.method.apply(f.scope, arguments); }; f.scope = o; f.method = m; return f; };
if(Array.prototype.indexOf) HxOverrides.remove = function(a,o) {
	var i = a.indexOf(o);
	if(i == -1) return false;
	a.splice(i,1);
	return true;
}; else null;
Math.__name__ = ["Math"];
Math.NaN = Number.NaN;
Math.NEGATIVE_INFINITY = Number.NEGATIVE_INFINITY;
Math.POSITIVE_INFINITY = Number.POSITIVE_INFINITY;
$hxClasses.Math = Math;
Math.isFinite = function(i) {
	return isFinite(i);
};
Math.isNaN = function(i) {
	return isNaN(i);
};
String.prototype.__class__ = $hxClasses.String = String;
String.__name__ = ["String"];
Array.prototype.__class__ = $hxClasses.Array = Array;
Array.__name__ = ["Array"];
Date.prototype.__class__ = $hxClasses.Date = Date;
Date.__name__ = ["Date"];
var Int = $hxClasses.Int = { __name__ : ["Int"]};
var Dynamic = $hxClasses.Dynamic = { __name__ : ["Dynamic"]};
var Float = $hxClasses.Float = Number;
Float.__name__ = ["Float"];
var Bool = $hxClasses.Bool = Boolean;
Bool.__ename__ = ["Bool"];
var Class = $hxClasses.Class = { __name__ : ["Class"]};
var Enum = { };
var Void = $hxClasses.Void = { __ename__ : ["Void"]};
if(typeof document != "undefined") js.Lib.document = document;
if(typeof window != "undefined") {
	js.Lib.window = window;
	js.Lib.window.onerror = function(msg,url,line) {
		var f = js.Lib.onerror;
		if(f == null) return false;
		return f(msg,[url + ":" + line]);
	};
}
co.doubleduck.BaseAssets.onLoadAll = null;
co.doubleduck.BaseAssets._loader = null;
co.doubleduck.BaseAssets._cacheData = { };
co.doubleduck.BaseAssets._loadCallbacks = { };
co.doubleduck.BaseAssets.loaded = 0;
co.doubleduck.BaseAssets._useLocalStorage = false;
co.doubleduck.BaseGame._viewport = null;
co.doubleduck.BaseGame._scale = 1;
co.doubleduck.BaseGame.DEBUG = false;
co.doubleduck.BaseGame.LOGO_URI = "images/duckling/splash_logo.png";
co.doubleduck.BaseGame.LOAD_STROKE_URI = "images/duckling/loading_stroke.png";
co.doubleduck.BaseGame.LOAD_FILL_URI = "images/duckling/loading_fill.png";
co.doubleduck.BaseGame.ORIENT_PORT_URI = "images/duckling/orientation_error_port.png";
co.doubleduck.BaseGame.ORIENT_LAND_URI = "images/duckling/orientation_error_land.png";
co.doubleduck.BaseGame.isLocalized = false;
co.doubleduck.BasePersistence.GAME_PREFIX = "DUCK";
co.doubleduck.BasePersistence.available = co.doubleduck.BasePersistence.localStorageSupported();
co.doubleduck.Button.CLICK_TYPE_NONE = 0;
co.doubleduck.Button.CLICK_TYPE_TINT = 1;
co.doubleduck.Button.CLICK_TYPE_JUICY = 2;
co.doubleduck.Button.CLICK_TYPE_SCALE = 3;
co.doubleduck.Button.CLICK_TYPE_TOGGLE = 4;
co.doubleduck.Button.CLICK_TYPE_HOLD = 5;
co.doubleduck.Button._defaultSound = null;
co.doubleduck.Menu.LEVELS_PER_SCREEN = 6;
co.doubleduck.Menu.WORLD_MOVE_EASE = 0.007;
co.doubleduck.Menu._iconSpritesheet = null;
co.doubleduck.Menu._shownChaz = false;
co.doubleduck.Persistence.XP = "xp";
co.doubleduck.Persistence.LAST_LEVEL = "lastlevel";
co.doubleduck.Persistence.STAR_PREFIX = "starRateLvl_";
co.doubleduck.Session._lastLevelId = -1;
co.doubleduck.audio.WebAudioAPI._buffers = { };
co.doubleduck.SoundManager._muted = false;
co.doubleduck.SoundManager._cache = { };
co.doubleduck.SoundManager.audioPoolSize = 2;
co.doubleduck.SoundManager.available = co.doubleduck.SoundManager.isSoundAvailable();
co.doubleduck.audio.AudioFX._muted = false;
co.doubleduck.audio.HowlerAudio._muted = false;
co.doubleduck.audio.NonOverlappingAudio._musicPlaying = false;
js.Lib.onerror = null;
co.doubleduck.Main.main();
