UI.Controls = function () {
    "use strict";
    var touchStartPos = undefined;
    var delta = { x: 0, y: 0 };
    var keys = {
        up: 38,
        down: 40,
        left: 37,
        right: 39,
        space: 32
    };
    var threshold = 30;
    console.log("Basile Test"); 
    var firstTouchIdentifier = null;
    function handleTouchStart(event) {
        console.log("Basile Test:Touch Start:");
        var touch = event.touches[0];
        firstTouchIdentifier = touch.identifier;
        touchStartPos = {
            x: touch.clientX,
            y: touch.clientY
        }
    }
    function handleTouchMove(event) {

        console.log("Basile Test:Touch Move:");
        var firstTouch = event.touches.identifiedTouch(firstTouchIdentifier);
        delta.x = firstTouch.clientX - touchStartPos.x;
        delta.y = firstTouch.clientY - touchStartPos.y;
    }
    function handleTouchEnd(event) {
        console.log("Basile Test:Touch End:");

        firstTouchIdentifier = null;
        console.log("delta x :" + delta.x + " ,  delta y: " + delta.y);
        if (delta.x > threshold) {
            simKey(keys.right);
        } else if (delta.x < -1 * threshold) {
            simKey(keys.left);
        } else if (delta.y > threshold) {
            simKey(keys.down);
        } else if (delta.y < -1 * threshold) {
            simKey(keys.up);
        } else {
            simKey(keys.space);
        }

        delta = { x: 0, y: 0 };
    }
    function hideControls() {
        var stick = document.getElementById("leftButtons");
        var fix = document.getElementById("fix_button");
        stick.style.opacity = 0;
        fix.style.opacity = 0;
        fix.style.visibility = "hidden";
        stick.style.visibility = "hidden";
    }
    function showControls() {
        var stick = document.getElementById("leftButtons");
        var fix = document.getElementById("fix_button");
        stick.style.opacity = 1;
        stick.style.visibility = "visible";
        fix.style.opacity = 1;
        fix.style.visibility = "visible";
    }
    this.hideControls = hideControls;
    this.showControls = showControls;
    this.handleTouchStart = handleTouchStart;
    this.handleTouchEnd = handleTouchEnd;
    this.handleTouchMove = handleTouchMove;
};
UI.controls = new UI.Controls();
