"use strict";
UI.Credits = {
    hideCredits: function () {
        if (peek(UI.windowStack) === "credits") {
            var creditsDiv = document.getElementById("credits");
            creditsDiv.style.visibility = "hidden";
            UI.windowStack.pop();
        }
    },
    showCredits: function () {
        var creditsDiv = document.getElementById("credits");
        creditsDiv.style.visibility = "visible";
        UI.windowStack.push("credits");
    },
    addLinkListeners: function () {
        var credits = document.getElementById("creditsCenter");
        var links = credits.getElementsByTagName("a");
        for (var i = 0; i < links.length; i++) {
            links[i].addEventListener("click", UI.Credits.handleLinkNavigation.bind(this, links[i].href));
            links[i].href = "#";
        }
    },
    handleLinkNavigation: function (targetURL, event) {
        console.log(targetURL);
        var activity = new MozActivity({
            name: "view",
            data: {
                type: "url",
                url: targetURL
            }
        });
    }

}