UI.Options = {
    musicVolume: 1,
    soundVolume: 1,
    isDragging: false,
    dragType: "",
    setSliderPosition: function (sliderName, position) {
        var sliderDiv = document.getElementById(sliderName);
        var handleDiv = document.getElementById(sliderName + "Handle");
        var clampedPosition = Math.max(0, Math.min(position, 100));
        sliderDiv.style.width = 100 - clampedPosition + "%";
        handleDiv.style.right = 100 - clampedPosition + "%";
    },

    setVolume: function (type, val) {
        UI.Options.setSliderPosition(type, val);
        var clampedVal = Math.max(0, Math.min(val, 100));
        if (type === 'music') {
            document.getElementsByTagName("audio")[0].volume = clampedVal / 100.0;
            UI.Options.musicVolume = clampedVal / 100.0;
            if (ig.music) {
                ig.music.volume = clampedVal / 100.0;

            }
        } else if (type === 'sound') {
            UI.Options.soundVolume = clampedVal / 100.0;
            if (ig.soundManager) {
                ig.soundManager.volume = clampedVal / 100.0;

            }
        }
    },
    handleMouseDown: function (type, event) {
        UI.Options.isDragging = true;
        UI.Options.dragType = type;
        window.onmouseup = UI.Options.handleMouseUp;
        window.onmousemove = UI.Options.handleMouseMove.bind(window, type);
    },
    handleSoundMouseDown: function (event) {
        UI.Options.handleMouseDown('sound', event);
    },
    handleMusicMouseDown: function (event) {
        UI.Options.handleMouseDown('music', event);
    },
    handleMusicTouchStart: function (event) {
        UI.Options.handleTouchStart('music', event);
    },
    handleSoundTouchStart: function (event) {
        UI.Options.handleTouchStart('sound', event);
    },
    handleMouseUp: function () {
        UI.Options.isDragging = false;
        UI.Options.dragType = "";
        window.onmousemove = undefined;
        window.ontouchmove = undefined;
        window.ontouchend = undefined;
    },
    handleMouseMove: function (type, event) {
        var div = document.getElementsByClassName("slider")[0];
        var width = div.offsetWidth * 0.5;
        var x = div.parentNode.parentNode.parentNode.offsetLeft - (292 * 0.5) / 2;
        var y = div.parentNode.parentNode.parentNode.offsetTop
        var mousex = event.clientX;
        var mousey = event.clientY;
        var moffx = mousex - x;
        var moffy = mousey - y;
        var pct = (moffx / width) * 100.0;
        UI.Options.setVolume(type, pct);
    },
    handleTouchStart: function (type, event) {
        UI.Options.isDragging = true;
        UI.Options.dragType = type;
        window.ontouchend = UI.Options.handleMouseUp;
        window.ontouchmove = UI.Options.handleTouchMove.bind(window, type);
    },
    handleTouchMove: function (type, event) {
        //same as the stick forwarding touch move handler
        //uses duck typeing
        UI.Options.handleMouseMove(type, event.touches[0]);
    },
    closeMenu: function () {
        if (peek(UI.windowStack) === "options") {
            var options = document.getElementById("optionsMenu");
            options.style.visibility = "hidden";
            UI.windowStack.pop();
            sessionStorage.setItem("musicVolume", UI.Options.musicVolume);
            sessionStorage.setItem("soundVolume", UI.Options.soundVolume);
        }
    },
    openMenu: function () {
        var options = document.getElementById("optionsMenu");
        options.style.visibility = "visible";
        UI.windowStack.push("options");
    }
}
