ig.module('game.effects')
.requires(
    'impact.impact',
    'impact.entity',
    'game.entities.window-shard'
)
.defines(function () {
    "use strict";
    ig.global.Effects = {};
    ig.global.Effects.windowBreak = function (position) {
        //this is how many shards we are to spawn
        var numshards = 1;

        //actually go through and spawn the shards
        for (var i = 0; i < numshards; i+=2) {
            if (Effects.windowBreakPool.length !== 0) {
                var ent = Effects.windowBreakPool.pop();
                ent.reset(position.x, position.y);
            } else {
                var ent = ig.game.spawnEntity(EntityWindowShard, position.x, position.y);
                ent.onDisable = function (ent) {
                    Effects.windowBreakPool.push(ent);
                }
            }

        }
    }
    ig.global.Effects.windowBreakPool = [];
});
